/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.ClientBindDeployedWSDL;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ClientBindDeployedWSDLTaskHelper
implements AppDeploymentTaskHelper,
AppDeploymentTaskValidate {
    private static TraceComponent tc = Tr.register(ClientBindDeployedWSDLTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    protected String[] taskValidateErrorMessages = null;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        return new ClientBindDeployedWSDL(appController);
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        String[][] newTaskData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (task.getTaskData() != null) {
            return;
        }
        Vector<String> dataForTwoDimensionalArray = new Vector<String>();
        String[] columnNames = task.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            dataForTwoDimensionalArray.addElement(columnNames[i]);
        }
        Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector combined = new Vector();
        combined.addAll(ejbJars);
        combined.addAll(wars);
        boolean webServiceEnabled = false;
        boolean firstRowFilled = false;
        Iterator iter = combined.iterator();
        while (iter.hasNext()) {
            WSDeploymentDescriptorAccessor ddAccessor;
            EObject refObject = (EObject)iter.next();
            String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
            String[] pieces = util.separateUriString((String)moduleURI);
            String moduleName = pieces[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareTask: working on module " + moduleURI);
            }
            if ((ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabledClient()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: module " + moduleURI + " is Web Service enabled");
                }
                webServiceEnabled = true;
                WSBindingsFileAccessor bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo);
                ClientBinding clientBinding = bindingAccessor.getClientBinding();
                if (clientBinding == null) continue;
                String ejbName = "";
                if (bindingAccessor.isWebType(null)) {
                    EList services = clientBinding.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    firstRowFilled = this.fillServicesRows(dataForTwoDimensionalArray, moduleName, ejbName, services);
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    firstRowFilled = this.fillServicesRows(dataForTwoDimensionalArray, moduleName, ejbName, services);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "prepareTask: module " + moduleURI + " is NOT Web Service enabled");
        }
        if (webServiceEnabled) {
            if (!firstRowFilled) {
                for (int i = 0; i < columnNames.length; ++i) {
                    dataForTwoDimensionalArray.addElement("");
                }
            }
            newTaskData = util.buildTaskData(dataForTwoDimensionalArray, (int)columnNames.length);
            task.setTaskData(newTaskData);
        } else {
            newTaskData = null;
            task.setTaskData(newTaskData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private boolean fillServicesRows(Vector dataForTwoDimensionalArray, String moduleName, String ejbName, EList services) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillServicesRows", new Object[]{moduleName, ejbName});
        }
        int size = services.size();
        boolean firstRowFilled = false;
        for (int i = 0; i < size; ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            String deployedWsdl = sr.getDeployedWSDLFile();
            if (deployedWsdl == null) {
                deployedWsdl = "";
            }
            dataForTwoDimensionalArray.addElement(moduleName);
            dataForTwoDimensionalArray.addElement(ejbName);
            dataForTwoDimensionalArray.addElement(serviceName);
            dataForTwoDimensionalArray.addElement(deployedWsdl);
            firstRowFilled = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillServicesRows", new Boolean(firstRowFilled));
        }
        return firstRowFilled;
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!task.isTaskEmpty() && !task.isTaskDisabled()) {
            Hashtable appOptions = appDeploymentInfo.getAppOptions();
            String[][] taskData = task.getTaskData();
            Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector combined = new Vector();
            combined.addAll(ejbJars);
            combined.addAll(wars);
            Iterator iter = combined.iterator();
            while (iter.hasNext()) {
                WSBindingsFileAccessor bindingAccessor;
                ClientBinding clientBinding;
                WSDeploymentDescriptorAccessor ddAccessor;
                EObject refObject = (EObject)iter.next();
                String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
                String[] pieces = util.separateUriString((String)moduleURI);
                String moduleName = pieces[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: working on module " + moduleURI);
                }
                if (!(ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabledClient()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: module " + moduleURI + " is Web Service enabled");
                }
                if ((clientBinding = (bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo)).getClientBinding()) == null) continue;
                String ejbName = "";
                if (bindingAccessor.isWebType(null)) {
                    EList services = clientBinding.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetDeployedWsdl(moduleName, ejbName, services, taskData);
                    continue;
                }
                EList scopedComponents = clientBinding.getComponentScopedRefs();
                if (scopedComponents == null || scopedComponents.isEmpty()) continue;
                int sc_size = scopedComponents.size();
                for (int i = 0; i < sc_size; ++i) {
                    ComponentScopedRefs csr = (ComponentScopedRefs)scopedComponents.get(i);
                    ejbName = csr.getComponentNameLink();
                    EList services = csr.getServiceRefs();
                    if (services == null || services.isEmpty()) continue;
                    this.searchServicesAndSetDeployedWsdl(moduleName, ejbName, services, taskData);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void searchServicesAndSetDeployedWsdl(String moduleMatch, String ejbMatch, EList services, String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchServicesAndSetDeployedWsdl", new Object[]{moduleMatch, ejbMatch});
        }
        int size = services.size();
        int taskDataRows = taskData.length - 1;
        block0: for (int i = 0; i < size; ++i) {
            ServiceRef sr = (ServiceRef)services.get(i);
            String serviceName = sr.getServiceRefLink();
            String deployedWsdl = sr.getDeployedWSDLFile();
            if (deployedWsdl == null) {
                deployedWsdl = "";
            }
            for (int j = 1; j < taskData.length; ++j) {
                String newWsdlFile;
                String[] taskRow = taskData[j];
                if (!moduleMatch.equals(taskRow[0]) || !ejbMatch.equals(taskRow[1]) || !serviceName.equals(taskRow[2]) || (newWsdlFile = taskRow[3]) == null && newWsdlFile.equals("")) continue;
                if (newWsdlFile.equals(" ")) {
                    sr.eUnset(sr.eClass().getEStructuralFeature("deployedWSDLFile"));
                    continue block0;
                }
                if (deployedWsdl.equals(newWsdlFile)) continue;
                sr.setDeployedWSDLFile(newWsdlFile);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchServicesAndSetDeployedWsdl");
        }
    }

    public String[] validate(AppDeploymentTask task, AppDeploymentInfo appDeploymentInfo) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> errorMessages = new Vector<String>();
        String[][] taskData = task.getTaskData();
        for (i = 1; taskData != null && i < taskData.length; ++i) {
            InputStream inputStream = null;
            String deployedWsdl = taskData[i][3];
            if (deployedWsdl == null || deployedWsdl.equals("") || deployedWsdl.equals(" ")) continue;
            try {
                inputStream = appDeploymentInfo.getInputStream(taskData[i][0], taskData[i][3]);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.ClientBindDeployedWSDLTaskHelper.validate", "429", this);
            }
            if (inputStream == null) {
                Object[] fillins = new Object[]{deployedWsdl, taskData[i][0]};
                String error = MessageFormat.format(util.getMessage((AppDeploymentTask)task, (String)"WSWS0058E"), fillins);
                errorMessages.addElement(error);
                continue;
            }
            try {
                inputStream.close();
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.ClientBindDeployedWSDLTaskHelper.validate", "451", this);
            }
        }
        this.buildErrorMessages(errorMessages);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientBindDeployedWSDLTaskHelper validate taskValidateErrorMessages");
            if (this.taskValidateErrorMessages != null && this.taskValidateErrorMessages.length > 0) {
                for (i = 0; i < this.taskValidateErrorMessages.length; ++i) {
                    Tr.exit(tc, "errors[" + i + "]=" + this.taskValidateErrorMessages[i]);
                }
            }
        }
        return this.taskValidateErrorMessages;
    }

    private void buildErrorMessages(Vector error) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientBindDeployedWSDLTaskHelper buildErrorMessages");
        }
        this.taskValidateErrorMessages = null;
        if (error != null && error.size() > 0) {
            this.taskValidateErrorMessages = new String[error.size()];
            for (int i = 0; i < error.size(); ++i) {
                this.taskValidateErrorMessages[i] = (String)error.elementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientBindDeployedWSDLTaskHelper buildErrorMessages");
        }
    }
}

