/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory;
import com.ibm.ws.webservices.multiprotocol.AgnosticService;

public class ServerConfigurationFactory
implements EngineConfigurationFactory {
    private static final TraceComponent _tc = Tr.register(ServerConfigurationFactory.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");

    public static EngineConfigurationFactory newFactory(Object param) {
        WebServicesService serviceHome = WebServicesServiceHome.getWebServicesService();
        return serviceHome instanceof WSServerImpl && (serviceHome.isServerWebServiceEnabled() || serviceHome.isClientWebServiceEnabled()) ? new ServerConfigurationFactory() : null;
    }

    private ServerConfigurationFactory() {
    }

    public EngineConfiguration getClientEngineConfig() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Entering ServerConfigurationFactory::getClientEngineConfig()");
        }
        EngineConfiguration returnEngineConfiruration = null;
        String useGlobalHandlers = AgnosticService.getWhichGlobalHandlersToUseOffThread();
        if (!"SYSTEM_ENGINE".equals(useGlobalHandlers) && !"APPLICATION_ENGINE".equals(useGlobalHandlers)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.ws.webservices.configuration.ServerConfigurationFactory.getClientEngineConfig(): Looking for 109 client configuration");
            }
            returnEngineConfiruration = WebServicesServiceHome.getWebServicesService().getClientEngineConfig();
        }
        if (returnEngineConfiruration == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServerConfigurationFactory.getClientEngineConfig(): Using an unmanaged 101 client inside server.  Global handler usage setting = " + useGlobalHandlers);
            }
            EngineConfigurationFactory defaultClientConfiguration = DefaultEngineConfigurationFactory.newFactory(useGlobalHandlers);
            returnEngineConfiruration = defaultClientConfiguration.getClientEngineConfig();
        }
        return returnEngineConfiruration;
    }

    public EngineConfiguration getServerEngineConfig() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Entering ServerConfigurationFactory::getServerEngineConfig()");
        }
        return WebServicesServiceHome.getWebServicesService().getServerEngineConfig();
    }
}

