/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.component.WSClientImpl;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory;
import com.ibm.ws.webservices.multiprotocol.AgnosticService;

public class ClientConfigurationFactory
implements EngineConfigurationFactory {
    private static final TraceComponent _tc = Tr.register(ClientConfigurationFactory.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");

    public static EngineConfigurationFactory newFactory(Object param) {
        WebServicesService serviceHome = WebServicesServiceHome.getWebServicesService();
        return serviceHome instanceof WSClientImpl && serviceHome.isClientWebServiceEnabled() ? new ClientConfigurationFactory() : null;
    }

    private ClientConfigurationFactory() {
    }

    public EngineConfiguration getClientEngineConfig() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClientEngineConfig");
        }
        EngineConfiguration returnEngineConfiruration = null;
        returnEngineConfiruration = WebServicesServiceHome.getWebServicesService().getClientEngineConfig();
        String useGlobalHandlers = AgnosticService.getWhichGlobalHandlersToUseOffThread();
        boolean ignore109ClientConfig = false;
        if ("SYSTEM_ENGINE".equals(useGlobalHandlers) || "APPLICATION_ENGINE".equals(useGlobalHandlers)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.ws.webservices.configuration.ClientConfigurationFactory.getClientEngineConfig(): Looking for 109 client configuration");
            }
            ignore109ClientConfig = true;
        }
        if (returnEngineConfiruration != null && ignore109ClientConfig) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ClientConfigurationFactory.getClientEngineConfig(): Using an unmanaged 101 client inside managed client.  Global handler usage setting = " + useGlobalHandlers);
            }
            EngineConfigurationFactory defaultClientConfiguration = DefaultEngineConfigurationFactory.newFactory(useGlobalHandlers);
            returnEngineConfiruration = defaultClientConfiguration.getClientEngineConfig();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getClientEngineConfig");
        }
        return returnEngineConfiruration;
    }

    public EngineConfiguration getServerEngineConfig() {
        return null;
    }
}

