/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.webservices.models.IMappingMetaData;
import com.ibm.wsspi.webservices.models.IWSModelsLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.wsdl.xml.WSDLReader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.internal.WrappedRuntimeException;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResource;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;

public class WSModelsLoader
implements IWSModelsLoader {
    private TraceComponent tc = Tr.register(WSModelsLoader.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");

    public void preInvoke(ConfigObject c) {
    }

    public void postInvoke(ConfigObject c) {
    }

    public WSBinding getWSBinding(LoadStrategy loadStrategy, String xmiFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWSBinding: xmiFileName=" + xmiFileName);
        }
        WSBinding wsbnd = null;
        if (loadStrategy.getContainer().containsFile(xmiFileName)) {
            ResourceSet rs = loadStrategy.getResourceSet();
            Resource res = null;
            if (loadStrategy.isMofResourceLoaded(xmiFileName)) {
                res = rs.getResource(URI.createURI(xmiFileName), false);
            } else if (loadStrategy.getContainer().containsFile(xmiFileName)) {
                res = rs.getResource(URI.createURI(xmiFileName), true);
            }
            if (res != null) {
                wsbnd = (WSBinding)res.getContents().get(0);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWSBinding");
        }
        return wsbnd;
    }

    public ClientBinding getWSClientBinding(LoadStrategy loadStrategy, String xmiFileName) throws Exception {
        Resource res;
        ClientBinding wscbnd;
        block8: {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "getClientBinding: xmiFileName=" + xmiFileName);
            }
            wscbnd = null;
            ResourceSet rs = loadStrategy.getResourceSet();
            res = null;
            if (loadStrategy.isMofResourceLoaded(xmiFileName)) {
                res = rs.getResource(URI.createURI(xmiFileName), false);
            } else {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "getClientBinding: File is not loaded as a resource");
                }
                try {
                    res = rs.getResource(URI.createURI(xmiFileName), true);
                }
                catch (Exception e) {
                    if (!this.tc.isDebugEnabled()) break block8;
                    Tr.debug(this.tc, "getClientBinding: The " + xmiFileName + " was not found in the archive");
                }
            }
        }
        if (res != null) {
            wscbnd = (ClientBinding)res.getContents().get(0);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getClientBinding, wscbnd= " + wscbnd);
        }
        return wscbnd;
    }

    public WsExtension getWSExtension(LoadStrategy loadStrategy, String xmiFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWsExtension: xmiFileName=" + xmiFileName);
        }
        WsExtension wsext = null;
        if (loadStrategy.getContainer().containsFile(xmiFileName)) {
            try {
                ResourceSet rs = loadStrategy.getResourceSet();
                Resource res = rs.getResource(URI.createURI(xmiFileName), true);
                if (res != null) {
                    wsext = (WsExtension)res.getContents().get(0);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWsExtension", "214");
                if (e instanceof WrappedRuntimeException) {
                    WrappedRuntimeException wre = (WrappedRuntimeException)e;
                    Exception wrappedExcp = wre.getNestedException();
                    Tr.error(this.tc, "internal.error", wrappedExcp);
                } else {
                    Tr.error(this.tc, "internal.error", e);
                }
                throw e;
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWsExtension");
        }
        return wsext;
    }

    public WsClientExtension getWSClientExtension(LoadStrategy loadStrategy, String xmiFileName) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWsClientExtension: xmiFileName=" + xmiFileName);
        }
        WsClientExtension wscext = null;
        if (loadStrategy.getContainer().containsFile(xmiFileName)) {
            try {
                ResourceSet rs = loadStrategy.getResourceSet();
                Resource res = null;
                res = rs.getResource(URI.createURI(xmiFileName), true);
                if (res != null) {
                    wscext = (WsClientExtension)res.getContents().get(0);
                }
            }
            catch (RuntimeException e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWsClientExtension", "269");
                if (e instanceof WrappedRuntimeException) {
                    WrappedRuntimeException wre = (WrappedRuntimeException)e;
                    Exception wrappedExcp = wre.getNestedException();
                    Tr.error(this.tc, "internal.error", wrappedExcp);
                } else {
                    Tr.error(this.tc, "internal.error", e);
                }
                throw e;
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWsClientExtension");
        }
        return wscext;
    }

    public WebServices getWebServices(LoadStrategy loadStrategy, String xmlFileName) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWebServices: xmlFileName=" + xmlFileName);
        }
        WebServices wsdd = null;
        if (loadStrategy.getContainer().containsFile(xmlFileName)) {
            try {
                ResourceSet rs = loadStrategy.getResourceSet();
                Resource res = rs.getResource(URI.createURI(xmlFileName), true);
                if (res != null) {
                    WsddResource wsddRes = (WsddResource)res;
                    wsdd = wsddRes.getWebServices();
                }
            }
            catch (RuntimeException e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWebServices", "325");
                if (e instanceof WrappedRuntimeException) {
                    WrappedRuntimeException wre = (WrappedRuntimeException)e;
                    Exception wrappedExcp = wre.getNestedException();
                    Tr.error(this.tc, "internal.error", wrappedExcp);
                } else {
                    Tr.error(this.tc, "internal.error", e);
                }
                throw e;
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWebServices");
        }
        return wsdd;
    }

    public WebServicesClient getWebServicesClient(LoadStrategy loadStrategy, String xmlFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWebServicesClient: xmlFileName=" + xmlFileName);
        }
        WebServicesClient wscdd = null;
        if (loadStrategy.getContainer().containsFile(xmlFileName)) {
            try {
                URI uri = URI.createURI(xmlFileName);
                ResourceSet rs = loadStrategy.getResourceSet();
                Resource res = rs.getResource(uri, true);
                if (res != null) {
                    wscdd = ((WebServicesResource)res).getWebServicesClient();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWebServicesClient", "381");
                if (e instanceof WrappedRuntimeException) {
                    WrappedRuntimeException wre = (WrappedRuntimeException)e;
                    Exception wrappedExcp = wre.getNestedException();
                    Tr.error(this.tc, "internal.error", wrappedExcp);
                } else {
                    Tr.error(this.tc, "internal.error", e);
                }
                throw e;
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWebServicesClient");
        }
        return wscdd;
    }

    public IMappingMetaData getJavaWSDLMapping(LoadStrategy loadStrategy, String xmlFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getJavaWSDLMapping: xmlFileName=" + xmlFileName);
        }
        MappingMetaData mmd = null;
        if (loadStrategy.getContainer().containsFile(xmlFileName)) {
            mmd = MappingMetaData.loadFromFile(xmlFileName, loadStrategy);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getJavaWSDLMapping : " + mmd);
        }
        return mmd;
    }

    public WSBinding getWSBindingFromResourceSet(ResourceSet rs, String xmiFileName) throws Exception {
        WSBinding wsbnd;
        block8: {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "getWSBindingFromResourceSet: xmiFileName=" + xmiFileName);
            }
            wsbnd = null;
            try {
                Resource res = null;
                res = rs.getResource(URI.createURI(xmiFileName), true);
                if (res != null) {
                    wsbnd = (WSBinding)res.getContents().get(0);
                }
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof FileNotFoundException)) {
                    FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWSBindingFromResourceSet", "492");
                    if (e instanceof WrappedRuntimeException) {
                        WrappedRuntimeException wre = (WrappedRuntimeException)e;
                        Exception wrappedExcp = wre.getNestedException();
                        Tr.error(this.tc, "internal.error", wrappedExcp);
                    } else {
                        Tr.error(this.tc, "internal.error", e);
                    }
                    throw e;
                }
                if (!this.tc.isDebugEnabled()) break block8;
                Tr.debug(this.tc, "Could not find the file: " + xmiFileName);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWSBindingFromResourceSet");
        }
        return wsbnd;
    }

    public ClientBinding getWSClientBindingFromResourceSet(ResourceSet rs, String xmiFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getClientBindingFromResourceSet: xmiFileName=" + xmiFileName);
        }
        ClientBinding wscbnd = null;
        try {
            Resource res = null;
            res = rs.getResource(URI.createURI(xmiFileName), true);
            if (res != null) {
                wscbnd = (ClientBinding)res.getContents().get(0);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getClientBindingFromResourceSet", "511");
            if (e instanceof WrappedRuntimeException) {
                WrappedRuntimeException wre = (WrappedRuntimeException)e;
                Exception wrappedExcp = wre.getNestedException();
                Tr.error(this.tc, "internal.error", wrappedExcp);
            } else {
                Tr.error(this.tc, "internal.error", e);
            }
            throw e;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getClientBindingFromResourceSet");
        }
        return wscbnd;
    }

    public WebServicesClient getWSClientFromResourceSet(ResourceSet rs, String xmlFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWebServicesClientFromResourceSet: xmlFileName=" + xmlFileName);
        }
        WebServicesClient wscdd = null;
        try {
            Resource res;
            Resource.Factory.Registry saveFactory = rs.getResourceFactoryRegistry();
            rs.setResourceFactoryRegistry((Resource.Factory.Registry)J2EEResourceFactoryRegistry.INSTANCE);
            try {
                res = rs.getResource(URI.createURI(xmlFileName), true);
                rs.setResourceFactoryRegistry(saveFactory);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWebServicesClientFromResourceSet", "593");
                rs.setResourceFactoryRegistry(saveFactory);
                throw e;
            }
            if (res != null) {
                wscdd = ((WebServicesResource)res).getWebServicesClient();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWebServicesClientFromResourceSet", "564");
            if (e instanceof WrappedRuntimeException) {
                WrappedRuntimeException wre = (WrappedRuntimeException)e;
                Exception wrappedExcp = wre.getNestedException();
                Tr.error(this.tc, "internal.error", wrappedExcp);
            } else {
                Tr.error(this.tc, "internal.error", e);
            }
            throw e;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWebServicesClientFromResourceSet");
        }
        return wscdd;
    }

    public EJBJar getEJBJarFromResourceSet(ResourceSet rs, String xmlFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getEJBJarFromResourceSet: xmlFileName=" + xmlFileName);
        }
        EJBJar ejbJar = null;
        try {
            Resource res;
            Resource.Factory.Registry saveFactory = rs.getResourceFactoryRegistry();
            rs.setResourceFactoryRegistry((Resource.Factory.Registry)J2EEResourceFactoryRegistry.INSTANCE);
            try {
                res = rs.getResource(URI.createURI(xmlFileName), true);
                rs.setResourceFactoryRegistry(saveFactory);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getEJBJarFromResourceSet", "652");
                rs.setResourceFactoryRegistry(saveFactory);
                throw e;
            }
            if (res != null) {
                ejbJar = ((EJBResource)res).getEJBJar();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getEJBJarFromResourceSet", "651");
            if (e instanceof WrappedRuntimeException) {
                WrappedRuntimeException wre = (WrappedRuntimeException)e;
                Exception wrappedExcp = wre.getNestedException();
                Tr.error(this.tc, "internal.error", wrappedExcp);
            } else {
                Tr.error(this.tc, "internal.error", e);
            }
            throw e;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getEJBJarFromResourceSet");
        }
        return ejbJar;
    }

    public WebApp getWebAppFromResourceSet(ResourceSet rs, String xmlFileName) throws Exception {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWebAppFromResourceSet: xmlFileName=" + xmlFileName);
        }
        WebApp webApp = null;
        try {
            Resource res;
            Resource.Factory.Registry saveFactory = rs.getResourceFactoryRegistry();
            rs.setResourceFactoryRegistry((Resource.Factory.Registry)J2EEResourceFactoryRegistry.INSTANCE);
            try {
                res = rs.getResource(URI.createURI(xmlFileName), true);
                rs.setResourceFactoryRegistry(saveFactory);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWebAppFromResourceSet", "707");
                rs.setResourceFactoryRegistry(saveFactory);
                throw e;
            }
            if (res != null) {
                webApp = ((WebAppResource)res).getWebApp();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.WSModels.getWebAppFromResourceSet", "705");
            if (e instanceof WrappedRuntimeException) {
                WrappedRuntimeException wre = (WrappedRuntimeException)e;
                Exception wrappedExcp = wre.getNestedException();
                Tr.error(this.tc, "internal.error", wrappedExcp);
            } else {
                Tr.error(this.tc, "internal.error", e);
            }
            throw e;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWebAppFromResourceSet");
        }
        return webApp;
    }

    public IMappingMetaData loadFromFile(String file, LoadStrategy loadStrategy) throws IOException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "loadFromFile: file =" + file);
        }
        MappingMetaData mmd = null;
        if (loadStrategy.getContainer().containsFile(file)) {
            mmd = MappingMetaData.loadFromFile(file, loadStrategy);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "loadFromFile : " + mmd);
        }
        return mmd;
    }

    public IMappingMetaData loadFromRes(String file, JaxrpcmapResource res) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "loadFromRes: file =" + file);
        }
        MappingMetaData mmd = null;
        if (res != null) {
            mmd = new MappingMetaData();
            mmd.setMap(res.getJavaWSDLMapping());
            if (res.isJaxrpcmap1_0()) {
                mmd.setVersion("1.0");
            } else {
                mmd.setVersion("1.1");
            }
            mmd.setLoadedFile(file);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "loadFromRes: " + mmd);
        }
        return mmd;
    }

    public InputStream getJavaWSDLInputStream(String wsdlFileName, LoadStrategy loadStrategy) throws IOException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getJavaWSDLInputStream: file =" + wsdlFileName);
        }
        InputStream is = null;
        if (loadStrategy.contains(wsdlFileName)) {
            is = loadStrategy.getResourceInputStream(wsdlFileName);
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getJavaWSDLInputStream: inputstream = " + is);
        }
        return is;
    }

    public String buildWSDLPath(String modulePath, String wsdlFileName) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "buildWSDLPath: modulePath =" + modulePath + " wsdlFileName =" + wsdlFileName);
        }
        String wsdlContext = modulePath + File.separator + wsdlFileName;
        wsdlContext = wsdlContext.replace('\\', '/');
        wsdlContext = wsdlContext.replace('/', File.separatorChar);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "buildWSDLPath: wsdlContext =" + wsdlContext);
        }
        return wsdlContext;
    }

    public WSDLReader getWSDLReader() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "getWSDLReader");
        }
        ServiceProviderManager spm = new ServiceProviderManager(null);
        WSDLReader reader = spm.getWSDLFactory().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("com.ibm.wsdl.parseXMLSchemas", true);
        reader.setFeature("javax.wsdl.importDocuments", true);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getWSDLReader returning " + (reader == null ? "null reader." : "non-null reader."));
        }
        return reader;
    }
}

