/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeIOCallback;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLQueuedHandshake;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLUtils {
    private static final TraceComponent tc = Tr.register(SSLUtils.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLUtils";
    private static WsByteBufferPoolManager byteBufferManager = WsByteBufferPoolManagerImpl.getRef();
    private static ByteBuffer emptyBuffer = ByteBuffer.allocate(1);

    public static void shutDownSSLEngine(SSLConnectionLink connLink, boolean isServer, boolean isConnected) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutDownSSLEngine: isServer: " + isServer + " isConnected: " + isConnected + " " + connLink);
        }
        SSLEngine engine2 = connLink.getSSLEngine();
        if (isServer) {
            if (!engine2.isInboundDone()) {
                if (isConnected) {
                    engine2.closeOutbound();
                    WsByteBuffer buffer = SSLUtils.allocateByteBuffer(engine2.getSession().getPacketBufferSize(), false);
                    SSLUtils.flushCloseDown(engine2, buffer, connLink.getDeviceWriteInterface());
                    buffer.release();
                }
                try {
                    engine2.closeInbound();
                }
                catch (SSLException se) {}
            }
        } else {
            if (!engine2.isOutboundDone()) {
                engine2.closeOutbound();
            }
            if (isConnected) {
                WsByteBuffer buffer = SSLUtils.allocateByteBuffer(engine2.getSession().getPacketBufferSize(), false);
                SSLUtils.flushCloseDown(engine2, buffer, connLink.getDeviceWriteInterface());
                buffer.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutDownSSLEngine");
        }
    }

    private static void flushCloseDown(SSLEngine engine2, WsByteBuffer outputBuffer, TCPWriteRequestContext deviceWriteInterface) {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "flushCloseDown");
            }
            try {
                SSLEngineResult.Status status = null;
                do {
                    SSLEngineResult result;
                    int amountToWrite;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "before wrap: \r\n\tbuf: " + SSLUtils.getBufferTraceInfo(outputBuffer));
                    }
                    if (0 < (amountToWrite = (result = engine2.wrap(emptyBuffer, outputBuffer.getWrappedByteBuffer())).bytesProduced())) {
                        outputBuffer.flip();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "after wrap: \r\n\tbuf: " + SSLUtils.getBufferTraceInfo(outputBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                    }
                    if (0 < amountToWrite) {
                        deviceWriteInterface.setBuffer(outputBuffer);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "write bytes: " + amountToWrite);
                        }
                        deviceWriteInterface.write(amountToWrite, 0);
                        outputBuffer.clear();
                    }
                    if (SSLEngineResult.Status.OK != (status = result.getStatus()) || 0 != amountToWrite) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not produce anything, quit now");
                    }
                    break;
                } while (status != SSLEngineResult.Status.CLOSED);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Exception caught closing down, " + e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "flushCloseDown");
        }
    }

    public static ByteBuffer[] getWrappedByteBuffers(WsByteBuffer[] wsbuffers) {
        ByteBuffer[] buffers = new ByteBuffer[wsbuffers.length];
        boolean foundNullBuffer = false;
        int i = 0;
        for (i = 0; i < wsbuffers.length; ++i) {
            if (wsbuffers[i] == null) {
                foundNullBuffer = true;
                break;
            }
            buffers[i] = wsbuffers[i].getWrappedByteBuffer();
        }
        if (foundNullBuffer) {
            ByteBuffer[] tempBuffers = buffers;
            buffers = new ByteBuffer[i];
            for (int j = 0; j < i; ++j) {
                buffers[j] = tempBuffers[j];
            }
        }
        return buffers;
    }

    public static void limitToCapacity(WsByteBuffer[] buffers) {
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] == null) continue;
                buffers[i].limit(buffers[i].capacity());
            }
        }
    }

    public static void positionToLimit(WsByteBuffer[] buffers) {
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] == null) continue;
                buffers[i].position(buffers[i].limit());
            }
        }
    }

    public static void flipBuffersToMark(WsByteBuffer[] buffers, int mark, int markBufferIndex) {
        WsByteBuffer buffer = null;
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                buffer = buffers[i];
                if (buffer == null) continue;
                if (i == markBufferIndex && mark != 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "mark is " + mark);
                    }
                    buffer.limit(buffer.position());
                    buffer.position(mark);
                    continue;
                }
                buffer.flip();
            }
        }
    }

    public static void flipBuffers(WsByteBuffer[] buffers, int totalSize) {
        int size = 0;
        boolean overLimit = false;
        for (int i = 0; i < buffers.length && null != buffers[i]; ++i) {
            if (overLimit) {
                buffers[i].limit(buffers[i].position());
                continue;
            }
            buffers[i].flip();
            overLimit = (size += buffers[i].remaining()) >= totalSize;
        }
    }

    public static void copyBuffer(WsByteBuffer src, WsByteBuffer dst) {
        SSLUtils.copyBuffer(src, dst, src.remaining());
    }

    public static void copyBuffer(WsByteBuffer src, WsByteBuffer dst, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "copyBuffer: length=" + length + "\r\n\tsrc: " + SSLUtils.getBufferTraceInfo(src) + "\r\n\tdst: " + SSLUtils.getBufferTraceInfo(dst));
        }
        if (dst.remaining() < length || src.remaining() < length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "copyBuffer: Not enough space");
            }
            RuntimeException e = new RuntimeException("Attempt to copy source buffer to inadequate destination buffer");
            FFDCFilter.processException((Throwable)e, CLASS_NAME, "373", src);
            throw e;
        }
        if (src.hasArray()) {
            int newSrcPosition = src.position() + length;
            dst.put(src.array(), src.arrayOffset() + src.position(), length);
            src.position(newSrcPosition);
        } else {
            byte[] srcByteArray = new byte[length];
            src.get(srcByteArray, 0, length);
            dst.put(srcByteArray);
        }
    }

    public static WsByteBuffer allocateByteBuffer(int size, boolean allocateDirect) {
        WsByteBuffer newBuffer = null;
        newBuffer = allocateDirect ? byteBufferManager.allocateDirect(size) : byteBufferManager.allocate(size);
        newBuffer.limit(newBuffer.capacity());
        return newBuffer;
    }

    public static String getBufferTraceInfo(WsByteBuffer[] buffers) {
        if (null == buffers) {
            return "Null buffer array";
        }
        StringBuilder sb = new StringBuilder(32 + 64 * buffers.length);
        for (int i = 0; i < buffers.length; ++i) {
            sb.append("\r\n\t  Buffer [");
            sb.append(i);
            sb.append("]: ");
            SSLUtils.getBufferTraceInfo(sb, buffers[i]);
        }
        return sb.toString();
    }

    public static StringBuilder getBufferTraceInfo(StringBuilder src, WsByteBuffer buffer) {
        StringBuilder sb;
        StringBuilder stringBuilder = sb = null == src ? new StringBuilder(64) : src;
        if (null == buffer) {
            return sb.append("null");
        }
        sb.append("hc=");
        sb.append(buffer.hashCode());
        sb.append(" pos=");
        sb.append(buffer.position());
        sb.append(" lim=");
        sb.append(buffer.limit());
        sb.append(" cap=");
        sb.append(buffer.capacity());
        return sb;
    }

    public static String getBufferTraceInfo(WsByteBuffer buffer) {
        if (null == buffer) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("hc=");
        sb.append(buffer.hashCode());
        sb.append(" pos=");
        sb.append(buffer.position());
        sb.append(" lim=");
        sb.append(buffer.limit());
        sb.append(" cap=");
        sb.append(buffer.capacity());
        return sb.toString();
    }

    public static String showBufferContents(WsByteBuffer[] buffers) {
        if (null == buffers || 0 == buffers.length) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffers.length; ++i) {
            sb.append("Buffer [");
            sb.append(i);
            if (null == buffers[i]) {
                sb.append("]: null\r\n");
                continue;
            }
            sb.append("]: ");
            sb.append(WsByteBufferUtils.asString(buffers[i]));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static WsByteBuffer[] allocateByteBuffers(int requestedBufferSize, long totalDataSize, boolean allocateDirect, boolean enforceRequestedSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "allocateByteBuffers");
        }
        WsByteBuffer firstBuffer = SSLUtils.allocateByteBuffer(requestedBufferSize, allocateDirect);
        if (enforceRequestedSize) {
            firstBuffer.limit(requestedBufferSize);
        }
        int actualBufferSize = firstBuffer.limit();
        boolean enforce = enforceRequestedSize;
        if (enforce && actualBufferSize == requestedBufferSize) {
            enforce = false;
        }
        int numBuffersToAllocate = (int)(totalDataSize / (long)actualBufferSize);
        if (totalDataSize % (long)actualBufferSize > 0L) {
            ++numBuffersToAllocate;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "allocate: requestSize=" + requestedBufferSize + ", actualSize=" + actualBufferSize + ", totSize=" + totalDataSize + ", numBufs=" + numBuffersToAllocate);
        }
        WsByteBuffer[] newBuffers = new WsByteBuffer[numBuffersToAllocate];
        newBuffers[0] = firstBuffer;
        for (int i = 1; i < newBuffers.length; ++i) {
            newBuffers[i] = SSLUtils.allocateByteBuffer(requestedBufferSize, allocateDirect);
            if (!enforce) continue;
            newBuffers[i].limit(requestedBufferSize);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "allocateByteBuffers");
        }
        return newBuffers;
    }

    public static boolean anyPositionsNonZero(WsByteBuffer[] buffers) {
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] == null || buffers[i].position() == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHandshaking(SSLEngine engine2) {
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != engine2.getHandshakeStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SSLEngineResult handleHandshake(SSLConnectionLink connLink, WsByteBuffer netBuffer, WsByteBuffer decryptedNetBuffer, WsByteBuffer encryptedAppBuffer, SSLEngineResult inResult, SSLHandshakeCompletedCallback handshakeCallback, boolean fromCallback) throws IOException, ReadOnlyBufferException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleHandshake, engine=" + connLink.getSSLEngine().hashCode());
        }
        SSLEngineResult result = inResult;
        if (connLink.getChannel().isZOSCR && handshakeCallback != null && !(Thread.currentThread() instanceof ThreadPool.DecoratedCRThread)) {
            if (connLink.isQueuedHandshake()) {
                FFDCFilter.processException(new Exception("SSL handshake on non-decorated thread"), "com.ibm.ws.ssl.channel.impl.SSLUtils.handleHandshake", "631");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake on non-decorated thread; however already queued once");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting off ACRW thread");
                }
                Map connectionInfo = JSSEHelper.getInstance().getInboundConnectionInfo();
                Properties props = connLink.getLinkConfig().getProperties();
                if (connectionInfo != null) {
                    Boolean isWebContainer;
                    String endpointName = (String)connectionInfo.get("com.ibm.ssl.endPointName");
                    if (endpointName != null) {
                        props.put("com.ibm.ssl.endPointName", endpointName);
                    }
                    if ((isWebContainer = (Boolean)connectionInfo.get("com.ibm.ssl.isWebContainerInbound")) != null) {
                        props.put("com.ibm.ssl.isWebContainerInbound", isWebContainer.toString());
                    }
                    SSLLinkConfig updatedLinkConfig = new SSLLinkConfig(props);
                    connLink.setLinkConfig(updatedLinkConfig);
                }
                SSLQueuedHandshake queuedWork = new SSLQueuedHandshake(connLink, netBuffer, decryptedNetBuffer, encryptedAppBuffer, result, handshakeCallback);
                ChannelException errorCause = null;
                try {
                    int executeRc = connLink.getThreadPool().execute(queuedWork, 2);
                    if (executeRc != 0) {
                        errorCause = new ChannelException("threadpool at capacity, request rejected");
                    }
                }
                catch (ChannelException ce) {
                    errorCause = ce;
                }
                if (errorCause != null) {
                    FFDCFilter.processException((Throwable)errorCause, CLASS_NAME, "677", connLink);
                    handshakeCallback.error(new IOException(errorCause.toString()));
                }
                return null;
            }
        }
        connLink.setQueuedHandshake(false);
        SSLEngine engine2 = connLink.getSSLEngine();
        TCPReadRequestContext deviceReadContext = connLink.getDeviceReadInterface();
        TCPWriteRequestContext deviceWriteContext = connLink.getDeviceWriteInterface();
        int amountToWrite = 0;
        boolean firstPass = true;
        SSLEngineResult.HandshakeStatus hsstatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        if (null != result) {
            hsstatus = result.getHandshakeStatus();
            status = result.getStatus();
        }
        SSLEngineResult.Status initialStatus = status;
        if (fromCallback && status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "From callback, former status BUFFER_UNDERFLOW.");
            }
            netBuffer.limit(netBuffer.position());
            netBuffer.reset();
            hsstatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            status = SSLEngineResult.Status.OK;
        }
        while (true) {
            block63: {
                block67: {
                    long bytesIn;
                    block68: {
                        block57: {
                            block64: {
                                block65: {
                                    block66: {
                                        SSLHandshakeIOCallback readCallback;
                                        VirtualConnection vc;
                                        block59: {
                                            block60: {
                                                block61: {
                                                    block62: {
                                                        block58: {
                                                            if (!SSLUtils.isHandshaking(engine2) && SSLEngineResult.Status.OK == status) break block57;
                                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                                Tr.debug(tc, "status=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus));
                                                            }
                                                            if (hsstatus != SSLEngineResult.HandshakeStatus.FINISHED) break block58;
                                                            if (connLink.getChannel().isZOS) {
                                                                JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
                                                            }
                                                            break block57;
                                                        }
                                                        if (hsstatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break block59;
                                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                                            Tr.event(tc, "before wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer));
                                                        }
                                                        if (0 < (amountToWrite = (result = engine2.wrap(emptyBuffer, encryptedAppBuffer.getWrappedByteBuffer())).bytesProduced())) {
                                                            encryptedAppBuffer.flip();
                                                        }
                                                        hsstatus = result.getHandshakeStatus();
                                                        status = result.getStatus();
                                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                                            Tr.event(tc, "after wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer) + "\r\n\tstatus=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                                                        }
                                                        if (0 >= amountToWrite) break block60;
                                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                                            Tr.event(tc, "Write bytes: " + amountToWrite);
                                                        }
                                                        deviceWriteContext.setBuffer(encryptedAppBuffer);
                                                        if (handshakeCallback == null) break block61;
                                                        SSLHandshakeIOCallback writeCallback = new SSLHandshakeIOCallback(connLink, netBuffer, decryptedNetBuffer, encryptedAppBuffer, result, handshakeCallback);
                                                        vc = deviceWriteContext.write(amountToWrite, writeCallback, false, 0);
                                                        if (vc == null) break block62;
                                                        encryptedAppBuffer.clear();
                                                        break block59;
                                                    }
                                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Write is not done.  Callback will be used.");
                                                    }
                                                    result = null;
                                                    break block57;
                                                }
                                                deviceWriteContext.write(amountToWrite, 0);
                                                encryptedAppBuffer.clear();
                                                break block59;
                                            }
                                            encryptedAppBuffer.clear();
                                        }
                                        while (hsstatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                                            Runnable task = engine2.getDelegatedTask();
                                            if (task != null) {
                                                task.run();
                                                hsstatus = engine2.getHandshakeStatus();
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "After task, hsstatus=" + (Object)((Object)hsstatus));
                                                }
                                            } else {
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "No task, setting status to HS_NEED_WRAP");
                                                }
                                                hsstatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                                            }
                                            result = new SSLEngineResult(status, hsstatus, 0, 0);
                                        }
                                        if (hsstatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) break block63;
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Get ready to decrypt data, netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer));
                                        }
                                        if (netBuffer.remaining() == netBuffer.capacity() && status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                            int size = netBuffer.capacity() + engine2.getSession().getPacketBufferSize();
                                            WsByteBuffer tempBuffer = SSLUtils.allocateByteBuffer(size, false);
                                            SSLUtils.copyBuffer(netBuffer, tempBuffer, netBuffer.remaining());
                                            tempBuffer.flip();
                                            netBuffer.release();
                                            netBuffer = tempBuffer;
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Had to grow the netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer));
                                            }
                                        }
                                        if (SSLEngineResult.Status.BUFFER_UNDERFLOW != status && (netBuffer.hasRemaining() || firstPass) && (netBuffer.remaining() != netBuffer.capacity() || firstPass && SSLEngineResult.Status.BUFFER_UNDERFLOW == initialStatus)) break block64;
                                        deviceReadContext.setBuffer(netBuffer);
                                        if (!netBuffer.hasRemaining() || netBuffer.remaining() == netBuffer.capacity()) {
                                            netBuffer.clear();
                                            netBuffer.mark();
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Nothing was in the buffer");
                                            }
                                        } else {
                                            netBuffer.mark();
                                            netBuffer.position(netBuffer.limit());
                                            netBuffer.limit(netBuffer.capacity());
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Existing data in netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer));
                                            }
                                        }
                                        if (handshakeCallback == null) break block65;
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Do async read");
                                        }
                                        if ((vc = deviceReadContext.read(1L, readCallback = new SSLHandshakeIOCallback(connLink, netBuffer, decryptedNetBuffer, encryptedAppBuffer, result, handshakeCallback), false, 0)) == null) break block66;
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Read already done.  No callback necessary.");
                                        }
                                        netBuffer.limit(netBuffer.position());
                                        netBuffer.reset();
                                        break block67;
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Read is not done.  Callback will be used.");
                                    }
                                    result = null;
                                    break block57;
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Do sync read");
                                }
                                bytesIn = 0L;
                                break block68;
                            }
                            if (!netBuffer.hasRemaining() && firstPass) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Callback came back with data that needs to be flipped.");
                                }
                                netBuffer.flip();
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Data already in netBuf: " + SSLUtils.getBufferTraceInfo(netBuffer));
                            }
                            break block67;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "after handshake loop, status=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus) + ", fromCallback=" + fromCallback + ", engine=" + engine2.hashCode() + "\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer));
                        }
                        if (fromCallback && null != result && null != handshakeCallback) {
                            handshakeCallback.complete(result);
                            result = null;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleHandshake");
                        }
                        return result;
                    }
                    while (bytesIn == 0L) {
                        try {
                            bytesIn = deviceReadContext.read(1L, 0);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                            Tr.event(tc, "Read bytes: " + bytesIn);
                        }
                        catch (IOException x) {
                            String s = "IOException receiving data during SSL Handshake.  One possible cause is that authenication may not be configured correctly";
                            Exception nx = new Exception(s, x);
                            FFDCFilter.processException(nx, "com.ibm.ws.ssl.channel.impls.SSLUtils", "905");
                            throw x;
                        }
                    }
                    netBuffer.limit(netBuffer.position());
                    netBuffer.reset();
                }
                if (0 != netBuffer.position() && netBuffer.limit() == netBuffer.capacity() && firstPass && SSLEngineResult.Status.BUFFER_UNDERFLOW != initialStatus) {
                    netBuffer.limit(netBuffer.position());
                    netBuffer.reset();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer));
                }
                result = engine2.unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                hsstatus = result.getHandshakeStatus();
                status = result.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)status) + " HSstatus=" + (Object)((Object)hsstatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                }
                if (netBuffer.remaining() == 0) {
                    netBuffer.clear();
                }
            }
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "BUFFER_OVERFLOW occured during handshake: " + (Object)((Object)hsstatus));
                }
                throw new SSLException("BUFFER_OVERFLOW occured during handshake: " + (Object)((Object)hsstatus));
            }
            if (status == SSLEngineResult.Status.CLOSED) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake terminated SSL engine: " + (Object)((Object)hsstatus));
                }
                throw new SSLException("Handshake terminated SSL engine: " + (Object)((Object)hsstatus));
            }
            firstPass = false;
        }
    }

    public static void handleHandshake(SSLEngine currentEngine, SSLEngine otherEngine) throws SSLException {
        WsByteBuffer encryptedAppBuffer1;
        WsByteBuffer decryptedNetBuffer1;
        WsByteBuffer netBuffer1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleHandshake");
        }
        if (currentEngine == null || otherEngine == null) {
            throw new SSLException("Null engine found: engine1=" + currentEngine + ", engine2=" + otherEngine);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parameters: engine1=" + currentEngine.hashCode() + ", engine2=" + otherEngine.hashCode());
        }
        WsByteBuffer netBuffer = netBuffer1 = SSLUtils.allocateByteBuffer(currentEngine.getSession().getPacketBufferSize(), false);
        WsByteBuffer decryptedNetBuffer = decryptedNetBuffer1 = SSLUtils.allocateByteBuffer(currentEngine.getSession().getApplicationBufferSize(), false);
        WsByteBuffer encryptedAppBuffer = encryptedAppBuffer1 = SSLUtils.allocateByteBuffer(currentEngine.getSession().getPacketBufferSize(), false);
        Runnable task = null;
        SSLEngine tempEngine = null;
        SSLEngineResult.HandshakeStatus tempStatus = null;
        SSLEngineResult.HandshakeStatus currentStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        SSLEngineResult.HandshakeStatus otherStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current engine= " + currentEngine.hashCode() + ", status=" + (Object)((Object)currentStatus));
        }
        while (SSLUtils.isHandshaking(currentEngine) || SSLUtils.isHandshaking(otherEngine) || currentStatus != SSLEngineResult.HandshakeStatus.FINISHED || otherStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            SSLEngineResult result;
            if (currentStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && encryptedAppBuffer.limit() == encryptedAppBuffer.capacity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before wrap: encBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer));
                }
                if (0 < (result = currentEngine.wrap(emptyBuffer, encryptedAppBuffer.getWrappedByteBuffer())).bytesProduced()) {
                    encryptedAppBuffer.flip();
                }
                currentStatus = result.getHandshakeStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after wrap: encBuf: " + SSLUtils.getBufferTraceInfo(encryptedAppBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " HSstatus=" + (Object)((Object)currentStatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                }
            } else if ((currentStatus == SSLEngineResult.HandshakeStatus.FINISHED || currentStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) && netBuffer.limit() != netBuffer.capacity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer));
                }
                result = currentEngine.unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                currentStatus = result.getHandshakeStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " HSstatus=" + (Object)((Object)currentStatus) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                }
                if (netBuffer.remaining() == 0) {
                    netBuffer.clear();
                }
            } else if (currentStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP && currentStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && currentStatus != SSLEngineResult.HandshakeStatus.FINISHED && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected status: " + (Object)((Object)currentStatus));
                throw new SSLException("Unexpected status: " + (Object)((Object)currentStatus));
            }
            if (currentStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                while (currentStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    task = currentEngine.getDelegatedTask();
                    if (task != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Run task");
                        }
                        task.run();
                        currentStatus = currentEngine.getHandshakeStatus();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "After task, handshake status=" + (Object)((Object)currentStatus));
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No task, setting status to HS_NEED_WRAP");
                    }
                    currentStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                }
                if (currentStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Switching engines");
            }
            netBuffer = encryptedAppBuffer;
            tempEngine = currentEngine;
            currentEngine = otherEngine;
            otherEngine = tempEngine;
            tempStatus = currentStatus;
            currentStatus = otherStatus;
            otherStatus = tempStatus;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "current engine= " + currentEngine.hashCode() + ", status=" + (Object)((Object)currentStatus));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleHandshake");
        }
    }

    public static SSLEngine getOutboundSSLEngine(SSLContext context, SSLLinkConfig config, String host, int port2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundSSLEngine, host=" + host + ", port=" + port2);
        }
        SSLEngine engine2 = context.createSSLEngine(host, port2);
        SSLUtils.configureEngine(engine2, FlowType.OUTBOUND, config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundSSLEngine, hc=" + engine2.hashCode());
        }
        return engine2;
    }

    public static SSLEngine getSSLEngine(SSLContext context, FlowType type, SSLLinkConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLEngine");
        }
        SSLEngine engine2 = context.createSSLEngine();
        SSLUtils.configureEngine(engine2, type, config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLEngine, hc=" + engine2.hashCode());
        }
        return engine2;
    }

    private static void configureEngine(SSLEngine engine2, FlowType type, SSLLinkConfig config) {
        block18: {
            engine2.setEnabledCipherSuites(config.getEnabledCipherSuites(engine2));
            String protocol2 = config.getProperty("com.ibm.ssl.protocol");
            if (protocol2 != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting protocol on engine to ", protocol2);
                }
                engine2.setEnabledProtocols(new String[]{protocol2});
            }
            if (type == FlowType.INBOUND) {
                engine2.setUseClientMode(false);
                boolean flag = config.getBooleanProperty("com.ibm.ssl.clientAuthentication");
                if (PlatformHelperFactory.getPlatformHelper().isZOS() && "LOCALOS".equals(SecurityObjectLocator.getCSIv2Config().getString("com.ibm.CSI.activeUserRegistry"))) {
                    String endpointName;
                    Boolean cbindCheckEnabled = Boolean.FALSE;
                    Map connectionInfo = JSSEHelper.getInstance().getInboundConnectionInfo();
                    if (connectionInfo != null && (endpointName = (String)connectionInfo.get("com.ibm.ssl.endPointName")) != null && endpointName.startsWith("WC_")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "The endpoint, " + endpointName + ", is web and we are on z/OS. Proceeding to get the mutualAuthCbindCheck property.");
                        }
                        try {
                            String className = "com.ibm.ws.security.zOS.NativeConfiguration";
                            Class<?> zNativeConfigClass = Class.forName("com.ibm.ws.security.zOS.NativeConfiguration");
                            Method getConfigMethod = zNativeConfigClass.getMethod("getConfig", null);
                            Object configInstance = getConfigMethod.invoke((Object)null, (Object[])null);
                            Method cbindCheckMethod = zNativeConfigClass.getMethod("isMutualAuthCBINDCheckEnabled", null);
                            cbindCheckEnabled = (Boolean)cbindCheckMethod.invoke(configInstance, (Object[])null);
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No class, object, or method found for CBIND check", new Object[]{e});
                            }
                            FFDCFilter.processException(e, "com.ibm.ws.ssl.channel.impls.SSLUtils", "1278");
                        }
                        if (cbindCheckEnabled.booleanValue()) {
                            flag = cbindCheckEnabled;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "The mutualAuthCBINDCheck is true, so hard-coded setNeedClientAuth to true.");
                            }
                        }
                    }
                }
                engine2.setNeedClientAuth(flag);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client auth needed is " + engine2.getNeedClientAuth());
                }
                if (!flag) {
                    flag = config.getBooleanProperty("com.ibm.ssl.clientAuthenticationSupported");
                    engine2.setWantClientAuth(flag);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Client auth supported is " + engine2.getWantClientAuth());
                    }
                }
            } else {
                engine2.setUseClientMode(true);
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling beginHandshake on engine");
                }
                engine2.beginHandshake();
            }
            catch (SSLException se) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block18;
                Tr.event(tc, "Error while starting handshake; " + se);
            }
        }
    }

    public static int[] adjustBuffersForJSSE(WsByteBuffer[] buffers, int maxBufferSize) {
        int[] limitInfo = null;
        int dataAmount = 0;
        for (int i = 0; i < buffers.length && null != buffers[i]; ++i) {
            if ((dataAmount += buffers[i].remaining()) > maxBufferSize) {
                int savedLimit = buffers[i].limit();
                limitInfo = new int[]{i, savedLimit};
                int overFlow = dataAmount - maxBufferSize;
                buffers[i].limit(savedLimit - overFlow);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "adjustBuffersForJSSE: buffer [" + i + "] from " + savedLimit + " to " + buffers[i].limit());
                break;
            }
            if (dataAmount == maxBufferSize) break;
        }
        return limitInfo;
    }

    public static int adjustBufferForJSSE(WsByteBuffer buffer, int maxBufferSize) {
        int size;
        int limit = -1;
        if (null != buffer && maxBufferSize < (size = buffer.remaining())) {
            limit = buffer.limit();
            int overFlow = size - maxBufferSize;
            buffer.limit(limit - overFlow);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "adjustBufferForJSSE: from " + limit + " to " + buffer.limit());
            }
        }
        return limit;
    }

    public static void resetBuffersAfterJSSE(WsByteBuffer[] buffers, int[] limitInfo) {
        WsByteBuffer buffer;
        if (limitInfo == null) {
            return;
        }
        int bufferIndex = limitInfo[0];
        int bufferLimit = limitInfo[1];
        if (buffers.length > bufferIndex && (buffer = buffers[bufferIndex]) != null && buffer.capacity() >= bufferLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "resetBuffersAfterJSSE: buffer [" + bufferIndex + "] from " + buffer.limit() + " to " + bufferLimit);
            }
            buffer.limit(bufferLimit);
        }
    }

    public static void getBufferLimits(WsByteBuffer[] buffers, int[] limits) {
        if (buffers != null && limits != null) {
            for (int i = 0; i < buffers.length && i < limits.length; ++i) {
                if (buffers[i] != null) {
                    limits[i] = buffers[i].limit();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getBufferLimits: buffer[" + i + "] limit of " + limits[i]);
                    continue;
                }
                limits[i] = 0;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getBufferLimits: null buffer[" + i + "] limit of " + limits[i]);
            }
        }
    }

    public static void setBufferLimits(WsByteBuffer[] buffers, int[] limits) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBufferLimits");
        }
        if (buffers != null && limits != null) {
            int bufferCapacity = 0;
            int limit = 0;
            for (int i = 0; i < buffers.length && i < limits.length; ++i) {
                if (buffers[i] == null) continue;
                bufferCapacity = buffers[i].capacity();
                limit = limits[i];
                if (buffers[i].limit() == limit) continue;
                if (bufferCapacity >= limit) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Buffer [" + i + "] being updated from " + buffers[i].limit() + " to " + limit);
                    }
                    buffers[i].limit(limit);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Buffer [" + i + "] has capacity " + bufferCapacity + " less than passed in limit " + limit);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBufferLimits");
        }
    }

    public static int lengthOf(WsByteBuffer[] src, int startIndex) {
        int length = 0;
        if (null != src) {
            for (int i = startIndex; i < src.length && null != src[i]; ++i) {
                length += src[i].remaining();
            }
        }
        return length;
    }

    public static WsByteBuffer[] compressBuffers(WsByteBuffer[] src, boolean releaseEmpty) {
        LinkedList<WsByteBuffer> output = new LinkedList<WsByteBuffer>();
        boolean first = true;
        int size = 0;
        for (int i = 0; i < src.length; ++i) {
            if (null == src[i]) continue;
            if (0 < src[i].remaining()) {
                if (first) {
                    output.add(src[i].slice());
                    src[i].release();
                    first = false;
                } else {
                    output.add(src[i]);
                }
                ++size;
                continue;
            }
            if (!releaseEmpty) continue;
            src[i].release();
        }
        if (0 == size) {
            return null;
        }
        WsByteBuffer[] data = new WsByteBuffer[size];
        output.toArray(data);
        return data;
    }

    static {
        emptyBuffer.limit(0);
    }
}

