/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.util.HashMap;
import javax.net.ssl.SSLEngineResult;

public class SSLQueuedHandshake
implements Runnable {
    private static final TraceComponent tc = Tr.register(SSLUtils.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private SSLConnectionLink connLink;
    private WsByteBuffer netBuffer;
    private WsByteBuffer decryptedNetBuffer;
    private WsByteBuffer encryptedAppBuffer;
    private SSLEngineResult result;
    private SSLHandshakeCompletedCallback handshakeCallback;

    public SSLQueuedHandshake(SSLConnectionLink inputConnLink, WsByteBuffer inputNetBuffer, WsByteBuffer inputDecryptedNetBuffer, WsByteBuffer inputEncryptedAppBuffer, SSLEngineResult inputResult, SSLHandshakeCompletedCallback inputHandshakeCallback) {
        this.connLink = inputConnLink;
        this.netBuffer = inputNetBuffer;
        this.decryptedNetBuffer = inputDecryptedNetBuffer;
        this.encryptedAppBuffer = inputEncryptedAppBuffer;
        this.result = inputResult;
        this.handshakeCallback = inputHandshakeCallback;
        this.connLink.setQueuedHandshake(true);
    }

    public void run() {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Should be off ACRW thread now so doing SSL handshake.");
            }
            HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
            String endpoint = this.connLink.getLinkConfig().getProperty("com.ibm.ssl.endPointName");
            String webContainer = this.connLink.getLinkConfig().getProperty("com.ibm.ssl.isWebContainerInbound");
            connectionInfo.put("com.ibm.ssl.endPointName", endpoint);
            connectionInfo.put("com.ibm.ssl.isWebContainerInbound", Boolean.valueOf(webContainer));
            JSSEHelper.getInstance().setInboundConnectionInfo(connectionInfo);
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, this.result, this.handshakeCallback, true);
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException in queued handshake, ioe=" + ioe);
            }
            this.handshakeCallback.error(ioe);
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwable in queued handshake, t=" + t);
            }
            IOException ioe = new IOException("Queued handshake failure");
            ioe.initCause(t);
            this.handshakeCallback.error(ioe);
        }
    }
}

