/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.timeutils.QuickApproxTime;

public class SSLHandshakeErrorTracker {
    private static final TraceComponent tc = Tr.register(SSLHandshakeErrorTracker.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final int MAX_ERRORS_PER_INTERVAL = 5;
    private static final long ERROR_INTERVAL = 3600000L;
    private long[] times = new long[5];
    private int start = 0;
    private int next = 0;
    private int count = 0;

    public void noteHandshakeError(Exception failure) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "noteHandshakeError: " + failure);
        }
        if (this.addErrorTime(QuickApproxTime.getRef().getApproxTime())) {
            Tr.error(tc, "handshake.failure", failure);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "noteHandshakeError");
        }
    }

    protected boolean addErrorTime(long newTime) {
        this.times[this.next] = newTime;
        this.next = (this.next + 1) % this.times.length;
        if (this.next == this.start) {
            this.start = (this.start + 1) % this.times.length;
        }
        this.count = (this.count + 1) % this.times.length;
        if (0 == this.count) {
            return true;
        }
        return newTime - this.times[this.start] >= 3600000L;
    }
}

