/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.config.FIPSManager;
import com.ibm.ws.ssl.provider.IBMJSSE2Provider;
import com.ibm.ws.ssl.provider.IBMJSSEProvider;
import com.ibm.ws.ssl.provider.SunJSSEProvider;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.net.ssl.SSLContext;

public class JSSEProviderFactory {
    private static TraceComponent tc = Tr.register(JSSEProviderFactory.class.getName(), "SSL");
    private static JSSEProvider cachedProvider = null;
    private static Boolean USE_FIPS_FLAG = new Boolean(false);
    private static Hashtable providerCache = new Hashtable();
    private static String IBMJSSEFIPS_PROVIDER = "IBMJSSEFIPS";
    private static String IBMJSSE_PROVIDER = "IBMJSSE";
    private static String IBMJSSE2_PROVIDER = "IBMJSSE2";
    private static String SUNJSSE_PROVIDER = "SunJSSE";
    private static String DEFAULT_PROVIDER = "IBMJSSE2";
    private static String trustManagerFactoryAlgorithm = null;
    private static String keyManagerFactoryAlgorithm = null;
    private static String defaultSSLSocketFactory = null;
    private static String defaultSSLServerSocketFactory = null;
    private static String isFipsEnabled = null;
    private static boolean fipsInitialized = false;
    private static List fipsJCEProvidersObjectList = null;
    private static List fipsJSSEProvidersObjectList = null;
    private static String providerFromProviderList = "IBMJSSE2";

    public static JSSEProvider getInstance() {
        return JSSEProviderFactory.getInstance(null);
    }

    public static JSSEProvider getInstance(String contextProvider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance: " + contextProvider);
        }
        if (contextProvider == null) {
            contextProvider = JSSEProviderFactory.getProviderFromProviderList();
        }
        if (contextProvider == null) {
            contextProvider = DEFAULT_PROVIDER;
        }
        if (contextProvider != null) {
            if (JSSEProviderFactory.isFipsEnabled() || contextProvider.equalsIgnoreCase(IBMJSSEFIPS_PROVIDER)) {
                contextProvider = IBMJSSE2_PROVIDER;
            }
            if ((cachedProvider = (JSSEProvider)providerCache.get(contextProvider)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInstance returning cached provider: " + cachedProvider);
                }
                return cachedProvider;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cachedProvider is null, proceeding to determine the provider.");
            }
        }
        final String contextProviderPriv = contextProvider;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Provider provider = Security.getProvider(contextProviderPriv);
                if (provider == null) {
                    block16: {
                        if (JSSEProviderFactory.isFipsEnabled() || contextProviderPriv.equalsIgnoreCase(IBMJSSE2_PROVIDER)) {
                            try {
                                provider = (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance();
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception loading provider: " + contextProviderPriv);
                                }
                                break block16;
                            }
                        }
                        if (contextProviderPriv.equalsIgnoreCase(IBMJSSE_PROVIDER)) {
                            try {
                                provider = (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance();
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception loading provider: " + contextProviderPriv);
                                }
                                break block16;
                            }
                        }
                        if (contextProviderPriv.equalsIgnoreCase(SUNJSSE_PROVIDER)) {
                            try {
                                provider = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception loading provider: " + contextProviderPriv);
                                }
                                break block16;
                            }
                        }
                        try {
                            provider = (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance();
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block16;
                            Tr.debug(tc, "Exception loading provider: " + contextProviderPriv);
                        }
                    }
                    if (provider != null && provider instanceof Provider) {
                        Security.addProvider(provider);
                    }
                }
                return null;
            }
        });
        Provider[] providerList = Security.getProviders();
        for (int i = 0; i < providerList.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Provider name [" + i + "]: " + providerList[i].getName());
            }
            if (cachedProvider == null && providerList[i].getName().equalsIgnoreCase(contextProvider)) {
                if (contextProvider.equalsIgnoreCase(IBMJSSE2_PROVIDER) && JSSEProviderFactory.validateProvider(IBMJSSE2_PROVIDER)) {
                    cachedProvider = new IBMJSSE2Provider();
                    providerCache.put(IBMJSSE2_PROVIDER, cachedProvider);
                    providerCache.put(contextProvider, cachedProvider);
                } else if (contextProvider.equalsIgnoreCase(IBMJSSE_PROVIDER) && JSSEProviderFactory.validateProvider(IBMJSSE_PROVIDER)) {
                    cachedProvider = new IBMJSSEProvider();
                    providerCache.put(IBMJSSE_PROVIDER, cachedProvider);
                    providerCache.put(contextProvider, cachedProvider);
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        Tr.warning(tc, "UseFIPS is enabled but the SSL Configuration is not using FIPS approved JSSE Provider. FIPS approved cryptographic algorithms will not be used in this case.");
                    }
                } else if (contextProvider.equalsIgnoreCase(SUNJSSE_PROVIDER) && JSSEProviderFactory.validateProvider(SUNJSSE_PROVIDER)) {
                    cachedProvider = new SunJSSEProvider();
                    providerCache.put(SUNJSSE_PROVIDER, cachedProvider);
                    providerCache.put(contextProvider, cachedProvider);
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        Tr.warning(tc, "UseFIPS is enabled but the SSL Configuration is not using FIPS approved JSSE Provider. FIPS approved cryptographic algorithms will not be used in this case.");
                    }
                } else {
                    cachedProvider = new IBMJSSE2Provider();
                    providerCache.put(IBMJSSE2_PROVIDER, cachedProvider);
                    providerCache.put(contextProvider, cachedProvider);
                }
            }
            if (cachedProvider != null) continue;
            cachedProvider = new IBMJSSE2Provider();
            providerCache.put(IBMJSSE2_PROVIDER, cachedProvider);
            providerCache.put(contextProvider, cachedProvider);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance provider = " + cachedProvider);
        }
        return cachedProvider;
    }

    private static boolean validateProvider(String provider) {
        boolean success = true;
        try {
            SSLContext sslContext = null;
            try {
                String protocol2 = "SSL";
                if (JSSEProviderFactory.isFipsEnabled()) {
                    protocol2 = "TLS";
                }
                final String final_protocol = protocol2;
                final String final_contextProvider = provider;
                sslContext = (SSLContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchAlgorithmException, NoSuchProviderException {
                        return SSLContext.getInstance(final_protocol, final_contextProvider);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error validating provider: " + provider + ", Exception: " + ex.getMessage(), new Object[]{ex});
                }
                success = false;
            }
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error validating provider: " + provider + ", Exception: " + e.getMessage(), new Object[]{e});
            }
            success = false;
        }
        return success;
    }

    public static String getDefaultSSLSocketFactory() {
        if (defaultSSLSocketFactory == null) {
            defaultSSLSocketFactory = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.SocketFactory.provider");
                }
            });
        }
        return defaultSSLSocketFactory;
    }

    public static String getDefaultSSLServerSocketFactory() {
        if (defaultSSLServerSocketFactory == null) {
            defaultSSLServerSocketFactory = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.ServerSocketFactory.provider");
                }
            });
        }
        return defaultSSLServerSocketFactory;
    }

    public static String getKeyManagerFactoryAlgorithm() {
        if (keyManagerFactoryAlgorithm == null) {
            keyManagerFactoryAlgorithm = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.KeyManagerFactory.algorithm");
                }
            });
        }
        return keyManagerFactoryAlgorithm;
    }

    public static String getTrustManagerFactoryAlgorithm() {
        if (trustManagerFactoryAlgorithm == null) {
            trustManagerFactoryAlgorithm = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.TrustManagerFactory.algorithm");
                }
            });
        }
        return trustManagerFactoryAlgorithm;
    }

    public static boolean isFipsEnabled() {
        return FIPSManager.getInstance().isFIPSEnabled();
    }

    public static void initializeIBMCMSProvider() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeIBMCMSProvider");
        }
        if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeIBMCMSProvider (iSeries platform)");
            }
            return;
        }
        Provider provider = Security.getProvider("IBMCMSProvider");
        if (provider != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeIBMCMSProvider (already present)");
            }
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block3: {
                    try {
                        Provider provider = (Provider)Class.forName("com.ibm.security.cmskeystore.CMSProvider").newInstance();
                        if (provider != null) {
                            Security.addProvider(provider);
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block3;
                        Tr.debug(tc, "Exception loading provider: com.ibm.security.cmskeystore.CMSProvider");
                    }
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeIBMCMSProvider (provider initialized)");
        }
    }

    public static void initializeFips() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeFips");
        }
        if (!fipsInitialized) {
            int ibmjce_position = 0;
            int ibmjcefips_position = 0;
            int sun_position = 0;
            Provider[] provider_list = null;
            Provider ibmjce = null;
            Provider ibmjcefips = null;
            Provider sun = null;
            try {
                block22: {
                    System.setProperty("com.ibm.jsse2.JSSEFIPS", "true");
                    provider_list = Security.getProviders();
                    for (int i = 0; i < provider_list.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Provider[" + i + "]: " + provider_list[i].getName());
                        }
                        if (provider_list[i].getName().equals("IBMJCE")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "IBMJCE provider at position " + i);
                            }
                            ibmjce_position = i;
                            ibmjce = provider_list[i];
                            continue;
                        }
                        if (provider_list[i].getName().equals("IBMJCEFIPS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "IBMJCEFIPS provider at position " + i);
                            }
                            ibmjcefips_position = i;
                            ibmjcefips = provider_list[i];
                            continue;
                        }
                        if (!provider_list[i].getName().equals("SUN")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SUN provider at position " + i);
                        }
                        sun_position = i;
                        sun = provider_list[i];
                    }
                    if (ibmjcefips == null) {
                        provider_list = Security.getProviders();
                        try {
                            ibmjcefips = (Provider)Class.forName("com.ibm.crypto.fips.provider.IBMJCEFIPS").newInstance();
                            if (sun != null) {
                                JSSEProviderFactory.insertProviderAt(sun, 1);
                                JSSEProviderFactory.insertProviderAt(ibmjcefips, 2);
                                break block22;
                            }
                            JSSEProviderFactory.insertProviderAt(ibmjcefips, 1);
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception loading provider: com.ibm.crypto.fips.provider.IBMJCEFIPS");
                            }
                            break block22;
                        }
                    }
                    if (ibmjcefips != null && ibmjcefips_position != 0) {
                        provider_list = Security.getProviders();
                        if (sun != null) {
                            JSSEProviderFactory.insertProviderAt(sun, 1);
                            JSSEProviderFactory.insertProviderAt(ibmjcefips, 2);
                        } else {
                            JSSEProviderFactory.insertProviderAt(ibmjcefips, 1);
                        }
                    }
                }
                provider_list = Security.getProviders();
                for (int i = 0; i < provider_list.length; ++i) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Provider[" + i + "]: " + provider_list[i].getName() + ", info: " + provider_list[i].getInfo());
                }
                fipsInitialized = true;
            }
            catch (Exception e) {
                Tr.warning(tc, "security.addprovider.error", new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught adding IBMJCEFIPS provider.", new Object[]{e});
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeFips");
        }
    }

    public static void insertProviderAt(Provider newProvider, int slot) {
        Provider currentProvider;
        int i;
        Provider[] provider_list = Security.getProviders();
        Provider[] newList = null;
        if (provider_list != null && provider_list.length > 0) {
            newList = new Provider[provider_list.length + 2];
            newList[slot] = newProvider;
        }
        int newListIndex = 1;
        for (i = 0; i < provider_list.length; ++i) {
            currentProvider = provider_list[i];
            if (currentProvider == null || currentProvider.getName() == newProvider.getName()) continue;
            while (newList[newListIndex] != null) {
                ++newListIndex;
            }
            newList[newListIndex] = currentProvider;
            ++newListIndex;
        }
        JSSEProviderFactory.removeAllProviders();
        provider_list = Security.getProviders();
        for (i = 0; i < newList.length; ++i) {
            currentProvider = newList[i];
            if (currentProvider == null) continue;
            int position = Security.insertProviderAt(currentProvider, i + 1);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, currentProvider.getName() + " provider added at position " + position);
        }
    }

    public static void removeAllProviders() {
        Provider[] provider_list = Security.getProviders();
        for (int i = 0; i < provider_list.length; ++i) {
            String name2;
            if (provider_list[i] == null || (name2 = provider_list[i].getName()) == null) continue;
            Security.removeProvider(name2);
        }
    }

    public static List fipsJCEProviders() {
        String[] fipsJCEProvidersList = new String[]{"IBMJCEFIPS"};
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fipsJCEProviders");
        }
        if (fipsJCEProvidersObjectList == null) {
            fipsJCEProvidersObjectList = new ArrayList(fipsJCEProvidersList.length);
            if (JSSEProviderFactory.isFipsEnabled()) {
                for (int i = 0; i < fipsJCEProvidersList.length; ++i) {
                    fipsJCEProvidersObjectList.add(fipsJCEProvidersList[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fipsJCEProviders: " + fipsJCEProvidersObjectList);
        }
        return fipsJCEProvidersObjectList;
    }

    public static List fipsJSSEProviders() {
        String[] fipsJSSEProvidersList = new String[]{"IBMJSSE2"};
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fipsJSSEProviders");
        }
        if (fipsJSSEProvidersObjectList == null) {
            fipsJSSEProvidersObjectList = new ArrayList(fipsJSSEProvidersList.length);
            if (JSSEProviderFactory.isFipsEnabled()) {
                for (int i = 0; i < fipsJSSEProvidersList.length; ++i) {
                    fipsJSSEProvidersObjectList.add(fipsJSSEProvidersList[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fipsJCEProviders: " + fipsJSSEProvidersObjectList);
        }
        return fipsJSSEProvidersObjectList;
    }

    private static String getProviderFromProviderList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProviderFromProviderList");
        }
        Provider[] providerList = Security.getProviders();
        for (int i = 0; i < providerList.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Provider name [" + i + "]: " + providerList[i].getName());
            }
            if (providerList[i].getName().equalsIgnoreCase(IBMJSSE2_PROVIDER)) {
                providerFromProviderList = IBMJSSE2_PROVIDER;
                break;
            }
            if (providerList[i].getName().equalsIgnoreCase(IBMJSSE_PROVIDER)) {
                providerFromProviderList = IBMJSSE_PROVIDER;
                break;
            }
            if (!providerList[i].getName().equalsIgnoreCase(SUNJSSE_PROVIDER)) continue;
            providerFromProviderList = SUNJSSE_PROVIDER;
            break;
        }
        if (providerFromProviderList == null) {
            providerFromProviderList = IBMJSSE2_PROVIDER;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProviderFromProviderList -> " + providerFromProviderList);
        }
        return providerFromProviderList;
    }
}

