/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import javax.security.auth.Subject;

public final class SyncToOSThreadHelper {
    private static final TraceComponent tc = Tr.register(SyncToOSThreadHelper.class, "Security", "com.ibm.ejs.resources.security");
    private WSLoginLocalOSExtension _localSecurity = null;
    private boolean _syncEnabled = false;

    public SyncToOSThreadHelper() {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if ((contextManager = ContextManagerFactory.getInstance()).processIsServer() && contextManager.getPlatformHelper().isZOS()) {
            this._localSecurity = WSLoginLocalOSExtensionFactory.getInstance();
        }
        if (this._localSecurity != null) {
            this._syncEnabled = this._localSecurity.isApplicationSyncToOSThreadEnabled();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Object setAppSyncToThread(Subject invokeSubject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAppSynctothread", invokeSubject);
        }
        Object threadToken = null;
        if (this._syncEnabled) {
            threadToken = this._localSecurity.setAppLocalOSThreadID(invokeSubject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAppSyncToThread", threadToken);
        }
        return threadToken;
    }

    public void restoreAppSyncToThread(Object threadToken) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreAppSyncToThread", threadToken);
        }
        if (threadToken != null && this._syncEnabled) {
            this._localSecurity.restoreAppLocalOSThreadID(threadToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreAppSyncToThread");
        }
    }

    public boolean isThreadLocalApplicationSyncEnabled() {
        boolean enabled = false;
        if (this._syncEnabled) {
            enabled = this._localSecurity.isThreadLocalApplicationSyncEnabled();
        }
        return enabled;
    }

    public void setThreadLocalApplicationSyncEnabled(boolean enabled) {
        if (this._syncEnabled) {
            this._localSecurity.setThreadLocalApplicationSyncEnabled(enabled);
        }
    }

    public boolean isCurrentComponentAppSyncEnabled() {
        boolean enabled = false;
        if (this._syncEnabled) {
            enabled = this._localSecurity.getAppSyncEnabledFromComponentMetaData();
        }
        return enabled;
    }
}

