/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orb.transport.WSSSLServerSocketFactory;
import com.ibm.ws.orbimpl.transport.WSTransport;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.orbssl.SocketFactoryMessageUtility;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class WSSSLServerSocketFactoryImpl
implements WSSSLServerSocketFactory {
    private static final String SCCSID = " @(#) 1.22.2.1 ws/code/orbext/src/com/ibm/ws/security/orbssl/WSSSLServerSocketFactoryImpl.java, WAS.orbext, ASV 2/20/04 09:35:20 [2/20/04 16:38:57]";
    private static String[] ENABLED_CIPHERS = null;
    private static String[] SUPPORTED_CIPHERS = null;
    private static SSLContext sslContext;
    private static Properties sslProperties;

    public synchronized ServerSocket createSSLServerSocket(ServerConnectionData serverConnectionData) {
        SSLServerConnectionData scd = (SSLServerConnectionData)serverConnectionData;
        SSLServerSocket ssl_server_sock = null;
        boolean messageLoggingEnabled = scd.getMessageLoggingEnabled();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "IIOPSSLConnection.createSSLServerSocket", "\n[\n" + ((Object)scd).toString() + "\n]\n");
        }
        try {
            String sslAlias = scd.getSSLConfigAlias();
            String endPointName = scd.getEndPointName();
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "inbound");
            connectionInfo.put("com.ibm.ssl.endPointName", endPointName);
            sslContext = JSSEHelper.getInstance().getSSLContext(sslAlias, connectionInfo, WSTransport.getInstanceToRegisterListener());
            sslProperties = JSSEHelper.getInstance().getProperties(sslAlias, connectionInfo, null);
            short targetSupports = scd.getTargetSupportsQOP();
            short targetRequires = scd.getTargetRequiresQOP();
            if (targetSupports < 1) {
                if (!messageLoggingEnabled) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that was passed to createSSLServerSocket returns a value for getTargetSupportsQOP() that is less than 1.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_SUPPORTS_LESS_THAN_1", 1229066355, CompletionStatus.COMPLETED_NO);
            }
            if (targetRequires < 1) {
                if (!messageLoggingEnabled) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that is passed to createSSLServerSocket returned a value from getTargetRequiresQOP() that is less than 1.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.targetRequires"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_REQUIRES_LESS_THAN_1", 1229066356, CompletionStatus.COMPLETED_NO);
            }
            if (targetSupports < targetRequires) {
                if (!messageLoggingEnabled) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that is passed to createSSLServerSocket contains a TargetSupportsQOP value that is less than its  TargetRequirsQOP value.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.targetSupports2"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_LESS_THAN_TARGET_REQUIRES", 1229066357, CompletionStatus.COMPLETED_NO);
            }
            SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
            try {
                if (scd.getUseSingleNIC()) {
                    ssl_server_sock = (SSLServerSocket)factory.createServerSocket(scd.getServerPort(), scd.getServerServerQueueDepth(), InetAddress.getByName(scd.getServerHost()));
                    if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLServerSocket()", "Bind Server Socket To A Specific NIC card=" + scd.getUseSingleNIC() + ", Remote Port=" + scd.getServerPort() + ", Server Queue Depth=" + scd.getServerServerQueueDepth() + ", LocalHost=" + scd.getServerHost() + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(scd.getServerHost()));
                    }
                } else {
                    ssl_server_sock = (SSLServerSocket)factory.createServerSocket(scd.getServerPort(), scd.getServerServerQueueDepth());
                    if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLServerSocket()", "Bind Server Socket To Multiple NIC cards=" + !scd.getUseSingleNIC() + ", Remote Port=" + scd.getServerPort() + ", Server Queue Depth=" + scd.getServerServerQueueDepth());
                    }
                }
                if (endPointName != null && endPointName.equals("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS")) {
                    ssl_server_sock.setNeedClientAuth(true);
                } else if (endPointName != null && endPointName.equals("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS")) {
                    ssl_server_sock.setNeedClientAuth(false);
                    ssl_server_sock.setWantClientAuth(false);
                } else {
                    String clientAuth;
                    String clientAuthSupported = sslProperties.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                    if (clientAuthSupported != null && clientAuthSupported.equals("true")) {
                        ssl_server_sock.setWantClientAuth(true);
                    }
                    if ((clientAuth = sslProperties.getProperty("com.ibm.ssl.clientAuthentication")) != null && clientAuth.equals("true")) {
                        ssl_server_sock.setNeedClientAuth(true);
                    }
                }
            }
            catch (IOException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", "368", this);
                if (!messageLoggingEnabled) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", (Exception)ex);
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)ex);
                }
                throw new INTERNAL("UNABLE_TO_CREATE_SSL_SERVER_SOCKET Exception=" + ex, 1229066358, CompletionStatus.COMPLETED_NO);
            }
            if (ssl_server_sock != null) {
                String enabledCiphers = sslProperties.getProperty("com.ibm.ssl.enabledCipherSuites");
                ENABLED_CIPHERS = SSLConfigManager.getInstance().parseEnabledCiphers(enabledCiphers);
                if (ENABLED_CIPHERS == null) {
                    String securityLevel = sslProperties.getProperty("com.ibm.ssl.securityLevel");
                    SUPPORTED_CIPHERS = factory.getSupportedCipherSuites();
                    SUPPORTED_CIPHERS = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(SUPPORTED_CIPHERS, securityLevel);
                }
                if (ENABLED_CIPHERS != null && ENABLED_CIPHERS.length > 0) {
                    ssl_server_sock.setEnabledCipherSuites(ENABLED_CIPHERS);
                } else if (SUPPORTED_CIPHERS != null && SUPPORTED_CIPHERS.length > 0) {
                    ssl_server_sock.setEnabledCipherSuites(SUPPORTED_CIPHERS);
                }
            }
        }
        catch (COMM_FAILURE ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", "426", this);
            if (!messageLoggingEnabled) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", (Exception)((Object)ex));
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", "459", this);
            String[] fillins = new String[]{ex.toString()};
            if (!messageLoggingEnabled) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", ex);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)ex);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + ex, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        if (serverConnectionData.getServerPort() == 0) {
            serverConnectionData.setServerPort(ssl_server_sock.getLocalPort());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "Setting local port = " + serverConnectionData.getServerPort());
        }
        return ssl_server_sock;
    }

    public X509Certificate[] getPeerCertificateChain(SSLSocket theSocket) {
        SSLSession session;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "theSocket=" + theSocket);
        }
        if ((session = theSocket.getSession()) == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "IIOPSSLConnection.createSSLServerSocket", "theSocket.getSession returned null");
            }
            throw new INTERNAL("GET_SSL_SESSION_RETURNED_NULL", 1229066362, CompletionStatus.COMPLETED_NO);
        }
        X509Certificate[] peerCertificateChain = null;
        try {
            peerCertificateChain = (X509Certificate[])session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "Caught Exception from getPeerCertificateChain(),  returning a null for peerCertificateChain:  Exception=" + ex);
            }
            peerCertificateChain = null;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "About to return peerCertificateChain=" + peerCertificateChain);
        }
        return peerCertificateChain;
    }
}

