/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigException;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;

public class SecurityConfigRefreshHelper {
    private static TraceComponent tc = Tr.register(SecurityConfigRefreshHelper.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private static HashMap<String, Boolean> isNDDMZ = new HashMap();

    public static synchronized void clearCachesOnAdminAgentSubsystemStop() throws SecurityConfigException {
        block39: {
            block38: {
                boolean clearWebCollaborator;
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    SecurityConfigManager scm;
                                    if (tc.isEntryEnabled()) {
                                        Tr.entry(tc, "clearCachesOnAdminAgentSubsystemStop()");
                                    }
                                    if (!(scm = SecurityObjectLocator.getSecurityConfigManager()).isAdminAgent()) {
                                        throw new SecurityConfigException("SecurityConfigRefreshHelper.refreshAdminAgentProfile() called outside the AdminAgent process");
                                    }
                                    clearWebCollaborator = true;
                                    String uuid = scm.getDomainId();
                                    Boolean isContextNDDMZ = isNDDMZ.get(uuid);
                                    if (isContextNDDMZ == null) {
                                        String prodName = null;
                                        String aaNodeName = SecurityObjectLocator.getAdminData().getNodeName();
                                        String aaCellName = SecurityObjectLocator.getAdminData().getCellName();
                                        if (aaNodeName != null && aaCellName != null) {
                                            Properties props = new Properties();
                                            try {
                                                String path = SecurityObjectLocator.getAdminData().getConfigRootPath() + File.separator + "cells" + File.separator + aaCellName + File.separator + "nodes" + File.separator + aaNodeName + File.separator + "node-metadata.properties";
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "node-metadata path: " + path);
                                                }
                                                FileInputStream inStream = null;
                                                inStream = new FileInputStream(path);
                                                props.load(inStream);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                            prodName = props.getProperty("com.ibm.websphere.baseProductShortName");
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Product name is " + prodName);
                                        }
                                        if (prodName != null) {
                                            if (prodName.equalsIgnoreCase("nddmz")) {
                                                isNDDMZ.put(uuid, Boolean.TRUE);
                                                clearWebCollaborator = false;
                                            } else {
                                                isNDDMZ.put(uuid, Boolean.FALSE);
                                            }
                                        } else if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Unable to determine product name");
                                        }
                                    } else if (isContextNDDMZ.booleanValue()) {
                                        clearWebCollaborator = false;
                                    }
                                    try {
                                        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                                        SecurityObjectLocator.releaseSecurityConfig();
                                        SecurityObjectLocator.releaseNamingAuthzConfig();
                                        SecurityObjectLocator.releaseCSIv2Config();
                                        SecurityObjectLocator.releaseAdminData();
                                        SecurityObjectLocator.releaseRoleBasedConfigurator();
                                        scm.purgeCache(security2.getSCO());
                                    }
                                    catch (Exception e) {
                                        Tr.error(tc, "Unable to release caches during AdminAgent profile refresh.", e);
                                    }
                                    try {
                                        Class<?> msd_helper = Class.forName("com.ibm.ws.security.util.MultiDomainHelper");
                                        Method release_tags = msd_helper.getMethod("releaseTaggedComponents", null);
                                        release_tags.invoke((Object)null, (Object[])null);
                                    }
                                    catch (Exception e) {
                                        if (!tc.isDebugEnabled()) break block33;
                                        Tr.debug(tc, "Could not release CSIv2 tags", new Object[]{e});
                                    }
                                }
                                try {
                                    Class<?> patp = Class.forName("com.ibm.ws.security.role.PluggableAuthorizationTableProxy");
                                    Method patp_release = patp.getMethod("releaseInstance", null);
                                    patp_release.invoke((Object)null, (Object[])null);
                                }
                                catch (Exception e) {
                                    if (!tc.isDebugEnabled()) break block34;
                                    Tr.debug(tc, "Could not release cache for PluggableAuthorizationTableProxy.", new Object[]{e});
                                }
                            }
                            try {
                                Class<?> ac = Class.forName("com.ibm.ws.security.auth.AuthCache");
                                Method ac_release = ac.getMethod("releaseInstance", null);
                                ac_release.invoke((Object)null, (Object[])null);
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block35;
                                Tr.debug(tc, "Could not release cache for AuthCache.", new Object[]{e});
                            }
                        }
                        try {
                            Class<?> lso = Class.forName("com.ibm.ws.security.ltpa.LTPAServerObject");
                            Method lso_release = lso.getMethod("releaseLTPAServer", null);
                            lso_release.invoke((Object)null, (Object[])null);
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block36;
                            Tr.debug(tc, "Could not release cache for LTPAServerObject.", new Object[]{e});
                        }
                    }
                    try {
                        Class<?> srmf = Class.forName("com.ibm.ws.security.zOS.authz.SAFRoleMapperFactory");
                        Method srmf_release = srmf.getMethod("releaseSAFRoleMapper", null);
                        srmf_release.invoke((Object)null, (Object[])null);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block37;
                        Tr.debug(tc, "Could not release cache for SAFRoleMapperFactory.", new Object[]{e});
                    }
                }
                if (clearWebCollaborator) {
                    try {
                        Class<?> wc = Class.forName("com.ibm.ws.security.web.WebCollaborator");
                        Method wc_release = wc.getMethod("releaseAuthorizer", null);
                        wc_release.invoke((Object)null, (Object[])null);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block38;
                        Tr.debug(tc, "Could not release cache for WebCollaborator.", new Object[]{e});
                    }
                }
            }
            try {
                Class<?> cmf = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                Method cmf_release = cmf.getMethod("releaseInstance", null);
                cmf_release.invoke((Object)null, (Object[])null);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block39;
                Tr.debug(tc, "Could not release cache for ContextManagerFactory.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCachesOnAdminAgentSubsystemStop()");
        }
    }

    public static void refreshRuntime() {
    }
}

