/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.util.URLHandlerFactory;
import com.ibm.ws.runtime.util.URLStreamHandlerAdapter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public final class StreamHandlerUtils {
    private static final String DEFAULT_STREAM_HANDLER_CLASS_NAME = "com.ibm.resources.URLResourceProvider";
    private static Object urlHandlerSynch = new Object();
    private static URLHandlerFactory urlHandlerFactory = null;
    private static boolean runningInOSGi;
    private static Map streamHandlerAdapters;
    private static TraceComponent tc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryHandler() {
        if (runningInOSGi) {
            return true;
        }
        Object object = urlHandlerSynch;
        synchronized (object) {
            return urlHandlerFactory != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addProvider(String name2, String protocol2, String classname, String classpath) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", new Object[]{protocol2, classname, classpath});
        }
        if (runningInOSGi) {
            URLStreamHandlerAdapter adapter = new URLStreamHandlerAdapter(protocol2, classname, classpath);
            streamHandlerAdapters.put(protocol2, adapter);
        } else {
            Object object = urlHandlerSynch;
            synchronized (object) {
                try {
                    if (urlHandlerFactory == null) {
                        StreamHandlerUtils.createStreamHandler();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registering provider: " + protocol2 + " classpath: " + classpath);
                    }
                    urlHandlerFactory.registerProvider(name2, protocol2, classname, classpath);
                }
                catch (Exception e) {
                    Tr.debug(tc, "failure " + e.getMessage() + " registering provider " + classpath);
                    throw e;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProvider");
        }
    }

    private static void addProvider(String name2, String protocol2, String classname, List classpath) throws Throwable {
        StreamHandlerUtils.addProvider(name2, protocol2, classname, StreamHandlerUtils.getProviderClasspath(classpath));
    }

    public static void addProvider(ConfigObject provider) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", provider);
        }
        String name2 = provider.getString("name", "__null__");
        String protocol2 = provider.getString("protocol", "__null__");
        String classname = provider.getString("streamHandlerClassName", "__null__");
        if (classname == null || classname.length() == 0 || classname.equals("unused") || classname.equals(DEFAULT_STREAM_HANDLER_CLASS_NAME)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "skipping URL stream handler for " + protocol2 + " with class name " + classname);
            }
        } else {
            List classpath = provider.getStringList("classpath");
            StreamHandlerUtils.addProvider(name2, protocol2, classname, classpath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProvider");
        }
    }

    public static void addProvider(URLProvider provider, String classPath) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", new Object[]{provider, classPath});
        }
        StreamHandlerUtils.addProvider(provider.getName(), provider.getProtocol(), provider.getStreamHandlerClassName(), classPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProvider");
        }
    }

    public static void addProvider(String protocol2, String handlerClass) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", new Object[]{protocol2, handlerClass});
        }
        StreamHandlerUtils.addProvider(null, protocol2, handlerClass, (String)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProvider", new Object[]{protocol2, handlerClass});
        }
    }

    public static void addProvider(URLProvider provider) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProvider", provider);
        }
        StreamHandlerUtils.addProvider(provider.getName(), provider.getProtocol(), provider.getStreamHandlerClassName(), provider.getClasspath());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProvider", provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProvider(String protocol2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProvider", protocol2);
        }
        if (runningInOSGi) {
            URLStreamHandlerAdapter adapter = (URLStreamHandlerAdapter)streamHandlerAdapters.get(protocol2);
            if (adapter != null) {
                adapter.destroy();
                streamHandlerAdapters.remove(protocol2);
            }
        } else {
            Object object = urlHandlerSynch;
            synchronized (object) {
                try {
                    if (urlHandlerFactory == null) {
                        return;
                    }
                    urlHandlerFactory.deregisterProvider(protocol2);
                }
                catch (Exception e) {
                    Tr.debug(tc, "failure " + e.getMessage() + " deregistering provider " + protocol2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProvider", protocol2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryProvider(String protocol2) {
        if (runningInOSGi) {
            return streamHandlerAdapters.containsKey(protocol2);
        }
        Object object = urlHandlerSynch;
        synchronized (object) {
            if (urlHandlerFactory == null) {
                return false;
            }
            return urlHandlerFactory.queryProvider(protocol2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStreamHandler() throws Throwable {
        if (runningInOSGi) {
            return;
        }
        Object object = urlHandlerSynch;
        synchronized (object) {
            block8: {
                if (urlHandlerFactory == null) {
                    urlHandlerFactory = new URLHandlerFactory();
                    try {
                        URL.setURLStreamHandlerFactory(urlHandlerFactory);
                    }
                    catch (Throwable t) {
                        if (!tc.isDebugEnabled()) break block8;
                        if (t instanceof Error) {
                            Tr.debug(tc, "Exception " + t.toString() + " occurred.");
                            Tr.debug(tc, "Exception " + t.toString() + " if a URL Stream handler has already been set, add the safkeyring and safkeyringhw providers to it");
                        }
                        throw t;
                    }
                }
            }
        }
    }

    static boolean isStringEmpty(String s) {
        return s == null || s.length() <= 0;
    }

    static String appendClasspathStrings(String s1, String s2) {
        if (!StreamHandlerUtils.isStringEmpty(s1)) {
            s1 = s1.trim();
        }
        if (!StreamHandlerUtils.isStringEmpty(s2)) {
            s2 = s2.trim();
        }
        if (!StreamHandlerUtils.isStringEmpty(s2)) {
            if (StreamHandlerUtils.isStringEmpty(s1)) {
                return s2;
            }
            if (s1.endsWith(File.pathSeparator)) {
                return s1 + s2;
            }
            return s1 + File.pathSeparator + s2;
        }
        return s1;
    }

    static String getProviderClasspath(List providerClasspath) {
        ListIterator i1 = providerClasspath.listIterator();
        String classpath = new String();
        while (i1.hasNext()) {
            String classpathSegment = (String)i1.next();
            classpath = StreamHandlerUtils.appendClasspathStrings(classpath, classpathSegment);
        }
        return classpath;
    }

    static String getClassName(String path) {
        String classname = new String(path);
        classname = classname.replace(File.pathSeparatorChar, '.');
        return classname;
    }

    static ClassLoader getResourceClassLoader(String classpath, ClassLoader parent) throws MalformedURLException {
        ClassLoader classloader = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceClassLoader " + classpath + " : " + parent);
        }
        if (classpath == null || classpath.equalsIgnoreCase("")) {
            classloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ClassLoader result = Thread.currentThread().getContextClassLoader();
                    if (result == null) {
                        result = ClassLoader.getSystemClassLoader();
                    }
                    return result;
                }
            });
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parsing urls classpath=" + classpath);
            }
            StringTokenizer st = new StringTokenizer(classpath.trim(), File.pathSeparator);
            ArrayList<String> entries = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String urlString = st.nextToken().trim();
                if (urlString.equals("")) continue;
                entries.add(urlString);
            }
            final ArrayList<String> entriesF = entries;
            URL[] urls = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ArchiveUtil.toLocalURLs((List)entriesF, (String)File.separator);
                }
            });
            StringBuffer msgurls = new StringBuffer();
            for (int i = 0; i < urls.length; ++i) {
                msgurls.append("\n       " + urls[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadingurls: " + msgurls.toString());
            }
            final ClassLoader parentF = parent;
            final URL[] urlsF = urls;
            classloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (parentF == null) {
                        return new URLClassLoader(urlsF, Thread.currentThread().getContextClassLoader());
                    }
                    return new URLClassLoader(urlsF, parentF);
                }
            });
        }
        return classloader;
    }

    static {
        streamHandlerAdapters = Collections.synchronizedMap(new HashMap());
        tc = Tr.register(StreamHandlerUtils.class.getName(), "StreamHandler", "com.ibm.ws.runtime.runtime");
        try {
            runningInOSGi = ExtensionRegistryFactory.instance().isEclipse();
        }
        catch (Exception cnfe) {
            runningInOSGi = false;
        }
    }
}

