/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public abstract class DeployedObjectCollaborator
extends J2EEManagedObjectCollaborator
implements PropertyChangeListener {
    private static TraceComponent tc = Tr.register(DeployedObjectCollaborator.class, "Runtime", "com.ibm.ws.runtime.runtime");
    static final String SERVER = "WebSphere:type=Server,*";
    protected String archivePath;
    protected String ddFilename;
    protected ModuleItem pmiModule;
    private long ntfySeqNum = 0L;
    private DeployedObject deployedObj;

    public DeployedObjectCollaborator(DeployedObject dobj) {
        this.deployedObj = dobj;
        Resource r = dobj.getDeploymentDescriptor().eResource();
        ModuleFile archive = dobj.getModuleFile();
        try {
            this.archivePath = archive.getResourcesPath();
            this.ddFilename = r.getURI().toFileString();
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        dobj.addPropertyChangeListener("state", this);
    }

    protected void destroy() {
        this.deployedObj.removePropertyChangeListener("state", this);
        this.deployedObj = null;
    }

    public abstract String getType();

    public String getName() {
        return this.getObjectName().getKeyProperty("name");
    }

    public String getJavaVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getDeploymentDescriptor() throws IOException {
        String earPath = null;
        if (this.deployedObj instanceof DeployedModule) {
            DeployedApplication dApp = ((DeployedModule)this.deployedObj).getDeployedApplication();
            earPath = dApp.getModuleFile().getResourcesPath();
        } else if (this.deployedObj instanceof DeployedApplication) {
            earPath = this.archivePath;
        } else {
            throw new IllegalStateException("Unknown deployedObj type");
        }
        CommonarchiveFactory archiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
        ArchiveOptions options = new ArchiveOptions();
        options.setIsReadOnly(true);
        options.setUseJavaReflection(false);
        EARFile earFile = null;
        try {
            earFile = archiveFactory.openEARFile(options, earPath);
        }
        catch (OpenFailureException e) {
            FFDCFilter.processException((Throwable)e, DeployedObjectCollaborator.class.getName() + ".getDeploymentDescriptor", "166", this);
            return "";
        }
        earFile.rollUpRoles();
        Resource ddResource = null;
        if (this.deployedObj instanceof DeployedModule) {
            Module m = earFile.getModule(this.deployedObj.getName());
            try {
                ddResource = earFile.getDeploymentDescriptor(m).eResource();
            }
            catch (EmptyResourceException e) {
                FFDCFilter.processException((Throwable)e, DeployedObjectCollaborator.class.getName() + ".getDeploymentDescriptor", "200", this);
                return "";
            }
        } else {
            ddResource = earFile.getDeploymentDescriptor().eResource();
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        ddResource.save(byteOutStream, null);
        return byteOutStream.toString();
    }

    public String getServer() {
        return this.getObjectName(SERVER);
    }

    protected Set lookupMBeans(String name2, QueryExp queryExp) {
        try {
            ObjectName objName = new ObjectName(name2);
            return AdminServiceFactory.getAdminService().queryNames(objName, queryExp);
        }
        catch (MalformedObjectNameException mone) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MalformedObjectName Exception", mone);
            }
            return null;
        }
    }

    protected String[] getObjectNames(String query) {
        return this.getObjectNames(query, null);
    }

    protected String[] getObjectNames(String query, QueryExp queryExp) {
        Set s = this.lookupMBeans(query, queryExp);
        String[] objNames = new String[s.size()];
        int idx = 0;
        Iterator i = s.iterator();
        while (i.hasNext()) {
            objNames[idx++] = i.next().toString();
        }
        return objNames;
    }

    protected String getObjectName(String query) {
        Set s = this.lookupMBeans(query, null);
        if (s.size() == 0) {
            return null;
        }
        return s.iterator().next().toString();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String currentState = (String)evt.getNewValue();
        String ntfyType = null;
        if (currentState.equals("STARTING")) {
            ntfyType = "j2ee.state.starting";
        } else if (currentState.equals("STARTED")) {
            ntfyType = "j2ee.state.running";
        } else if (currentState.equals("STOPPING")) {
            ntfyType = "j2ee.state.stopping";
        } else if (currentState.equals("STOPPED")) {
            ntfyType = "j2ee.state.stopped";
        } else if (currentState.equals("ERROR")) {
            ntfyType = "j2ee.state.failed";
        } else if (currentState.equals("DESTROYED")) {
            this.destroy();
        }
        this.sendStateNotification(ntfyType);
    }

    protected void sendStateNotification(String ntfyType) {
        if (ntfyType != null) {
            try {
                this.sendNotification(new Notification(ntfyType, this.getObjectName(), this.ntfySeqNum++));
            }
            catch (MBeanException exc) {
                FFDCFilter.processException((Throwable)exc, DeployedObjectCollaborator.class.getName() + ".sendStateNotification", "211", this);
            }
        }
    }
}

