/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.InternalConfigService;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ConfigLocatorAdapter
implements ConfigLocator,
com.ibm.wsspi.runtime.config.ConfigLocator {
    private static final TraceComponent tc = Tr.register(ConfigLocatorAdapter.class, "RCS", "com.ibm.ws.runtime.runtime");
    private Repository repository;
    private InternalConfigService service;
    private Object locator;

    public ConfigLocatorAdapter(Object locator, InternalConfigService service) {
        if (!(locator instanceof ConfigLocator) && !(locator instanceof com.ibm.wsspi.runtime.config.ConfigLocator)) {
            throw new IllegalArgumentException(locator + " is of type " + (locator == null ? null : locator.getClass()));
        }
        this.service = service;
        this.locator = locator;
    }

    public String toString() {
        return super.toString() + '[' + this.locator + ']';
    }

    public void initialize(Repository repository) throws ConfigurationError, ConfigurationWarning {
        if (this.locator instanceof com.ibm.wsspi.runtime.config.ConfigLocator) {
            ((com.ibm.wsspi.runtime.config.ConfigLocator)this.locator).initialize(this.service);
        } else {
            ((ConfigLocator)this.locator).initialize(repository);
        }
    }

    public void initialize(ConfigService configService) {
        throw new UnsupportedOperationException();
    }

    public Object getConfig(Object currentConfig, String type) throws ConfigurationWarning, ConfigurationError {
        if (currentConfig instanceof EObject) {
            return this.getConfig((EObject)currentConfig, type);
        }
        return this.getConfig((ConfigObject)currentConfig, type);
    }

    public Object getConfig(EObject currentConfig, String type) throws ConfigurationWarning, ConfigurationError {
        List<Object> result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfig", new Object[]{currentConfig, type});
        }
        if (this.locator instanceof com.ibm.wsspi.runtime.config.ConfigLocator) {
            ConfigObject configObject = currentConfig == null ? null : this.service.getConfigObject(currentConfig);
            List list = ((com.ibm.wsspi.runtime.config.ConfigLocator)this.locator).getConfig(configObject, type);
            if (list == null) {
                result = null;
            } else {
                EStructuralFeature feature;
                EStructuralFeature eStructuralFeature = feature = currentConfig == null ? null : currentConfig.eClass().getEStructuralFeature(type);
                if (feature != null && feature.isMany()) {
                    Object[] objects = new Object[list.size()];
                    for (int i = 0; i < objects.length; ++i) {
                        objects[i] = this.service.getEObject((ConfigObject)list.get(i));
                    }
                    result = Arrays.asList(objects);
                } else {
                    result = this.service.getEObject((ConfigObject)list.get(0));
                }
            }
        } else {
            result = ((ConfigLocator)this.locator).getConfig(currentConfig, type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfig", result);
        }
        return result;
    }

    public List getConfig(ConfigObject currentConfig, String type) throws ConfigurationWarning, ConfigurationError {
        List<Object> result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfig", new Object[]{currentConfig, type});
        }
        if (this.locator instanceof com.ibm.wsspi.runtime.config.ConfigLocator) {
            result = ((com.ibm.wsspi.runtime.config.ConfigLocator)this.locator).getConfig(currentConfig, type);
        } else {
            EObject emfObject = currentConfig == null ? null : this.service.getEObject(currentConfig);
            Object data = ((ConfigLocator)this.locator).getConfig(emfObject, type);
            if (data == null) {
                result = null;
            } else if (data instanceof List) {
                List list = (List)data;
                Object[] objects = new Object[list.size()];
                for (int i = 0; i < objects.length; ++i) {
                    objects[i] = this.service.getConfigObject((EObject)list.get(i));
                }
                result = Arrays.asList(objects);
            } else {
                result = Collections.singletonList(this.service.getConfigObject((EObject)data));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfig", result);
        }
        return result;
    }
}

