/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Properties;
import javax.naming.Referenceable;

public class WASQueueConnectionFactoryBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(WASQueueConnectionFactoryBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.internalmessaging.xmi", "WASQueueConnectionFactory");
    }

    public Object getBindingObject(ConfigObject resource) throws ResourceBindingException {
        Properties jmsProps = new Properties();
        ConfigObject jmsProvider = resource.getParent();
        ConfigObject connectionPool = resource.getObject("connectionPool");
        this.checkRequiredProperty(connectionPool, "Invalid Configuration! The JMS Resource: " + resource.getString("name", "__null__") + " has a null ConnectionPool property.");
        ConfigObject sessionPool = resource.getObject("sessionPool");
        try {
            Server server2 = WsServiceRegistry.getService(this, Server.class);
            this.setProperty(jmsProps, "CELL", server2.getCellName(), true);
        }
        catch (Throwable e) {
            Tr.audit(tc, "Exception getting Server Service", e);
        }
        this.addPropertySet(jmsProps, resource.getObject("propertySet"), true);
        this.addPropertySet(jmsProps, jmsProvider.getObject("propertySet"), true);
        String name2 = resource.getString("name", "__null__");
        if (name2 == null || name2.length() <= 0) {
            throw new ResourceBindingException("WASQueueConnectionFactory can not be bound as no name has been specified.");
        }
        this.setProperty(jmsProps, "NAME", name2, true);
        this.setProperty(jmsProps, "DESC", resource.getString("description", "__null__"), true);
        String property = resource.getString("node", "__null__");
        this.checkRequiredProperty(property, "WASQueueConnectionFactory " + name2 + " can not be bound as no node property has been specified.");
        this.setProperty(jmsProps, "NODE", property, true);
        this.addJMSServerProperties(jmsProps, resource.getString("node", "__null__"));
        this.setAuthenticationProperties(resource, jmsProps);
        this.setProperty(jmsProps, "XAEnabled", resource.isSet("XAEnabled") ? new Boolean(resource.getBoolean("XAEnabled", true)) : Boolean.TRUE, true);
        Properties connectionPoolProperties = new Properties();
        this.addConnectionPoolProperties(connectionPoolProperties, connectionPool);
        this.addJ2EEHrefProperties(connectionPoolProperties, resource);
        Properties sessionPoolProperties = new Properties();
        this.addConnectionPoolProperties(sessionPoolProperties, sessionPool);
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            ref = refBuilder.createEmbeddedQueueConnectionFactoryReferenceable(jmsProps, connectionPoolProperties, sessionPoolProperties);
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.WASQueueConnectionFactoryBinder.getBindingObject", "124", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.WASQueueConnectionFactoryBinder.getBindingObject", "129", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }
}

