/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.advanced.cm.factory.DataSourceFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.component.collaborator.JDBCResourceMBean;
import com.ibm.ws.runtime.resource.ResourceBinderImpl;
import com.ibm.wsspi.runtime.config.ConfigHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.Properties;

public class WAS40DataSourceBinder
extends ResourceBinderImpl {
    private static final TraceComponent tc = Tr.register(WAS40DataSourceBinder.class, "ResourceBinders", "com.ibm.ws.j2c.resources.J2CAMessages");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jdbc.xmi", "WAS40DataSource");
    }

    public String getNamePrefix() {
        return "jdbc";
    }

    public Object getBindingObject(ConfigObject dataSource) throws ResourceBindingException {
        String dataSourceName = dataSource.getString("name", "__null__");
        ConfigObject jdbcDriver = dataSource.getParent();
        if (jdbcDriver.getBoolean("isolatedClassLoader", false)) {
            Tr.error(tc, "WAS40_DS_ISOLATION_UNSUPPORTED_J2CA0218", new Object[]{dataSourceName});
            throw new ResourceBindingException("Version 4 data sources are not supported for isolated JDBC providers.");
        }
        ConfigObject pool2 = dataSource.getObject("connectionPool");
        this.checkRequiredProperty(pool2, "Invalid Configuration! The DataSource: " + dataSourceName + " has a null ConnectionPool property.");
        Properties properties = new Properties();
        this.addPropertySet(properties, dataSource.getObject("propertySet"), false);
        this.setProperty(properties, "name", dataSourceName, false);
        this.setProperty(properties, "dataSourceClassName", jdbcDriver.getString("implementationClassName", "__null__"), false);
        try {
            this.setProperty(properties, "databaseName", this.expandVariable(dataSource.getString("databaseName", "__null__")), false);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.WAS40DataSourceBinder.getBindingObject", "73", this);
            throw new ResourceBindingException(dataSource, e.toString());
        }
        this.setProperty(properties, "description", dataSource.getString("description", "__null__"), false);
        this.setProperty(properties, "minimumPoolSize", new Integer(pool2.getInt("minimumPoolSize", 0)), false);
        this.setProperty(properties, "maximumPoolSize", new Integer(pool2.getInt("maximumPoolSize", 0)), false);
        this.setProperty(properties, "connectionTimeout", new Integer(pool2.getInt("connectionTimeout", 0)), false);
        this.setProperty(properties, "idleTimeout", new Integer(pool2.getInt("idleTimeout", 0)), false);
        this.setProperty(properties, "orphanTimeout", new Integer(pool2.getInt("orphanTimeout", 0)), false);
        this.setProperty(properties, "statementCacheSize", new Integer(pool2.getInt("statementCacheSize", 10)), false);
        this.setProperty(properties, "user", dataSource.getString("defaultUser", "__null__"), false);
        this.setProperty(properties, "password", ConfigHelper.decodePassword(dataSource.getUnexpandedString("defaultPassword", "__null__")), false);
        this.setProperty(properties, "disableAutoConnectionCleanup", new Boolean(pool2.getBoolean("disableAutoConnectionCleanup", false)), false);
        this.addJ2EEHrefProperties(properties, dataSource);
        return DataSourceFactory.getBindableObject((Properties)properties);
    }

    protected void addJ2EEHrefProperties(Properties props, ConfigObject resourceFactory) {
        MBeanFactory mbeanFactory = null;
        try {
            mbeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
            if (mbeanFactory != null) {
                this.setProperty(props, "j2ee.resource.factory.href", mbeanFactory.getConfigId(resourceFactory), false);
                this.setProperty(props, "j2ee.resource.provider.href", mbeanFactory.getConfigId(resourceFactory.getParent()), false);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.WAS40DataSourceBinder.addJ2EEHrefPropeties", "144", this);
        }
    }

    public void activateProviderMBean(ConfigObject rp, String serverName) {
        new JDBCResourceMBean(rp, serverName);
    }
}

