/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.mbean.TraceServiceMBean;
import com.ibm.ws.runtime.service.TraceService;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;

public class TraceImpl
extends WsComponentImpl
implements TraceService {
    private static final int oneMeg = 0x100000;
    protected ConfigObject traceConfig;

    public void boot(ConfigObject config) {
        String version = null;
        String processId = null;
        String serverName = null;
        String verboseVersion = null;
        try {
            serverName = ServerName.getFullName();
            Process process = ProcessFactory.createSelf();
            processId = process.id();
            String wasInstallRoot = System.getProperty("was.install.root");
            WASDirectory wasDirectory = new WASDirectory(wasInstallRoot);
            WASProductInfo[] wasProds = wasDirectory.getWASProductInfoInstances();
            StringBuffer sbVersion = new StringBuffer(2048);
            for (int i = 0; i < wasProds.length; ++i) {
                String id = wasProds[i].getId();
                if (id.equals("ND") || id.equals("BASE") || id.equals("EXPRESS")) {
                    sbVersion.append("Platform " + wasDirectory.getVersion(id) + " ");
                }
                sbVersion.append("[" + wasProds[i].getId() + " " + wasProds[i].getVersion() + " " + wasProds[i].getBuildLevel() + "]");
            }
            version = sbVersion.toString();
        }
        catch (Throwable th) {
            Manager.Ffdc.log(th, this, "com.ibm.ws.runtime.component.TraceImpl.boot", "101", config, version, processId, serverName, verboseVersion);
        }
        RasHelper.setServerAttributes((String)serverName, (String)processId, (String)version, verboseVersion);
        String traceSpec = "*=all=disabled";
        String traceOutput = "null";
        String traceFileName = null;
        long rollover = 0xA00000L;
        int backups = 1;
        int bufferSize = 8;
        String traceFormat = "basic";
        if (config != null) {
            try {
                traceSpec = config.getString("startupTraceSpecification", "__null__");
                if (traceSpec == null) {
                    traceSpec = "*=all=disabled";
                }
                if (config.getBoolean("enable", false)) {
                    String TraceType = config.getString("traceFormat", "BASIC");
                    if (TraceType.equalsIgnoreCase("basic")) {
                        traceFormat = "basic";
                    } else if (TraceType.equalsIgnoreCase("advanced")) {
                        traceFormat = "advanced";
                    } else if (TraceType.equalsIgnoreCase("loganalyzer")) {
                        traceFormat = "loganalyzer";
                    }
                    String TraceOutType = config.getString("traceOutputType", "MEMORY_BUFFER");
                    if (TraceOutType != null && !TraceOutType.equalsIgnoreCase("SPECIFIED_FILE")) {
                        traceOutput = "ringbuffer";
                        bufferSize = config.getInt("memoryBufferSize", 8);
                        if (bufferSize < 1) {
                            bufferSize = 8;
                        }
                    } else {
                        ConfigObject traceLog = config.getObject("traceLog");
                        if (traceLog != null) {
                            traceFileName = this.expandVariable(traceLog.getString("fileName", "__null__"));
                            rollover = traceLog.getInt("rolloverSize", 100);
                            rollover = rollover < 1L ? 0x100000L : (rollover *= 0x100000L);
                            backups = traceLog.getInt("maxNumberOfBackupFiles", 1);
                            if (backups < 1) {
                                backups = 1;
                            }
                            traceOutput = "named file";
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                traceOutput = "ringbuffer";
                bufferSize = 8;
            }
        }
        ManagerAdmin.configureServerTrace((String)traceSpec, (String)traceOutput, traceFileName, (long)rollover, (int)backups, (int)bufferSize, (String)traceFormat);
        try {
            WsServiceRegistry.addService(this, TraceService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, WsComponentImpl.class.getName(), "594", this);
        }
    }

    public void initialize(Object config) {
        this.traceConfig = (ConfigObject)config;
    }

    public void destroy() {
    }

    public void start() {
        TraceServiceMBean trace = new TraceServiceMBean();
        this.registerMBean("TraceService", trace, "TraceService", this.getConfigId(this.traceConfig), null);
        this.traceConfig = null;
    }

    public void stop() {
    }

    public void appendTraceString(String traceString) {
        ManagerAdmin.appendTraceString((String)traceString);
    }
}

