/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ejs.ras.Tr;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.ChannelFactoryData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.ctm.BaseChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.RuntimeChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.ValidationChannelTypeManager;
import com.ibm.ws.channel.framework.impl.RCSUtil;
import com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.TransportChannelLoaderImpl;
import com.ibm.wsspi.channel.ChannelFrameworkProvider;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.TransportChannelLoader;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import com.ibm.wsspi.channel.framework.exception.DuplicatePoolException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelFrameworkServiceImpl
extends WsComponentImpl
implements ChannelFrameworkService {
    private static final TraceComponent tc = com.ibm.ejs.ras.Tr.register(ChannelFrameworkServiceImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    protected Exception factoryException = null;
    protected Context _context;
    protected ChannelFrameworkService _delegate;
    protected static final int WAS_TPM = 0;
    protected static final int NO_WAS_TPM = 1;
    ConfigService configService = null;

    public ChannelFrameworkServiceImpl(int propOption) {
        if (propOption == 0) {
            System.setProperty("com.ibm.wsspi.runtime.ThreadPoolRepositoryName", "com.ibm.ws.runtime.WSThreadPoolRepository");
        }
        Tr.setAuditTraceLevel("INFO");
        System.setProperty("FFDCProcessLevel", "4");
        System.setProperty("FFDCLogDirectory", FFDC.getLogRoot() + "/ffdc");
    }

    public ChannelFrameworkServiceImpl() {
        this(0);
    }

    public ChannelFrameworkService getDelegateService() {
        return this._delegate;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public void initialize(Object configuration) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        ConfigurationWarning warning;
        block40: {
            BaseChannelTypeManager manager;
            ConfigObject root;
            block39: {
                this.checkFactoryExceptions();
                warning = null;
                root = null;
                try {
                    this.configService = WsServiceRegistry.getService(this, ConfigService.class);
                    root = ChannelFrameworkServiceImpl.getConfig(this.configService);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && root != null) {
                        com.ibm.ejs.ras.Tr.debug(tc, "root object is: " + root);
                        List x = root.getObjectList("factories");
                        com.ibm.ejs.ras.Tr.debug(tc, "number of factories is: " + x.size());
                        Iterator i = x.iterator();
                        while (i.hasNext()) {
                            com.ibm.ejs.ras.Tr.debug(tc, "factory: " + i.next());
                        }
                        x = root.getObjectList("transportChannels");
                        com.ibm.ejs.ras.Tr.debug(tc, "number of transportChannels are: " + x.size());
                        i = x.iterator();
                        while (i.hasNext()) {
                            com.ibm.ejs.ras.Tr.debug(tc, "transportChannel: " + i.next());
                        }
                        x = root.getObjectList("chains");
                        com.ibm.ejs.ras.Tr.debug(tc, "number of chains: " + x.size());
                        i = x.iterator();
                        while (i.hasNext()) {
                            com.ibm.ejs.ras.Tr.debug(tc, "chain: " + i.next());
                        }
                    }
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block39;
                    com.ibm.ejs.ras.Tr.debug(tc, "Caught Exception while obtaining registry service: " + e);
                }
            }
            if (root != null && root.isSet("enable") && !root.getBoolean("enable", false)) {
                com.ibm.ejs.ras.Tr.audit(tc, "framework.disabled");
                throw new ComponentDisabledException();
            }
            String optionalChannelLocation = null;
            String retryInterval = null;
            String retryAttempts = null;
            if (root != null) {
                List props = root.getObjectList("properties");
                for (ConfigObject prop : props) {
                    String propName = prop.getString("name", null);
                    if (propName.equals("ChainStartRetryInterval")) {
                        retryInterval = prop.getString("value", null);
                        continue;
                    }
                    if (propName.equals("ChainStartRetryAttempts")) {
                        retryAttempts = prop.getString("value", null);
                        continue;
                    }
                    if (!propName.equals("ChannelJarLocation")) continue;
                    optionalChannelLocation = prop.getString("value", null);
                }
            }
            if (optionalChannelLocation == null) {
                optionalChannelLocation = System.getProperty("ChannelJarLocation");
            }
            TransportChannelLoaderImpl loader = (TransportChannelLoaderImpl)this.getService(TransportChannelLoader.class);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "instantiate RuntimeChannelTypeManager");
                }
                manager = new RuntimeChannelTypeManager(this.configService, optionalChannelLocation, loader);
            }
            catch (FileNotFoundException exp) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "instantiate ValidationChannelTypeManager");
                }
                manager = new ValidationChannelTypeManager();
                warning = new ConfigurationWarning("installed-channels.xml missing; defaulting to all channels", exp);
                FFDCFilter.processException(exp, this.getClass().getName() + ".initialize", "207", this, new Object[]{optionalChannelLocation});
            }
            catch (Exception exp) {
                throw new ConfigurationError("could not initialize the ChannelTypeManager", exp);
            }
            try {
                this._delegate = (ChannelFrameworkService)ChannelFrameworkProvider.getChannelFramework();
                WSChannelFrameworkImpl cf = (WSChannelFrameworkImpl)this._delegate;
                cf.setClassLoader(this.getClass().getClassLoader());
                cf.setCFService(this);
                cf.setTypeManager(manager);
            }
            catch (Exception exp) {
                throw new ConfigurationError("Could not build the channel framework instance", exp);
            }
            if (retryAttempts != null) {
                try {
                    ((WSChannelFrameworkImpl)this._delegate).setChainStartRetryAttempts(retryAttempts);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (retryInterval != null) {
                try {
                    ((WSChannelFrameworkImpl)this._delegate).setChainStartRetryInterval(retryInterval);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (root != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "add factories and channels");
                }
                List workList = root.getObjectList("factories");
                Iterator i = workList.iterator();
                while (i.hasNext()) {
                    try {
                        this.intializeChannelFactory((ConfigObject)i.next());
                    }
                    catch (ChannelFrameworkException exp) {
                        com.ibm.ejs.ras.Tr.error(tc, "factory.load.failure", exp);
                    }
                }
                workList = root.getObjectList("transportChannels");
                i = workList.iterator();
                while (i.hasNext()) {
                    try {
                        this.addChannel((ConfigObject)i.next());
                    }
                    catch (ChannelFrameworkException exp) {
                        com.ibm.ejs.ras.Tr.error(tc, "channel.load.failure", exp);
                    }
                }
                workList = root.getObjectList("chains");
                i = workList.iterator();
                while (i.hasNext()) {
                    try {
                        this.addChain((ConfigObject)i.next());
                    }
                    catch (ChannelFrameworkException exp) {
                        com.ibm.ejs.ras.Tr.error(tc, "chain.load.failure", exp);
                    }
                }
            }
            try {
                WsServiceRegistry.addService(this, ChannelFrameworkService.class);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".initialize", "407", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block40;
                com.ibm.ejs.ras.Tr.event(tc, "Error adding service: " + e);
            }
        }
        if (warning != null) {
            throw warning;
        }
    }

    @Override
    public void start() throws RuntimeError, RuntimeWarning {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
        try {
            this._delegate.destroy();
        }
        catch (Exception exp) {
            FFDCFilter.processException((Throwable)exp, this.getClass().getName() + ".destroy", "279", this);
        }
    }

    public Object getService(final Class<?> serviceInterface) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return WsServiceRegistry.getService(this, serviceInterface);
                }
            });
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getService", "467", this);
            return null;
        }
    }

    public void releaseService(Object service) {
    }

    @Override
    public VirtualConnectionFactory getOutboundVCFactory(String chainName) throws ChannelException, ChainException {
        return this._delegate.getOutboundVCFactory(chainName);
    }

    @Override
    public VirtualConnectionFactory getInboundVCFactory() {
        return this._delegate.getInboundVCFactory();
    }

    @Override
    public ChannelFactoryData updateAllChannelFactoryProperties(Class factoryType, Map properties) throws ChannelFactoryException {
        return this._delegate.updateAllChannelFactoryProperties(factoryType, properties);
    }

    @Override
    public ChannelFactoryData updateChannelFactoryProperty(Class factoryType, Object key, Object value2) throws ChannelFactoryException {
        return this._delegate.updateChannelFactoryProperty(factoryType, key, value2);
    }

    @Override
    public ChannelFactoryData getChannelFactory(Class type) throws ChannelFactoryException {
        return this._delegate.getChannelFactory(type);
    }

    @Override
    public ChannelData addChannel(String channelName, Class factoryType, Map properties, int weight) throws ChannelException {
        return this._delegate.addChannel(channelName, factoryType, properties, weight);
    }

    @Override
    public ChannelData addChannel(String channelName, Class factoryType, Map properties) throws ChannelException {
        return this._delegate.addChannel(channelName, factoryType, properties);
    }

    @Override
    public ChannelData removeChannel(String channelName) throws ChannelException, ChainException {
        return this._delegate.removeChannel(channelName);
    }

    @Override
    public ChannelData updateChannelWeight(String channelName, int discriminationWeight) throws ChannelException {
        return this._delegate.updateChannelWeight(channelName, discriminationWeight);
    }

    @Override
    public ChannelData updateChannelProperty(String channelName, Object propertyKey, Object propertyValue) throws ChannelException {
        return this._delegate.updateChannelProperty(channelName, propertyKey, propertyValue);
    }

    @Override
    public ChannelData updateAllChannelProperties(String channelName, Map newProperties) throws ChannelException {
        return this._delegate.updateAllChannelProperties(channelName, newProperties);
    }

    @Override
    public ChannelData getChannel(String channelName) {
        return this._delegate.getChannel(channelName);
    }

    @Override
    public ChannelData[] getAllChannels() {
        return this._delegate.getAllChannels();
    }

    @Override
    public ChannelData[] getRunningChannels() {
        return this._delegate.getRunningChannels();
    }

    @Override
    public ChainData addChain(String chainName, FlowType chainType, String[] channelList) throws ChannelException, ChainException {
        return this._delegate.addChain(chainName, chainType, channelList);
    }

    @Override
    public ChainData addChain(String chainName, FlowType type, String[] channels, String acceptorID) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.addChain(chainName, type, channels, acceptorID);
    }

    @Override
    public ChainData removeChain(String chainName) throws ChainException {
        return this._delegate.removeChain(chainName);
    }

    @Override
    public ChainData updateChain(String chainName, String[] channelList) throws ChannelException, ChainException {
        return this._delegate.updateChain(chainName, channelList);
    }

    @Override
    public ChainData getChain(String chainName) {
        return this._delegate.getChain(chainName);
    }

    @Override
    public ChainData[] getAllChains() {
        return this._delegate.getAllChains();
    }

    @Override
    public ChainData[] getAllChains(String channelName) throws ChannelException {
        return this._delegate.getAllChains(channelName);
    }

    @Override
    public ChainData[] getAllChains(Class factoryClass) throws InvalidChannelFactoryException {
        return this._delegate.getAllChains(factoryClass);
    }

    @Override
    public ChainData[] getRunningChains() {
        return this._delegate.getRunningChains();
    }

    @Override
    public ChainData[] getRunningChains(String channelName) throws ChannelException {
        return this._delegate.getRunningChains(channelName);
    }

    @Override
    public ChainData[] getInternalRunningChains(String channelName) throws ChannelException {
        return this._delegate.getRunningChains(channelName);
    }

    @Override
    public ChainData[] getRunningChains(Class factoryClass) throws InvalidChannelFactoryException {
        return this._delegate.getRunningChains(factoryClass);
    }

    @Override
    public void initChain(String chainName) throws ChannelException, ChainException {
        this._delegate.initChain(chainName);
    }

    @Override
    public void startChain(String chainName) throws ChannelException, ChainException {
        this._delegate.startChain(chainName);
    }

    @Override
    public void stopChain(String chainName, long delay) throws ChannelException, ChainException {
        this._delegate.stopChain(chainName, delay);
    }

    @Override
    public void destroyChain(String chainName) throws ChannelException, ChainException {
        this._delegate.destroyChain(chainName);
    }

    @Override
    public void addChainEventListener(ChainEventListener cel, String chainName) throws ChainException {
        this._delegate.addChainEventListener(cel, chainName);
    }

    @Override
    public void removeChainEventListener(ChainEventListener cel, String chainName) throws ChainException {
        this._delegate.removeChainEventListener(cel, chainName);
    }

    @Override
    public void addGroupEventListener(ChainEventListener cel, String groupName) throws ChainGroupException {
        this._delegate.addGroupEventListener(cel, groupName);
    }

    @Override
    public void removeGroupEventListener(ChainEventListener cel, String groupName) throws ChainGroupException {
        this._delegate.removeGroupEventListener(cel, groupName);
    }

    @Override
    public ChainGroupData addChainGroup(String groupName, String[] chainNames) throws ChainException, ChainGroupException {
        return this._delegate.addChainGroup(groupName, chainNames);
    }

    @Override
    public ChainGroupData removeChainGroup(String groupName) throws ChainGroupException {
        return this._delegate.removeChainGroup(groupName);
    }

    @Override
    public ChainGroupData updateChainGroup(String groupName, String[] chainnames) throws ChainException, ChainGroupException {
        return this._delegate.updateChainGroup(groupName, chainnames);
    }

    @Override
    public ChainGroupData getChainGroup(String groupName) {
        return this._delegate.getChainGroup(groupName);
    }

    @Override
    public ChainGroupData addChainToGroup(String groupName, String chainName) throws ChainGroupException, ChainException {
        return this._delegate.addChainToGroup(groupName, chainName);
    }

    @Override
    public ChainGroupData removeChainFromGroup(String groupName, String chainName) throws ChainGroupException, ChainException {
        return this._delegate.removeChainFromGroup(groupName, chainName);
    }

    @Override
    public ChainGroupData[] getAllChainGroups() {
        return this._delegate.getAllChainGroups();
    }

    @Override
    public ChainGroupData[] getAllChainGroups(String chainName) throws ChainException {
        return this._delegate.getAllChainGroups(chainName);
    }

    @Override
    public ChainData[] initChainGroup(String groupName) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.initChainGroup(groupName);
    }

    @Override
    public ChainData[] startChainGroup(String groupName) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.startChainGroup(groupName);
    }

    public ChainData[] startChainGroup(String groupName, ChainStartMode mode) throws ChannelException, ChainException, ChainGroupException {
        return ((WSChannelFrameworkImpl)this._delegate).startChainGroup(groupName, mode);
    }

    @Override
    public ChainData[] stopChainGroup(String groupName, long delay) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.stopChainGroup(groupName, delay);
    }

    @Override
    public ChainData[] destroyChainGroup(String groupName) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.destroyChainGroup(groupName);
    }

    @Override
    public ChainData addChain(ConfigObject chainConfig) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.addChain(chainConfig);
    }

    @Override
    public ChannelData addChannel(ConfigObject channelConfig) throws ChannelException, ConfigurationError {
        return this._delegate.addChannel(channelConfig);
    }

    @Override
    public void intializeChannelFactory(ConfigObject factoryConfig) throws ChannelFactoryException, ConfigurationError {
        this._delegate.intializeChannelFactory(factoryConfig);
    }

    @Override
    public void startChainsByAcceptorID(String acceptorID) throws ChannelException, ChainException, ChainGroupException {
        this._delegate.startChainsByAcceptorID(acceptorID);
    }

    @Override
    public void startChainsByAcceptorID(String acceptorID, ChainStartMode mode) throws ChannelException, ChainException, ChainGroupException {
        this._delegate.startChainsByAcceptorID(acceptorID, mode);
    }

    @Override
    public void stopChainsByAcceptorID(String acceptorID, long delay) throws ChannelException, ChainException, ChainGroupException {
        this._delegate.stopChainsByAcceptorID(acceptorID, delay);
    }

    @Override
    public CFEndPoint determineBestEndPoint(CFEndPoint[] endPointList, CFEndPointCriteria descriptor) {
        return this._delegate.determineBestEndPoint(endPointList, descriptor);
    }

    @Override
    public CFEndPoint[] getEndPoints(CFEndPoint[] endPointList, CFEndPointCriteria criteria) {
        return this._delegate.getEndPoints(endPointList, criteria);
    }

    @Override
    public CFEndPoint getEndPoint(String chainName) throws ChainNotInboundException, NoCFEndPointException, NullCFEndPointException {
        return this._delegate.getEndPoint(chainName);
    }

    @Override
    public CFEndPoint[] getEndPointsByAcceptorID(String acceptorID) {
        return this._delegate.getEndPointsByAcceptorID(acceptorID);
    }

    @Override
    public void prepareEndPoint(CFEndPoint endPoint) throws ChannelException, ChainException {
        this._delegate.prepareEndPoint(endPoint);
    }

    @Override
    public void setDefaultThreadPool(int minimumThreads, int maximumThreads) throws IllegalStateException {
        this._delegate.setDefaultThreadPool(minimumThreads, maximumThreads);
    }

    @Override
    public ThreadPool addThreadPool(String poolName, int minimumThreads, int maximumThreads) throws DuplicatePoolException {
        return this._delegate.addThreadPool(poolName, minimumThreads, maximumThreads);
    }

    @Override
    public ThreadPool getThreadPool(String poolName) {
        return this._delegate.getThreadPool(poolName);
    }

    @Override
    public ThreadPool getDefaultThreadPool() {
        return this._delegate.getDefaultThreadPool();
    }

    @Override
    public void registerService(Class clazz, Object service) {
        this._delegate.registerService(clazz, service);
    }

    @Override
    public Object deregisterService(Class clazz) {
        return this._delegate.deregisterService(clazz);
    }

    @Override
    public Object lookupService(Class clazz) {
        return this._delegate.lookupService(clazz);
    }

    @Override
    public int getListeningPort(String chainName) throws ChainException {
        return this._delegate.getListeningPort(chainName);
    }

    @Override
    public String getListeningHost(String chainName) throws ChainException {
        return this._delegate.getListeningHost(chainName);
    }

    protected void checkFactoryExceptions() throws ComponentDisabledException {
        if (this.factoryException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "Multiple ChannelFrameworks existed in the runtime and this should not be allowed.");
            }
            com.ibm.ejs.ras.Tr.audit(tc, "framework.disabled");
            throw new ComponentDisabledException(this.factoryException);
        }
    }

    protected void configureThreadPool(com.ibm.websphere.models.config.process.ThreadPool config, com.ibm.ws.util.ThreadPool runtime2) {
        if (config.isSetInactivityTimeout()) {
            runtime2.setKeepAliveTime(config.getInactivityTimeout());
        }
        if (config.isSetIsGrowable()) {
            runtime2.setGrowAsNeeded(config.isIsGrowable());
        }
    }

    protected static ConfigObject getConfig(ConfigService service) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                com.ibm.ejs.ras.Tr.entry(tc, "getConfig");
            }
            try {
                List list = service.getDocumentObjects(service.getScope(4), "server.xml");
                for (ConfigObject server2 : list) {
                    List services = server2.getObjectList("services");
                    for (ConfigObject current : services) {
                        if (!RCSUtil.instanceOfTransportChannelService(current)) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            com.ibm.ejs.ras.Tr.debug(tc, "TransportChannelService configuration discovered");
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            com.ibm.ejs.ras.Tr.exit(tc, "getConfig");
                        }
                        return current;
                    }
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                com.ibm.ejs.ras.Tr.debug(tc, "Caught Exception will processing configuration data" + e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.ejs.ras.Tr.debug(tc, "Did not find TransportChannelService Configuration Data");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "getConfig");
        }
        return null;
    }
}

