/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import java.io.File;
import java.util.Properties;

public class FileTransferServletConfigHelper {
    private static TraceComponent tc = Tr.register(FileTransferServletConfigHelper.class, "Admin", null);
    private String repositoryRoot = null;
    public static final String FT_SERVLET_NAME_SINCE60 = "/FileTransfer/transfer";
    private static final String FT_DOWNLOAD_DIRECTORY = "download";

    public String getRepositoryRoot() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "com.ibm.ws.management.util.FileTransferServletConfigHelper.getRepositoryRoot: enter");
        }
        if (this.repositoryRoot == null) {
            String tempRoot = null;
            try {
                ConfigRepository repository = ConfigRepositoryFactory.getConfigRepository();
                if (repository != null) {
                    Properties repositoryProps = repository.getConfig();
                    tempRoot = repositoryProps.getProperty("was.repository.temp");
                    tempRoot = tempRoot.replace('/', File.separatorChar);
                    if ((tempRoot = tempRoot.replace('\\', File.separatorChar)).endsWith(File.separator)) {
                        tempRoot = tempRoot.substring(0, tempRoot.length() - 1);
                    }
                }
                this.repositoryRoot = tempRoot;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.management.util.FileTransferServletConfigHelper.getRepositoryRoot", "75");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "com.ibm.ws.management.util.FileTransferServletConfigHelper.getRepositoryRoot: exit, config root: " + this.repositoryRoot);
            }
        }
        return this.repositoryRoot;
    }

    public static String generateUniquePartial(String stem, String userName) {
        String timeStamp = Long.toHexString(System.currentTimeMillis());
        timeStamp = timeStamp.substring(4, timeStamp.length());
        String directory = FT_DOWNLOAD_DIRECTORY + File.separator + userName + File.separator;
        String retPartial = directory + stem + "_" + timeStamp + File.separator;
        return retPartial;
    }

    public static String convertToFileTransferContextDirectory(String uniquePartial) {
        String fileTransferContextDirectory = FT_SERVLET_NAME_SINCE60 + File.separator + uniquePartial;
        fileTransferContextDirectory = fileTransferContextDirectory.replace(File.separator.charAt(0), '/');
        return fileTransferContextDirectory;
    }
}

