/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ObjectNotRunningException;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public abstract class J2EEDeployedObjectProxy
extends J2EEManagedObjectCollaborator {
    private String deploymentDescriptor;
    private String fullServerName;
    protected String earPath;
    private ObjectName websphereMBeanObjectName;

    public J2EEDeployedObjectProxy(String dd, int initialState) {
        this(null, dd, initialState);
    }

    public J2EEDeployedObjectProxy(String earPath, String dd, int initialState) {
        super(initialState);
        this.deploymentDescriptor = dd;
        this.earPath = earPath;
    }

    public String getDeploymentDescriptor() {
        String fileContents = new String();
        File ddFile = new File(this.deploymentDescriptor);
        fileContents = ddFile.exists() ? this.getDDFromFile() : this.getDDFromEar();
        return fileContents;
    }

    public String getServer() {
        if (this.fullServerName == null) {
            ObjectName query = null;
            try {
                query = new ObjectName("WebSphere:*,j2eeType=J2EEServer," + this.getLocationKeyProperties());
            }
            catch (MalformedObjectNameException exc) {
                // empty catch block
            }
            Set s = AdminServiceFactory.getAdminService().queryNames(query, null);
            if (!s.isEmpty()) {
                this.fullServerName = s.iterator().next().toString();
            }
        }
        return this.fullServerName;
    }

    public String getName() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        return (String)this.getAttributeIfRunning("name");
    }

    public String getJavaVendor() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        return (String)this.getAttributeIfRunning("javaVendor");
    }

    public String getJavaVersion() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        return (String)this.getAttributeIfRunning("javaVersion");
    }

    protected Object getAttributeIfRunning(String attrName) throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        if (this.getJ2EEState() != 1) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(this.getWebSphereMBeanObjectName(), attrName);
    }

    protected String getJ2EEName() {
        return this.getObjectName().getKeyProperty("name");
    }

    protected String getJ2EEType() {
        return this.getObjectName().getKeyProperty("j2eeType");
    }

    protected abstract ObjectName getWebSphereMBeanQueryName();

    protected ObjectName getWebSphereMBeanObjectName() {
        if (this.websphereMBeanObjectName == null) {
            this.websphereMBeanObjectName = this.getFirstObjectName(this.getWebSphereMBeanQueryName());
        }
        return this.websphereMBeanObjectName;
    }

    protected ObjectName getFirstObjectName(ObjectName partialObjectName) {
        Set s = AdminServiceFactory.getAdminService().queryNames(partialObjectName, null);
        if (!s.isEmpty()) {
            return (ObjectName)s.iterator().next();
        }
        return null;
    }

    protected String getLocationKeyProperties() {
        AdminService as = AdminServiceFactory.getAdminService();
        StringBuffer buf = new StringBuffer();
        buf.append("cell=");
        buf.append(as.getCellName());
        buf.append(",node=");
        buf.append(as.getNodeName());
        buf.append(",process=");
        buf.append(as.getProcessName());
        return buf.toString();
    }

    protected String getDeploymentDescriptorPath() {
        return this.deploymentDescriptor;
    }

    private String getDDFromFile() {
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader dd = new BufferedReader(new FileReader(this.deploymentDescriptor));
            String next = null;
            while ((next = dd.readLine()) != null) {
                buffer.append(next);
                buffer.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            Manager.Ffdc.log(e, this, J2EEDeployedObjectProxy.class.getName() + ".getDDFromFile", "%C", this);
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, J2EEDeployedObjectProxy.class.getName() + ".getDDFromFile", "%C", this);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDDFromEar() {
        String fileContents = new String();
        EARFile earFile = null;
        try {
            CommonarchiveFactory archiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions options = new ArchiveOptions();
            options.setIsReadOnly(true);
            options.setUseJavaReflection(false);
            earFile = archiveFactory.openEARFile(options, this.earPath);
            earFile.rollUpRoles();
            Resource ddResource = earFile.getDeploymentDescriptor().eResource();
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            ddResource.save(byteOutStream, new HashMap());
            byteOutStream.close();
            fileContents = byteOutStream.toString();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, J2EEDeployedObjectProxy.class.getName() + ".getDDFromEAR", "%C", this);
        }
        finally {
            if (earFile != null) {
                earFile.close();
            }
        }
        return fileContents;
    }
}

