/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CBEHandlerAdapter
extends Handler {
    Handler ivDelegate;
    boolean ibAutoComplete;
    int iCBEConversionLevelInt;

    public CBEHandlerAdapter(Handler delegate, boolean autoComplete, Level minCBEConversionLevel) {
        this.ivDelegate = delegate;
        this.ibAutoComplete = autoComplete;
        this.iCBEConversionLevelInt = minCBEConversionLevel != null ? minCBEConversionLevel.intValue() : Level.ALL.intValue();
    }

    public void publish(LogRecord logRecord) {
        int delegateLevelValue;
        int logRecordLevelValue = logRecord.getLevel().intValue();
        if (logRecordLevelValue < (delegateLevelValue = this.ivDelegate.getLevel().intValue())) {
            return;
        }
        if (logRecordLevelValue >= this.iCBEConversionLevelInt) {
            CommonBaseEventLogRecord cbeLR = WsLogRecordFactory.convertToCBELogRecord(logRecord);
            if (this.ibAutoComplete) {
                try {
                    cbeLR.getCommonBaseEvent().complete();
                }
                catch (CompletionException e) {
                    // empty catch block
                }
            }
            this.ivDelegate.publish(cbeLR);
        } else {
            this.ivDelegate.publish(logRecord);
        }
    }

    public void close() throws SecurityException {
        this.ivDelegate.close();
    }

    public void flush() {
        this.ivDelegate.flush();
    }

    public String getEncoding() {
        return this.ivDelegate.getEncoding();
    }

    public ErrorManager getErrorManager() {
        return this.ivDelegate.getErrorManager();
    }

    public Filter getFilter() {
        return this.ivDelegate.getFilter();
    }

    public Formatter getFormatter() {
        return this.ivDelegate.getFormatter();
    }

    public synchronized Level getLevel() {
        return this.ivDelegate.getLevel();
    }

    public int hashCode() {
        return this.ivDelegate.hashCode();
    }

    public boolean isLoggable(LogRecord record) {
        return this.ivDelegate.isLoggable(record);
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.ivDelegate.setEncoding(encoding);
    }

    public void setErrorManager(ErrorManager em) {
        this.ivDelegate.setErrorManager(em);
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.ivDelegate.setFilter(newFilter);
    }

    public void setFormatter(Formatter newFormatter) throws SecurityException {
        this.ivDelegate.setFormatter(newFormatter);
    }

    public synchronized void setLevel(Level newLevel) throws SecurityException {
        this.ivDelegate.setLevel(newLevel);
    }

    public String toString() {
        return this.ivDelegate.toString();
    }
}

