/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.compression.CompressionHandler;
import com.ibm.ws.http.channel.compression.DecompressionHandler;
import com.ibm.ws.http.channel.compression.DeflateInputHandler;
import com.ibm.ws.http.channel.compression.DeflateOutputHandler;
import com.ibm.ws.http.channel.compression.GzipInputHandler;
import com.ibm.ws.http.channel.compression.GzipOutputHandler;
import com.ibm.ws.http.channel.compression.IdentityInputHandler;
import com.ibm.ws.http.channel.impl.CancelIOWrapper;
import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpTrailersImpl;
import com.ibm.ws.http.channel.impl.TrailerCallback;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.error.HttpErrorPageProvider;
import com.ibm.wsspi.http.channel.error.HttpErrorPageService;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.zip.DataFormatException;

public abstract class HttpServiceContextImpl
implements HttpServiceContext {
    private static final TraceComponent tc = Tr.register(HttpServiceContextImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int NOT_ENOUGH_DATA = -1;
    private static final int NO_MORE_DATA = -1;
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected static final byte[] CHUNK_TRAILER_DATA = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private static final int PENDING_BUFFER_INITIAL_SIZE = 10;
    private static final int PENDING_BUFFER_MIN_GROWTH_SIZE = 4;
    private static final int STATE_NONE = 0;
    private static final int STATE_FULL_HEADERS = 1;
    private static final int STATE_PARTIAL_BODY = 2;
    private static final int STATE_FULL_MESSAGE = 3;
    private static final int DEFAULT_REMOTE_PORT = 1024;
    private static final int DEFAULT_LOCAL_PORT = 9080;
    private static final ContentEncodingValues DEFAULT_ENCODING = ContentEncodingValues.IDENTITY;
    protected static final String EPS_KEY = "HttpChannel_ErrorPageService_Body";
    private TCPConnectionContext myTSC = null;
    private VirtualConnection myVC = null;
    private InterChannelCallback appWriteCB = null;
    private InterChannelCallback appReadCB = null;
    private WsByteBuffer[] myPendingBuffers = new WsByteBuffer[10];
    private int pendingBufferStart = 0;
    private int pendingBufferStop = 0;
    private WsByteBuffer[] myParseBuffers = null;
    private int parseBufferIndex = -1;
    private boolean bIsJITRead = true;
    private int msgParsedState = 0;
    private int msgSentState = 0;
    private boolean writingHeaders = false;
    private boolean isFinalWrite = false;
    private boolean bIsPersistent = true;
    private boolean bIsPartialBody = false;
    private boolean bIsOutgoingBodyValid = true;
    private boolean bIsIncomingBodyValid = false;
    private boolean bIsRawBody = false;
    private boolean bIsResponseOwner = true;
    private boolean bIsRequestOwner = true;
    private boolean bForceAsync = false;
    private boolean bParsingTrailers = false;
    private int unparsedDataRemaining = -1;
    private boolean bIsChunked = false;
    private int myContentLength = -1;
    private TCPReadCompletedCallback myBodyRC = null;
    private LinkedList<WsByteBuffer> storage = new LinkedList();
    private LinkedList<WsByteBuffer> tempBuffers = new LinkedList();
    private boolean bIsMultiRead = false;
    private int amountBeingRead = 0;
    private int numBytesWritten = 0;
    private long incomingMsgSize = 0L;
    private int savedChunkLength = -1;
    private int oldLimit = 0;
    private int oldPosition = -1;
    private boolean shouldModify = true;
    private WsByteBuffer buffChunkHeader = null;
    private WsByteBuffer buffChunkTrailer = null;
    private HttpChannelConfig myChannelConfig = null;
    private int myReadTimeout = 0;
    private int myWriteTimeout = 0;
    private HttpRequestMessageImpl myRequest = null;
    private HttpResponseMessageImpl myResponse = null;
    private WsByteBuffer currentReadBB = null;
    private VersionValues reqVersion = null;
    private MethodValues reqMethod = null;
    private boolean bIsBodyExpected = false;
    private int chunkLengthParseState = 0;
    private ContentEncodingValues incomingMsgEncoding = DEFAULT_ENCODING;
    private ContentEncodingValues outgoingMsgEncoding = DEFAULT_ENCODING;
    private CancelIOWrapper cancelRead = null;
    private CancelIOWrapper cancelWrite = null;
    private InetAddress myRemoteAddr = null;
    private InetAddress myLocalAddr = null;
    private int myRemotePort = 1024;
    private int myLocalPort = 9080;
    private LinkedList<WsByteBuffer> allocatedBuffers = new LinkedList();
    private int lastHeaderBuffer = -1;
    private CompressionHandler compressHandler = null;
    private DecompressionHandler decompressHandler = null;

    protected HttpServiceContextImpl() {
    }

    public final void resetMsgSentState() {
        this.msgSentState = 0;
    }

    public final void resetMsgParsedState() {
        this.msgParsedState = 0;
    }

    protected final boolean isBodyComplete() {
        return 3 == this.msgParsedState;
    }

    private void setBodyComplete() {
        this.msgParsedState = 3;
    }

    public final boolean isPartialBodySendState() {
        return 2 == this.msgSentState;
    }

    public final boolean isMessageSent() {
        return 3 == this.msgSentState;
    }

    protected final void setMessageSent() {
        this.msgSentState = 3;
    }

    public boolean isIncomingMessageFullyRead() {
        if (!this.storage.isEmpty()) {
            return false;
        }
        if (!this.isBodyComplete()) {
            return !this.isIncomingBodyValid();
        }
        return true;
    }

    public final boolean headersSent() {
        return 1 <= this.msgSentState;
    }

    public boolean writingHeaders() {
        return this.writingHeaders;
    }

    protected final void setHeadersSent() {
        this.msgSentState = 1;
    }

    public final boolean isHeadersSentState() {
        return 1 == this.msgSentState;
    }

    public final boolean headersParsed() {
        return 1 <= this.msgParsedState;
    }

    public final void setHeadersParsed() {
        this.msgParsedState = 1;
    }

    protected boolean incomingBuffersReady() {
        return !this.storage.isEmpty();
    }

    protected final void setBodyRC(TCPReadCompletedCallback rc) {
        this.myBodyRC = rc;
    }

    private TCPReadCompletedCallback getBodyRC() {
        return this.myBodyRC;
    }

    public final boolean isPersistent() {
        return this.bIsPersistent;
    }

    public final void setPersistent(boolean flag) {
        this.bIsPersistent = flag;
    }

    public boolean isSecure() {
        return null != this.getSSLContext();
    }

    public abstract boolean isInboundConnection();

    private void setIncomingMsgEncoding(ContentEncodingValues val) {
        this.incomingMsgEncoding = val;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Incoming msg encoding: " + val.getName());
        }
    }

    private void setOutgoingMsgEncoding(ContentEncodingValues val) {
        this.outgoingMsgEncoding = val;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Outgoing msg encoding: " + val.getName());
        }
    }

    private boolean isOutgoingMsgEncoded() {
        return !DEFAULT_ENCODING.equals(this.outgoingMsgEncoding);
    }

    public boolean isZlibEncoded() {
        return ContentEncodingValues.DEFLATE.equals(this.outgoingMsgEncoding);
    }

    public boolean setZlibEncoded(boolean flag) {
        if (this.headersSent()) {
            return false;
        }
        if (flag) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.DEFLATE);
        } else if (this.isZlibEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    public boolean isZlibEncodingSupported() {
        return true;
    }

    public boolean isGZipEncoded() {
        return ContentEncodingValues.GZIP.equals(this.outgoingMsgEncoding);
    }

    public boolean setGZipEncoded(boolean flag) {
        if (this.headersSent()) {
            return false;
        }
        if (flag) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.GZIP);
        } else if (this.isGZipEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    public boolean isGZipEncodingSupported() {
        return true;
    }

    public boolean isXGZipEncoded() {
        return ContentEncodingValues.XGZIP.equals(this.outgoingMsgEncoding);
    }

    public boolean setXGZipEncoded(boolean flag) {
        if (this.headersSent()) {
            return false;
        }
        if (flag) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.XGZIP);
        } else if (this.isXGZipEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    public boolean isXGZipEncodingSupported() {
        return true;
    }

    protected final boolean isRawBody() {
        return this.bIsRawBody;
    }

    protected final void setRawBody(boolean flag) {
        this.bIsRawBody = flag;
    }

    public final boolean isPartialBody() {
        return this.bIsPartialBody;
    }

    protected final void setPartialBody(boolean flag) {
        this.bIsPartialBody = flag;
    }

    protected final boolean isOutgoingBodyValid() {
        return this.bIsOutgoingBodyValid;
    }

    private void setOutgoingBodyValid(boolean flag) {
        this.bIsOutgoingBodyValid = flag;
    }

    protected final boolean isForceAsync() {
        return this.bForceAsync;
    }

    protected final void setForceAsync(boolean flag) {
        this.bForceAsync = flag;
    }

    protected final boolean isResponseOwner() {
        return this.bIsResponseOwner;
    }

    protected final void setResponseOwner(boolean flag) {
        this.bIsResponseOwner = flag;
    }

    protected final void setMyResponse(HttpResponseMessageImpl msg) {
        this.myResponse = msg;
    }

    protected final HttpResponseMessageImpl getMyResponse() {
        return this.myResponse;
    }

    protected final boolean isRequestOwner() {
        return this.bIsRequestOwner;
    }

    protected final void setRequestOwner(boolean flag) {
        this.bIsRequestOwner = flag;
    }

    protected final void setMyRequest(HttpRequestMessageImpl msg) {
        this.myRequest = msg;
    }

    protected final HttpRequestMessageImpl getMyRequest() {
        return this.myRequest;
    }

    public void resetRequestOwnership() {
        if (null != this.getMyRequest()) {
            this.getMyRequest().setOwner(this);
        }
    }

    public void resetResponseOwnership() {
        if (null != this.getMyResponse()) {
            this.getMyResponse().setOwner(this);
        }
    }

    private int getChunkLengthParsingState() {
        return this.chunkLengthParseState;
    }

    private void setChunkLengthParsingState(int val) {
        this.chunkLengthParseState = val;
    }

    protected void init(TCPConnectionContext tsc, HttpChannelConfig hcc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.setHttpConfig(hcc);
        if (null != tsc) {
            block5: {
                this.myTSC = tsc;
                try {
                    this.setLocalPort(this.getTSC().getLocalPort());
                    this.setRemotePort(this.getTSC().getRemotePort());
                    this.setLocalAddr(this.getTSC().getLocalAddress());
                    this.setRemoteAddr(this.getTSC().getRemoteAddress());
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.getClass().getName() + ".init", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                    Tr.event(tc, "Received exception from JDK socket calls; " + t);
                }
            }
            this.myReadTimeout = this.getHttpConfig().getReadTimeout();
            this.myWriteTimeout = this.getHttpConfig().getWriteTimeout();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        while (!this.allocatedBuffers.isEmpty()) {
            this.allocatedBuffers.removeFirst().release();
        }
        this.lastHeaderBuffer = -1;
        if (null != this.getMyRequest() && this.isRequestOwner()) {
            this.getMyRequest().destroy();
        }
        this.setMyRequest(null);
        if (null != this.getMyResponse() && this.isResponseOwner()) {
            this.getMyResponse().destroy();
        }
        this.setMyResponse(null);
        this.myTSC = null;
        this.setVC(null);
        this.setAppWriteCallback(null);
        this.setAppReadCallback(null);
        this.releaseReadBuffers();
        if (null != this.buffChunkHeader) {
            this.buffChunkHeader.release();
            this.buffChunkHeader = null;
        }
        if (null != this.buffChunkTrailer) {
            this.buffChunkTrailer.release();
            this.buffChunkTrailer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        while (!this.allocatedBuffers.isEmpty()) {
            this.allocatedBuffers.removeFirst().release();
        }
        this.lastHeaderBuffer = -1;
        if (null != this.myRequest) {
            if (this.bIsRequestOwner) {
                this.myRequest.clear();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Request not mine, skipping clear()");
                }
                this.myRequest = null;
            }
        }
        this.bIsRequestOwner = true;
        if (null != this.myResponse) {
            if (this.bIsResponseOwner) {
                this.myResponse.clear();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Response not mine, skipping clear()");
                }
                this.myResponse = null;
            }
        }
        this.bIsResponseOwner = true;
        this.msgSentState = 0;
        this.msgParsedState = 0;
        this.writingHeaders = false;
        this.bIsPersistent = true;
        this.bIsOutgoingBodyValid = true;
        this.bIsIncomingBodyValid = false;
        this.bIsBodyExpected = false;
        this.bIsPartialBody = false;
        this.outgoingMsgEncoding = DEFAULT_ENCODING;
        this.incomingMsgEncoding = DEFAULT_ENCODING;
        this.bIsRawBody = false;
        this.unparsedDataRemaining = -1;
        this.bIsChunked = false;
        this.myContentLength = -1;
        this.clearStorage();
        this.clearTempStorage();
        this.amountBeingRead = 0;
        this.numBytesWritten = 0;
        this.incomingMsgSize = 0L;
        this.savedChunkLength = -1;
        this.oldLimit = 0;
        this.shouldModify = true;
        this.clearPendingByteBuffers();
        this.bIsJITRead = false;
        this.reqMethod = null;
        this.reqVersion = null;
        this.chunkLengthParseState = 0;
        this.bParsingTrailers = false;
        if (null != this.decompressHandler) {
            this.decompressHandler.close();
            this.decompressHandler = null;
        }
        if (null != this.compressHandler) {
            Iterator<WsByteBuffer> it = this.compressHandler.finish().iterator();
            while (it.hasNext()) {
                it.next().release();
            }
            this.compressHandler = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public VersionValues getRequestVersion() {
        if (null == this.reqVersion) {
            return this.getRequest().getVersionValue();
        }
        return this.reqVersion;
    }

    public final void setRequestVersion(VersionValues val) {
        this.reqVersion = val;
    }

    public MethodValues getRequestMethod() {
        if (null == this.reqMethod) {
            return this.getRequest().getMethodValue();
        }
        return this.reqMethod;
    }

    public final void setRequestMethod(MethodValues val) {
        this.reqMethod = val;
    }

    public void setReadTimeout(int time) throws IllegalArgumentException {
        if (time < 0) {
            throw new IllegalArgumentException("Timeout too low (" + time + ")");
        }
        this.myReadTimeout = time;
    }

    public void setWriteTimeout(int time) throws IllegalArgumentException {
        if (time < 0) {
            throw new IllegalArgumentException("Timeout too low (" + time + ")");
        }
        this.myWriteTimeout = time;
    }

    public final int getReadTimeout() {
        return this.myReadTimeout;
    }

    public final int getWriteTimeout() {
        return this.myWriteTimeout;
    }

    protected void updatePersistence(HttpBaseMessageImpl msg) {
        String value2;
        if (!this.isPersistent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updatePersistence: already false");
            }
            return;
        }
        if (msg.isIncoming() && this.getHttpConfig().isServantRegion() && "false".equalsIgnoreCase(value2 = (String)this.getVC().getStateMap().get("SessionPersistence"))) {
            this.setPersistent(false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "z/OS CR forced non-persistence");
            }
            return;
        }
        if (msg.isCloseSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message contains Close value");
            }
            this.setPersistent(false);
        } else if (!msg.isKeepAliveSet()) {
            if (msg.isIncoming()) {
                if (msg.getVersionValue().equals(VersionValues.V10)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Incoming 1.0 msg has no connection header");
                    }
                    this.setPersistent(false);
                }
            } else {
                this.setPersistent(this.getHttpConfig().isKeepAliveEnabled());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting persistence based on configuration: " + this.isPersistent());
                }
            }
        }
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Connection persistence updated to " + this.isPersistent(), (HttpServiceContext)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePersistence updated: " + this.isPersistent());
        }
    }

    private void updateBodyFlags(HttpBaseMessageImpl msg) {
        if (!msg.isIncoming()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updateBodyFlags skipping outgoing message: " + msg);
            }
            return;
        }
        this.setIsChunkedEncoding(msg.isChunkedEncodingSet());
        if (this.isChunkedEncoding() && -1 != msg.getContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Content-Length header of " + msg.getContentLength() + " and only using chunked-encoding");
            }
            msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
            if (this.getHttpConfig().isRequestSmugglingProtectionEnabled()) {
                this.setPersistent(false);
            }
        }
        this.setContentLength(msg.getContentLength());
        if (0 == this.getContentLength()) {
            this.setBodyComplete();
        }
        this.bIsIncomingBodyValid = msg.isBodyAllowed();
        this.bIsBodyExpected = msg.isBodyExpected();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updateBodyFlags: CL: " + this.getContentLength() + " isChunked: " + this.isChunkedEncoding() + " bodyValid: " + this.isIncomingBodyValid() + " bodyExpected: " + this.bIsBodyExpected);
        }
    }

    protected void updateBodyLengthHeaders(HttpBaseMessageImpl msg) {
        if (!msg.shouldUpdateBodyHeaders()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg not allowing body header changes: " + msg);
            }
            return;
        }
        if (0 != msg.getContentLength()) {
            msg.setContentLength(0);
        }
        if (msg.isChunkedEncodingSet()) {
            msg.removeTransferEncoding(TransferEncodingValues.CHUNKED);
            msg.commitTransferEncoding();
        }
    }

    private void updateIncomingEncodingFlags(HttpBaseMessageImpl msg) {
        ContentEncodingValues enc = msg.getOutermostEncoding();
        if (null != enc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg outermost encoding: " + enc);
            }
            if (ContentEncodingValues.DEFLATE.equals(enc) || ContentEncodingValues.GZIP.equals(enc) || ContentEncodingValues.XGZIP.equals(enc)) {
                this.setIncomingMsgEncoding(enc);
            } else {
                this.setIncomingMsgEncoding(DEFAULT_ENCODING);
            }
        } else {
            this.setIncomingMsgEncoding(DEFAULT_ENCODING);
        }
    }

    public boolean isChunkedEncoding() {
        return this.bIsChunked;
    }

    private void setIsChunkedEncoding(boolean flag) {
        this.bIsChunked = flag;
    }

    public boolean isContentLength() {
        return -1 != this.getContentLength();
    }

    protected final int getContentLength() {
        return this.myContentLength;
    }

    private void setContentLength(int length) {
        this.myContentLength = length;
    }

    protected final boolean isIncomingBodyValid() {
        return this.bIsIncomingBodyValid;
    }

    protected final boolean isIncomingBodyExpected() {
        return this.bIsBodyExpected;
    }

    private boolean loadReadBuffers() {
        boolean rc = false;
        WsByteBuffer[] list = this.getTSC().getReadInterface().getBuffers();
        if (null != list && 0 != list.length) {
            this.parseBufferIndex = 0;
            this.myParseBuffers = list;
            rc = true;
        } else {
            this.parseBufferIndex = -1;
            this.myParseBuffers = null;
        }
        this.getTSC().getReadInterface().setBuffers(null);
        return rc;
    }

    protected WsByteBuffer getNextReadBuffer() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (-1 == this.parseBufferIndex) {
            if (!this.loadReadBuffers()) {
                this.setReadBuffer(null);
                return null;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read " + this.myParseBuffers.length + " buffers from device.");
            }
        }
        this.setReadBuffer(this.myParseBuffers[this.parseBufferIndex]);
        this.configurePostReadBuffer(this.getReadBuffer());
        if (this.isJITRead()) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving JIT buffer");
            }
            this.allocatedBuffers.add(this.getReadBuffer());
        }
        ++this.parseBufferIndex;
        if (this.parseBufferIndex == this.myParseBuffers.length) {
            this.parseBufferIndex = -1;
        }
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read buffer: " + this.getReadBuffer());
        }
        return this.getReadBuffer();
    }

    public boolean isReadDataAvailable() {
        if (null != this.getReadBuffer() && this.getReadBuffer().hasRemaining()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Data exists in buffer: " + this.getReadBuffer());
            }
            this.disableBufferModification();
            return true;
        }
        if (-1 == this.parseBufferIndex) {
            return false;
        }
        if (this.parseBufferIndex < this.myParseBuffers.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Secondary read buffers exist.");
            }
            this.getNextReadBuffer();
            return true;
        }
        return false;
    }

    public boolean isReadSpaceAvailable(int size) {
        if (null != this.getReadBuffer()) {
            int min2;
            int cap = this.getReadBuffer().capacity();
            int availSpace = cap - this.getReadBuffer().limit();
            if (0 == availSpace) {
                return false;
            }
            if (cap < size) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring smaller buffer, capacity=" + cap + " target size=" + size);
                }
                return false;
            }
            int n = min2 = 1024 > size ? size : 1024;
            if (min2 > availSpace) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring buffer with too little free: " + availSpace);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public WsByteBuffer getReadBuffer() {
        return this.currentReadBB;
    }

    public void setReadBuffer(WsByteBuffer buffer) {
        this.currentReadBB = buffer;
    }

    public void configurePostReadBuffer(WsByteBuffer buffer) {
        if (!this.shouldModify) {
            return;
        }
        if (0 < this.getOldLimit()) {
            buffer.limit(buffer.position());
            buffer.position(this.getOldLimit());
            this.setOldLimit(0);
        } else {
            buffer.flip();
        }
        this.disableBufferModification();
    }

    public void configurePreReadBuffer(WsByteBuffer buffer) {
        this.setOldLimit(buffer.limit());
        buffer.position(this.getOldLimit());
        buffer.limit(buffer.capacity());
    }

    private void releaseReadBuffers() {
        if (-1 != this.parseBufferIndex) {
            for (int i = this.parseBufferIndex; i < this.myParseBuffers.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Releasing read buffer: " + this.myParseBuffers[i]);
                }
                this.myParseBuffers[i].release();
            }
            this.myParseBuffers = null;
            this.parseBufferIndex = -1;
        }
    }

    public final boolean isJITRead() {
        return this.bIsJITRead;
    }

    public void setupJITRead(int size) {
        this.bIsJITRead = true;
        this.enableBufferModification();
        this.setOldLimit(0);
        this.getTSC().getReadInterface().setJITAllocateSize(size);
        this.getTSC().getReadInterface().setBuffers(null);
        this.setReadBuffer(null);
    }

    public void setupNonJITRead() {
        this.bIsJITRead = false;
        this.enableBufferModification();
        this.getTSC().getReadInterface().setJITAllocateSize(0);
        this.getTSC().getReadInterface().setBuffer(this.getReadBuffer());
    }

    public final void disableBufferModification() {
        this.shouldModify = false;
    }

    public final void enableBufferModification() {
        this.shouldModify = true;
    }

    private void clearPendingByteBuffers() {
        for (int i = 0; i < this.pendingBufferStop; ++i) {
            this.myPendingBuffers[i] = null;
        }
        this.pendingBufferStart = 0;
        this.pendingBufferStop = 0;
    }

    protected final WsByteBuffer[] getPendingBuffers() {
        return this.myPendingBuffers;
    }

    protected final void setPendingBuffers(WsByteBuffer[] list) {
        this.myPendingBuffers = list;
    }

    protected final int getPendingStart() {
        return this.pendingBufferStart;
    }

    protected final void setPendingStart(int start) {
        this.pendingBufferStart = start;
    }

    protected final int getPendingStop() {
        return this.pendingBufferStop;
    }

    protected final void setPendingStop(int stop) {
        this.pendingBufferStop = stop;
    }

    public int getNumBytesWritten() {
        return this.numBytesWritten;
    }

    protected final void addBytesWritten(int num) {
        this.numBytesWritten += num;
    }

    protected final void resetBytesWritten() {
        this.numBytesWritten = 0;
    }

    protected long queryIncomingMsgSize() {
        return this.incomingMsgSize;
    }

    protected void addToIncomingMsgSize(int num) {
        this.incomingMsgSize += (long)num;
    }

    protected void checkIncomingMessageLimit(int addition) throws MessageTooLargeException {
    }

    private void growPendingArray(int size) {
        WsByteBuffer[] tempNew = new WsByteBuffer[size];
        System.arraycopy(this.myPendingBuffers, 0, tempNew, 0, this.pendingBufferStop);
        this.myPendingBuffers = tempNew;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Increased pending list to " + size);
        }
    }

    private void addToPendingByteBuffer(WsByteBuffer wsbb) {
        if (this.pendingBufferStop == this.myPendingBuffers.length) {
            this.growPendingArray(this.pendingBufferStop + 4);
        }
        this.myPendingBuffers[this.pendingBufferStop] = wsbb;
        ++this.pendingBufferStop;
    }

    private void addToPendingByteBuffer(WsByteBuffer[] list, int length) {
        int newsize = this.pendingBufferStop + length;
        if (newsize >= this.myPendingBuffers.length) {
            if (length < 4) {
                newsize = this.myPendingBuffers.length + 4;
            }
            this.growPendingArray(newsize);
        }
        System.arraycopy(list, 0, this.myPendingBuffers, this.pendingBufferStop, length);
        this.pendingBufferStop += length;
    }

    private void formatBody(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) {
        boolean doChunkWork;
        int index;
        if (null == wsbb || null == msg) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Leaving formatBody, wsbb: " + wsbb + " msg: " + msg);
            }
            return;
        }
        int length = 0;
        for (index = 0; index < wsbb.length && null != wsbb[index]; ++index) {
            length += wsbb[index].remaining();
        }
        if (0 == length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring empty body buffers");
            }
            return;
        }
        boolean bl = doChunkWork = !this.isRawBody() && msg.isChunkedEncodingSet();
        if (doChunkWork) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a chunk of length " + length);
            }
            byte[] encodedLength = this.asChunkedLength(length);
            this.addBytesWritten(encodedLength.length + BNFHeaders.EOL.length);
            this.addToPendingByteBuffer(this.createChunkHeader(encodedLength));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "formatBody: Adding " + index + " app buffers to write queue");
        }
        this.addToPendingByteBuffer(wsbb, index);
        if (doChunkWork) {
            WsByteBuffer trailer = this.createChunkTrailer();
            trailer.limit(BNFHeaders.EOL.length);
            this.addToPendingByteBuffer(trailer);
            this.addBytesWritten(BNFHeaders.EOL.length);
        }
        this.addBytesWritten(length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "formatBody: total bytes now : " + this.getNumBytesWritten());
        }
    }

    private void formatHeaders(HttpBaseMessageImpl msg) {
        WsByteBuffer[] headerBuffers;
        ContentEncodingValues ce;
        if (null != this.compressHandler && !(ce = this.compressHandler.getContentEncoding()).equals(msg.getOutermostEncoding())) {
            msg.appendContentEncoding(ce);
        }
        this.updatePersistence(msg);
        this.setOutgoingBodyValid(msg.isBodyAllowed());
        if (!this.isOutgoingBodyValid()) {
            this.updateBodyLengthHeaders(msg);
        }
        try {
            headerBuffers = this.getHttpConfig().isBinaryTransportEnabled() ? msg.marshallBinaryMessage() : msg.marshallMessage();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".formatHeaders", "1859", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "marshallMessage returned " + e);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "formatHeaders: Adding " + headerBuffers.length + " buffers to be written");
        }
        this.addToPendingByteBuffer(headerBuffers, headerBuffers.length);
        this.writingHeaders = true;
        this.setHeadersSent();
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Sending headers to client", (HttpServiceContext)this);
        }
    }

    protected final void sendHeaders(HttpBaseMessageImpl msg) throws IOException {
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Invalid call to sendHeaders after already sent");
            }
            return;
        }
        this.setupCompressionHandler(msg);
        this.formatHeaders(msg);
        this.synchWrite();
    }

    protected final VirtualConnection sendHeaders(HttpBaseMessageImpl msg, TCPWriteCompletedCallback myCB) {
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Invalid call to sendHeaders after already sent");
            }
            return null;
        }
        this.setupCompressionHandler(msg);
        this.formatHeaders(msg);
        return this.asynchWrite(myCB);
    }

    protected boolean isCompressionAllowed() {
        return true;
    }

    private boolean isAutoCompression(HttpBaseMessageImpl msg) {
        String val;
        boolean rc = this.isOutgoingMsgEncoded();
        if (!rc && null != (val = msg.getHeaderAsString(HttpHeaderKeys.HDR_$WSZIP))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header requests compression: [" + val + "]");
            }
            if ("gzip".equalsIgnoreCase(val)) {
                this.setGZipEncoded(true);
                rc = true;
            } else if ("x-gzip".equalsIgnoreCase(val)) {
                this.setXGZipEncoded(true);
                rc = true;
            } else if ("zlib".equalsIgnoreCase(val) || "deflate".equalsIgnoreCase(val)) {
                this.setZlibEncoded(true);
                rc = true;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid WSZIP compression: " + val);
                }
                this.setOutgoingMsgEncoding(ContentEncodingValues.IDENTITY);
            }
            msg.removeSpecialHeader(HttpHeaderKeys.HDR_$WSZIP);
        }
        if (rc && !(rc = this.isCompressionAllowed())) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.IDENTITY);
        }
        return rc;
    }

    private void prepareOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Preparing to send message");
        }
        WsByteBuffer[] buffers = wsbb;
        this.writingHeaders = false;
        if (!this.isRawBody() && !this.headersSent()) {
            this.setupCompressionHandler(msg);
        }
        if (null != this.compressHandler) {
            List<WsByteBuffer> list = this.compressHandler.compress(buffers);
            if (this.isFinalWrite) {
                list.addAll(this.compressHandler.finish());
            }
            if (0 < list.size()) {
                buffers = new WsByteBuffer[list.size()];
                list.toArray(buffers);
                this.storeAllocatedBuffers(buffers);
            } else {
                buffers = null;
            }
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareOutgoing: partial: " + this.isPartialBody() + " chunked: " + msg.isChunkedEncodingSet() + " cl: " + msg.getContentLength());
            }
            if (!this.isPartialBody() && msg.shouldUpdateBodyHeaders()) {
                msg.setContentLength(GenericUtils.sizeOf(buffers));
                if (msg.isChunkedEncodingSet()) {
                    msg.removeTransferEncoding(TransferEncodingValues.CHUNKED);
                    msg.commitTransferEncoding();
                }
            }
            this.formatHeaders(msg);
        }
        if (null != buffers) {
            if (this.isOutgoingBodyValid()) {
                this.formatBody(buffers, msg);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring " + buffers.length + " body buffers");
            }
        }
    }

    protected final void sendOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) throws IOException {
        this.prepareOutgoing(wsbb, msg);
        this.synchWrite();
    }

    protected final VirtualConnection sendOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg, TCPWriteCompletedCallback writeCallback) {
        this.prepareOutgoing(wsbb, msg);
        return this.asynchWrite(writeCallback);
    }

    protected final void sendFullOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) throws IOException {
        this.isFinalWrite = true;
        this.prepareOutgoing(wsbb, msg);
        if (this.isOutgoingBodyValid() && msg.isChunkedEncodingSet()) {
            this.createEndOfBodyChunk();
        }
        this.setMessageSent();
        this.synchWrite();
    }

    protected final VirtualConnection sendFullOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg, TCPWriteCompletedCallback wc) {
        this.isFinalWrite = true;
        this.prepareOutgoing(wsbb, msg);
        if (this.isOutgoingBodyValid() && msg.isChunkedEncodingSet()) {
            this.createEndOfBodyChunk();
        }
        this.setMessageSent();
        return this.asynchWrite(wc);
    }

    protected WsByteBuffer createChunkHeader(byte[] length) {
        if (null == this.buffChunkHeader) {
            this.buffChunkHeader = this.newBuffer(32);
            this.buffChunkHeader.removeFromLeakDetection();
        } else {
            this.buffChunkHeader.clear();
        }
        this.buffChunkHeader.put(length);
        this.buffChunkHeader.put(BNFHeaders.EOL);
        this.buffChunkHeader.flip();
        return this.buffChunkHeader;
    }

    protected WsByteBuffer createChunkTrailer() {
        if (null == this.buffChunkTrailer) {
            this.buffChunkTrailer = this.newBuffer(32);
            this.buffChunkTrailer.removeFromLeakDetection();
            this.buffChunkTrailer.put(CHUNK_TRAILER_DATA);
            this.buffChunkTrailer.flip();
        } else {
            this.buffChunkTrailer.position(0);
        }
        return this.buffChunkTrailer;
    }

    private void createEndOfBodyChunk() {
        if (this.isRawBody()) {
            WsByteBuffer[] trailers = this.marshallOutgoingTrailers();
            if (null != trailers) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding trailers after raw body.");
                }
                this.addToPendingByteBuffer(trailers, trailers.length);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating end of body chunk");
        }
        WsByteBuffer trailer = null;
        if (null == this.buffChunkTrailer) {
            trailer = this.createChunkTrailer();
            trailer.position(2);
            this.addToPendingByteBuffer(trailer);
        } else {
            trailer = this.buffChunkTrailer;
            int pos = trailer.position();
            if (0 != pos) {
                if (2 != pos) {
                    trailer.position(2);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Zero chunk adding to pending list");
                }
                this.addToPendingByteBuffer(trailer);
            }
        }
        WsByteBuffer[] trailerData = this.marshallOutgoingTrailers();
        if (null != trailerData) {
            trailer.limit(5);
            this.addBytesWritten(3);
            this.addToPendingByteBuffer(trailerData, trailerData.length);
        } else {
            trailer.limit(7);
            this.addBytesWritten(5);
        }
    }

    private WsByteBuffer[] marshallOutgoingTrailers() {
        HttpTrailersImpl trailers = this.getMessageBeingSent().getTrailersImpl();
        WsByteBuffer[] buffers = null;
        if (null != trailers) {
            trailers.computeRemainingTrailers();
            if (0 < trailers.getNumberOfHeaders()) {
                buffers = this.getHttpConfig().isBinaryTransportEnabled() ? trailers.marshallBinaryHeaders(null) : trailers.marshallHeaders(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trailers marshalled into " + buffers.length + " buffers.");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: no actual trailers to marshall.");
            }
        }
        return buffers;
    }

    protected final VirtualConnection asynchWrite(TCPWriteCompletedCallback callback) {
        WsByteBuffer[] writeBuffers = this.getBuffList();
        if (null != writeBuffers) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing (async) " + writeBuffers.length + " buffers.");
            }
            this.getTSC().getWriteInterface().setBuffers(writeBuffers);
            return this.getTSC().getWriteInterface().write(-1L, callback, this.isForceAsync(), this.getWriteTimeout());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Async write has no data to send.");
        }
        if (this.isForceAsync()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "App channel forcing callback usage.");
            }
            callback.complete(this.getVC(), this.getTSC().getWriteInterface());
            return null;
        }
        return this.getVC();
    }

    private void synchWrite() throws IOException {
        WsByteBuffer[] writeBuffers = this.getBuffList();
        if (null != writeBuffers) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing (sync) " + writeBuffers.length + " buffers.");
            }
            this.getTSC().getWriteInterface().setBuffers(writeBuffers);
            try {
                this.getTSC().getWriteInterface().write(-1L, this.getWriteTimeout());
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "IOException during sync write: " + ioe.getMessage());
                }
                this.setPersistent(false);
                this.logLegacyMessage();
                throw ioe;
            }
            finally {
                this.getTSC().getWriteInterface().setBuffers(null);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sync write has no data to send.");
        }
    }

    public void logLegacyMessage() {
    }

    protected WsByteBuffer[] getBuffList() {
        int size = this.pendingBufferStop - this.pendingBufferStart;
        if (0 == size) {
            return null;
        }
        WsByteBuffer[] list = new WsByteBuffer[size];
        System.arraycopy(this.myPendingBuffers, this.pendingBufferStart, list, 0, size);
        this.clearPendingByteBuffers();
        return list;
    }

    protected abstract boolean reconnectAllowed();

    protected abstract HttpBaseMessageImpl getMessageBeingParsed();

    protected abstract HttpBaseMessageImpl getMessageBeingSent();

    public boolean parseMessage() throws Exception {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (null == this.currentReadBB && null == this.getNextReadBuffer()) {
            this.setupJITRead(this.myChannelConfig.getIncomingHdrBufferSize());
            return false;
        }
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        boolean rc = false;
        boolean newBuffer = false;
        if (-1 == msg.getBuffersIndex()) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "First buffer of message: " + this.currentReadBB);
            }
            if (this.isSecure()) {
                this.myChannelConfig.getDebugLog().log(DebugLog.Level.INFO, "Connection is secure", (HttpServiceContext)this);
            }
            this.myChannelConfig.getDebugLog().log(DebugLog.Level.DEBUG, "Starting to parse the message", (HttpServiceContext)this);
            newBuffer = true;
        } else if (this.isJITRead()) {
            newBuffer = true;
        }
        do {
            if (newBuffer) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Msg saving buffer: " + this.currentReadBB);
                }
                msg.addParseBuffer(this.currentReadBB);
            }
            this.configurePostReadBuffer(this.currentReadBB);
            rc = msg.parseMessage(this.currentReadBB, this.myChannelConfig.shouldExtractValue());
            if (rc) {
                this.parsingComplete();
                continue;
            }
            if (!this.isReadDataAvailable()) break;
            newBuffer = true;
        } while (!rc);
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseMessage() returning " + rc + " for " + msg);
        }
        return rc;
    }

    protected void parsingComplete() throws Exception {
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        this.setHeadersParsed();
        this.setLastHeaderBuffer();
        this.updatePersistence(msg);
        this.updateBodyFlags(msg);
        this.updateIncomingEncodingFlags(msg);
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Finished parsing the message", (HttpServiceContext)this);
        }
    }

    public boolean setupReadBuffers(int size, boolean bAllocate) {
        if (this.isReadDataAvailable()) {
            return true;
        }
        if (this.getHttpConfig().isJITOnlyReads()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config forcing a JIT read.");
            }
            this.setupJITRead(size);
        } else if (this.isReadSpaceAvailable(size)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading into existing buffer: " + this.getReadBuffer());
            }
            this.configurePreReadBuffer(this.getReadBuffer());
            this.setupNonJITRead();
        } else if (bAllocate) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Allocating read buffer, size=" + size);
            }
            this.setOldLimit(0);
            this.setReadBuffer(this.newBuffer(size));
            this.setupNonJITRead();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting up a JIT read, size=" + size);
            }
            this.setupJITRead(size);
        }
        return false;
    }

    public void resetRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting parsing variables");
        }
        this.resetMsgParsedState();
        this.getMessageBeingParsed().clear();
    }

    public void resetWrite() {
        this.resetMsgSentState();
        VersionValues version = this.getMessageBeingSent().getVersionValue();
        this.getMessageBeingSent().clear();
        this.getMessageBeingSent().setVersion(version);
    }

    public String getFFDCDumpData() {
        StringBuilder sb = new StringBuilder();
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        if (null != msg) {
            sb.append("Message being parsed: header count=");
            sb.append(msg.getAllHeaders().size());
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
            Vector<?> allHeaders = msg.getAllHeaders();
            int size = allHeaders.size();
            for (int i = 0; i < size; ++i) {
                String hdrName = (String)allHeaders.get(i);
                Iterator<String> values = msg.getHeaderStringValues(hdrName).iterator();
                while (values.hasNext()) {
                    HTTPChannelDM.formatFFDCString(hdrName, values.next(), sb);
                }
            }
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
        } else {
            HTTPChannelDM.formatFFDCString("Message being parsed", "null", sb);
        }
        if (null != this.getReadBuffer()) {
            HTTPChannelDM.formatFFDCString("read buffer", ((Object)this.getReadBuffer()).toString(), sb);
        } else {
            HTTPChannelDM.formatFFDCString("read buffer", "null", sb);
        }
        sb.append(HTTPChannelDM.LINE_SEPARATOR);
        HTTPChannelDM.formatFFDCString("ReadBufferSize", String.valueOf(this.getHttpConfig().getIncomingBodyBufferSize()), sb);
        HTTPChannelDM.formatFFDCString("ReadTimeout", String.valueOf(this.getReadTimeout()), sb);
        HTTPChannelDM.formatFFDCString("WriteTimeout", String.valueOf(this.getWriteTimeout()), sb);
        HTTPChannelDM.formatFFDCString("unparsedDataRemaining", String.valueOf(this.getDataLength()), sb);
        sb.append(HTTPChannelDM.LINE_SEPARATOR);
        return sb.toString();
    }

    public final InterChannelCallback getAppWriteCallback() {
        return this.appWriteCB;
    }

    public final InterChannelCallback getAppReadCallback() {
        return this.appReadCB;
    }

    protected final void setAppWriteCallback(InterChannelCallback cb) {
        this.appWriteCB = cb;
    }

    protected final void setAppReadCallback(InterChannelCallback cb) {
        this.appReadCB = cb;
    }

    public abstract HttpObjectFactory getObjectFactory();

    public final void setHttpConfig(HttpChannelConfig hcc) {
        this.myChannelConfig = hcc;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myChannelConfig;
    }

    public final TCPConnectionContext getTSC() {
        return this.myTSC;
    }

    protected final VirtualConnection getVC() {
        return this.myVC;
    }

    protected final void setVC(VirtualConnection vc) {
        this.myVC = vc;
    }

    private byte[] asChunkedLength(int length) {
        int initSize = 16;
        byte[] chunkBuf = new byte[initSize];
        int off = chunkBuf.length;
        for (int count = length; 0 < count; count >>= 4) {
            int digit = count & 0xF;
            chunkBuf[--off] = HEX_BYTES[digit];
        }
        byte[] retVal = new byte[initSize - off];
        System.arraycopy(chunkBuf, off, retVal, 0, retVal.length);
        return retVal;
    }

    private WsByteBuffer newBuffer(int size) {
        return this.getHttpConfig().isDirectBufferType() ? WsByteBufferPoolManagerImpl.getRef().allocateDirect(size) : WsByteBufferPoolManagerImpl.getRef().allocate(size);
    }

    protected WsByteBuffer allocateBuffer(int size) {
        WsByteBuffer wsbb = this.newBuffer(size);
        this.allocatedBuffers.add(wsbb);
        return wsbb;
    }

    private void setDataLength(int len) {
        this.unparsedDataRemaining = len;
    }

    private int getDataLength() {
        return this.unparsedDataRemaining;
    }

    private boolean doTrailersFollow() throws IllegalHttpBodyException {
        if (this.getMessageBeingParsed().containsHeader(HttpHeaderKeys.HDR_TRAILER)) {
            return true;
        }
        int data_len = this.getReadBuffer().remaining();
        if (0 == data_len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No data present, assuming no trailers exist");
            }
            return false;
        }
        byte b = this.getReadBuffer().get();
        boolean rc = true;
        if (13 == b) {
            this.addToIncomingMsgSize(1);
            if (1 < data_len) {
                b = this.getReadBuffer().get();
                if (10 == b) {
                    this.addToIncomingMsgSize(1);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error: Received " + b + " after the CR");
                    }
                    throw new IllegalHttpBodyException("Missing chunk LF: " + b);
                }
            }
            rc = false;
        } else if (10 == b) {
            this.addToIncomingMsgSize(1);
            rc = false;
        } else {
            int pos = this.getReadBuffer().position() - 1;
            this.getReadBuffer().position(pos);
            rc = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Peek ahead for trailers rc->" + rc);
        }
        return rc;
    }

    private void parseChunkCRLF(int excess) throws IllegalHttpBodyException {
        if (0 == excess) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing past chunk CRLF, excess=" + excess);
        }
        byte b = this.getReadBuffer().get();
        this.addToIncomingMsgSize(1);
        if (13 == b) {
            if (1 == excess) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "LF char not read yet.");
                }
                return;
            }
            b = this.getReadBuffer().get();
            this.addToIncomingMsgSize(1);
        }
        if (10 != b) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Char expected to be LF but is ->" + b);
            }
            throw new IllegalHttpBodyException("Missing chunk LF: " + b);
        }
    }

    private boolean findBodyLength(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (this.isChunkedEncoding()) {
            if (0 == this.getChunkLengthParsingState()) {
                this.setChunkLengthParsingState(15);
            }
            this.setDataLength(this.readChunkLength(this.getReadBuffer()));
            while (-1 == this.getDataLength()) {
                if (!this.isReadDataAvailable()) {
                    if (this.fillABuffer(3, async, true)) {
                        return true;
                    }
                    if (this.isBodyComplete()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to read chunk length");
                        }
                        throw new BodyCompleteException("Failed to read chunk length");
                    }
                }
                this.setDataLength(this.readChunkLength(this.getReadBuffer()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read chunk size " + this.getDataLength());
            }
            this.checkIncomingMessageLimit(this.getDataLength());
            if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
                this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Parsed chunk size of " + this.getDataLength(), (HttpServiceContext)this);
            }
            if (0 == this.getDataLength()) {
                this.setBodyComplete();
                if (this.doTrailersFollow()) {
                    return this.parseTrailers(msg, async);
                }
                return false;
            }
        } else if (this.isContentLength()) {
            this.setDataLength(this.getContentLength());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got CL size " + this.getDataLength());
            }
            if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
                this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Parsed message content-length of " + this.getDataLength(), (HttpServiceContext)this);
            }
            if (0 == this.getDataLength()) {
                this.setBodyComplete();
                throw new BodyCompleteException("No more body to read");
            }
        }
        if (0 > this.getDataLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid negative body length: " + this.getDataLength());
            }
            this.setDataLength(0);
            throw new IllegalHttpBodyException("Invalid body length");
        }
        return false;
    }

    private boolean findRawChunkLength(HttpBaseMessageImpl msg, boolean async) throws IllegalHttpBodyException, IOException {
        if (0 == this.getChunkLengthParsingState()) {
            this.setChunkLengthParsingState(15);
        }
        if (null == this.getReadBuffer() && this.fillABuffer(3, async, true)) {
            return true;
        }
        this.setDataLength(this.readChunkLength(this.getReadBuffer()));
        while (-1 == this.getDataLength()) {
            if (!this.isReadDataAvailable()) {
                if (this.fillABuffer(3, async, true)) {
                    return true;
                }
                if (this.isBodyComplete()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to read chunk length");
                    }
                    throw new IllegalHttpBodyException("IOException while reading chunk");
                }
            }
            this.setDataLength(this.readChunkLength(this.getReadBuffer()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read raw chunk size " + this.getDataLength());
        }
        this.checkIncomingMessageLimit(this.getDataLength());
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Parsed chunk size of " + this.getDataLength(), (HttpServiceContext)this);
        }
        if (0 == this.getDataLength()) {
            this.setBodyComplete();
            boolean bTrailers = this.doTrailersFollow();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slicing body up to zero chunk, trailers=" + bTrailers);
            }
            int position = this.getReadBuffer().position();
            int limit = this.getReadBuffer().limit();
            this.getReadBuffer().position(this.oldPosition);
            if (position == limit) {
                this.storeBuffer(this.getReadBuffer().slice());
            } else {
                this.getReadBuffer().limit(position);
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(limit);
            }
            this.getReadBuffer().position(position);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Post-slice: " + this.getReadBuffer());
            }
            if (bTrailers) {
                return this.parseTrailers(msg, async);
            }
            return false;
        }
        return false;
    }

    private boolean readRawChunk(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading raw chunk buffer, len->" + this.getDataLength());
        }
        if (this.isBodyComplete()) {
            return false;
        }
        if (null == this.getReadBuffer()) {
            this.getNextReadBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current buffer: " + this.getReadBuffer());
        }
        if (null == this.getReadBuffer() || this.getReadBuffer().position() == this.getReadBuffer().capacity()) {
            this.oldPosition = 0;
        } else if (-1 == this.oldPosition) {
            this.oldPosition = this.getReadBuffer().position();
        }
        if (-1 == this.getDataLength() && this.findRawChunkLength(msg, async)) {
            return true;
        }
        if (0 == this.getDataLength()) {
            return false;
        }
        if (!this.isReadDataAvailable()) {
            if (this.fillABuffer(this.getDataLength(), async, true)) {
                return true;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error while reading body data");
                }
                throw new IllegalHttpBodyException("Error while reading chunk body.");
            }
        }
        int position = this.getReadBuffer().position();
        int limit = this.getReadBuffer().limit();
        int amountAvail = limit - position;
        int excess = amountAvail - this.getDataLength();
        if (0 < excess) {
            amountAvail = this.getDataLength();
            this.unparsedDataRemaining = 0;
        } else {
            this.unparsedDataRemaining -= amountAvail;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unparsed data remaining: " + this.getDataLength());
        }
        if (0 >= excess && limit == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Buffer is full, position: " + this.oldPosition);
            }
            this.getReadBuffer().position(this.oldPosition);
            if (0 == this.oldPosition) {
                this.storeBuffer(this.returnLastBuffer());
            } else {
                this.storeBuffer(this.getReadBuffer().slice());
            }
            this.setReadBuffer(null);
            this.oldPosition = -1;
            if (0 == this.getDataLength()) {
                this.setDataLength(-1);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slicing part of a buffer");
            }
            this.getReadBuffer().position(this.oldPosition);
            if (excess > 0) {
                byte b;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing CRLF for raw chunk, excess=" + excess);
                }
                if (13 == (b = this.getReadBuffer().get(limit - excess)) && 0 < --excess) {
                    b = this.getReadBuffer().get(limit - excess);
                }
                if (10 == b) {
                    --excess;
                }
                this.getReadBuffer().limit(limit - excess);
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(limit);
                this.getReadBuffer().position(limit - excess);
            } else {
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().position(limit);
            }
            this.oldPosition = this.getReadBuffer().position();
            if (0 == this.getDataLength()) {
                this.setDataLength(-1);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Post-slice: " + this.getReadBuffer());
            }
        }
        return false;
    }

    private boolean readSingleBlock(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (!this.isMultiRead() && !this.tempBuffers.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Buffer already available");
            }
            return false;
        }
        if (this.isBodyComplete()) {
            throw new BodyCompleteException("No more body to read");
        }
        if (null == this.getReadBuffer()) {
            this.getNextReadBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current buffer: " + this.getReadBuffer());
        }
        if (-1 == this.getDataLength() && this.findBodyLength(msg, async)) {
            return true;
        }
        if (0 == this.getDataLength()) {
            return false;
        }
        if (!this.isReadDataAvailable()) {
            if (this.fillABuffer(this.getDataLength(), async, true)) {
                return true;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "End of body found during fillABuffer");
                }
                return false;
            }
        }
        int position = this.getReadBuffer().position();
        int limit = this.getReadBuffer().limit();
        int amountAvail = limit - position;
        int excess = amountAvail - this.getDataLength();
        if (0 < excess) {
            if (this.isContentLength() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Excess data received: " + excess);
            }
            amountAvail = this.getDataLength();
            this.unparsedDataRemaining = 0;
        } else {
            this.unparsedDataRemaining -= amountAvail;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unparsed data remaining: " + this.getDataLength());
        }
        if (this.isContentLength() && 0 == this.getDataLength()) {
            this.setBodyComplete();
        }
        if (amountAvail == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning full buffer");
            }
            this.storeTempBuffer(this.returnLastBuffer());
            this.getNextReadBuffer();
        } else {
            int newPosition;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slicing part of a buffer");
            }
            if ((newPosition = position + amountAvail) == limit) {
                this.storeTempBuffer(this.getReadBuffer().slice());
            } else {
                this.getReadBuffer().limit(newPosition);
                this.storeTempBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(limit);
            }
            this.getReadBuffer().position(newPosition);
            if (this.isChunkedEncoding() && 0 < excess) {
                this.parseChunkCRLF(excess);
            }
        }
        return false;
    }

    protected final boolean readBodyBuffer(HttpBaseMessageImpl msg, boolean async) throws IllegalHttpBodyException, BodyCompleteException, IOException {
        boolean bAsyncInProgress = false;
        this.setupDecompressionHandler();
        if (this.decompressHandler.isEnabled() && VersionValues.V10.equals(msg.getVersionValue())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Reading encoded 1.0 body");
            }
            this.setMultiRead(true);
            return this.readBodyBuffers(msg, async);
        }
        if (this.isContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading body, content-length");
            }
            bAsyncInProgress = this.readSingleBlock(msg, async);
        } else if (this.isChunkedEncoding()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading body, chunked");
            }
            if (0 == this.getDataLength()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reached end of chunk previously");
                }
                this.setDataLength(-1);
            }
            bAsyncInProgress = !this.isRawBody() ? this.readSingleBlock(msg, async) : this.readRawChunk(msg, async);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading until closure");
            }
            bAsyncInProgress = this.readUntilEnd(async);
        }
        if (!bAsyncInProgress && !this.moveBuffers()) {
            bAsyncInProgress = this.readBodyBuffer(msg, async);
        }
        return bAsyncInProgress;
    }

    protected final boolean readBodyBuffers(HttpBaseMessageImpl msg, boolean async) throws IllegalHttpBodyException, BodyCompleteException, IOException {
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "BodyComplete is true, exiting");
            }
            return false;
        }
        boolean bAsyncInProgress = false;
        this.setupDecompressionHandler();
        if (this.isChunkedEncoding()) {
            if (this.isRawBody()) {
                bAsyncInProgress = this.readRawChunk(msg, async);
                while (!bAsyncInProgress && !this.isBodyComplete()) {
                    bAsyncInProgress = this.readRawChunk(msg, async);
                }
            } else {
                bAsyncInProgress = this.readFullChunk(msg, async);
                while (!bAsyncInProgress && !this.isBodyComplete()) {
                    bAsyncInProgress = this.readFullChunk(msg, async);
                }
            }
        } else {
            bAsyncInProgress = this.isContentLength() ? this.readFullCL(msg, async) : this.readFullBody(async);
        }
        if (!bAsyncInProgress) {
            this.setBodyComplete();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readBodyBuffers returning " + bAsyncInProgress);
        }
        return bAsyncInProgress;
    }

    protected boolean readUntilEnd(boolean async) throws IllegalHttpBodyException, BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Inbound request sending non-length delimited body, async:" + async + ", throwing exception");
        }
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "Invalid non-delimited message body", (HttpServiceContext)this);
        }
        this.prepareClosure();
        throw new IllegalHttpBodyException("Non-length delimited body on request");
    }

    private boolean moveBuffers() throws IllegalHttpBodyException {
        if (this.tempBuffers.isEmpty()) {
            return true;
        }
        boolean rc = false;
        if (this.decompressHandler.isEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing encoding...");
            }
            while (!this.tempBuffers.isEmpty()) {
                WsByteBuffer buffer = this.tempBuffers.removeFirst();
                while (buffer.hasRemaining()) {
                    try {
                        List<WsByteBuffer> list = this.decompressHandler.decompress(buffer);
                        if (list.isEmpty()) continue;
                        this.storage.addAll(list);
                        rc = true;
                    }
                    catch (DataFormatException dfe) {
                        FFDCFilter.processException(dfe, this.getClass().getName() + ".moveBuffers", "1");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Received exception during decompress; " + dfe);
                        }
                        throw new IllegalHttpBodyException(dfe.getMessage());
                    }
                }
                buffer.release();
            }
            HttpBaseMessageImpl msg = this.getMessageBeingParsed();
            if (!msg.containsHeader(HttpHeaderKeys.HDR_$WSZIP)) {
                msg.removeOutermostEncoding();
                if (this.isContentLength()) {
                    msg.setHeader((HeaderKeys)HttpHeaderKeys.HDR_$WSORIGCL, msg.getHeaderAsByteArray(HttpHeaderKeys.HDR_CONTENT_LENGTH));
                }
                if (this.isBodyComplete()) {
                    int newlen = (int)this.decompressHandler.getBytesWritten();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting decompressed Content-Length old: " + this.getContentLength() + " new: " + newlen);
                    }
                    msg.setContentLength(newlen);
                } else {
                    msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
                    msg.setTransferEncoding(TransferEncodingValues.CHUNKED);
                }
            }
        } else {
            this.storage.addAll(this.tempBuffers);
            this.tempBuffers.clear();
            rc = true;
        }
        return rc;
    }

    private boolean readFullCL(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        boolean bAsyncInProgress = false;
        if (-1 == this.getDataLength()) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        while (0 < this.getDataLength() && !bAsyncInProgress) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        if (!bAsyncInProgress && !this.moveBuffers()) {
            bAsyncInProgress = this.readFullCL(msg, async);
        }
        return bAsyncInProgress;
    }

    private boolean readFullBody(boolean async) throws IllegalHttpBodyException, BodyCompleteException {
        boolean bAsyncInProgress = false;
        while (!bAsyncInProgress && !this.isBodyComplete()) {
            bAsyncInProgress = this.readUntilEnd(async);
        }
        if (!(bAsyncInProgress || this.isBodyComplete() || this.moveBuffers())) {
            bAsyncInProgress = this.readFullBody(async);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readFullBody returning " + bAsyncInProgress);
        }
        return bAsyncInProgress;
    }

    private boolean readFullChunk(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        boolean bAsyncInProgress = false;
        if (0 == this.getDataLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reached end of chunk");
            }
            this.setDataLength(-1);
        }
        if (-1 == this.getDataLength()) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        while (0 < this.getDataLength() && !bAsyncInProgress) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        if (!bAsyncInProgress && !this.moveBuffers()) {
            bAsyncInProgress = this.readFullChunk(msg, async);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readFullChunk returning " + bAsyncInProgress);
        }
        return bAsyncInProgress;
    }

    private boolean parseTrailers(HttpBaseMessageImpl msg, boolean async) {
        try {
            this.bParsingTrailers = true;
            boolean rc = false;
            while (!rc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing a buffer for trailer headers");
                }
                HttpTrailersImpl trailers = msg.createTrailers();
                this.addToIncomingMsgSize(this.getReadBuffer().remaining());
                rc = this.getHttpConfig().isBinaryTransportEnabled() ? trailers.parseBinaryHeaders(this.getReadBuffer(), HttpHeaderKeys.HDR_$WSAT) : trailers.parseHeaders(this.getReadBuffer(), true);
                if (rc || this.isReadDataAvailable()) continue;
                this.setBodyRC(TrailerCallback.getRef());
                if (!this.fillABuffer(1, async, false)) continue;
                return true;
            }
            int extra = this.getReadBuffer().remaining();
            if (0 < extra) {
                this.addToIncomingMsgSize(-extra);
            }
        }
        catch (Exception mhe) {
            FFDCFilter.processException((Throwable)mhe, this.getClass().getName() + ".parseTrailers", "1915", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "parseTrailers caught exception: " + mhe);
            }
            this.setPersistent(false);
        }
        this.bParsingTrailers = false;
        return false;
    }

    private int convertCharToLength(int ch, int inLen) throws IllegalHttpBodyException {
        int mod;
        int length = inLen;
        if (-1 == length) {
            length = 0;
        }
        if (48 <= ch && 57 >= ch) {
            mod = ch - 48;
        } else if (97 <= ch && 102 >= ch) {
            mod = ch - 97 + 10;
        } else if (65 <= ch && 70 >= ch) {
            mod = ch - 65 + 10;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Client sent a bad chunk: " + ch);
            }
            throw new IllegalHttpBodyException("Illegal chunk length digit: " + ch);
        }
        length <<= 4;
        return length += mod;
    }

    private int getSavedChunkLength() {
        return this.savedChunkLength;
    }

    private void setSavedChunkLength(int length) {
        this.savedChunkLength = length;
    }

    private int readChunkLength(WsByteBuffer buff) throws IllegalHttpBodyException {
        int position;
        if (null == buff) {
            return -1;
        }
        int length = this.getSavedChunkLength();
        int limit = buff.limit();
        byte ch = 0;
        if (15 == this.getChunkLengthParsingState()) {
            for (position = buff.position(); position < limit; ++position) {
                ch = buff.get();
                this.addToIncomingMsgSize(1);
                if (13 == ch || 10 == ch) {
                    if (-1 == length) continue;
                    this.setChunkLengthParsingState(17);
                    break;
                }
                if (59 == ch || 32 == ch || 9 == ch) {
                    this.setChunkLengthParsingState(16);
                    break;
                }
                length = this.convertCharToLength(ch, length);
            }
            ++position;
        }
        if (16 == this.getChunkLengthParsingState()) {
            if (-1 == length) {
                throw new IllegalHttpBodyException("Missing chunk length");
            }
            while (position < limit) {
                ch = buff.get();
                this.addToIncomingMsgSize(1);
                if (13 == ch || 10 == ch) {
                    this.setChunkLengthParsingState(17);
                    break;
                }
                ++position;
            }
            ++position;
        }
        if (17 == this.getChunkLengthParsingState() && position < limit) {
            ch = buff.get();
            this.addToIncomingMsgSize(1);
            if (13 != ch && 10 != ch) {
                buff.position(position);
            }
            this.setChunkLengthParsingState(0);
            this.setSavedChunkLength(-1);
            return length;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readChunkLength: Not enough data, storing [" + length + "]");
        }
        this.setSavedChunkLength(length);
        return -1;
    }

    public final int getOldLimit() {
        return this.oldLimit;
    }

    public final void setOldLimit(int limit) {
        this.oldLimit = limit;
    }

    private int getAmountBeingRead() {
        return this.amountBeingRead;
    }

    private void setAmountBeingRead(int amount) {
        this.amountBeingRead = amount;
    }

    protected final boolean fillABuffer(int amount, boolean async, boolean throwException) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "fillABuffer(i,b) " + amount + " " + async);
        }
        int size = this.getHttpConfig().getIncomingBodyBufferSize();
        if (amount < 1024) {
            size = 1024;
        } else if (amount < size) {
            size = amount;
        }
        if (this.getHttpConfig().isJITOnlyReads()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config forcing JIT read");
            }
            if (null != this.getReadBuffer() && !this.lastBufferContainsHeaders()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returning non-header buffer before JIT read: " + this.getReadBuffer());
                }
                this.returnLastBuffer().release();
            }
            this.setupJITRead(size);
        } else {
            WsByteBuffer currentBuffer = this.getReadBuffer();
            if (null == currentBuffer || currentBuffer.limit() == currentBuffer.capacity()) {
                if (null != currentBuffer && !this.lastBufferContainsHeaders()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning non-header buffer: " + currentBuffer);
                    }
                    this.returnLastBuffer().release();
                }
                this.setReadBuffer(this.allocateBuffer(size));
                this.getReadBuffer().clear();
                this.setOldLimit(0);
            } else {
                this.configurePreReadBuffer(currentBuffer);
            }
            size = this.getReadBuffer().capacity() - this.getOldLimit();
            this.setupNonJITRead();
        }
        this.setAmountBeingRead(amount > size ? size : amount);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Filling buffer " + this.getReadBuffer() + " with amount " + this.getAmountBeingRead());
        }
        if (async) {
            VirtualConnection vc = this.getTSC().getReadInterface().read(this.getAmountBeingRead(), this.getBodyRC(), this.isForceAsync(), this.getReadTimeout());
            if (null == vc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "fillABuffer(i,b): async read in progress");
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "fillABuffer(i,b) read() returned immediately");
            }
        } else {
            try {
                this.getTSC().getReadInterface().read(this.getAmountBeingRead(), this.getReadTimeout());
                this.setAmountBeingRead(0);
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "IOException, closing the reads: " + ioe);
                }
                this.prepareClosure();
                if (throwException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing exception back to caller.");
                    }
                    throw ioe;
                }
                return false;
            }
        }
        this.getNextReadBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "fillABuffer(i,b) data ready in " + this.getReadBuffer());
        }
        return false;
    }

    protected void clearStorage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing buffer storage; size=" + this.storage.size());
        }
        while (!this.storage.isEmpty()) {
            WsByteBuffer buffer = this.storage.removeFirst();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing: " + buffer);
            }
            buffer.release();
        }
    }

    protected void clearTempStorage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing temp storage; size=" + this.tempBuffers.size());
        }
        while (!this.tempBuffers.isEmpty()) {
            WsByteBuffer buffer = this.tempBuffers.removeFirst();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing: " + buffer);
            }
            buffer.release();
        }
    }

    protected final void debugPrintStorage(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (int i = 0; i < buffers.length; ++i) {
                Tr.debug(tc, "debug: buffers[" + i + "]: " + (null != buffers[i] ? WsByteBufferUtils.asString(buffers[i]) : "null"));
            }
        }
    }

    protected WsByteBuffer[] getAllStorageBuffers() {
        if (this.storage.isEmpty()) {
            return null;
        }
        WsByteBuffer[] output = new WsByteBuffer[this.storage.size()];
        this.storage.toArray(output);
        this.storage.clear();
        return output;
    }

    protected WsByteBuffer[] queryAllStorageBuffers() {
        if (this.storage.isEmpty()) {
            return null;
        }
        WsByteBuffer[] output = new WsByteBuffer[this.storage.size()];
        this.storage.toArray(output);
        return output;
    }

    protected void setupDecompressionHandler() {
        if (null != this.decompressHandler) {
            return;
        }
        this.decompressHandler = !this.getHttpConfig().isAutoDecompressionEnabled() || this.isRawBody() ? new IdentityInputHandler() : (ContentEncodingValues.GZIP.equals(this.incomingMsgEncoding) ? new GzipInputHandler() : (ContentEncodingValues.XGZIP.equals(this.incomingMsgEncoding) ? new GzipInputHandler() : (ContentEncodingValues.DEFLATE.equals(this.incomingMsgEncoding) ? new DeflateInputHandler() : new IdentityInputHandler())));
    }

    private void setupCompressionHandler(HttpBaseMessageImpl msg) {
        if (!this.isOutgoingBodyValid() && this.isOutgoingMsgEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing disallowed encoding request flag: " + this.outgoingMsgEncoding);
            }
            this.outgoingMsgEncoding = DEFAULT_ENCODING;
            return;
        }
        if (this.isAutoCompression(msg)) {
            if (this.isGZipEncoded() || this.isXGZipEncoded()) {
                this.compressHandler = new GzipOutputHandler(this.isXGZipEncoded());
            } else if (this.isZlibEncoded()) {
                this.compressHandler = this.isInboundConnection() ? new DeflateOutputHandler(this.getRequest().getHeaderAsByteArray(HttpHeaderKeys.HDR_USER_AGENT)) : new DeflateOutputHandler();
            }
        }
        if (null != this.compressHandler && msg.shouldUpdateBodyHeaders()) {
            msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
        }
    }

    public final void prepareClosure() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Preparing connection for closure");
        }
        this.setPersistent(false);
        this.setBodyComplete();
        this.setDataLength(0);
        this.setAmountBeingRead(0);
        this.getTSC().getReadInterface().setBuffers(null);
        try {
            this.moveBuffers();
        }
        catch (IllegalHttpBodyException illegalHttpBodyException) {
            // empty catch block
        }
    }

    protected WsByteBuffer getNextBuffer() {
        WsByteBuffer buffer;
        WsByteBuffer wsByteBuffer = buffer = !this.storage.isEmpty() ? this.storage.removeFirst() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getNextBuffer returning " + buffer);
        }
        return buffer;
    }

    protected void storeTempBuffer(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Storing buffer: " + buffer);
        }
        if (null == this.decompressHandler || !this.decompressHandler.isEnabled()) {
            this.storage.add(buffer);
        } else {
            this.tempBuffers.add(buffer);
        }
    }

    private void storeBuffer(WsByteBuffer buffer) {
        this.storage.add(buffer);
    }

    protected final void setMultiRead(boolean bRead) {
        this.bIsMultiRead = bRead;
    }

    private boolean isMultiRead() {
        return this.bIsMultiRead;
    }

    public final void continueRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Continuing read...");
        }
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        if (this.bParsingTrailers) {
            if (!this.parseTrailers(msg, true)) {
                this.getAppReadCallback().complete(this.getVC());
            }
            return;
        }
        if (!this.incomingBuffersReady() && this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Nothing to read");
            }
            return;
        }
        this.getNextReadBuffer();
        try {
            boolean rc;
            boolean bl = rc = this.isMultiRead() ? this.readBodyBuffers(msg, true) : this.readBodyBuffer(msg, true);
            if (!rc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling complete on application channel.");
                }
                this.getAppReadCallback().complete(this.getVC());
            }
        }
        catch (IOException ioe) {
            this.getAppReadCallback().error(this.getVC(), ioe);
            return;
        }
        catch (BodyCompleteException bce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception: " + bce);
            }
            this.getAppReadCallback().error(this.getVC(), bce);
            return;
        }
    }

    public SSLConnectionContext getSSLContext() {
        return this.myTSC.getSSLContext();
    }

    public boolean cancelOutstandingRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Attempting to cancel an outstanding read: " + this.getVC());
        }
        try {
            this.myTSC.getReadInterface().read(1L, null, false, -2);
        }
        catch (IllegalArgumentException iae) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingRead: tcp layer does not support");
            }
            return false;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.getClass().getName() + ".cancelOutstandingRead", "1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingRead: unexpected exception from tcp: " + t);
            }
            return false;
        }
        return true;
    }

    public boolean cancelOutstandingWrite() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Attempting to cancel an outstanding write: " + this.getVC());
        }
        try {
            this.myTSC.getWriteInterface().write(1L, null, false, -2);
        }
        catch (IllegalArgumentException iae) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingWrite: tcp layer does not support");
            }
            return false;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.getClass().getName() + ".cancelOutstandingWrite", "1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingWrite: unexpected exception from tcp: " + t);
            }
            return false;
        }
        return true;
    }

    public CancelIOWrapper getReadCancel() {
        if (null == this.cancelRead) {
            this.cancelRead = new CancelIOWrapper();
        }
        return this.cancelRead;
    }

    public CancelIOWrapper getWriteCancel() {
        if (null == this.cancelWrite) {
            this.cancelWrite = new CancelIOWrapper();
        }
        return this.cancelWrite;
    }

    public boolean markReadCancelSuccess() {
        if (this.getReadCancel().success()) {
            if (null != this.getReadBuffer()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reset after canceled read is updating buffer: " + this.getReadBuffer());
                }
                this.getReadBuffer().limit(this.getReadBuffer().position());
            }
            return true;
        }
        return false;
    }

    public boolean markWriteCancelSuccess() {
        return this.getWriteCancel().success();
    }

    public void markReadCancelFailure() {
        this.getReadCancel().failure();
    }

    public void markWriteCancelFailure() {
        this.getWriteCancel().failure();
    }

    protected WsByteBuffer[] loadErrorBody(HttpError error, HttpRequestMessage request, HttpResponseMessage response) {
        HttpErrorPageProvider provider;
        WsByteBuffer[] body = error.getErrorBody();
        if (null != body) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HttpError returned body of length=" + body.length);
            }
            this.getVC().getStateMap().put(EPS_KEY, body);
            return body;
        }
        HttpErrorPageService eps = (HttpErrorPageService)this.getHttpConfig().getCHFW().lookupService(HttpErrorPageService.class);
        if (null == eps) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Querying service for port=" + this.getLocalPort());
        }
        if (null != (provider = eps.access(this.getLocalPort()))) {
            block10: {
                String host = this.getLocalAddr().getHostName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Querying provider for host=" + host);
                }
                try {
                    body = provider.accessPage(host, this.getLocalPort(), request, response);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.getClass().getName() + ".loadErrorBody", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception while calling into provider, t=" + t);
                }
            }
            if (null != body) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received body of length=" + body.length);
                }
                this.getVC().getStateMap().put(EPS_KEY, body);
            }
        }
        return body;
    }

    public final InetAddress getRemoteAddr() {
        return this.myRemoteAddr;
    }

    public final void setRemoteAddr(InetAddress addr) {
        this.myRemoteAddr = addr;
    }

    public final InetAddress getLocalAddr() {
        return this.myLocalAddr;
    }

    public final void setLocalAddr(InetAddress addr) {
        this.myLocalAddr = addr;
    }

    public final int getRemotePort() {
        return this.myRemotePort;
    }

    public final void setRemotePort(int port2) {
        this.myRemotePort = port2;
    }

    public final int getLocalPort() {
        return this.myLocalPort;
    }

    public final void setLocalPort(int port2) {
        this.myLocalPort = port2;
    }

    public WsByteBuffer returnLastBuffer() {
        WsByteBuffer buffer = this.allocatedBuffers.removeLast();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning " + buffer);
        }
        return buffer;
    }

    protected void setLastHeaderBuffer() {
        this.lastHeaderBuffer = this.allocatedBuffers.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Last header buffer: " + this.lastHeaderBuffer);
        }
    }

    protected boolean lastBufferContainsHeaders() {
        return -1 == this.lastHeaderBuffer || this.allocatedBuffers.size() <= this.lastHeaderBuffer;
    }

    public void storeAllocatedBuffer(WsByteBuffer buffer) {
        this.allocatedBuffers.add(buffer);
    }

    public void storeAllocatedBuffers(WsByteBuffer[] list) {
        for (int i = 0; i < list.length; ++i) {
            this.allocatedBuffers.add(list[i]);
        }
    }
}

