/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ws.timeutils.QuickApproxTime;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HttpLocalFormat {
    protected static final long DEFAULT_TOLERANCE = 1000L;
    protected static final TimeZone gmt = TimeZone.getTimeZone("GMT");
    private CachedTime c1123Time = new CachedTime("EEE, dd MMM yyyy HH:mm:ss z", true);
    private CachedTime c1036Time = new CachedTime("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", true);
    private CachedTime cAsciiTime = new CachedTime("EEE MMM  d HH:mm:ss yyyy", true);
    private CachedTime cNCSATime = new CachedTime("dd/MMM/yyyy:HH:mm:ss Z", false);
    private CachedTime c2109Time = new CachedTime("EEE, dd-MMM-yy HH:mm:ss z", true);

    public byte[] get1123TimeAsBytes(long range) {
        return this.c1123Time.getTimeAsBytes(range);
    }

    public String get1123TimeAsString(long range) {
        return this.c1123Time.getTimeAsString(range);
    }

    public byte[] get1036TimeAsBytes(long range) {
        return this.c1036Time.getTimeAsBytes(range);
    }

    public String get1036TimeAsString(long range) {
        return this.c1036Time.getTimeAsString(range);
    }

    public byte[] getAsciiTimeAsBytes(long range) {
        return this.cAsciiTime.getTimeAsBytes(range);
    }

    public String getAsciiTimeAsString(long range) {
        return this.cAsciiTime.getTimeAsString(range);
    }

    public byte[] getNCSATimeAsBytes(long range) {
        return this.cNCSATime.getTimeAsBytes(range);
    }

    public String getNCSATimeAsString(long range) {
        return this.cNCSATime.getTimeAsString(range);
    }

    public byte[] get2109TimeAsBytes(long range) {
        return this.c2109Time.getTimeAsBytes(range);
    }

    public String get2109TimeAsString(long range) {
        return this.c2109Time.getTimeAsString(range);
    }

    public SimpleDateFormat get1123Format() {
        return this.c1123Time.getFormat();
    }

    public SimpleDateFormat get1036Format() {
        return this.c1036Time.getFormat();
    }

    public SimpleDateFormat getAsciiFormat() {
        return this.cAsciiTime.getFormat();
    }

    public SimpleDateFormat getNCSAFormat() {
        return this.cNCSATime.getFormat();
    }

    public SimpleDateFormat get2109Format() {
        return this.c2109Time.getFormat();
    }

    public SimpleDateFormat get1123Parse() {
        return this.c1123Time.getParse();
    }

    public SimpleDateFormat get1036Parse() {
        return this.c1036Time.getParse();
    }

    public SimpleDateFormat getAsciiParse() {
        return this.cAsciiTime.getParse();
    }

    public SimpleDateFormat getNCSAParse() {
        return this.cNCSATime.getParse();
    }

    public SimpleDateFormat get2109Parse() {
        return this.c2109Time.getParse();
    }

    private class CachedTime {
        private SimpleDateFormat myFormat = null;
        private SimpleDateFormat myParse = null;
        private long lastTimeCheck = 0L;
        private String sTime = null;
        private byte[] baTime = new byte[0];
        private char[] caTime = new char[0];
        private Date myDate = new Date();
        private StringBuffer myBuffer = new StringBuffer(33);

        protected CachedTime(String format, Boolean notNCSATime) {
            this.myFormat = new SimpleDateFormat(format, Locale.US);
            this.myParse = new SimpleDateFormat(format, Locale.US);
            if (notNCSATime.booleanValue()) {
                this.myFormat.setTimeZone(gmt);
                this.myParse.setTimeZone(gmt);
            }
        }

        protected SimpleDateFormat getFormat() {
            return this.myFormat;
        }

        protected SimpleDateFormat getParse() {
            return this.myParse;
        }

        private void updateTime(long tolerance) {
            long now = QuickApproxTime.getRef().getApproxTime();
            if (now == this.lastTimeCheck) {
                return;
            }
            if (0L != tolerance) {
                long range;
                long l = range = -1L == tolerance ? 1000L : tolerance;
                if (now - this.lastTimeCheck <= range) {
                    return;
                }
            }
            this.myDate.setTime(now);
            this.myBuffer.setLength(0);
            this.myBuffer = this.myFormat.format(this.myDate, this.myBuffer, new FieldPosition(0));
            int len = this.myBuffer.length();
            if (this.caTime.length != len) {
                this.caTime = new char[len];
                this.baTime = new byte[len];
            }
            this.myBuffer.getChars(0, len, this.caTime, 0);
            for (int i = 0; i < len; ++i) {
                this.baTime[i] = (byte)this.caTime[i];
            }
            this.sTime = null;
            this.lastTimeCheck = now;
        }

        protected byte[] getTimeAsBytes(long tolerance) {
            this.updateTime(tolerance);
            return this.baTime;
        }

        protected String getTimeAsString(long tolerance) {
            this.updateTime(tolerance);
            if (null == this.sTime) {
                this.sTime = new String(this.caTime, 0, this.caTime.length);
            }
            return this.sTime;
        }
    }
}

