/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.cookies.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.ws.http.channel.values.impl.CookieData;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieHeaderByteParser {
    private static final TraceComponent tc = Tr.register(CookieHeaderByteParser.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private int bytePosition = 0;
    private byte[] name;
    private byte[] value;

    public List<Cookie> parse(byte[] headerValue, HeaderKeys cookieHeader) throws IllegalArgumentException {
        if (null == headerValue) {
            throw new IllegalArgumentException("Null input");
        }
        this.name = null;
        this.value = null;
        this.bytePosition = 0;
        CookieData token = null;
        Cookie cookie = null;
        LinkedList<Cookie> cookiesList = new LinkedList<Cookie>();
        int version = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parse [" + GenericUtils.getEnglishString(headerValue) + "] " + cookieHeader);
        }
        while (this.bytePosition < headerValue.length) {
            token = this.matchAndParse(headerValue, cookieHeader);
            this.parseValue(headerValue, token);
            if (null == token) {
                if (null != this.name && 0 != this.name.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating cookie, version " + version);
                    }
                    try {
                        cookie = new Cookie(GenericUtils.getEnglishString(this.name), GenericUtils.getEnglishString(this.value));
                    }
                    catch (IllegalArgumentException iae) {
                        this.name = null;
                        this.value = null;
                        continue;
                    }
                    cookie.setVersion(version);
                    cookiesList.add(cookie);
                }
            } else if (null != this.value) {
                if (CookieData.cookieVersion.equals(token)) {
                    try {
                        version = GenericUtils.asIntValue(this.value);
                        if (null != cookie) {
                            cookie.setVersion(version);
                        }
                    }
                    catch (NumberFormatException ne) {
                        FFDCFilter.processException(ne, this.getClass().getName() + ".parse", "166");
                        version = 0;
                    }
                } else if (null != cookie) {
                    token.set(cookie, this.value);
                }
            }
            token = null;
            this.name = null;
            this.value = null;
        }
        return cookiesList;
    }

    private CookieData matchAndParse(byte[] data, HeaderKeys hdr) {
        boolean foundDollar;
        byte b;
        int pos;
        int start = -1;
        int stop = -1;
        for (pos = this.bytePosition; pos < data.length && 61 != (b = data[pos]); ++pos) {
            if (59 == b || 44 == b) {
                if (-1 == start) continue;
                --pos;
                break;
            }
            if (32 == b || 9 == b) continue;
            if (-1 == start) {
                start = pos;
            }
            stop = pos;
        }
        this.bytePosition = pos + 1;
        if (-1 == start) {
            return null;
        }
        if (-1 == stop) {
            stop = pos;
        } else if (data.length == stop) {
            --stop;
        }
        boolean bl = foundDollar = 36 == data[start];
        if (foundDollar) {
            ++start;
        } else if (34 == data[start] && 34 == data[stop]) {
            ++start;
            --stop;
        }
        int len = stop - start + 1;
        if (0 >= len) {
            return null;
        }
        CookieData token = CookieData.match(data, start, len);
        if (null != token && null != hdr && !token.validForHeader(hdr, foundDollar)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Token not valid for header, " + hdr + " " + token);
            }
            token = null;
        }
        if (null == token) {
            this.name = new byte[len];
            System.arraycopy(data, start, this.name, 0, len);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + GenericUtils.getEnglishString(this.name));
            }
        }
        return token;
    }

    private void parseValue(byte[] data, CookieData token) {
        int len;
        byte b;
        int pos;
        int start = -1;
        int stop = -1;
        int num_quotes = 0;
        for (pos = this.bytePosition; pos < data.length && 59 != (b = data[pos]); ++pos) {
            if (34 == b) {
                ++num_quotes;
            }
            if (44 == b && (!CookieData.cookiePort.equals(token) ? !CookieData.cookieExpires.equals(token) : 2 <= num_quotes)) break;
            if (32 == b || 9 == b) continue;
            if (-1 == start) {
                start = pos;
            }
            stop = pos;
        }
        this.bytePosition = pos + 1;
        if (-1 == start) {
            this.value = new byte[0];
            return;
        }
        if (-1 == stop) {
            this.value = new byte[0];
            return;
        }
        if (34 == data[start] && 34 == data[stop]) {
            ++start;
            --stop;
        }
        if (0 <= (len = stop - start + 1)) {
            this.value = new byte[len];
            if (0 < len) {
                System.arraycopy(data, start, this.value, 0, len);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "value: " + GenericUtils.getEnglishString(this.value));
                }
            }
        }
    }

    public String getFFDCDumpData() {
        StringBuilder ffdcDump = new StringBuilder();
        ffdcDump.append("Exception thrown while parsing the following name:value combination ");
        HTTPChannelDM.formatFFDCString(" name", GenericUtils.getEnglishString(this.name), ffdcDump);
        HTTPChannelDM.formatFFDCString(" value", GenericUtils.getEnglishString(this.value), ffdcDump);
        return ffdcDump.toString();
    }
}

