/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BinaryHeaderNode;
import com.ibm.wsspi.genericbnf.GenericKeys;

public abstract class QuickGenericMatcher {
    private static final TraceComponent tc = Tr.register(QuickGenericMatcher.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    protected static final byte UPPER_BYTE_A = 65;
    protected static final byte UPPER_BYTE_Z = 90;
    protected static final byte LOWER_BYTE_A = 97;
    protected static final byte LOWER_BYTE_Z = 122;
    protected static final int OFFSET = 32;

    public boolean add(GenericKeys key) {
        BinaryHeaderNode node = this.getNode(key);
        if (null == node) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error, key " + key + " is invalid");
            }
            return false;
        }
        return node.add(key);
    }

    public boolean add(String key, Object value2) {
        BinaryHeaderNode node = this.getNode(key);
        if (null == node) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error, key " + key + " is invalid");
            }
            return false;
        }
        return node.add(key, value2);
    }

    public abstract BinaryHeaderNode getNode(GenericKeys var1);

    public abstract BinaryHeaderNode getNode(String var1);

    public abstract void init();

    public Object match(char[] input) {
        return this.match(input, 0, input.length);
    }

    public abstract Object match(char[] var1, int var2, int var3);

    public Object match(String input) {
        return this.match(input.toCharArray());
    }

    public Object match(StringBuffer input) {
        char[] temp = new char[input.length()];
        input.getChars(0, input.length(), temp, 0);
        return this.match(temp);
    }

    public Object match(byte[] input) {
        return this.match(input, 0, input.length);
    }

    public abstract Object match(byte[] var1, int var2, int var3);

    protected static boolean isUpper(byte input) {
        return input >= 65 && input <= 90;
    }

    protected static boolean isUpper(char input) {
        return input >= 'A' && input <= 'Z';
    }

    protected static boolean isLower(byte input) {
        return input >= 97 && input <= 122;
    }

    protected static boolean isLower(char input) {
        return input >= 'a' && input <= 'z';
    }

    protected static boolean isUpper(int input) {
        return input >= 65 && input <= 90;
    }

    protected static boolean isLower(int input) {
        return input >= 97 && input <= 122;
    }

    protected static byte normalizeToLower(byte b) {
        return QuickGenericMatcher.isUpper(b) ? (byte)(b + 32) : b;
    }

    protected static int normalizeToLower(int i) {
        return QuickGenericMatcher.isUpper(i) ? i + 32 : i;
    }

    protected static int normalizeToUpper(int i) {
        return QuickGenericMatcher.isUpper(i) ? i - 32 : i;
    }

    protected static char normalizeToLower(char c) {
        return QuickGenericMatcher.isUpper(c) ? (char)(c + 32) : c;
    }
}

