/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.models.config.ipc.ssl.WSNotification;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class WSNotifier {
    private static final TraceComponent tc = Tr.register(WSNotifier.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String name = null;
    boolean logToSystemOut = false;
    boolean sendEmail = false;
    String emailList = null;

    public WSNotifier(WSNotification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSNotifier");
        }
        this.name = notification.getName();
        this.logToSystemOut = notification.isLogToSystemOut();
        this.sendEmail = notification.isSendEmail();
        this.emailList = notification.getEmailList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSNotifier", new Object[]{this.toString()});
        }
    }

    public void notify(String notificationText) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notify", notificationText);
        }
        if (this.logToSystemOut) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Logging to message log.");
            }
            Tr.info(tc, "ssl.notification.send.info.CWPKI0037I", new Object[]{notificationText});
        }
        if (this.sendEmail) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending email(s).");
            }
            this.sendMail(notificationText);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notify");
        }
    }

    public void sendMail(String notificationText) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMail");
        }
        String smtpServer = null;
        String emailAddress = null;
        String[] emailListEntries = this.emailList.split("\\|");
        for (int j = 0; j < emailListEntries.length; ++j) {
            String emailEntry = emailListEntries[j].trim();
            int index = emailEntry.indexOf("(");
            if (index == -1) {
                emailAddress = emailEntry;
                index = emailEntry.indexOf("@");
                if (index != -1) {
                    smtpServer = "smtp-server." + emailEntry.substring(index + 1);
                }
            } else {
                smtpServer = emailEntry.substring(index + 1, emailEntry.length() - 1);
                emailAddress = emailEntry.substring(0, index);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending email to " + emailAddress + " at smtp server " + smtpServer + ".");
            }
            this.send(emailAddress, smtpServer, notificationText);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendMail");
        }
    }

    public void send(String emailAddress, String smtpServer, String notificationText) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send");
        }
        try {
            Properties props = new Properties();
            props.setProperty("mail.transport.protocol", "smtp");
            props.setProperty("mail.host", smtpServer);
            props.setProperty("mail.user", emailAddress);
            props.setProperty("mail.password", "");
            Session mailSession = Session.getDefaultInstance(props, null);
            MimeMessage message = new MimeMessage(mailSession);
            message.setFrom(new InternetAddress("WebSphereNotification@ibm.com"));
            String textEncoding = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.crypto.config.certexp.notify.textEncoding");
            String fromAddress = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.crypto.config.certexp.notify.fromAddress");
            if (fromAddress != null && fromAddress.length() != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fromAddress:" + fromAddress + " has been specified. Updating the fromAddress");
                }
                message.setFrom(new InternetAddress(fromAddress));
            } else {
                message.setFrom(new InternetAddress("WebSphereNotification@ibm.com"));
            }
            if (textEncoding != null && textEncoding.length() != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "textEncoding :" + textEncoding + " has been specified. Updating the textEncoding.");
                }
                message.setText(notificationText, textEncoding);
            } else {
                message.setContent(notificationText, "text/plain");
            }
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(emailAddress));
            message.setSubject("WebSphere Notification from process: " + ManagementScopeManager.getInstance().getProcessScopeName());
            Transport transport2 = mailSession.getTransport();
            transport2.connect();
            transport2.sendMessage(message, message.getRecipients(Message.RecipientType.TO));
            transport2.close();
        }
        catch (Exception e) {
            Tr.error(tc, "ssl.notification.send.error.CWPKI0036E", new Object[]{emailAddress, smtpServer, e.getMessage()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception sending email to user.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSNotifier.send", "156", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("WSNotifier.toString() {\n");
        buf.append("name = ");
        buf.append(this.name);
        buf.append("\n");
        buf.append("logToSystemOut = ");
        buf.append(this.logToSystemOut);
        buf.append("\n");
        buf.append("sendEmail = ");
        buf.append(this.sendEmail);
        buf.append("\n");
        buf.append("emailList = ");
        buf.append(this.emailList);
        buf.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return buf.toString();
    }
}

