/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.crypto.KeyPairGenerator;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.crypto.spec.SecretKeySpec;

public class WSKeyPairReference
extends KeyReference {
    private static final TraceComponent tc = Tr.register(WSKeyPairReference.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private KeyPair keyPair = null;
    private KeyPairGenerator keyPairGenerationClassImpl = null;
    private String keyGenerationClass = null;
    private WSKeySet wsKeySet = null;

    public WSKeyPairReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference kref, WSKeySet keySet, WSKeyStore ks) {
        super(kref, keySet, ks);
        this.keyGenerationClass = keySet.getKeyGenerationClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyPairReference");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyPairReference", new Object[]{this.toString()});
        }
    }

    public WSKeyPairReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference kref, KeyPair pair, WSKeySet keySet, WSKeyStore ks) throws KeyException {
        super(kref, keySet, ks);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyPairReference (with keyPair)");
        }
        try {
            this.keyGenerationClass = keySet.getKeyGenerationClass();
            KeyStore jkstore = ks.getKeyStore(false, false);
            this.importKeyPair(pair, jkstore);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSKeyPairReference import key initialization failed.", new Object[]{e});
            }
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyPairReference (with keyPair)", new Object[]{this.toString()});
        }
    }

    public WSKeyPairReference(SecurityConfigObject kref, WSKeySet keySet, WSKeyStore ks) {
        super(kref, keySet, ks);
        this.keyGenerationClass = keySet.getKeyGenerationClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyPairReference");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyPairReference", new Object[]{this.toString()});
        }
    }

    public WSKeyPairReference(SecurityConfigObject kref, KeyPair pair, WSKeySet keySet, WSKeyStore ks) throws KeyException {
        super(kref, keySet, ks);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyPairReference (with keyPair)");
        }
        try {
            this.keyGenerationClass = keySet.getKeyGenerationClass();
            KeyStore jkstore = ks.getKeyStore(false, false);
            this.importKeyPair(pair, jkstore);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSKeyPairReference import key initialization failed.", new Object[]{e});
            }
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyPairReference (with keyPair)", new Object[]{this.toString()});
        }
    }

    public KeyPair getKeyPair() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyPair");
        }
        if (this.keyPair == null) {
            try {
                KeyStore jkstore = null;
                String name2 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreName");
                String type = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
                String provider = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreProvider");
                String location = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                String kspassword = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                String scope = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreScope");
                jkstore = KeyStoreManager.getInstance().getKeyStore(name2, type, provider, location, kspassword, scope, true, null);
                if (jkstore != null) {
                    boolean isSecretKey = false;
                    String alias = this.getKeyAlias();
                    String password = this.getPassword();
                    Key privateKey = jkstore.getKey(alias, password.toCharArray());
                    Certificate[] chain = jkstore.getCertificateChain(alias);
                    if (chain != null && privateKey != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating a KeyPair from Certificate Chain and privateKey retrieved from KeyStore.");
                        }
                        this.keyPair = new KeyPair(chain, (Key)((PrivateKey)privateKey));
                    } else {
                        String privateKeyAlias = alias + "_private";
                        Key privateKeyAsSecret = jkstore.getKey(privateKeyAlias, password.toCharArray());
                        String publicKeyAlias = alias + "_public";
                        Key publicKeyAsSecret = jkstore.getKey(publicKeyAlias, password.toCharArray());
                        if (privateKeyAsSecret != null && publicKeyAsSecret != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating a KeyPair from publicKey and privateKey retrieved from KeyStore.");
                            }
                            this.keyPair = new KeyPair(publicKeyAsSecret, privateKeyAsSecret);
                            isSecretKey = true;
                        }
                    }
                    if (this.keyPair == null && this.isValidKeyStoreType(isSecretKey)) {
                        this.keyPair = this.initializeReferenceIfNotInKeyStore(jkstore);
                    }
                }
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception getting KeyPair from KeyStore.", new Object[]{e});
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeyPairReference.getKeyPair", "200", this);
                Tr.error(tc, "crypto.key.getkey.error.CWPKI0201E", new Object[]{this.getKeySetName(), this.getKeyAlias(), e.getMessage()});
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyPair");
        }
        return this.keyPair;
    }

    public KeyPair initializeReferenceIfNotInKeyStore(KeyStore jkstore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeReferenceIfNotInKeyStore");
        }
        FileOutputStream fos = null;
        try {
            if (jkstore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore type is \"" + jkstore.getType() + "\" and the provider is \"" + jkstore.getProvider() + "\".");
            }
            if (this.keyGenerationClass == null || this.keyGenerationClass.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys as auto-generation class is not specified.");
                }
                throw new KeyException("KeyPair is not present and keyGenerationClass is null.");
            }
            KeyPairGenerator keyGen = (KeyPairGenerator)this.getKeyPairGeneratorImpl();
            KeyPair pair = keyGen.generateKeyPair();
            if (pair != null) {
                String alias = this.getKeyAlias();
                String password = this.getPassword();
                Key privateKey = pair.getPrivateKey();
                Key publicKey = pair.getPublicKey();
                Certificate[] certChain = pair.getCertificateChain();
                if (certChain != null && privateKey != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting public/private key using alias: " + alias);
                    }
                    jkstore.setKeyEntry(alias, privateKey, password.toCharArray(), certChain);
                } else if (privateKey != null && publicKey != null) {
                    String privateKeyAlias = alias + "_private";
                    SecretKeySpec privateKeyAsSecretKey = new SecretKeySpec(privateKey.getEncoded(), privateKey.getAlgorithm());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting private key (as secret) using alias: " + privateKeyAlias);
                    }
                    jkstore.setKeyEntry(privateKeyAlias, privateKeyAsSecretKey, password.toCharArray(), null);
                    String publicKeyAlias = alias + "_public";
                    SecretKeySpec publicKeyAsSecretKey = new SecretKeySpec(publicKey.getEncoded(), publicKey.getAlgorithm());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting public key (as secret) using alias: " + publicKeyAlias);
                    }
                    jkstore.setKeyEntry(publicKeyAlias, publicKeyAsSecretKey, password.toCharArray(), null);
                    this.keyPair = new KeyPair(publicKeyAsSecretKey, (Key)privateKeyAsSecretKey);
                }
                String keyStoreLocation = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                String keyStorePassword = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                fos = new FileOutputStream(keyStoreLocation);
                jkstore.store(fos, keyStorePassword.toCharArray());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeReferenceIfNotInKeyStore (generated)");
                }
                KeyPair keyPair = this.keyPair;
                return keyPair;
            }
            try {
                throw new KeyException("KeyPairGenerator " + this.keyGenerationClass + " did not return a KeyPair.");
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception generating Key.", new Object[]{e});
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeySet.generate", "294", this);
                Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), e.getMessage()});
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), e.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + e.getMessage()));
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void importKeyPair(KeyPair pair, KeyStore jkstore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importKeyPair");
        }
        FileOutputStream fos = null;
        try {
            if (jkstore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot update keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore type is \"" + jkstore.getType() + "\" and the provider is \"" + jkstore.getProvider() + "\".");
            }
            if (pair == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot updates keys as the KeyPair is not specified.");
                }
                throw new KeyException("KeyPair was not passed in.");
            }
            String alias = this.getKeyAlias();
            String password = this.getPassword();
            Key privateKey = pair.getPrivateKey();
            Key publicKey = pair.getPublicKey();
            Certificate[] certChain = pair.getCertificateChain();
            if (certChain != null && privateKey != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting public/private key using alias: " + alias);
                }
                jkstore.setKeyEntry(alias, privateKey, password.toCharArray(), certChain);
            } else if (privateKey != null && publicKey != null) {
                String privateKeyAlias = alias + "_private";
                SecretKeySpec privateKeyAsSecretKey = new SecretKeySpec(privateKey.getEncoded(), privateKey.getAlgorithm());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting private key (as secret) using alias: " + privateKeyAlias);
                }
                jkstore.setKeyEntry(privateKeyAlias, privateKeyAsSecretKey, password.toCharArray(), null);
                String publicKeyAlias = alias + "_public";
                SecretKeySpec publicKeyAsSecretKey = new SecretKeySpec(publicKey.getEncoded(), publicKey.getAlgorithm());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting public key (as secret) using alias: " + publicKeyAlias);
                }
                jkstore.setKeyEntry(publicKeyAlias, publicKeyAsSecretKey, password.toCharArray(), null);
            }
            String keyStoreLocation = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
            String keyStorePassword = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
            fos = new FileOutputStream(keyStoreLocation);
            jkstore.store(fos, keyStorePassword.toCharArray());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importKeyPair (imported)");
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception updating KeyStore with keys.", new Object[]{e});
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeyPairReference.importKeyPair", "382", this);
            Tr.error(tc, "crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), e.getMessage()});
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), e.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + e.getMessage()));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private Object getKeyPairGeneratorImpl() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyGeneratorImpl");
        }
        if (this.keyPairGenerationClassImpl == null) {
            if (this.keyGenerationClass != null && !this.keyGenerationClass.equals("")) {
                Object wrapperObj;
                block11: {
                    wrapperObj = null;
                    try {
                        Class<?> wrapperClass = Class.forName(this.keyGenerationClass);
                        wrapperObj = wrapperClass.newInstance();
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Could not load using class using current class loader.");
                    }
                }
                if (wrapperObj == null) {
                    ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                    Class<?> wrapperClass = Class.forName(this.keyGenerationClass, true, contextCL);
                    wrapperObj = wrapperClass.newInstance();
                }
                if (wrapperObj != null && wrapperObj instanceof KeyPairGenerator) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Instantiating new KeyPairGenerator: " + this.keyGenerationClass);
                    }
                    this.keyPairGenerationClassImpl = wrapperObj;
                    if (this.getWSKeySet().getCustomProperties() != null) {
                        this.keyPairGenerationClassImpl.init(this.getWSKeySet().getCustomProperties());
                    }
                    return this.keyPairGenerationClassImpl;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getKeyGeneratorImpl is not an implementation of KeyPairGenerator.");
                }
                throw new KeyException("The custom key generator class " + this.keyGenerationClass + " is not an implementation of com.ibm.websphere.crypto.KeyPairGenerator.");
            }
            Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()});
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyGeneratorImpl");
        }
        return this.keyPairGenerationClassImpl;
    }

    private boolean isValidKeyStoreType(boolean isSecretKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidKeyStoreType");
        }
        if (this.getWSKeyStore() != null) {
            String readOnly = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreReadOnly");
            if (readOnly == null || readOnly.equals("")) {
                readOnly = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreReadOnly");
            }
            if (readOnly != null && readOnly.equals("true")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidKeyStoreType (readonly) -> false");
                }
                return false;
            }
            if (isSecretKey) {
                String ksType = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
                if (ksType == null || ksType.equals("")) {
                    ksType = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreType");
                }
                if (ksType != null && !ksType.equals("JCEKS")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isValidKeyStoreType (not jceks) -> false");
                    }
                    return false;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidKeyStoreType -> true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidKeyStoreType (null keystore) -> false");
        }
        return false;
    }
}

