/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class IdentityMapImpl
extends DescriptionA
implements IdentityMap {
    private static final TraceComponent tc = Tr.register(IdentityMap.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int NUMBER_DOUBLE = 5;
    private static final int NUMBER_FLOAT = 4;
    private static final int NUMBER_LONG = 3;
    private static final int NUMBER_INTEGER = 2;
    private static final int NUMBER_SHORT = 1;
    private static final int NUMBER_BYTE = 0;
    private static final int TYPE_NULL = -1;
    private static final int TYPE_NUMBER = 0;
    private static final int TYPE_STRING = 1;
    private static final int TYPE_DESCRIPTION_KEY = 2;
    private static final int TYPE_DESCRIPTION = 3;
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final Map map = Collections.synchronizedMap(new HashMap());

    public IdentityMapImpl(DescriptionKey key) {
        super(key);
    }

    public int size() {
        return ((MementoImpl)this.getMemento()).m_map.size();
    }

    public boolean isEmpty() {
        return ((MementoImpl)this.getMemento()).m_map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return ((MementoImpl)this.getMemento()).m_map.containsKey(key);
    }

    public boolean containsValue(Object value2) {
        return ((MementoImpl)this.getMemento()).m_map.containsValue(value2);
    }

    public synchronized Object get(Object key) {
        return ((MementoImpl)this.getMemento()).m_map.get(key);
    }

    public synchronized Object put(Object key, Object value2) {
        Object result = this.map.put(key, value2);
        this.updateMemento();
        return result;
    }

    public Object put(Object key, Object value2, int delay) {
        Object result = this.map.put(key, value2);
        this.updateMemento(delay);
        return result;
    }

    public synchronized Object remove(Object key) {
        Object result = this.map.remove(key);
        this.updateMemento();
        return result;
    }

    public Object remove(Object key, int delay) {
        Object result = this.map.remove(key);
        this.updateMemento(delay);
        return result;
    }

    public void putAll(Map t) {
        this.map.putAll(t);
        this.updateMemento();
    }

    public void putAll(Map t, int delay) {
        this.map.putAll(t);
        this.updateMemento(delay);
    }

    public void removeSet(Set keys) {
        for (Object key : keys) {
            this.map.remove(key);
        }
        this.updateMemento();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSet(Set keys, int delay) {
        Map map = this.map;
        synchronized (map) {
            for (Object key : keys) {
                this.map.remove(key);
            }
        }
        this.updateMemento(delay);
    }

    public void clear() {
        this.map.clear();
        this.updateMemento();
    }

    public Set keySet() {
        return ((MementoImpl)this.getMemento()).m_map.keySet();
    }

    public Collection values() {
        return ((MementoImpl)this.getMemento()).m_map.values();
    }

    public Set entrySet() {
        return ((MementoImpl)this.getMemento()).m_map.entrySet();
    }

    public Set getVersion602EntrySetForInterop() {
        return this.map.entrySet();
    }

    public String getDefinitionKey() {
        return IdentityMap.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exportToStream(DataOutput out, Format format) throws IOException {
        int size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        int version = 0;
        out.writeByte(version);
        Map map = this.map;
        synchronized (map) {
            size = this.map.size();
            out.writeInt(size);
            Iterator iterator = this.map.entrySet().iterator();
            for (int i = 0; i < size; ++i) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                this.writeOut(key, out);
                Object value2 = entry.getValue();
                this.writeOut(value2, out);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version " + version);
            Tr.debug(tc, "wrote size " + size);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeOut(Object object, DataOutput out) throws IOException {
        if (object == null) {
            out.writeByte(-1);
            return;
        }
        if (object instanceof Number) {
            out.writeByte(0);
            Number numberObject = (Number)object;
            if (numberObject instanceof Byte) {
                out.writeByte(0);
                out.writeByte(numberObject.byteValue());
                return;
            }
            if (numberObject instanceof Short) {
                out.writeByte(1);
                out.writeShort(numberObject.shortValue());
                return;
            }
            if (numberObject instanceof Integer) {
                out.writeByte(2);
                out.writeInt(numberObject.intValue());
                return;
            }
            if (numberObject instanceof Long) {
                out.writeByte(3);
                out.writeLong(numberObject.longValue());
                return;
            }
            if (numberObject instanceof Float) {
                out.writeByte(4);
                out.writeFloat(numberObject.floatValue());
                return;
            }
            if (numberObject instanceof Double) {
                out.writeByte(5);
                out.writeDouble(numberObject.doubleValue());
                return;
            }
            if (!TraceComponent.isAnyTracingEnabled()) throw new IOException("The value for " + object + " was not a correct number type. " + numberObject.getClass());
            if (!tc.isEventEnabled()) throw new IOException("The value for " + object + " was not a correct number type. " + numberObject.getClass());
            Tr.event(tc, "unexpected");
            throw new IOException("The value for " + object + " was not a correct number type. " + numberObject.getClass());
        }
        if (object instanceof CharSequence) {
            out.writeByte(1);
            out.writeUTF(object.toString());
            return;
        }
        if (object instanceof DescriptionKey) {
            out.writeByte(2);
            keyRepository.exportToStream(out, (DescriptionKey)object);
            return;
        }
        if (object instanceof Description) {
            out.writeByte(3);
            keyRepository.exportToStream(out, ((Description)object).getKey());
            return;
        }
        if (!TraceComponent.isAnyTracingEnabled()) throw new IllegalArgumentException("Object was not a supported type.\n" + object.getClass());
        if (!tc.isEventEnabled()) throw new IllegalArgumentException("Object was not a supported type.\n" + object.getClass());
        Tr.event(tc, "unexpected");
        throw new IllegalArgumentException("Object was not a supported type.\n" + object.getClass());
    }

    public synchronized Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        MementoImpl newMemento;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((newMemento = (MementoImpl)memento) == null) {
            newMemento = (MementoImpl)this.createMemento();
        }
        byte version = in.readByte();
        int size = in.readInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + version);
            Tr.debug(tc, "read size " + size);
        }
        for (int i = 0; i < size; ++i) {
            Object key = this.readIn(in);
            Object value2 = this.readIn(in);
            newMemento.m_map.put(key, value2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return newMemento;
    }

    private Object readIn(DataInput in) throws IOException {
        Object result = null;
        byte type = in.readByte();
        block1 : switch (type) {
            case -1: {
                result = null;
                break;
            }
            case 0: {
                byte number = in.readByte();
                switch (number) {
                    case 0: {
                        result = new Byte(in.readByte());
                        break block1;
                    }
                    case 1: {
                        result = new Short(in.readShort());
                        break block1;
                    }
                    case 2: {
                        result = new Integer(in.readInt());
                        break block1;
                    }
                    case 3: {
                        result = new Long(in.readLong());
                        break block1;
                    }
                    case 4: {
                        result = new Float(in.readFloat());
                        break block1;
                    }
                    case 5: {
                        result = new Double(in.readDouble());
                        break block1;
                    }
                }
                result = null;
                break;
            }
            case 1: {
                result = in.readUTF();
                break;
            }
            case 2: {
                result = keyRepository.importFromStream(in);
                break;
            }
            case 3: {
                DescriptionKey descKey = keyRepository.importFromStream(in);
                String definitionKey = in.readUTF();
                try {
                    result = descMgr.getDescription(descKey, definitionKey);
                    break;
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, IdentityMapImpl.class.getName() + ".readIn", "438", this, new Object[]{descKey, definitionKey});
                    IOException ioe = new IOException("Unable to fluff up description.  Exception logged to ffdc.");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setMemento(Description.Memento memento) {
        MementoImpl currentMemento = (MementoImpl)this.getMemento();
        super.setMemento(memento);
        for (Map.Entry entry : currentMemento.m_map.entrySet()) {
            if (((MementoImpl)memento).m_map.containsKey(entry.getKey())) continue;
            this.notifyListeners("type.key.removed", entry.getKey());
        }
        for (Map.Entry entry : ((MementoImpl)memento).m_map.entrySet()) {
            if (!currentMemento.m_map.containsKey(entry.getKey())) {
                this.notifyListeners("type.key.added", entry.getKey());
                continue;
            }
            Object incoming = ((MementoImpl)memento).m_map.get(entry.getKey());
            Object current = currentMemento.m_map.get(entry.getKey());
            if (incoming == null && current != null) {
                this.notifyListeners("type.value.modified", entry.getKey());
                continue;
            }
            if (incoming != null && current == null) {
                this.notifyListeners("type.value.modified", entry.getKey());
                continue;
            }
            if (incoming == null || incoming.equals(current)) continue;
            this.notifyListeners("type.value.modified", entry.getKey());
        }
    }

    public String toString() {
        return new StringBuffer(super.toString()).append(this.map == null ? null : this.map.toString()).toString();
    }

    public final class MementoImpl
    extends DescriptionA.MementoA {
        private final Map m_map = new HashMap();

        public String toString() {
            return new StringBuffer(super.toString()).append(this.m_map).toString();
        }
    }
}

