/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ConcernImpl
implements Concern {
    private static final TraceComponent tc = Tr.register(ConcernImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = 7888542107438194487L;
    private int interest = Integer.MAX_VALUE;

    public ConcernImpl() {
    }

    public ConcernImpl(int interest) {
        this.interest = interest;
    }

    public int getInterest() {
        return this.interest;
    }

    public boolean hasInterest(int mask) {
        return (mask & this.interest) != 0;
    }

    public void addInterest(int mask) {
        this.interest |= mask;
    }

    public void removeInterest(int mask) {
        this.interest ^= mask;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this.interest);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.interest = in.readInt();
    }

    public boolean equals(Object arg0) {
        try {
            return this.interest == ((Concern)arg0).getInterest();
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.interest;
    }

    public String toString() {
        return ConcernImpl.class.getName() + "[" + String.valueOf(this.interest) + "]";
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.3 ");
        }
    }
}

