/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.security.util.AccessController;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassLoaderDump {
    private static boolean showClassesEnabled = false;
    private static final Class thisClass = ClassLoaderDump.class;
    static TraceComponent tc;
    private static final Permission classLoaderInfoPermission;
    private static Map classLoaderMapToModules;
    private static Map classLoaderMapToApplications;

    private static native ArrayList getClassLoaderClasses(ClassLoader var0);

    public static native void setDebug(int var0);

    public static String getClassLoaderInfo(ClassLoader in_cl, int in_level, boolean atDepthOnly, boolean showClasses, boolean showCodeSource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolea,boolean)");
        }
        String classLoaderInfo = ClassLoaderDump.getClassLoaderInfo(in_cl, in_level, atDepthOnly, showClasses, showCodeSource, true, false, false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolean,boolean)");
        }
        return classLoaderInfo;
    }

    public static String getClassLoaderInfo(final ClassLoader in_cl, final int in_level, final boolean atDepthOnly, final boolean showClasses, final boolean showCodeSource, final boolean showDelegation, final boolean showHierarchy, final boolean showModules, final boolean showDepth) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolea,boolean,boolean,boolean,boolean)");
        }
        ClassLoaderDump.checkPermission();
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int level = in_level;
                ClassLoader cl = in_cl;
                ArrayList classloaders = new ArrayList();
                ClassLoaderDump.buildHierarchy(cl, classloaders, showDelegation);
                if (level >= classloaders.size()) {
                    level = classloaders.size() - 1;
                }
                if (level < 0) {
                    level = 0;
                }
                StringBuffer sb = new StringBuffer(8192);
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                sb.append("<classloaderinfo>\n");
                sb.append(" <singleServerClassLoader>").append(ClassLoaderManager.getSingleServerClassLoader()).append("</singleServerClassLoader>\n");
                int start = 0;
                if (atDepthOnly) {
                    start = level;
                }
                ClassLoaderDump.getClassLoaderInfo(sb, classloaders, level, start, showClasses, showCodeSource, showHierarchy, showModules, showDepth);
                sb.append("</classloaderinfo>\n");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolea,boolean,boolean,boolean,boolean)");
                }
                return sb.toString();
            }
        });
    }

    public static int getClassLoaderDepth(final ClassLoader cl) {
        ClassLoaderDump.checkPermission();
        Integer i = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList classloaders = new ArrayList();
                ClassLoaderDump.buildHierarchy(cl, classloaders, false);
                return new Integer(classloaders.size());
            }
        });
        return i;
    }

    protected static void checkPermission() {
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            securitymanager.checkPermission(classLoaderInfoPermission);
        }
    }

    protected static void buildHierarchy(ClassLoader cl, ArrayList classLoaders, boolean showDelegation) {
        boolean delegates = ClassLoaderDump.getDelegation(cl);
        ClassLoader parent = cl.getParent();
        if (parent == null) {
            classLoaders.add(cl);
        } else if (!delegates && showDelegation) {
            classLoaders.add(cl);
            ClassLoaderDump.buildHierarchy(parent, classLoaders, showDelegation);
        } else {
            ClassLoaderDump.buildHierarchy(parent, classLoaders, showDelegation);
            classLoaders.add(cl);
        }
    }

    protected static boolean getDelegation(ClassLoader cl) {
        boolean delegate = true;
        if (cl instanceof ReloadableClassLoader) {
            cl = ((ReloadableClassLoader)cl).getCurrentClassLoader();
        }
        if (cl instanceof CompoundClassLoader) {
            try {
                Field fDelegate = CompoundClassLoader.class.getDeclaredField("delegate");
                fDelegate.setAccessible(true);
                delegate = fDelegate.getBoolean(cl);
                fDelegate.setAccessible(false);
            }
            catch (Throwable t) {
                Manager.Ffdc.log(t, thisClass, "com.ibm.ws.classloader.ClassLoaderDump.getDelegation", "97");
            }
        }
        return delegate;
    }

    protected static void getClassLoaderInfo(StringBuffer sb, ArrayList classloaders, int endCL, int currentCL, boolean showClasses, boolean showCodeSource, boolean showHierarchy, boolean showModules, boolean showDepth) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoderInfo(StringBuffer,ArrayList,int,int,boolean,boolean,boolean,boolean)");
        }
        ClassLoader cl = (ClassLoader)classloaders.get(currentCL);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Classloader = " + cl);
            ClassLoaderDump.setDebug(1);
        }
        sb.append(" <classloader>\n");
        sb.append("   <implementation-class>");
        sb.append(cl.getClass().getName());
        sb.append("</implementation-class>\n");
        if (showDepth) {
            sb.append("   <depth>").append(currentCL).append("</depth>\n");
        }
        if (showModules) {
            ClassLoaderDump.processApplications(cl, sb);
            ClassLoaderDump.processModules(cl, sb);
        }
        if (cl instanceof CompoundClassLoader) {
            CompoundClassLoader cl2 = (CompoundClassLoader)cl;
            CompoundClassLoader[] sharedLibClassLoaders = cl2.getLibraryClassLoaders();
            if (sharedLibClassLoaders.length > 0) {
                ClassLoaderDump.processSharedLibraryClassLoaders(sb, currentCL, showClasses, showCodeSource, showDepth, cl, sharedLibClassLoaders);
            }
            ClassLoaderDump.processCompoundClassLoader(cl, sb);
        } else if (cl instanceof ReloadableClassLoader) {
            ClassLoaderDump.processReloadableClassLoader(cl, sb);
            cl = ((ReloadableClassLoader)cl).getCurrentClassLoader();
        } else if (cl instanceof ExtClassLoader) {
            ClassLoaderDump.processExtClassLoader(cl, sb);
        } else if (cl instanceof URLClassLoader) {
            ClassLoaderDump.processURLClassLoader(cl, sb);
        }
        if (showClasses && showClassesEnabled) {
            ClassLoaderDump.processShowClasses(sb, showCodeSource, cl);
        }
        if (endCL - currentCL > 0) {
            if (!showHierarchy) {
                sb.append(" </classloader>\n");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClassLoderInfo(StringBuffer,ArrayList,int,int,boolean,boolean,boolean,boolean) 2");
            }
            ClassLoaderDump.getClassLoaderInfo(sb, classloaders, endCL, currentCL + 1, showClasses, showCodeSource, showHierarchy, showModules, showDepth);
        } else if (!showHierarchy) {
            sb.append(" </classloader>\n");
        }
        if (showHierarchy) {
            sb.append(" </classloader>\n");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClassLoaderDump:getClassLoderInfo(StringBuffer,ArrayList,int,int,boolean,boolean,boolean,boolean)");
        }
    }

    private static void processSharedLibraryClassLoaders(StringBuffer sb, int currentCL, boolean showClasses, boolean showCodeSource, boolean showDepth, ClassLoader cl, CompoundClassLoader[] sharedLibClassLoaders) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClassLoaderDump:processSharedLibraryClassLoaders(StringBuffer,...)");
        }
        int l = sb.lastIndexOf("<classloader>");
        sb.delete(l, sb.length());
        int i = sharedLibClassLoaders.length;
        while (--i >= 0) {
            CompoundClassLoader compoundClassLoader = sharedLibClassLoaders[i];
            sb.append(" <classloader>\n");
            sb.append("   <implementation-class>");
            sb.append(cl.getClass().getName());
            String name2 = compoundClassLoader.toString();
            int ff = name2.indexOf(91) + 9;
            int ll = name2.indexOf(93);
            sb.append(" Shared - " + name2.substring(ff, ll));
            sb.append("</implementation-class>\n");
            if (showDepth) {
                sb.append("   <depth>").append(currentCL).append("</depth>\n");
            }
            ClassLoaderDump.processCompoundClassLoader(compoundClassLoader, sb);
            if (showClasses && showClassesEnabled) {
                ClassLoaderDump.processShowClasses(sb, showCodeSource, compoundClassLoader);
            }
            sb.append(" </classloader>\n");
        }
        sb.append(" <classloader>\n");
        sb.append("   <implementation-class>");
        sb.append(cl.getClass().getName());
        sb.append("</implementation-class>\n");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClassLoaderDump:processSharedLibraryClassLoaders(StringBuffer,...)");
        }
    }

    private static void processShowClasses(StringBuffer sb, boolean showCodeSource, ClassLoader cl) {
        try {
            ArrayList classes = ClassLoaderDump.getClassLoaderClasses(cl);
            if (classes != null) {
                int i;
                Object[] classData = new ClassData[classes.size()];
                for (i = 0; i < classData.length; ++i) {
                    CodeSource cs;
                    Class c = (Class)classes.get(i);
                    classData[i] = new ClassData();
                    ((ClassData)classData[i]).isInterface = c.isInterface();
                    ((ClassData)classData[i]).className = c.getName();
                    ((ClassData)classData[i]).codeSource = null;
                    if (!showCodeSource) continue;
                    ((ClassData)classData[i]).codeSource = "";
                    ProtectionDomain pd = c.getProtectionDomain();
                    if (pd == null || (cs = pd.getCodeSource()) == null) continue;
                    ((ClassData)classData[i]).codeSource = cs.getLocation().toString();
                }
                Arrays.sort(classData);
                for (i = 0; i < classData.length; ++i) {
                    sb.append("   <class>\n");
                    sb.append("      <name>");
                    sb.append(((ClassData)classData[i]).className);
                    sb.append("</name>\n");
                    sb.append("      <interface>");
                    sb.append(((ClassData)classData[i]).isInterface);
                    sb.append("</interface>\n");
                    if (((ClassData)classData[i]).codeSource != null) {
                        sb.append("      <code-source>");
                        sb.append(((ClassData)classData[i]).codeSource);
                        sb.append("</code-source>\n");
                    }
                    sb.append("   </class>\n");
                }
            }
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, thisClass, "com.ibm.ws.classloader.ClassLoaderDump.getClassLoaderInfo", "660");
            t.printStackTrace();
        }
    }

    protected static void processCompoundClassLoader(ClassLoader cl, StringBuffer sb) {
        ArrayList<String> localPaths = new ArrayList<String>();
        try {
            Field fProviders = CompoundClassLoader.class.getDeclaredField("providers");
            fProviders.setAccessible(true);
            Object providers = fProviders.get(cl);
            fProviders.setAccessible(false);
            int length = Array.getLength(providers);
            for (int i = 0; i < length; ++i) {
                Object fileprovider = Array.get(providers, i);
                Method mGetPath = fileprovider.getClass().getMethod("getPath", null);
                String path = (String)mGetPath.invoke(fileprovider, null);
                path = path.startsWith("/") ? "file:" + path : "file:/" + path;
                localPaths.add(path.replace('\\', '/'));
            }
            Field fDelegate = CompoundClassLoader.class.getDeclaredField("delegate");
            fDelegate.setAccessible(true);
            boolean delegate = fDelegate.getBoolean(cl);
            fDelegate.setAccessible(false);
            sb.append("   <delegation-mode>");
            sb.append(delegate);
            sb.append("</delegation-mode>\n");
            for (int i = 0; i < localPaths.size(); ++i) {
                sb.append("   <path>");
                sb.append((String)localPaths.get(i));
                sb.append("</path>\n");
            }
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, thisClass, "com.ibm.ws.classloader.ClassLoaderDump.processCompoundClassLoader", "232");
            t.printStackTrace();
        }
    }

    protected static void processReloadableClassLoader(ClassLoader cl, StringBuffer sb) {
        CompoundClassLoader ccl = ((ReloadableClassLoader)cl).getCurrentClassLoader();
        ClassLoaderDump.processCompoundClassLoader(ccl, sb);
    }

    protected static void processExtClassLoader(ClassLoader cl, StringBuffer sb) {
        URL[] urls = ((ExtClassLoader)cl)._getURLs();
        sb.append("   <delegation-mode>true");
        sb.append("</delegation-mode>\n");
        for (int i = 0; i < urls.length; ++i) {
            sb.append("   <path>");
            sb.append(urls[i]);
            sb.append("</path>\n");
        }
    }

    protected static void processURLClassLoader(ClassLoader cl, StringBuffer sb) {
        URL[] urls = ((URLClassLoader)cl).getURLs();
        sb.append("   <delegation-mode>true");
        sb.append("</delegation-mode>\n");
        try {
            for (int i = 0; i < urls.length; ++i) {
                sb.append("   <path>");
                sb.append(URLDecoder.decode(urls[i].toString(), "UTF-8"));
                sb.append("</path>\n");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected static void processModules(ClassLoader cl, StringBuffer sb) {
        List moduleURIs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processModules for Classloader = " + cl);
        }
        if ((moduleURIs = (List)classLoaderMapToModules.get(cl)) != null) {
            Iterator it = moduleURIs.iterator();
            while (it.hasNext()) {
                sb.append("   <module>").append((String)it.next()).append("</module>\n");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processModules - No Modules in ArrayList for " + cl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processModules");
        }
    }

    protected static void processApplications(ClassLoader cl, StringBuffer sb) {
        ArrayList applicationURIs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processApplication for Classloader = " + cl);
        }
        if ((applicationURIs = (ArrayList)classLoaderMapToApplications.get(cl)) != null) {
            Iterator it = applicationURIs.iterator();
            while (it.hasNext()) {
                sb.append("   <application>").append((String)it.next()).append("</application>\n");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processApplications - No Application in ArrayList for " + cl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processApplication");
        }
    }

    public static void addModule(String moduleName, ClassLoader cl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addModule", cl);
        }
        List<String> moduleList = null;
        while (cl != null) {
            if (classLoaderMapToModules.containsKey(cl)) {
                moduleList = (List<String>)classLoaderMapToModules.get(cl);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "moduleList Array==null for " + cl + " creating new one");
                }
                moduleList = Collections.synchronizedList(new ArrayList(20));
                classLoaderMapToModules.put(cl, moduleList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " adding module: " + moduleName + " to ClassLoader " + cl);
            }
            moduleList.add(moduleName);
            cl = cl.getParent();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addModule");
        }
    }

    public static void addApplication(String appURI, ClassLoader cl) {
        int indexOfPathSeperator = appURI.lastIndexOf(92);
        if (indexOfPathSeperator == -1) {
            indexOfPathSeperator = appURI.lastIndexOf(47);
        }
        String appName = appURI.substring(indexOfPathSeperator + 1, appURI.length());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addApplication", cl);
        }
        ArrayList<String> applicationList = null;
        while (cl != null) {
            if (classLoaderMapToApplications.containsKey(cl)) {
                applicationList = (ArrayList<String>)classLoaderMapToApplications.get(cl);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "applicationList Array==null for " + cl + " creating new one");
                }
                applicationList = new ArrayList<String>();
                classLoaderMapToApplications.put(cl, applicationList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " adding module: " + appName + " to ClassLoader " + cl);
            }
            applicationList.add(appName);
            cl = cl.getParent();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addApplication");
        }
    }

    public static void removeClassLoader(ReloadableClassLoader cl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClassLoader", cl);
        }
        classLoaderMapToModules.remove(cl);
        classLoaderMapToApplications.remove(cl);
        CompoundClassLoader cl2 = cl.getCurrentClassLoader();
        classLoaderMapToModules.remove(cl2);
        classLoaderMapToApplications.remove(cl2);
        if (tc.isDebugEnabled()) {
            ClassLoaderDump.dumpClassLoaderMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClassLoader");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpClassLoaderMap() {
        Map map = classLoaderMapToModules;
        synchronized (map) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "dumpClassLoaderMap()");
            }
            Tr.debug(tc, "classLoaderMapToModules size = " + classLoaderMapToModules.size());
            for (Object key : classLoaderMapToModules.keySet()) {
                Object nextObject;
                if (key == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "");
                    Tr.debug(tc, "Key = " + key);
                }
                if ((nextObject = classLoaderMapToModules.get(key)) == null) continue;
                List modules = (List)nextObject;
                for (int i = 0; i < modules.size(); ++i) {
                    nextObject = modules.get(i);
                    if (nextObject == null) continue;
                    String moduleName = (String)nextObject;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "   ModuleName = " + moduleName);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "dumpClassLoaderMap()");
            }
        }
    }

    static {
        try {
            String property = System.getProperty("os.name");
            boolean isZos = property.indexOf("z/OS") != -1;
            boolean isIseris = property.indexOf("OS/400") != -1;
            boolean os400UseJ9 = System.getProperty("os400.use.j9", "false").equals("true");
            boolean os40064bit = System.getProperty("com.ibm.vm.bitmode", "false").equals("64");
            String libName = "getClasses";
            if (isZos) {
                String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
                int bitmode = Integer.parseInt(CurrentBitmode);
                libName = bitmode == 64 ? "bbgclvti" : "bboclvti";
            } else if (isIseris && !os400UseJ9) {
                libName = "/QSYS.LIB/" + System.getProperty("was.install.library") + ".LIB/GETCLASSES.SRVPGM";
                System.load(libName);
            } else if (isIseris && os400UseJ9 && !os40064bit) {
                libName = System.getProperty("was.install.root") + "/bin/libgetClasses.so";
                System.load(libName);
            } else if (isIseris && os400UseJ9 && os40064bit) {
                libName = System.getProperty("was.install.root") + "/bin/libgetClasses64.so";
                System.load(libName);
            }
            if (!isIseris) {
                System.loadLibrary(libName);
            }
            showClassesEnabled = true;
        }
        catch (SecurityException se) {
            Manager.Ffdc.log(se, thisClass, "com.ibm.ws.classloader.ClassLoaderDump.<init>", "96");
        }
        catch (UnsatisfiedLinkError ule) {
            Manager.Ffdc.log(ule, thisClass, "com.ibm.ws.classloader.ClassLoaderDump.<init>", "101");
        }
        catch (NullPointerException npe) {
            Manager.Ffdc.log(npe, thisClass, "com.ibm.ws.classloader.ClassLoaderDump.<init>", "106");
        }
        tc = Tr.register(ClassLoaderDump.class.getName(), "Websphere ClassLoader", null);
        classLoaderInfoPermission = new WebSphereRuntimePermission("accessClassLoaderInfo");
        classLoaderMapToModules = Collections.synchronizedMap(new HashMap());
        classLoaderMapToApplications = Collections.synchronizedMap(new HashMap());
    }

    static class ClassData
    implements Comparable {
        public String className;
        public String codeSource;
        boolean isInterface;

        ClassData() {
        }

        public int compareTo(Object o) {
            if (!(o instanceof ClassData)) {
                return 0;
            }
            ClassData cd = (ClassData)o;
            return this.className.compareTo(cd.className);
        }
    }
}

