/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.validation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.wsspi.channel.ChannelFactoryTypeValidator;
import com.ibm.wsspi.channel.ChannelTypeValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ChannelTypeValidatorManager {
    private static final TraceComponent tc = Tr.register(ChannelTypeValidatorManager.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static final Class[] SIGNATURE = new Class[]{MOFValidator.class};
    private MOFValidator _parent;
    private Map<Class, MOFValidator> _validatorMap = new HashMap<Class, MOFValidator>();
    private final Object[] _arguments;
    private ChannelTypeManager _typeManager;

    public ChannelTypeValidatorManager(MOFValidator parentValidator, ChannelTypeManager typeManager) {
        this._parent = parentValidator;
        this._arguments = new Object[]{parentValidator};
        this._typeManager = typeManager;
    }

    public ChannelTypeValidator getChannelTypeValidator(Object target) {
        ChannelTypeManager.ChannelMetaData type;
        if (target == null) {
            return null;
        }
        String targetClass = target.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting validator for " + targetClass);
        }
        if ((type = this._typeManager.getChannelType(target)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelTypeValidator: unknown.channel.type ");
            }
            this._parent.addError("unknown.channel.type", new String[]{targetClass}, target);
            return null;
        }
        String validatorClass = type.getValidatorClass();
        if (validatorClass == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelTypeValidator: validator.unspecified");
            }
            this._parent.addError("validator.unspecified", new String[]{targetClass}, target);
            return null;
        }
        try {
            return (ChannelTypeValidator)this.getValidator(type.getClass(validatorClass));
        }
        catch (ClassNotFoundException exp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelTypeValidator: validator.missing");
            }
            this._parent.addError("validator.missing", new String[]{validatorClass, targetClass}, target);
            return null;
        }
        catch (NoClassDefFoundError exp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelTypeValidator: validator.missing");
            }
            this._parent.addError("validator.missing", new String[]{validatorClass, targetClass}, target);
            return null;
        }
        catch (ClassCastException exp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelTypeValidator: not.a.channel.validator");
            }
            this._parent.addError("not.a.channel.validator", new String[]{validatorClass, targetClass, ChannelTypeValidator.class.getName()}, target);
            return null;
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelTypeValidator: validator.create.failed; " + t);
            }
            this._parent.addError("validator.create.failed", new String[]{validatorClass, targetClass}, target);
            return null;
        }
    }

    public ChannelFactoryTypeValidator getChannelFactoryTypeValidator(Object target) {
        ChannelTypeManager.ChannelFactoryMetaData type;
        if (target == null) {
            return null;
        }
        String targetClass = target.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting validator for " + targetClass);
        }
        if ((type = this._typeManager.getChannelFactoryType(target)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelFactoryTypeValidator: unknown.factory.type");
            }
            this._parent.addError("unknown.factory.type", new String[]{targetClass}, target);
            return null;
        }
        String validatorClass = type.getValidatorClass();
        if (validatorClass == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelFactoryTypeValidator: validator.unspecified");
            }
            this._parent.addError("validator.unspecified", new String[]{targetClass}, target);
            return null;
        }
        try {
            return (ChannelFactoryTypeValidator)this.getValidator(type.getClass(validatorClass));
        }
        catch (NoClassDefFoundError exp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelFactoryTypeValidator: validator.missing");
            }
            this._parent.addError("validator.missing", new String[]{validatorClass, targetClass}, target);
            return null;
        }
        catch (ClassCastException exp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelFactoryTypeValidator: not.a.channel.validator");
            }
            this._parent.addError("not.a.channel.validator", new String[]{validatorClass, targetClass, ChannelFactoryTypeValidator.class.getName()}, target);
            return null;
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: getChannelFactoryTypeValidator: validator.create.failed; " + t);
            }
            this._parent.addError("validator.create.failed", new String[]{validatorClass, targetClass}, target);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MOFValidator getValidator(Class validatorClass) throws NoClassDefFoundError, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Map<Class, MOFValidator> map = this._validatorMap;
        synchronized (map) {
            MOFValidator result = this._validatorMap.get(validatorClass);
            if (result == null) {
                Constructor constructor = validatorClass.getConstructor(SIGNATURE);
                result = (MOFValidator)constructor.newInstance(this._arguments);
                this._validatorMap.put(validatorClass, result);
            }
            return result;
        }
    }
}

