/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.wsspi.bootstrap.WSPreLauncher;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class StopWatch {
    private static final int STACKSIZE = 64;
    private static final String STOPWATCH_DEFAULT_LOG_FILE = "stopwatch.log";
    private static final String STOPWATCH_TIMESTAMP_PATTERN = "yy:MM:dd-HH:mm:ss.SSS";
    private static boolean formatTimeStamp;
    private static boolean useThreadTime;
    private static boolean logThreadIds;
    private static boolean forceGC;
    private static boolean dumpHeap;
    private static ThreadMXBean threadBean;
    private static SimpleDateFormat timeStampFormatter;
    private static PrintStream gcLog;
    private static final ThreadLocal<ThreadData> threadData;
    private static PrintStream log;
    private static StopWatch instance;
    private static Method dumpMethodJ9;

    private static void loadProperties() {
        try {
            String propsFile = System.getProperty("was.stopwatch.props");
            if (propsFile == null) {
                if (Boolean.getBoolean("was.stopwatch")) {
                    String logFile = System.getProperty("was.stopwatch.logfile", STOPWATCH_DEFAULT_LOG_FILE);
                    log = new PrintStream(new FileOutputStream(logFile));
                }
                return;
            }
            FileInputStream is = new FileInputStream(propsFile);
            Properties props = new Properties();
            props.load(is);
            ((InputStream)is).close();
            if (Boolean.valueOf(props.getProperty("was.stopwatch", "false")).booleanValue()) {
                boolean shouldDump;
                String logFile = props.getProperty("was.stopwatch.logfile", STOPWATCH_DEFAULT_LOG_FILE);
                log = new PrintStream(new FileOutputStream(logFile));
                formatTimeStamp = Boolean.valueOf(props.getProperty("was.stopwatch.timestamp.format", "false"));
                if (formatTimeStamp) {
                    String timeStampPattern = props.getProperty("was.stopwatch.timestamp.pattern", STOPWATCH_TIMESTAMP_PATTERN);
                    timeStampFormatter = new SimpleDateFormat(timeStampPattern);
                }
                if (useThreadTime = Boolean.valueOf(props.getProperty("was.stopwatch.threadtime", "false")).booleanValue()) {
                    threadBean = ManagementFactory.getThreadMXBean();
                    if (!threadBean.isCurrentThreadCpuTimeSupported()) {
                        useThreadTime = false;
                    } else if (!threadBean.isThreadCpuTimeEnabled()) {
                        threadBean.setThreadCpuTimeEnabled(true);
                    }
                }
                logThreadIds = Boolean.valueOf(props.getProperty("was.stopwatch.log.threadid", "false"));
                forceGC = Boolean.valueOf(props.getProperty("was.stopwatch.forcegc", "false"));
                if (forceGC) {
                    gcLog = WSPreLauncher.getOriginalSystemErrStream();
                }
                if (shouldDump = Boolean.valueOf(props.getProperty("was.stopwatch.dumpheap", "false")).booleanValue()) {
                    try {
                        Class<?> dumpClassJ9 = Class.forName("com.ibm.jvm.Dump");
                        dumpMethodJ9 = dumpClassJ9.getMethod("HeapDump", new Class[0]);
                        dumpHeap = true;
                    }
                    catch (ClassNotFoundException cnfe) {}
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void dumpHeap() {
        try {
            dumpMethodJ9.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            dumpHeap = false;
        }
    }

    public static StopWatch instance() {
        return instance;
    }

    private StopWatch() {
    }

    public void start(String label) {
        if (log != null) {
            long threadId = Thread.currentThread().getId();
            ThreadData td = threadData.get();
            if (td.stackp == 63) {
                throw new IllegalStateException("stack overflow, thread=" + threadId);
            }
            td.timers[++td.stackp] = useThreadTime ? threadBean.getCurrentThreadCpuTime() : System.currentTimeMillis();
            td.labels[td.stackp] = label;
            if (forceGC) {
                gcLog.println("<stopwatch-explicitgc label=\"" + td.labels[td.stackp] + "\"" + " state=" + "\"begin\"/>");
                gcLog.flush();
                System.gc();
            }
            if (dumpHeap) {
                this.dumpHeap();
            }
        }
    }

    public void stop() {
        if (log != null) {
            long latency;
            long threadId = Thread.currentThread().getId();
            ThreadData td = threadData.get();
            if (td == null) {
                throw new IllegalStateException("No Thread timer found for thread: " + threadId);
            }
            if (td.stackp < 0) {
                throw new IllegalStateException("stack underflow, thread=" + threadId);
            }
            long timestamp = System.currentTimeMillis();
            if (useThreadTime) {
                long current = threadBean.getThreadCpuTime(threadId);
                latency = (current - td.timers[td.stackp]) / 1000000L;
            } else {
                long current = timestamp;
                latency = current - td.timers[td.stackp];
            }
            log.println("" + (formatTimeStamp ? timeStampFormatter.format(timestamp) : Long.toString(timestamp)) + (logThreadIds ? " [" + threadId + "] " + td.stackp + " " : " ") + td.stackp + StopWatch.pad("" + latency, 7) + " : " + StopWatch.pad(" ", td.stackp * 2) + td.labels[td.stackp]);
            if (forceGC) {
                gcLog.println("<stopwatch-explicitgc label=\"" + td.labels[td.stackp] + "\"" + " state=" + "\"end\"/>");
                gcLog.flush();
                System.gc();
            }
            if (dumpHeap) {
                this.dumpHeap();
            }
            --td.stackp;
        }
    }

    private static String pad(String latency, int width) {
        String prefix = "";
        for (int i = 0; i < width - latency.length(); ++i) {
            prefix = prefix + " ";
        }
        return prefix + latency;
    }

    private static void usage() {
        System.out.println("Stopwatch tool can only parse stopwatch logs generated after disable multi-threaded startup on the server");
        System.out.println("The tool cannot parse log files when following options are enabled:");
        System.out.println("  was.stopwatch.timestamp.format");
        System.out.println("  was.stopwatch.log.threadid");
        System.out.println("  was.stopwatch.forcegc");
        System.out.println("  was.stopwatch.dumpheap");
        System.out.println("  was.stopwatch.threadtime");
        System.out.println();
        System.out.println("usage: Stopwatch -f <logfile> [options]");
        System.out.println();
        System.out.println("  Options");
        System.out.println("  -------");
        System.out.println("    -t <threshold> - used to filter data.  Only data");
        System.out.println("        points whose percentage of the overall time");
        System.out.println("        exceeds the threshold will be shown.  The units");
        System.out.println("        are in tenths of a percent point.  The default");
        System.out.println("        is 0.");
        System.out.println();
        System.out.println("    -h - prints this message.");
        System.out.println();
        System.out.println("  Examples");
        System.out.println("  --------");
        System.out.println();
        System.out.println("    1) Stopwatch -f c:/WebSphere/AppServer/Stopwatch.log");
        System.out.println();
        System.out.println("       processes the specified log using the default filter.");
        System.out.println();
        System.out.println("    2) Stopwatch -f c:/WebSphere/AppServer/Stopwatch.log -t 5");
        System.out.println();
        System.out.println("       processes the specified log and filters out all data points");
        System.out.println("       that represent less than 0.5% of the overall time.");
        System.out.println();
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            String logFileName = null;
            int threshold = 0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-t")) {
                    threshold = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    StopWatch.usage();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-f")) {
                    logFileName = args[++i];
                    continue;
                }
                StopWatch.usage();
            }
            if (logFileName == null) {
                StopWatch.usage();
            }
            System.out.println("latency  %all  %prnt");
            System.out.println("-------- ----- ----- --------------------------------------");
            BufferedReader r = new BufferedReader(new FileReader(logFileName));
            String l = null;
            Vector<String> allLines = new Vector<String>();
            Stats[] stack = new Stats[256];
            while ((l = r.readLine()) != null) {
                allLines.add(l);
            }
            int previousStackP = -1;
            for (int i = allLines.size() - 1; i >= 0; --i) {
                String nxt = (String)allLines.get(i);
                StringTokenizer tokens = new StringTokenizer(nxt, " ");
                long timestamp = Long.parseLong(tokens.nextToken());
                int stackp = Integer.parseInt(tokens.nextToken());
                int latency = Integer.parseInt(tokens.nextToken());
                tokens.nextToken();
                String remainder = "";
                while (tokens.hasMoreTokens()) {
                    remainder = remainder + tokens.nextToken() + " ";
                }
                if (stackp != previousStackP) {
                    if (stackp == previousStackP + 1) {
                        if (stack[stackp] == null) {
                            stack[stackp] = new Stats();
                        }
                        previousStackP = stackp;
                    } else if (stackp < previousStackP) {
                        previousStackP = stackp;
                    } else {
                        throw new IllegalStateException("invalid indexing");
                    }
                }
                stack[stackp].timestamp = timestamp;
                stack[stackp].indent = stackp;
                stack[stackp].label = remainder;
                stack[stackp].latency = latency;
                if (stackp <= 0) continue;
                Stats chld = stack[stackp];
                Stats prnt = stack[stackp - 1];
                Stats base = stack[0];
                int percentOfBase = chld.latency * 1000 / base.latency;
                int percentOfPrnt = 1000;
                if (prnt.latency > 0) {
                    percentOfPrnt = chld.latency * 1000 / prnt.latency;
                }
                if (percentOfBase < threshold) continue;
                System.out.println(StopWatch.pad("" + chld.latency, 8) + StopWatch.pad("" + percentOfBase / 10, 4) + "." + percentOfBase % 10 + StopWatch.pad("" + percentOfPrnt / 10, 4) + "." + percentOfPrnt % 10 + StopWatch.pad(" ", chld.indent * 2) + chld.label);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        threadData = new ThreadLocal<ThreadData>(){

            @Override
            protected ThreadData initialValue() {
                return new ThreadData();
            }
        };
        log = null;
        instance = null;
        instance = new StopWatch();
        StopWatch.loadProperties();
    }

    static class ThreadData {
        public long[] timers = new long[64];
        public String[] labels = new String[64];
        public int stackp = -1;
    }

    static class Stats {
        long timestamp = 0L;
        int indent = 0;
        int latency = 0;
        String label = null;

        Stats() {
        }
    }
}

