/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl;

import java.util.Map;
import java.util.Properties;

public class SSLConfigChangeEvent {
    private String selectionType;
    private String sslAlias;
    private String sslState;
    private Properties originalSSLConfig;
    private Properties changedSSLConfig;
    private Map connectionInfo;

    public SSLConfigChangeEvent(String alias, Properties config, String selection, Map connInfo) {
        this.sslAlias = alias;
        this.originalSSLConfig = config;
        this.selectionType = selection;
        this.connectionInfo = connInfo;
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    public Map getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getAlias() {
        return this.sslAlias;
    }

    public String getClientCertificateAlias() {
        if (this.originalSSLConfig != null) {
            return this.originalSSLConfig.getProperty("com.ibm.ssl.keyStoreClientAlias");
        }
        return null;
    }

    public String getServerCertificateAlias() {
        if (this.originalSSLConfig != null) {
            return this.originalSSLConfig.getProperty("com.ibm.ssl.keyStoreServerAlias");
        }
        return null;
    }

    public String getState() {
        return this.sslState;
    }

    public Properties getOriginalSSLConfig() {
        return this.originalSSLConfig;
    }

    public Properties getChangedSSLConfig() {
        return this.changedSSLConfig;
    }

    public void setChangedSSLConfig(Properties config) {
        this.changedSSLConfig = config;
    }

    public void setState(String state) {
        this.sslState = state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SSLConfigChangeEvent: selectionType=");
        sb.append(this.selectionType);
        sb.append(", sslAlias=");
        sb.append(this.sslAlias);
        sb.append(", sslState=");
        sb.append(this.sslState);
        return sb.toString();
    }
}

