/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;

public class WASPrincipal
implements WSPrincipal {
    public static final String UNAUTHENTICATED = "UNAUTHENTICATED";
    private String name;
    private String uniqueUserId;
    private List uniqueGroupIds;
    private static final ArrayList EMPTY_LIST = new ArrayList(0);

    public WASPrincipal(String name2, String uniqueUserId, List uniqueGroupIds) {
        this.name = name2 == null ? ContextManagerFactory.getInstance().getUnauthenticatedString() : name2;
        this.uniqueUserId = uniqueUserId;
        this.uniqueGroupIds = uniqueGroupIds == null ? EMPTY_LIST : uniqueGroupIds;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof WASPrincipal) {
            WASPrincipal another = (WASPrincipal)obj;
            String anotherUniqueUserId = another.getUniqueUserId();
            if (this.uniqueUserId == null && anotherUniqueUserId == null) {
                return true;
            }
            if (this.uniqueUserId == null || anotherUniqueUserId == null) {
                return false;
            }
            return this.uniqueUserId.equals(anotherUniqueUserId);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueUserId() {
        return this.uniqueUserId;
    }

    public List getUniqueGroupIds() {
        return this.uniqueGroupIds;
    }

    public int hashCode() {
        if (this.uniqueUserId != null) {
            return this.uniqueUserId.hashCode();
        }
        return 0;
    }

    public WSCredential getCredential() {
        ContextManager contextMgr = ContextManagerFactory.getInstance();
        if (contextMgr != null) {
            try {
                Subject subject = contextMgr.getInvocationSubject();
                return SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            }
            catch (WSSecurityException wSSecurityException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("securityName: ");
        sb.append(this.name).append(", uid: ").append(this.uniqueUserId);
        sb.append(", gid: ").append(this.uniqueGroupIds.toString());
        return sb.toString();
    }
}

