/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminHelper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallRARTask {
    String LOCAL = "local_";
    private static TraceComponent tc = Tr.register(InstallRARTask.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final int DELETE_SOURCE_FLAG_VALUE = 1000;
    private ConfigService configService;
    static final String _SERVER = "Server";
    static final String _NODE = "Node";
    static final String _CLUSTER = "ServerCluster";
    static final String _CELL = "Cell";

    public InstallRARTask(ConfigService configService) {
        this.configService = configService;
    }

    public ObjectName installResourceAdapter(Session session, String nodeName, String archivePath, Hashtable options) throws ConfigServiceException, ConnectorException {
        String haCapability;
        boolean status;
        String nativePath;
        ObjectName[] matches;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter", new Object[]{session, nodeName, archivePath, options});
        }
        if (options == null) {
            options = new Hashtable<String, String>();
        }
        if ((matches = this.configService.resolve(session, "Node=" + nodeName)).length == 0) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "63", this);
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0034E", new Object[]{nodeName}, null);
            throw new ConfigServiceException(msg);
        }
        int flag = 0;
        Boolean deletesrc = (Boolean)options.get("rar.DeleteSourceRar");
        if (deletesrc != null && deletesrc.booleanValue()) {
            flag = 1000;
        }
        ObjectName node = matches[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node", node);
        }
        boolean isolated = false;
        String str = (String)options.get("rar.isolatedClassLoader");
        if (str != null) {
            if (str.equalsIgnoreCase("true")) {
                str = options.put("rar.isolatedClassLoader", "true");
                isolated = true;
            }
            if (str.equals("")) {
                isolated = true;
                options.put("rar.isolatedClassLoader", "true");
            }
        }
        if (isolated && (nativePath = (String)options.get("rar.nativePath")) != null) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "134", this);
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0305E", new Object[]{archivePath}, null);
            throw new ConfigServiceException(msg);
        }
        File f = new File(archivePath.replace('\\', '/'));
        String aPath = (String)options.get("rar.archivePath");
        if (aPath == null) {
            aPath = "${CONNECTOR_INSTALL_ROOT}/";
        }
        if (!aPath.trim().endsWith("/") && !aPath.trim().endsWith(File.separator)) {
            aPath = aPath + "/";
        }
        aPath = aPath + f.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive path: " + aPath);
        }
        try {
            boolean exist = InstallRARTask.isJ2CRAExist(session, this.configService, aPath, isolated, node);
        }
        catch (NullPointerException e) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "165");
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{e}, null);
            ConfigServiceException ex = new ConfigServiceException(msg);
            ex.initCause(e);
            throw ex;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        String HAflag = (String)options.get("rar.enableHASupport");
        boolean enableHA = false;
        if (HAflag != null) {
            if (HAflag.equalsIgnoreCase("yes")) {
                enableHA = true;
            }
            if (HAflag.equals("")) {
                enableHA = true;
                options.put("rar.enableHASupport", "true");
            }
        }
        if (enableHA && !(status = InstallRARTask.validateHACapability(haCapability = (String)options.get("rar.HACapability")))) {
            options.put("rar.HACapability", "no");
        }
        String opName = "getResourceAdapterFromRAR";
        String[] sigs = new String[]{"java.lang.String", "java.util.Hashtable"};
        Object[] params = new Object[]{archivePath, options};
        AttributeList raAttrList = (AttributeList)this.invoke(session, node, nodeName, opName, params, sigs);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "raAttrList", raAttrList);
        }
        opName = "extractArchive";
        sigs = new String[]{"java.lang.String", "java.lang.String", "int"};
        String dest = null;
        try {
            dest = (String)ConfigServiceHelper.getAttributeValue(raAttrList, "archivePath");
        }
        catch (AttributeNotFoundException ex) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null);
            throw new ConfigServiceException(ex, msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dest", dest);
        }
        params = new Object[]{archivePath, dest, new Integer(flag)};
        this.invoke(session, node, nodeName, opName, params, sigs);
        ObjectName result = this.configService.createConfigData(session, node, "J2CResourceAdapter", null, raAttrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter", result);
        }
        return result;
    }

    private Object invoke(Session session, ObjectName nodeObject, String node, String operationName, Object[] params, String[] sigs) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{session, nodeObject, node, operationName, params, sigs});
        }
        Object result = null;
        try {
            if (this.configService instanceof ConfigServiceProxy) {
                ObjectName pattern;
                ConfigServiceProxy proxy = (ConfigServiceProxy)this.configService;
                AdminClient client2 = proxy.getAdminClient();
                ObjectName serverMBean = client2.getServerMBean();
                String processType = (String)client2.invoke(serverMBean, "getProcessType", null, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configService processType", processType);
                }
                if (processType.equals("UnManagedProcess") || processType.equals("AdminAgent")) {
                    pattern = new ObjectName("*:node=" + node + ",type=AdminOperations,*");
                } else {
                    ObjectName oName = new ObjectName("*:node=" + node + ",type=NodeAgent,*");
                    Set s = client2.queryNames(oName, null);
                    if (s.isEmpty()) {
                        throw new InstanceNotFoundException(oName.getCanonicalName());
                    }
                    String nodeAgentName = ((ObjectName)s.iterator().next()).getKeyProperty("process");
                    pattern = new ObjectName("*:node=" + node + ",process=" + nodeAgentName + ",type=AdminOperations,*");
                }
                Set adminOps = client2.queryNames(pattern, null);
                if (adminOps.size() == 0) {
                    throw new InstanceNotFoundException(pattern.getCanonicalName());
                }
                ObjectName adminOp = (ObjectName)adminOps.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminOp", adminOp);
                }
                result = client2.invoke(adminOp, operationName, params, sigs);
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    String wsnode = System.getProperty("local.node");
                    Tr.debug(tc, "local node=" + wsnode + "while the target node =" + node);
                    if (!wsnode.equals(node)) {
                        throw new UnsupportedOperationException("Target node should be the same as the current node in local node mode.");
                    }
                    Class<?> admClass = Class.forName("com.ibm.ws.management.component.AdminOperationsMBean");
                    Class<?> str = Class.forName("java.lang.String");
                    Class<Integer> intType = Integer.TYPE;
                    Class<?> htbl = Class.forName("java.util.Hashtable");
                    ObjectName[] cell = this.configService.getRelationship(session, nodeObject, "parent");
                    String cellName = ConfigServiceHelper.getDisplayName(cell[0]);
                    String configRoot = System.getProperty("was.repository.root");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configRoot" + configRoot + " cell=" + cellName + "node = " + node);
                    }
                    Class[] pp = null;
                    Object[] lparams = null;
                    if (operationName.equals("getResourceAdapterFromRAR") || operationName.equals("getRARInfo")) {
                        pp = new Class[]{str, htbl, str, str, str};
                        lparams = new Object[]{params[0], params[1], configRoot, cellName, node};
                    } else {
                        pp = new Class[]{str, str, intType, str, str, str};
                        lparams = new Object[]{params[0], params[1], params[2], configRoot, cellName, node};
                    }
                    Method mtd = admClass.getMethod(this.LOCAL + operationName, pp);
                    result = mtd.invoke(null, lparams);
                } else {
                    ObjectName pattern;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adminService processType", adminService.getProcessType());
                    }
                    if (adminService.getProcessType().equals("UnManagedProcess") || adminService.getProcessType().equals("AdminAgent")) {
                        pattern = new ObjectName("*:node=" + node + ",type=AdminOperations,*");
                    } else {
                        String nodeAgentName = AdminHelper.getInstance().getNodeAgentName(node);
                        pattern = new ObjectName("*:node=" + node + ",process=" + nodeAgentName + ",type=AdminOperations,*");
                    }
                    Set adminOps = adminService.queryNames(pattern, null);
                    if (adminOps.size() == 0) {
                        throw new InstanceNotFoundException(pattern.getCanonicalName());
                    }
                    ObjectName adminOp = (ObjectName)adminOps.iterator().next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adminOp", adminOp);
                    }
                    if (operationName.equals("extractArchive")) {
                        this.fixExpansionFlag(params, adminOp);
                    }
                    result = adminService.invoke(adminOp, operationName, params, sigs);
                }
            }
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable th = ex.getTargetException();
            throw new ConfigServiceException(th);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "71", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", result);
        }
        return result;
    }

    public Hashtable getRARInfo(Session session, String nodeName, String archivePath, Hashtable options) throws ConfigServiceException, ConnectorException {
        ObjectName[] matches;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter", new Object[]{session, nodeName, archivePath, options});
        }
        Hashtable result = new Hashtable();
        if (options == null) {
            options = new Hashtable();
        }
        if ((matches = this.configService.resolve(session, "Node=" + nodeName)).length == 0) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "63", this);
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0034E", new Object[]{nodeName}, null);
            throw new ConfigServiceException(msg);
        }
        ObjectName node = matches[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node", node);
        }
        String opName = "getRARInfo";
        String[] sigs = new String[]{"java.lang.String", "java.util.Hashtable"};
        Object[] params = new Object[]{archivePath, options};
        result = (Hashtable)this.invoke(session, node, nodeName, opName, params, sigs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRAInfo ", result);
        }
        return result;
    }

    public static boolean validateHACapability(String key) {
        if (key == null) {
            return false;
        }
        return key.equals("endpoint") || key.equals("instance") || key.equals("no");
    }

    public static boolean isJ2CRAExist(Session session, ConfigService configService, String archivePath, boolean isolated, ObjectName scope) throws ConfigServiceException {
        return InstallRARTask.isJ2CRAExist(session, configService, archivePath, isolated, scope, null);
    }

    public static boolean isJ2CRAExist(Session session, ConfigService configService, String archivePath, boolean isolated, ObjectName scope, ObjectName orgRA) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJ2CRAExist " + archivePath + " isolated : " + isolated + " scope : " + scope);
        }
        ObjectName cellScope = null;
        ObjectName nodeScope = null;
        ObjectName[] parents = null;
        boolean flag = false;
        String type = scope.getKeyProperty("_Websphere_Config_Data_Type");
        String name2 = scope.getKeyProperty("_Websphere_Config_Data_Display_Name");
        String nodeName = null;
        try {
            if (type.equals(_SERVER)) {
                parents = configService.getRelationship(session, scope, "parent");
                if (parents.length > 0) {
                    nodeScope = parents[0];
                    nodeName = nodeScope.getKeyProperty("_Websphere_Config_Data_Display_Name");
                    parents = configService.getRelationship(session, nodeScope, "parent");
                    if (parents.length > 0) {
                        cellScope = parents[0];
                    }
                }
            } else if (type.equals(_NODE)) {
                nodeName = name2;
                name2 = null;
                parents = configService.getRelationship(session, scope, "parent");
                if (parents.length > 0) {
                    cellScope = parents[0];
                }
            } else if (type.equals(_CLUSTER) && (parents = configService.getRelationship(session, scope, "parent")).length > 0) {
                cellScope = parents[0];
            }
        }
        catch (ConnectorException e1) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "376");
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{e1}, null);
            ConfigServiceException ex = new ConfigServiceException(msg);
            ex.setStackTrace(e1.getStackTrace());
            throw ex;
        }
        List<ObjectName> ralist = InstallRARTask.listResources(session, configService, "J2CResourceAdapter", archivePath, true, cellScope);
        if (ralist != null) {
            flag = true;
            String[] rascopes = new String[]{null, null, null};
            String raType = null;
            String raName = null;
            String raNodeName = null;
            for (ObjectName ra : ralist) {
                InstallRARTask.getLocation(session, configService, ra, rascopes);
                raType = rascopes[0];
                raName = rascopes[1];
                raNodeName = rascopes[2];
                if (type.equals(_SERVER) && raType.equals(_SERVER) && !raName.equals(name2) || (type.equals(_NODE) || type.equals(_SERVER) ? raNodeName != null && !raNodeName.equals(nodeName) : type.equals(_CLUSTER) && (raType.equals(_CLUSTER) && !raName.equals(name2) || raType.equals(_NODE)))) continue;
                boolean foundIsolated = false;
                try {
                    foundIsolated = (Boolean)configService.getAttribute(session, ra, "isolatedClassLoader");
                }
                catch (ConnectorException e) {
                    Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "438");
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{e}, null);
                    throw new ConfigServiceException(msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found ra " + ra);
                }
                if (foundIsolated == isolated) continue;
                String id0 = null;
                String id1 = null;
                if (orgRA != null) {
                    id0 = ra.getKeyProperty("_Websphere_Config_Data_Id");
                    id1 = orgRA.getKeyProperty("_Websphere_Config_Data_Id");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "id0 = " + id0 + "id1 =" + id1);
                    }
                }
                if (id1 != null && id0.equals(id1)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mode did not match : " + isolated);
                }
                Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "446");
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0304E", new Object[]{archivePath}, null);
                throw new ConfigServiceException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJ2CRAExist returns " + flag);
        }
        return flag;
    }

    private static void getLocation(Session session, ConfigService configService, ObjectName scope, String[] rascopes) {
        Properties props = ConfigServiceHelper.getObjectLocation(scope);
        String server2 = (String)props.get("server");
        String node = (String)props.get("node");
        String cluster = (String)props.get("cluster");
        if (server2 != null) {
            rascopes[0] = _SERVER;
            rascopes[1] = server2;
            rascopes[2] = node;
        } else if (node != null) {
            rascopes[0] = _NODE;
            rascopes[2] = node;
        } else if (cluster != null) {
            rascopes[0] = _CLUSTER;
            rascopes[1] = cluster;
        } else {
            rascopes[0] = _CELL;
        }
    }

    public static List<ObjectName> listResources(Session session, ConfigService configService, String type, String archivePath, boolean recursive, ObjectName scope) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResources : " + type + " aechivePath: " + archivePath + " recursive " + recursive + " scope = " + scope);
        }
        ArrayList<ObjectName> ralist = null;
        ObjectName[] oList = null;
        ObjectName typeON = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("_Websphere_Config_Data_Type", type);
        try {
            typeON = new ObjectName("WebSphere", table);
            oList = configService.queryConfigObjects(session, scope, typeON, null);
        }
        catch (MalformedObjectNameException e) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "405");
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{e}, null);
            throw new ConfigServiceException(msg);
        }
        catch (NullPointerException e) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "410");
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{e}, null);
            throw new ConfigServiceException(msg);
        }
        catch (ConnectorException e) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "415");
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{e}, null);
            throw new ConfigServiceException(msg);
        }
        for (ObjectName on : oList) {
            String foundAPath = null;
            try {
                foundAPath = (String)configService.getAttribute(session, on, "archivePath");
                if (!foundAPath.equalsIgnoreCase(archivePath)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Archive Path = " + foundAPath);
                }
                if (ralist == null) {
                    ralist = new ArrayList<ObjectName>();
                }
                ralist.add(on);
            }
            catch (ConnectorException e) {
                Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "496");
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{e}, null);
                throw new ConfigServiceException(msg);
            }
        }
        if (tc.isDebugEnabled() && ralist != null && ralist.size() != 0) {
            for (ObjectName o : ralist) {
                Tr.debug(tc, "     ----" + o);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listResources");
        }
        return ralist;
    }

    private void fixExpansionFlag(Object[] params, ObjectName adminOp) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixExpansionValue", new Object[]{params, adminOp});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "extract archive operation, need to check for expansion flag");
        }
        int expansionFlag = 0;
        if (params.length >= 3) {
            Integer param = (Integer)params[2];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expansion flag is set to " + param);
            }
            expansionFlag = param;
        }
        if ((expansionFlag & 0x3E8) == 1000) {
            int majorVersionNum;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expansion is set to delete source, need to check for node agent version");
            }
            String nodeVersion = adminOp.getKeyProperty("version");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node agent version: " + nodeVersion);
            }
            String[] nodeVersionArray = nodeVersion.split("\\.");
            String majorVersion = "";
            String minorVersion = "";
            if (nodeVersionArray.length > 0) {
                majorVersion = nodeVersionArray[0];
            }
            if (nodeVersionArray.length > 1) {
                minorVersion = nodeVersionArray[1];
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "major version: " + majorVersion);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "minor version: " + minorVersion);
            }
            try {
                majorVersionNum = Integer.parseInt(majorVersion);
            }
            catch (NumberFormatException nfe) {
                Manager.Ffdc.log(nfe, this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "639", this);
                throw new ConfigServiceException(nfe);
            }
            if (majorVersionNum < 6) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node major version is < 6.0, reset expansion flag to remove deleteSourceRar option value");
                }
                expansionFlag -= 1000;
            } else if (majorVersionNum == 6 && Integer.parseInt(minorVersion) < 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node minor version is not 1, reset expansion flag to remove deleteSourceRar option value0");
                    Tr.debug(tc, "rar.DeleteSourceRar is supported in node v6.1 and above. This option is ignored if used to deply a resource adapter in a node with version lower than v6.1");
                }
                expansionFlag -= 1000;
            }
            if (params.length >= 3) {
                params[2] = new Integer(expansionFlag);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expansion is set to " + expansionFlag);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixExpansionValue");
        }
    }
}

