/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import com.ibm.ws.management.cmdframework.impl.CommandSecurityUtil;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;

public abstract class SimpleCommandProvider
extends CommandProvider {
    private static TraceComponent tc = Tr.register(SimpleCommandProvider.class, "SimpleCommandProvider", "com.ibm.websphere.management.cmdframework.provider");
    protected HashMap methodTable;

    protected SimpleCommandProvider() {
        Class<?> cls = this.getClass();
        Method[] methods = cls.getMethods();
        this.methodTable = new HashMap(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            this.methodTable.put(methods[i].getName(), methods[i]);
        }
    }

    public AbstractAdminCommand createCommand(CommandMetadata metadata) throws CommandNotFoundException {
        String cmdName = metadata.getName();
        if (!this.methodTable.containsKey(cmdName)) {
            throw new CommandNotFoundException(cmdName);
        }
        return new SimpleAdminCommand(metadata);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        SimpleAdminCommand result;
        try {
            result = new SimpleAdminCommand(cmdData);
        }
        catch (CommandNotFoundException ex) {
            throw ex;
        }
        catch (CommandLoadException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandLoadException(ex);
        }
        return result;
    }

    protected void execute(SimpleAdminCommand cmd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl cmdResult = new CommandResultImpl();
        cmd.setCommandResult(cmdResult);
        CommandSecurityUtil cmdSecurityUtil = CommandSecurityUtil.getInstance();
        boolean accessGranted = cmdSecurityUtil.checkAccess(cmd, "execute command");
        if (!accessGranted) {
            String msg = "Access denied for this command " + cmd.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            Exception e = new Exception(msg);
            cmdResult.setException(e);
            return;
        }
        String delegationMode = cmdSecurityUtil.getDelegationMode(cmd);
        if (delegationMode != null && delegationMode.equals("System")) {
            final SimpleAdminCommand cmdFinal = cmd;
            try {
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        SimpleCommandProvider.this.executeReal(cmdFinal);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception ex = pae.getException();
                cmdResult.setException(ex);
            }
            catch (Exception e) {
                cmdResult.setException(e);
            }
        } else {
            this.executeReal(cmd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    protected void executeReal(SimpleAdminCommand cmd) {
        CommandResultImpl commandResult = (CommandResultImpl)cmd.getCommandResult();
        try {
            cmd.validate();
            CommandMetadata metaData = cmd.getCommandMetadata();
            Method method = (Method)this.methodTable.get(cmd.getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Method to execute is " + method.getName());
            }
            Object result = method.invoke((Object)this, cmd);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result is " + result);
            }
            if (result != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Class of Result is " + result.getClass());
            }
            commandResult.setResult(result);
        }
        catch (InvocationTargetException ite) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown when invocation command");
            }
            commandResult.setException(ite.getTargetException());
        }
        catch (Throwable ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown when execute command");
            }
            commandResult.setException(ex);
        }
        cmd.setCommandResult(commandResult);
    }
}

