/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASEvent;
import com.ibm.ras.RASITraceEvent;
import com.ibm.ras.RASITraceLogger;
import com.ibm.ras.RASTraceFormatter;
import com.ibm.ras.RASUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RASTraceEvent
extends RASEvent
implements RASITraceEvent {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -2004164315649535547L;

    public RASTraceEvent() {
        this.setAttribute("threadID", Thread.currentThread().getName());
        this.setMessageEvent(false);
    }

    protected RASTraceEvent(long type, String text, Object[] parms) {
        super(type, text, parms);
        this.setAttribute("threadID", Thread.currentThread().getName());
        this.setMessageEvent(false);
    }

    protected RASTraceEvent(long type, String text, String[] parms) {
        this(type, text, (Object[])parms);
    }

    public RASTraceEvent(long type, String text, Object[] parms, String loggingClass, String loggingMethod, RASITraceLogger logger, String server2, String client2, Throwable exception) {
        this(type, text, parms);
        if (loggingClass != null) {
            this.setAttribute("loggingClass", loggingClass);
        }
        if (loggingMethod != null) {
            this.setAttribute("loggingMethod", loggingMethod);
        }
        if (logger != null) {
            this.setAttribute("logger", logger.getName());
        }
        if (server2 != null) {
            this.setAttribute("server", server2);
        }
        if (client2 != null) {
            this.setAttribute("client", client2);
        }
        if (exception != null) {
            this.setAttribute("exception", exception);
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            this.setAttribute("exceptionTrace", sw.toString());
        }
    }

    public RASTraceEvent(long type, String text, String[] parms, String loggingClass, String loggingMethod, RASITraceLogger logger, String server2, String client2, Throwable exception) {
        this(type, text, (Object[])parms, loggingClass, loggingMethod, logger, server2, client2, exception);
    }

    public RASTraceEvent(long type, String loggingClass, String loggingMethod, RASITraceLogger logger, String server2, String client2, byte[] data) {
        this();
        this.setType(type);
        if (loggingClass != null) {
            this.setAttribute("loggingClass", loggingClass);
        }
        if (loggingMethod != null) {
            this.setAttribute("loggingMethod", loggingMethod);
        }
        if (logger != null) {
            this.setAttribute("logger", logger.getName());
        }
        if (server2 != null) {
            this.setAttribute("server", server2);
        }
        if (client2 != null) {
            this.setAttribute("client", client2);
        }
        if (data != null) {
            this.setAttribute("hexData", data);
        }
    }

    public Hashtable getSupportedTypes() {
        Hashtable ht = super.getSupportedTypes();
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_API"), new Long(1L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_CALLBACK"), new Long(2L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_ENTRY_EXIT"), new Long(4L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_ERROR_EXC"), new Long(8L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_MISC_DATA"), new Long(16L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_OBJ_CREATE"), new Long(32L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_OBJ_DELETE"), new Long(64L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_PRIVATE"), new Long(128L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_PUBLIC"), new Long(256L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_STATIC"), new Long(512L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_SVC"), new Long(1024L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_LEVEL1"), new Long(2048L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_LEVEL2"), new Long(4096L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_LEVEL3"), new Long(8192L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_PERF"), new Long(16384L));
        return ht;
    }

    public long maskLongValue(String types) {
        long result = super.maskLongValue(types);
        StringTokenizer st = new StringTokenizer(types);
        while (st.hasMoreElements()) {
            String type = st.nextToken();
            if (type.equals("TYPE_API")) {
                result |= 1L;
                continue;
            }
            if (type.equals("TYPE_CALLBACK")) {
                result |= 2L;
                continue;
            }
            if (type.equals("TYPE_ENTRY_EXIT")) {
                result |= 4L;
                continue;
            }
            if (type.equals("TYPE_ERROR_EXC")) {
                result |= 8L;
                continue;
            }
            if (type.equals("TYPE_MISC_DATA")) {
                result |= 0x10L;
                continue;
            }
            if (type.equals("TYPE_OBJ_CREATE")) {
                result |= 0x20L;
                continue;
            }
            if (type.equals("TYPE_OBJ_DELETE")) {
                result |= 0x40L;
                continue;
            }
            if (type.equals("TYPE_PRIVATE")) {
                result |= 0x80L;
                continue;
            }
            if (type.equals("TYPE_PUBLIC")) {
                result |= 0x100L;
                continue;
            }
            if (type.equals("TYPE_STATIC")) {
                result |= 0x200L;
                continue;
            }
            if (type.equals("TYPE_SVC")) {
                result |= 0x400L;
                continue;
            }
            if (type.equals("TYPE_LEVEL1")) {
                result |= 0x800L;
                continue;
            }
            if (type.equals("TYPE_LEVEL2")) {
                result |= 0x1000L;
                continue;
            }
            if (type.equals("TYPE_LEVEL3")) {
                result |= 0x2000L;
                continue;
            }
            if (type.equals("TYPE_PERF")) {
                result |= 0x4000L;
                continue;
            }
            if (type.equals("DEFAULT_TRACE_MASK")) {
                result |= 0x7FFL;
                continue;
            }
            if (!type.equals("ALL_TRACE_MASK")) continue;
            result |= 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }

    public String maskToString(long types) {
        StringBuffer bfr = new StringBuffer(super.maskToString(types));
        if ((types & 1L) != 0L) {
            bfr.append("TYPE_API ");
        }
        if ((types & 2L) != 0L) {
            bfr.append("TYPE_CALLBACK ");
        }
        if ((types & 4L) != 0L) {
            bfr.append("TYPE_ENTRY_EXIT ");
        }
        if ((types & 8L) != 0L) {
            bfr.append("TYPE_ERROR_EXC ");
        }
        if ((types & 0x10L) != 0L) {
            bfr.append("TYPE_MISC_DATA ");
        }
        if ((types & 0x20L) != 0L) {
            bfr.append("TYPE_OBJ_CREATE ");
        }
        if ((types & 0x40L) != 0L) {
            bfr.append("TYPE_OBJ_DELETE ");
        }
        if ((types & 0x80L) != 0L) {
            bfr.append("TYPE_PRIVATE ");
        }
        if ((types & 0x100L) != 0L) {
            bfr.append("TYPE_PUBLIC ");
        }
        if ((types & 0x200L) != 0L) {
            bfr.append("TYPE_STATIC ");
        }
        if ((types & 0x400L) != 0L) {
            bfr.append("TYPE_SVC ");
        }
        if ((types & 0x800L) != 0L) {
            bfr.append("TYPE_LEVEL1 ");
        }
        if ((types & 0x1000L) != 0L) {
            bfr.append("TYPE_LEVEL2 ");
        }
        if ((types & 0x2000L) != 0L) {
            bfr.append("TYPE_LEVEL3 ");
        }
        if ((types & 0x4000L) != 0L) {
            bfr.append("TYPE_PERF ");
        }
        return bfr.toString().trim();
    }

    public String toString() {
        RASTraceFormatter f = new RASTraceFormatter();
        return f.format(this);
    }
}

