/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFileHandler;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RASMultiFileHandler
extends RASFileHandler {
    private static final String S = "(C) Copyright IBM Corp. 1999.";
    private static final long serialVersionUID = -6038340063368985500L;
    public static final int DEFAULT_FILE_NUMBER = 3;
    public static final int DEFAULT_FILE_SIZE = 512;
    protected transient long fileSize;
    private int maxFiles;
    private long maxFileSize;
    protected String baseFileName;
    protected String fileDir;
    protected String fileExt;

    public RASMultiFileHandler() {
    }

    public RASMultiFileHandler(String name2) {
        super(name2);
    }

    public RASMultiFileHandler(String name2, String desc) {
        super(name2, desc);
    }

    public RASMultiFileHandler(String name2, String desc, String file) {
        super(name2, desc, file);
    }

    public RASMultiFileHandler(String name2, String desc, String file, String encoding) {
        super(name2, desc, file, encoding);
    }

    protected void init() {
        super.init();
        this.fileSize = 0L;
        this.setMaxFiles(3);
        this.setMaxFileSize(512);
        this.baseFileName = null;
        this.fileDir = null;
        this.fileExt = null;
    }

    public Hashtable getConfig() {
        Hashtable ht = super.getConfig();
        ht.put("maxFiles", new Integer(this.getMaxFiles()).toString());
        ht.put("maxFileSize", new Integer(this.getMaxFileSize()).toString());
        return ht;
    }

    public void setConfig(Hashtable ht) {
        this.init();
        super.setConfig(ht);
        if (ht.containsKey("maxFiles")) {
            this.setMaxFiles(new Integer((String)ht.get("maxFiles")));
        }
        if (ht.containsKey("maxFileSize")) {
            this.setMaxFileSize(new Integer((String)ht.get("maxFileSize")));
        }
    }

    public void setFileName(String name2) {
        if (name2 != null) {
            int dot;
            super.setFileName(name2);
            name2 = this.getFileName();
            String tempName = new File(name2).getAbsolutePath();
            File file = new File(tempName);
            this.fileDir = file.getParent();
            if (this.fileDir != null && !this.fileDir.endsWith(File.separator)) {
                this.fileDir = this.fileDir + File.separator;
            }
            if ((dot = (tempName = file.getName()).lastIndexOf(46)) == -1) {
                this.baseFileName = tempName;
            } else {
                this.baseFileName = tempName.substring(0, dot);
                this.fileExt = tempName.substring(dot);
            }
            StringBuffer nameBfr = new StringBuffer();
            if (this.fileDir != null) {
                nameBfr.append(this.fileDir);
            }
            nameBfr.append(this.baseFileName + "1");
            if (this.fileExt != null) {
                nameBfr.append(this.fileExt);
            }
            this.fileName = nameBfr.toString();
        }
    }

    public String getNumberedFileName(int nbr) {
        String name2;
        if (this.getFileName() == null || nbr < 1 || nbr > this.getMaxFiles()) {
            name2 = null;
        } else {
            name2 = this.fileDir + this.baseFileName + nbr;
            if (this.fileExt != null) {
                name2 = name2 + this.fileExt;
            }
        }
        return name2;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int files) {
        if (files >= 0) {
            this.maxFiles = files;
        }
    }

    public int getMaxFileSize() {
        return (int)(this.maxFileSize / 1024L);
    }

    public void setMaxFileSize(int size) {
        if (size > 0) {
            this.maxFileSize = size * 1024;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.deviceOpen || this.fileSize >= this.maxFileSize) {
                this.closeDevice();
                if (this.fileSize >= this.maxFileSize) {
                    Vector dirList = this.getDirList(this.fileDir);
                    dirList = this.deleteExtraFiles(dirList, this.fileDir);
                    this.renameFiles(dirList, this.fileDir);
                }
                super.openDevice();
                this.fileSize = new File(this.getFileName()).length();
            }
        }
    }

    protected Vector getDirList(String dir) {
        File userDir = new File(dir);
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir1, String name2) {
                boolean match = false;
                try {
                    int logNumber;
                    int baseNameLength = RASMultiFileHandler.this.baseFileName.length();
                    if (RASMultiFileHandler.this.fileExt == null) {
                        int logNumber2;
                        if (name2.startsWith(RASMultiFileHandler.this.baseFileName) && (logNumber2 = Integer.parseInt(name2.substring(baseNameLength))) >= 1 && logNumber2 <= RASMultiFileHandler.this.getMaxFiles()) {
                            match = true;
                        }
                    } else if (name2.startsWith(RASMultiFileHandler.this.baseFileName) && name2.endsWith(RASMultiFileHandler.this.fileExt) && (logNumber = Integer.parseInt(name2.substring(baseNameLength, name2.indexOf(RASMultiFileHandler.this.fileExt)))) >= 1 && logNumber <= RASMultiFileHandler.this.getMaxFiles()) {
                        match = true;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return match;
            }
        };
        Vector<String> dirVector = new Vector<String>();
        String[] dirList = userDir.list(filter);
        if (dirList != null) {
            for (int i = 0; i < dirList.length; ++i) {
                dirVector.addElement(dirList[i]);
            }
        }
        return this.sortFiles(dirVector);
    }

    protected void renameFiles(Vector files, String dir) {
        int logNumber = files.size() + 1;
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            String oldLogName = (String)e.nextElement();
            String newLogName = this.fileExt == null ? this.baseFileName + logNumber : this.baseFileName + logNumber + this.fileExt;
            File currentFile = new File(dir + oldLogName);
            File newFile = new File(dir + newLogName);
            currentFile.renameTo(newFile);
            --logNumber;
        }
    }

    protected Vector sortFiles(Vector files) {
        int baseNameLength = this.baseFileName.length();
        for (int i = 0; i < files.size(); ++i) {
            String temp1 = (String)files.elementAt(i);
            for (int j = i + 1; j < files.size(); ++j) {
                int logNumber2;
                int logNumber1;
                String temp2 = (String)files.elementAt(j);
                if (this.fileExt == null) {
                    logNumber1 = Integer.parseInt(temp1.substring(baseNameLength));
                    logNumber2 = Integer.parseInt(temp2.substring(baseNameLength));
                } else {
                    logNumber1 = Integer.parseInt(temp1.substring(baseNameLength, temp1.indexOf(this.fileExt)));
                    logNumber2 = Integer.parseInt(temp2.substring(baseNameLength, temp2.indexOf(this.fileExt)));
                }
                if (logNumber1 >= logNumber2) continue;
                files.setElementAt(temp2, i);
                files.setElementAt(temp1, j);
                temp1 = temp2;
            }
        }
        return files;
    }

    protected Vector deleteExtraFiles(Vector files, String path) {
        int maxFiles = this.getMaxFiles();
        if (maxFiles > 0) {
            while (files.size() >= maxFiles) {
                File deadFile = new File(path + (String)files.firstElement());
                deadFile.delete();
                files.removeElement(files.firstElement());
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEvent(RASIEvent event) {
        this.openDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            RASIFormatter formatter;
            if (this.deviceOpen && (formatter = this.findFormatter(event)) != null) {
                String msg = formatter.format(event);
                this.fileSize += (long)msg.length();
                this.pWriter.println(msg);
                if (this.pWriter.checkError()) {
                    this.closeDevice();
                    if (++this.deviceFailures <= 2) {
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_WRITE_MSG", this.getName()));
                    }
                } else if (this.deviceFailures != 0) {
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("RETRY_OK", this.getName()));
                    this.deviceFailures = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.closeDevice();
            if (this.getFileName() != null) {
                Enumeration e = this.getDirList(this.fileDir).elements();
                while (e.hasMoreElements()) {
                    File file = new File(this.fileDir + (String)e.nextElement());
                    if (!file.exists() || file.delete()) continue;
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_DELETE_FILE", this.getFileName()));
                }
            }
        }
    }
}

