/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.Manager;
import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.Klass;
import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.FfdcProviderDependent;
import com.ibm.ffdc.util.provider.Formatters;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PrivilegedActionException;
import java.util.IdentityHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncidentStream<T extends FfdcProvider>
extends FfdcProviderDependent<T>
implements com.ibm.ffdc.config.IncidentStream,
Cloneable {
    private final IdentityHashMap<Object, Object> history = new IdentityHashMap();
    private PrintStream pw;
    private final Formatters formatters;
    private final OutputStream os;
    private int introspectDepth = 4;
    private int depth;
    private static int MAX_INTROSPECT_DEPTH = 4;

    public IncidentStream(T provider, OutputStream os) {
        this(provider, os, new Formatters<T>(provider));
    }

    public IncidentStream(T provider, OutputStream os, Formatters formatters) {
        this(provider, os, formatters, MAX_INTROSPECT_DEPTH);
    }

    public IncidentStream(T provider, OutputStream os, Formatters formatters, int introspectDepth) {
        super(provider);
        this.formatters = formatters;
        this.os = os;
        this.introspectDepth = introspectDepth;
        this.pw = new PrintStream(os);
    }

    public void writeSimple(String label, Object o, boolean addNewLine) {
        int indent = this.depth - 1;
        if (label != null && label.endsWith("BEGIN")) {
            --indent;
        }
        for (int i = 0; i < indent; ++i) {
            this.pw.print(' ');
        }
        if (label != null && label.length() > 0) {
            this.pw.print(label);
            this.pw.print(":");
        }
        this.pw.print(o);
        if (addNewLine) {
            this.pw.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String label, Object value2, int depth) {
        if (depth <= 0 || depth > 10) {
            Manager.Ffdc.log(new IllegalArgumentException(), this, this.getClass().getName(), "86");
            return;
        }
        int oldDepth = this.introspectDepth;
        this.introspectDepth += depth;
        try {
            this.writeSimple(null, "IntrospectDepth set from:" + oldDepth + " to: " + this.introspectDepth, true);
            this.write(label, value2);
        }
        finally {
            this.introspectDepth = oldDepth;
            this.writeSimple(null, "IntrospectDepth reset to:" + this.introspectDepth, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(String label, Object object) {
        if (this.isSimple(object)) {
            this.writeSimple(label, object, true);
            return;
        }
        String tag = IncidentStream.o2tag(object);
        if (this.hasWritten(object)) {
            this.writeSimple(label, tag, true);
            return;
        }
        try {
            if (this.introspectDepth >= 0 && ++this.depth > this.introspectDepth) {
                this.writeSimple(label, tag + " depth limit reached", true);
                return;
            }
            this.writeSimple((label == null ? "" : label + " ") + "BEGIN", tag, true);
            this.write(object);
            this.writeSimple("END", tag, true);
            this.pw.println();
        }
        catch (IOEx e) {
            this.recover(tag, e);
        }
        catch (IOException e) {
            this.recover(tag, e);
        }
        catch (PrivilegedActionException e) {
            this.report(tag, e);
        }
        catch (RuntimeException e) {
            this.report(tag, e);
        }
        catch (StackOverflowError e) {
            try {
                this.pw.println(" ... truncated ...");
            }
            catch (StackOverflowError e2) {
                // empty catch block
            }
        }
        finally {
            if (this.introspectDepth > 0) {
                --this.depth;
            }
        }
    }

    static String o2tag(Object o) {
        String tag = o.getClass().getName() + "@";
        try {
            int hashcode = System.identityHashCode(o);
            return tag + Integer.toHexString(hashcode);
        }
        catch (Throwable th) {
            return tag + "null";
        }
    }

    private void recover(String tag, Exception e) {
        this.pw.println();
        boolean trouble = this.pw.checkError();
        if (trouble) {
            this.provider.abort(e);
            throw new IllegalStateException(e);
        }
        this.report(tag, e);
    }

    private void report(String tag, Exception e) {
        Manager.Ffdc.log(e, this, this.getClass().getName(), "report");
        this.writeSimple("FAILED", tag, true);
        this.pw.println();
    }

    private void write(final Object object) throws IOException, PrivilegedActionException {
        final Formatter f = this.formatters.getFormatter(object);
        IncidentStream.Writer<OutputStream> isWriter = f == Formatters.FormattableMarker ? new IncidentStream.Writer<OutputStream>(){

            @Override
            public void writeTo(OutputStream os1) {
                ((Formattable)object).formatTo(IncidentStream.this);
            }
        } : new IncidentStream.Writer<OutputStream>(){

            @Override
            public void writeTo(OutputStream os1) {
                f.formatTo(object, IncidentStream.this);
            }
        };
        isWriter.writeTo(this.os);
    }

    @Override
    public void write(IncidentStream.Writer<OutputStream> isWriter) {
        try {
            isWriter.writeTo(this.os);
        }
        catch (IOException e) {
            throw new IOEx(e);
        }
    }

    public void release() {
        this.pw = null;
        this.formatters.clear();
    }

    protected boolean hasWritten(Object object) {
        try {
            Object old = this.history.put(object, object);
            return object == old;
        }
        catch (Throwable th) {
            Manager.Ffdc.log(th, this, this.getClass().getName(), "212", object.getClass().getName());
            return true;
        }
    }

    private boolean isSimple(Object o) {
        return o == null || o instanceof Class || o instanceof String || o instanceof Logger || Klass.isPrimitive(o.getClass()) || Object.class.equals(o.getClass());
    }

    private static class IOEx
    extends IllegalStateException {
        public IOEx(Throwable cause) {
            super(cause);
        }
    }
}

