/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.Ffdc;
import com.ibm.ffdc.config.DataCollector;
import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentForwarder;
import com.ibm.ffdc.util.formatting.ArrayFormatter;
import com.ibm.ffdc.util.formatting.ByteArrayFormatter;
import com.ibm.ffdc.util.formatting.JavaUtilFormatter;
import com.ibm.ffdc.util.provider.ApplicableDataCollectors;
import com.ibm.ffdc.util.provider.CapturedDataElements;
import com.ibm.ffdc.util.provider.Incident;
import com.ibm.ffdc.util.provider.IncidentEntry;
import com.ibm.ffdc.util.provider.IncidentLogger;
import com.ibm.ffdc.util.provider.IncidentSummaryLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FfdcProvider
implements com.ibm.ffdc.provider.FfdcProvider {
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<DataCollector> collectors = new ArrayList<DataCollector>();
    private final List<IncidentForwarder> incidentFormatters = new ArrayList<IncidentForwarder>();
    private final TreeMap<IncidentEntry.Key, IncidentEntry[]> incidents = new TreeMap();
    private final List<Incident> incidentlist = new ArrayList<Incident>(10);
    private static final String LOGGER_NAME = "com.ibm.ffdc.util.provider.FfdcProvider";
    private static final Logger logger = Logger.getLogger("com.ibm.ffdc.util.provider.FfdcProvider");
    private int internalFailures;
    static int internalFailureLimit = 10;

    protected FfdcProvider() {
        this.formatters.add(new ByteArrayFormatter());
        this.formatters.add(new ArrayFormatter());
        this.formatters.add(new JavaUtilFormatter());
    }

    protected synchronized IncidentEntry getIncident(IncidentEntry.Key key, ClassLoader cldr) {
        IncidentEntry[] aIE = this.incidents.get(key);
        if (aIE == null) {
            return this.makeIncidentEntry(key, cldr, null);
        }
        IncidentEntry incidentEntry = aIE[0];
        if (incidentEntry.hasSameClassLoader(cldr)) {
            incidentEntry.increment();
            return incidentEntry;
        }
        for (int i = 1; i < aIE.length; ++i) {
            incidentEntry = aIE[i];
            if (!incidentEntry.hasSameClassLoader(cldr)) continue;
            incidentEntry.increment();
            return incidentEntry;
        }
        return this.makeIncidentEntry(key, cldr, aIE);
    }

    private IncidentEntry makeIncidentEntry(IncidentEntry.Key key, ClassLoader cldr, IncidentEntry[] aIE) {
        IncidentEntry[] aNewIE;
        IncidentEntry ie = new IncidentEntry(key, cldr);
        if (aIE == null) {
            aNewIE = new IncidentEntry[]{ie};
        } else {
            int oldLength = aIE.length;
            aNewIE = new IncidentEntry[oldLength + 1];
            System.arraycopy(aIE, 0, aNewIE, 0, oldLength);
            aNewIE[oldLength] = ie;
        }
        this.incidents.put(key, aNewIE);
        this.incidentlist.add(ie);
        return ie;
    }

    @Override
    public List<Incident> getIncidents() {
        return Collections.unmodifiableList(this.incidentlist);
    }

    @Override
    public boolean unblockLogging(Incident incident) {
        if (incident != null && incident instanceof IncidentEntry) {
            ((IncidentEntry)incident).unblockLogging();
            return true;
        }
        return false;
    }

    protected List<Formatter> getFormatters() {
        return this.copy(this.formatters);
    }

    @Override
    public void register(Formatter formatter) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "register", "Registering formatter: " + this.toString(formatter));
        }
        FfdcProvider.register(this.formatters, formatter);
    }

    @Override
    public void deregister(Formatter formatter) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "deregister", "Deegistering formatter: " + this.toString(formatter));
        }
        FfdcProvider.deregister(this.formatters, formatter);
    }

    public List<DataCollector> getDataCollectors() {
        return this.copy(this.collectors);
    }

    @Override
    public void register(DataCollector collector) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "register", "Registering data collector: " + this.toString(collector));
        }
        FfdcProvider.register(this.collectors, collector);
    }

    @Override
    public void deregister(DataCollector collector) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "deregister", "Deregistering data collector: " + this.toString(collector));
        }
        FfdcProvider.deregister(this.collectors, collector);
    }

    @Override
    public void register(IncidentForwarder processor) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "register", "Registering processor: " + this.toString(processor));
        }
        FfdcProvider.register(this.incidentFormatters, processor);
    }

    @Override
    public void deregister(IncidentForwarder processor) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "deregister", "Deregistering processor: " + this.toString(processor));
        }
        FfdcProvider.deregister(this.incidentFormatters, processor);
    }

    protected List<IncidentForwarder> getIncidentForwarders() {
        return this.incidentFormatters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void register(List<T> list, T t) {
        List<T> list2 = list;
        synchronized (list2) {
            if (t == null || list.contains(t)) {
                return;
            }
            list.add(0, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void deregister(List<T> list, T t) {
        List<T> list2 = list;
        synchronized (list2) {
            list.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> copy(List<T> source) {
        List<T> list = source;
        synchronized (list) {
            ArrayList<T> copy = new ArrayList<T>(source.size());
            copy.addAll(source);
            return copy;
        }
    }

    @Override
    public void release() {
        this.formatters.clear();
        this.collectors.clear();
        this.incidentFormatters.clear();
    }

    protected boolean isLoggable(IncidentEntry incident) {
        return incident.tag();
    }

    protected void log(IncidentEntry incident, Object reporter, Throwable th, Object[] cde) throws Exception {
        CapturedDataElements capturedDataElements = cde == null ? null : new CapturedDataElements(cde);
        this.log(incident, reporter, th, capturedDataElements);
    }

    protected void log(IncidentEntry incident, Object reporter, Throwable th, CapturedDataElements capturedDataElements) throws Exception {
        if (th == null) {
            Ffdc.log(new IllegalArgumentException(" Ffdc invoked with null throwable"), this, this.getClass().getName(), "log");
            return;
        }
        ArrayList<Formattable> data = new ArrayList<Formattable>(2);
        if (capturedDataElements != null) {
            data.add(capturedDataElements);
        }
        data.add(new ApplicableDataCollectors(this, th));
        this.logIncident(incident, reporter, th, data);
        if (!this.incidentFormatters.isEmpty()) {
            this.postProcess(incident, th);
        }
    }

    private void postProcess(IncidentEntry incident, Throwable th) {
        ListIterator<IncidentForwarder> iter = this.incidentFormatters.listIterator();
        while (iter.hasNext()) {
            IncidentForwarder processor = iter.next();
            try {
                processor.process(incident, th);
            }
            catch (Exception e) {
                iter.remove();
                Ffdc.log(e, this, this.getClass().getName(), "218");
            }
        }
    }

    protected void logIncident(IncidentEntry incident, Object reporter, Throwable th, List<Formattable> data) throws Exception {
    }

    @Override
    public Ffdc getFfdc(Throwable th, Object reporter, String sourceId, String probeId) {
        return new com.ibm.ffdc.util.provider.Ffdc(th, reporter, sourceId, probeId, this);
    }

    @Override
    public Ffdc getFfdc(Throwable th, Object reporter, String sourceId) {
        return this.getFfdc(th, reporter, sourceId, null);
    }

    @Override
    public void log(Throwable th, Object reporter, String sourceId, String probeId, Object ... args) {
        Ffdc ffdc = this.getFfdc(th, reporter, sourceId, probeId);
        if (ffdc.isLoggable()) {
            ffdc.log(args);
        }
    }

    @Override
    public void log(Throwable th, Object reporter, String sourceId, String probeId) {
        Ffdc ffdc = this.getFfdc(th, reporter, sourceId, probeId);
        if (ffdc.isLoggable()) {
            ffdc.log(new Object[0]);
        }
    }

    protected IncidentLogger getIncidentLogger() {
        throw new UnsupportedOperationException();
    }

    protected IncidentSummaryLogger getIncidentSummaryLogger() {
        throw new UnsupportedOperationException();
    }

    public void ffdcerror(Throwable th) {
        ++this.internalFailures;
        Logger logger1 = this.logger();
        if (logger1.isLoggable(Level.INFO)) {
            logger1.log(Level.INFO, "FFDC provider error", th);
        }
        if (this.internalFailures > internalFailureLimit) {
            com.ibm.ffdc.impl.Ffdc.abort(this, th);
        }
    }

    public void abort(Throwable th) {
        com.ibm.ffdc.impl.Ffdc.abort(this, th);
    }

    private String toString(Object obj) {
        try {
            return obj.toString();
        }
        catch (Exception e) {
            this.log(e, (Object)this, "toString", obj.getClass().getName());
            return "Class: " + obj.getClass().getName();
        }
    }

    public Logger logger() {
        return logger;
    }
}

