/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.am.AlarmManagerThreadBH;
import com.ibm.ejs.util.am.AlarmThreadPool;
import com.ibm.ejs.util.am._Alarm;
import com.ibm.ws.util.BinaryHeap;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import java.util.Vector;
import java.util.concurrent.Executor;

class AlarmManagerBH
implements AlarmManager.Implementation {
    private static final TraceComponent tc = Tr.register(AlarmManagerBH.class, null, null);
    public static final String ALARM_WORKBASED = "com.ibm.ejs.am.mode.workbased";
    static final BinaryHeap deferredAlarmQ = new BinaryHeap(new _Alarm());
    static final BinaryHeap nonDeferredAlarmQ = new BinaryHeap(new _Alarm());
    private static boolean initialized = false;
    private static boolean deferred = false;
    private static Vector deferredAlarmList = new Vector();
    private static int activeWork = 0;
    private static final Executor deferrableExecutor = new ThreadPoolExecutor(new AlarmThreadPool("Deferrable Alarm"));
    private static final Executor nondeferrableExecutor = new ThreadPoolExecutor(new AlarmThreadPool("Non-deferrable Alarm"));

    protected AlarmManagerBH() {
    }

    private static final synchronized void init() {
        if (initialized) {
            return;
        }
        if (PlatformHelperFactory.getPlatformHelper().isBaseServantJvm()) {
            deferred = true;
        }
        Thread dThread = new Thread((Runnable)new AlarmManagerThreadBH(deferredAlarmQ, deferred), "Deferred Alarm Manager");
        dThread.setDaemon(true);
        dThread.start();
        Thread ndThread = new Thread((Runnable)new AlarmManagerThreadBH(nonDeferredAlarmQ, false), "Non-Deferred Alarm Manager");
        ndThread.setDaemon(true);
        ndThread.start();
        initialized = true;
    }

    public final Alarm createNonDeferrable(long n, AlarmListener l, Object alarmContext) {
        return this.createNonDeferrable(n, l, alarmContext, nondeferrableExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Alarm createNonDeferrable(long n, AlarmListener l, Object alarmContext, Executor executor) {
        AlarmManagerBH.init();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonDeferrable", new Object[]{new Long(n), l, alarmContext, executor});
        }
        if (l == null) {
            throw new NullPointerException();
        }
        if (n < 0L) {
            n = 0L;
        }
        if ((n += System.currentTimeMillis()) < 0L) {
            n = Long.MAX_VALUE;
        }
        _Alarm result = new _Alarm(n, l, alarmContext, false, executor);
        BinaryHeap binaryHeap = nonDeferredAlarmQ;
        synchronized (binaryHeap) {
            nonDeferredAlarmQ.insert(result);
            if (result == nonDeferredAlarmQ.minimum()) {
                nonDeferredAlarmQ.notify();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonDeferrable", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Alarm createDeferrable(long n, AlarmListener l, Object alarmContext) {
        AlarmManagerBH.init();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeferrable", new Object[]{new Long(n), l, alarmContext});
        }
        if (l == null) {
            throw new NullPointerException();
        }
        if (n < 0L) {
            n = 0L;
        }
        _Alarm result = new _Alarm(n, l, alarmContext, true, deferrableExecutor);
        if (!deferred || activeWork > 0) {
            BinaryHeap binaryHeap = deferredAlarmQ;
            synchronized (binaryHeap) {
                result.expirationTime += System.currentTimeMillis();
                if (result.expirationTime < 0L) {
                    result.expirationTime = Long.MAX_VALUE;
                }
                deferredAlarmQ.insert(result);
                if (result == deferredAlarmQ.minimum()) {
                    deferredAlarmQ.notify();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Alarm has been deferred", result);
        }
        Vector vector = deferredAlarmList;
        synchronized (vector) {
            deferredAlarmList.add(result);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeferrable", result);
        }
        return result;
    }

    public final void cancel(Alarm a) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
        this.disableAlarm(a);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disableAlarm(Alarm a) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "disableAlarm", a);
        }
        boolean disabled = false;
        if (((_Alarm)a).deferrable) {
            BinaryHeap binaryHeap = deferredAlarmQ;
            synchronized (binaryHeap) {
                Vector vector = deferredAlarmList;
                synchronized (vector) {
                    if (!((_Alarm)a).fired) {
                        deferredAlarmQ.delete((_Alarm)a);
                        deferredAlarmList.remove((_Alarm)a);
                        disabled = true;
                    }
                }
            }
        }
        BinaryHeap binaryHeap = nonDeferredAlarmQ;
        synchronized (binaryHeap) {
            if (!((_Alarm)a).fired) {
                nonDeferredAlarmQ.delete((_Alarm)a);
                disabled = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "disableAlarm", disabled);
        }
        return disabled;
    }

    private final void armDeferredAlarms() {
        this.createNonDeferrable(1000L, new AlarmListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alarm(Object alarmContext) {
                _Alarm result = null;
                BinaryHeap binaryHeap = deferredAlarmQ;
                synchronized (binaryHeap) {
                    Vector vector = deferredAlarmList;
                    synchronized (vector) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Starting arm of " + deferredAlarmList.size() + " deferred alarms");
                        }
                        for (int ix = 0; ix < deferredAlarmList.size(); ++ix) {
                            result = (_Alarm)deferredAlarmList.elementAt(ix);
                            result.expirationTime += System.currentTimeMillis();
                            if (result.expirationTime < 0L) {
                                result.expirationTime = Long.MAX_VALUE;
                            }
                            deferredAlarmQ.insert(result);
                        }
                        deferredAlarmList.clear();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Completed arm of deferred alarms");
                        }
                        deferredAlarmQ.notify();
                    }
                }
            }
        }, null);
    }

    public synchronized void incActiveWork() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "activeWork = " + activeWork);
        }
        if (activeWork == 0) {
            this.armDeferredAlarms();
        }
        ++activeWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decActiveWork() {
        BinaryHeap binaryHeap = deferredAlarmQ;
        synchronized (binaryHeap) {
            Class<AlarmManagerBH> clazz = AlarmManagerBH.class;
            synchronized (AlarmManagerBH.class) {
                --activeWork;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "activeWork = " + activeWork);
                }
                if (activeWork == 0) {
                    deferredAlarmQ.notify();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    public synchronized int getActiveWork() {
        return activeWork;
    }

    private static class ThreadPoolExecutor
    implements Executor {
        private ThreadPool threadPool;

        public ThreadPoolExecutor(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public String toString() {
            return super.toString() + '[' + this.threadPool + ']';
        }

        public void execute(Runnable command) {
            try {
                this.threadPool.execute(command);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

