/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras.ffdc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.ffdc.IncidentLogger;
import com.ibm.ejs.ras.ffdc.IncidentSummaryLogger;
import com.ibm.ffdc.Ffdc;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FfdcProvider
extends com.ibm.ffdc.util.provider.FfdcProvider
implements com.ibm.ffdc.provider.FfdcProvider {
    private IncidentLogger<FfdcProvider> incidentLogger;
    private IncidentSummaryLogger incidentSummaryLogger;
    private static final String className = FfdcProvider.class.getName();
    private static final TraceComponent tc = Tr.register(className);
    private static final String ALT_FFDC_LOG_FILE = "com.ibm.ejs.ras.lite.ffdcLogFile";
    private static String ffdcFileName;
    private static final String COMMA_PATTERN = ",";
    private static Set<Source> _ignoredSources;
    private static final int internalErrorsLimit = 10;
    private int internalErrors = 0;
    static boolean reportedError;

    private static void ignoreSource(String sourceid, String probeid) {
        Tr.debug(tc, "Ignoring FFDCs from sourceid=" + sourceid + " and probeid=" + probeid);
        _ignoredSources.add(new Source(sourceid, probeid));
    }

    @Override
    public IncidentSummaryLogger getIncidentSummaryLogger() {
        if (this.incidentSummaryLogger == null) {
            this.incidentSummaryLogger = new IncidentSummaryLogger(this);
        }
        return this.incidentSummaryLogger;
    }

    @Override
    public synchronized IncidentLogger<FfdcProvider> getIncidentLogger() {
        if (this.incidentLogger == null) {
            this.incidentLogger = new IncidentLogger<FfdcProvider>(this);
        }
        return this.incidentLogger;
    }

    @Override
    public Ffdc getFfdc(Throwable th, Object reporter, String sourceId, String probeId) {
        return new com.ibm.ffdc.util.provider.Ffdc(th, reporter, sourceId, probeId, this);
    }

    @Override
    public Ffdc getFfdc(Throwable th, Object reporter, String sourceId) {
        return this.getFfdc(th, reporter, sourceId, null);
    }

    @Override
    public void log(Throwable th, Object reporter, String sourceId, String probeId, Object ... args) {
        Ffdc ffdc = this.getFfdc(th, reporter, sourceId, probeId);
        if (ffdc.isLoggable() && !_ignoredSources.contains(new Source(sourceId, probeId))) {
            ffdc.log(args);
        }
    }

    @Override
    public void log(Throwable th, Object reporter, String sourceId, String probeId) {
        Ffdc ffdc = this.getFfdc(th, reporter, sourceId, probeId);
        if (ffdc.isLoggable() && !_ignoredSources.contains(new Source(sourceId, probeId))) {
            ffdc.log(new Object[0]);
        }
    }

    @Override
    public void ffdcerror(Throwable th) {
        if (++this.internalErrors < 10) {
            try {
                th.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static PrintStream getFFDCFilePrintStream() {
        PrintStream ps = null;
        if (ffdcFileName != null) {
            try {
                FileOutputStream fos = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws FileNotFoundException {
                        return new FileOutputStream(ffdcFileName, true);
                    }
                });
                ps = new PrintStream(fos, true);
            }
            catch (PrivilegedActionException e) {
                if (!reportedError) {
                    reportedError = true;
                    e.printStackTrace(System.err);
                }
                ps = System.err;
            }
        }
        return ps;
    }

    static {
        _ignoredSources = new HashSet<Source>();
        try {
            ffdcFileName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(FfdcProvider.ALT_FFDC_LOG_FILE);
                }
            });
            if (ffdcFileName == null) {
                ffdcFileName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("ffdcLogFile");
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace(System.err);
        }
        List<String> ignoreList = Tr.getFfdcIgnoreList();
        for (String ignore : ignoreList) {
            String[] fields = ignore.split(COMMA_PATTERN);
            if (fields.length <= 1 || fields[0] == null || fields[1] == null) continue;
            FfdcProvider.ignoreSource(fields[0], fields[1]);
        }
        reportedError = false;
    }

    private static final class Source {
        private static final int _PRIME = 1000003;
        private String _sourceId = "";
        private String _probeId = "";

        public Source(String source, String probe) {
            if (source != null) {
                this._sourceId = source;
            }
            if (probe != null) {
                this._probeId = probe;
            }
        }

        public int hashCode() {
            return this._sourceId.hashCode() * 1000003 + this._probeId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            Source other = (Source)o;
            if (this._sourceId == null && other._sourceId != null) {
                return false;
            }
            if (this._probeId == null && other._probeId != null) {
                return false;
            }
            if (this._sourceId != null && !this._sourceId.equals(other._sourceId)) {
                return false;
            }
            return this._probeId == null || this._probeId.equals(other._probeId);
        }

        public String getProbeId() {
            return this._probeId;
        }

        public String getSourceId() {
            return this._sourceId;
        }
    }
}

