/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.apache.harmony.logging.internal.nls.Messages;

public class FileHandler
extends StreamHandler {
    private static final String LCK_EXT = ".lck";
    private static final int DEFAULT_COUNT = 1;
    private static final int DEFAULT_LIMIT = 0;
    private static final boolean DEFAULT_APPEND = false;
    private static final String DEFAULT_PATTERN = "%h/java%u.log";
    private static final Hashtable<String, FileLock> allLocks = new Hashtable();
    private int count;
    private int limit;
    private boolean append;
    private String pattern;
    private LogManager manager;
    private MeasureOutputStream output;
    private File[] files;
    FileLock lock = null;
    String fileName = null;
    int uniqueID = -1;

    public FileHandler() throws IOException {
        this.init(null, null, null, null);
    }

    private void init(String string, Boolean bl, Integer n, Integer n2) throws IOException {
        this.manager = LogManager.getLogManager();
        this.manager.checkAccess();
        this.initProperties(string, bl, n, n2);
        this.initOutputFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initOutputFiles() throws FileNotFoundException, IOException {
        while (true) {
            ++this.uniqueID;
            for (int i = 0; i < this.count; ++i) {
                this.files[i] = new File(this.parseFileName(i));
            }
            this.fileName = this.files[0].getAbsolutePath();
            Hashtable<String, FileLock> hashtable = allLocks;
            synchronized (hashtable) {
                if (null != allLocks.get(this.fileName)) {
                    continue;
                }
                if (this.files[0].exists() && (!this.append || this.files[0].length() >= (long)this.limit)) {
                    for (int i = this.count - 1; i > 0; --i) {
                        if (this.files[i].exists()) {
                            this.files[i].delete();
                        }
                        this.files[i - 1].renameTo(this.files[i]);
                    }
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.fileName + LCK_EXT);
                FileChannel fileChannel = fileOutputStream.getChannel();
                this.lock = fileChannel.tryLock();
                if (null != this.lock) {
                    allLocks.put(this.fileName, this.lock);
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 7] lbl26 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.output = new MeasureOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName, this.append)), this.files[0].length());
                    this.setOutputStream(this.output);
                    return;
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void initProperties(String string, Boolean bl, Integer n, Integer n2) {
        super.initProperties("ALL", null, "java.util.logging.XMLFormatter", null);
        String string2 = this.getClass().getName();
        String string3 = this.pattern = null == string ? this.getStringProperty(string2 + ".pattern", DEFAULT_PATTERN) : string;
        if (null == this.pattern || "".equals(this.pattern)) {
            throw new NullPointerException(Messages.getString("logging.19"));
        }
        this.append = null == bl ? this.getBooleanProperty(string2 + ".append", false) : bl.booleanValue();
        this.count = null == n2 ? this.getIntProperty(string2 + ".count", 1) : n2.intValue();
        this.limit = null == n ? this.getIntProperty(string2 + ".limit", 0) : n.intValue();
        this.count = this.count < 1 ? 1 : this.count;
        this.limit = this.limit < 0 ? 0 : this.limit;
        this.files = new File[this.count];
    }

    void findNextGeneration() {
        super.close();
        for (int i = this.count - 1; i > 0; --i) {
            if (this.files[i].exists()) {
                this.files[i].delete();
            }
            this.files[i - 1].renameTo(this.files[i]);
        }
        try {
            this.output = new MeasureOutputStream(new BufferedOutputStream(new FileOutputStream(this.files[0])));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getErrorManager().error(Messages.getString("logging.1A"), fileNotFoundException, 4);
        }
        this.setOutputStream(this.output);
    }

    private String parseFileName(int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = System.getProperty("java.io.tmpdir");
        boolean bl3 = string == null ? false : string.endsWith(File.separator);
        String string2 = System.getProperty("user.home");
        boolean bl4 = string2 == null ? false : string2.endsWith(File.separator);
        StringBuilder stringBuilder = new StringBuilder();
        this.pattern = this.pattern.replace('/', File.separatorChar);
        char[] cArray = this.pattern.toCharArray();
        while ((n3 = this.pattern.indexOf(37, n2)) >= 0) {
            if (++n3 >= this.pattern.length()) continue;
            switch (cArray[n3]) {
                case 'g': {
                    stringBuilder.append(cArray, n2, n3 - n2 - 1).append(n);
                    bl2 = true;
                    break;
                }
                case 'u': {
                    stringBuilder.append(cArray, n2, n3 - n2 - 1).append(this.uniqueID);
                    bl = true;
                    break;
                }
                case 't': {
                    stringBuilder.append(cArray, n2, n3 - n2 - 1).append(string);
                    if (bl3) break;
                    stringBuilder.append(File.separator);
                    break;
                }
                case 'h': {
                    stringBuilder.append(cArray, n2, n3 - n2 - 1).append(string2);
                    if (bl4) break;
                    stringBuilder.append(File.separator);
                    break;
                }
                case '%': {
                    stringBuilder.append(cArray, n2, n3 - n2 - 1).append('%');
                    break;
                }
                default: {
                    stringBuilder.append(cArray, n2, n3 - n2);
                }
            }
            n2 = ++n3;
        }
        stringBuilder.append(cArray, n2, cArray.length - n2);
        if (!bl2 && this.count > 1) {
            stringBuilder.append(".").append(n);
        }
        if (!bl && this.uniqueID > 0) {
            stringBuilder.append(".").append(this.uniqueID);
        }
        return stringBuilder.toString();
    }

    private boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.manager.getProperty(string);
        if (null == string2) {
            return bl;
        }
        boolean bl2 = bl;
        if ("true".equalsIgnoreCase(string2)) {
            bl2 = true;
        } else if ("false".equalsIgnoreCase(string2)) {
            bl2 = false;
        }
        return bl2;
    }

    private String getStringProperty(String string, String string2) {
        String string3 = this.manager.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    private int getIntProperty(String string, int n) {
        String string2 = this.manager.getProperty(string);
        int n2 = n;
        if (null != string2) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public FileHandler(String string) throws IOException {
        if (string.equals("")) {
            throw new IllegalArgumentException(Messages.getString("logging.19"));
        }
        this.init(string, null, 0, 1);
    }

    public FileHandler(String string, boolean bl) throws IOException {
        if (string.equals("")) {
            throw new IllegalArgumentException(Messages.getString("logging.19"));
        }
        this.init(string, bl, 0, 1);
    }

    public FileHandler(String string, int n, int n2) throws IOException {
        if (string.equals("")) {
            throw new IllegalArgumentException(Messages.getString("logging.19"));
        }
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException(Messages.getString("logging.1B"));
        }
        this.init(string, null, n, n2);
    }

    public FileHandler(String string, int n, int n2, boolean bl) throws IOException {
        if (string.equals("")) {
            throw new IllegalArgumentException(Messages.getString("logging.19"));
        }
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException(Messages.getString("logging.1B"));
        }
        this.init(string, bl, n, n2);
    }

    @Override
    public void close() {
        super.close();
        allLocks.remove(this.fileName);
        try {
            FileChannel fileChannel = this.lock.channel();
            this.lock.release();
            fileChannel.close();
            File file = new File(this.fileName + LCK_EXT);
            file.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        super.publish(logRecord);
        this.flush();
        if (this.limit > 0 && this.output.getLength() >= (long)this.limit) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FileHandler.this.findNextGeneration();
                    return null;
                }
            });
        }
    }

    static class MeasureOutputStream
    extends OutputStream {
        OutputStream wrapped;
        long length;

        public MeasureOutputStream(OutputStream outputStream, long l) {
            this.wrapped = outputStream;
            this.length = l;
        }

        public MeasureOutputStream(OutputStream outputStream) {
            this(outputStream, 0L);
        }

        @Override
        public void write(int n) throws IOException {
            this.wrapped.write(n);
            ++this.length;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.wrapped.write(byArray);
            this.length += (long)byArray.length;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.wrapped.write(byArray, n, n2);
            this.length += (long)n2;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public void flush() throws IOException {
            this.wrapped.flush();
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long l) {
            this.length = l;
        }
    }
}

