/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.AvailableProcessorsNotificationInfo;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.OperatingSystemMXBeanImpl;
import com.ibm.lang.management.OperatingSystemNotificationThreadShutdown;
import com.ibm.lang.management.ProcessingCapacityNotificationInfo;
import com.ibm.lang.management.TotalPhysicalMemoryNotificationInfo;
import javax.management.Notification;

class OperatingSystemNotificationThread
extends Thread {
    private final OperatingSystemMXBeanImpl osBean;

    public OperatingSystemNotificationThread(OperatingSystemMXBeanImpl osBean) {
        this.osBean = osBean;
    }

    public void run() {
        OperatingSystemNotificationThreadShutdown myShutdownNotifier = new OperatingSystemNotificationThreadShutdown(this);
        try {
            Runtime.getRuntime().addShutdownHook(myShutdownNotifier);
        }
        catch (IllegalStateException e) {
            return;
        }
        this.processNotificationLoop();
    }

    private native void processNotificationLoop();

    private void dispatchNotificationHelper(int type, long data, long sequenceNumber) {
        if (type == 1) {
            AvailableProcessorsNotificationInfo info = new AvailableProcessorsNotificationInfo((int)data);
            Notification n = new Notification("com.ibm.management.available.processors.change", "java.lang:type=OperatingSystem", sequenceNumber);
            n.setUserData(ManagementUtils.toAvailableProcessorsNotificationInfoCompositeData(info));
            this.osBean.sendNotification(n);
        } else if (type == 2) {
            ProcessingCapacityNotificationInfo info = new ProcessingCapacityNotificationInfo((int)data);
            Notification n = new Notification("com.ibm.management.processing.capacity.change", "java.lang:type=OperatingSystem", sequenceNumber);
            n.setUserData(ManagementUtils.toProcessingCapacityNotificationInfoCompositeData(info));
            this.osBean.sendNotification(n);
        } else if (type == 3) {
            TotalPhysicalMemoryNotificationInfo info = new TotalPhysicalMemoryNotificationInfo(data);
            Notification n = new Notification("com.ibm.management.total.physical.memory.change", "java.lang:type=OperatingSystem", sequenceNumber);
            n.setUserData(ManagementUtils.toTotalPhysicalMemoryNotificationInfoCompositeData(info));
            this.osBean.sendNotification(n);
        }
    }
}

