/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryPoolMXBean;
import com.ibm.lang.management.MemoryPoolMXBeanImpl;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryManagerMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryManagerMXBean {
    protected final String name;
    protected final int id;
    private List<MemoryPoolMXBean> managedPoolList;

    MemoryManagerMXBeanImpl(String name, int id, MemoryMXBeanImpl memBean) {
        this.name = name;
        this.id = id;
        this.initializeInfo();
        this.managedPoolList = new LinkedList<MemoryPoolMXBean>();
        this.createMemoryPools(id, memBean);
    }

    protected void initializeInfo() {
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(MemoryManagerMXBean.class.getName()));
    }

    private native void createMemoryPools(int var1, MemoryMXBeanImpl var2);

    private void createMemoryPoolHelper(String name, boolean isHeap, int internalID, MemoryMXBeanImpl memBean) {
        this.managedPoolList.add(new MemoryPoolMXBeanImpl(name, isHeap ? MemoryType.HEAP : MemoryType.NON_HEAP, internalID, memBean));
    }

    List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return this.managedPoolList;
    }

    @Override
    public String[] getMemoryPoolNames() {
        String[] names = new String[this.managedPoolList.size()];
        int idx = 0;
        Iterator<MemoryPoolMXBean> iter = this.managedPoolList.iterator();
        while (iter.hasNext()) {
            names[idx++] = iter.next().getName();
        }
        return names;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private native boolean isValidImpl();

    @Override
    public boolean isValid() {
        return this.isValidImpl();
    }
}

