/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingMXBeanImpl
extends DynamicMXBeanImpl
implements LoggingMXBean {
    private static LoggingMXBeanImpl instance = new LoggingMXBeanImpl();

    private LoggingMXBeanImpl() {
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(LoggingMXBean.class.getName()));
    }

    static LoggingMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        String result = null;
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null) {
            Level level = logger.getLevel();
            result = level != null ? level.getName() : "";
        }
        return result;
    }

    @Override
    public List<String> getLoggerNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                result.add(enumeration.nextElement());
            }
        }
        return result;
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        String result = null;
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null) {
            Logger parent = logger.getParent();
            result = parent != null ? parent.getName() : "";
        }
        return result;
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelName) {
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger == null) {
            throw new IllegalArgumentException("Unable to find Logger with name " + loggerName);
        }
        Level newLevel = Level.parse(levelName);
        logger.setLevel(newLevel);
    }
}

