/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.jgss.Debug;
import com.ibm.security.jgss.GSSCredentialImpl;
import com.ibm.security.jgss.GSSManagerImpl;
import com.ibm.security.jgss.GSSNameImpl;
import com.ibm.security.jgss.TokenHeader;
import com.ibm.security.jgss.mech.spnego.ContextFlags;
import com.ibm.security.jgss.mech.spnego.InitNegToken;
import com.ibm.security.jgss.mech.spnego.MechTypeList;
import com.ibm.security.jgss.mech.spnego.TargNegToken;
import com.ibm.security.jgss.spi.GSSContextSpi;
import com.ibm.security.jgss.spi.GSSCredentialSpi;
import com.ibm.security.jgss.spi.GSSNameSpi;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class SPNEGOContext
implements GSSContextSpi {
    private Provider provider;
    private GSSNameSpi target;
    private GSSCredentialSpi cred;
    private int desiredLifetime;
    private long starttime;
    private boolean initiator;
    private boolean disposed;
    private boolean established;
    private boolean beforeCallSecContext = true;
    private static Debug debug = new Debug();
    private final String msKrbOid = "1.2.840.48018.1.2.2";
    private final String mitKrbOid = "1.2.840.113554.1.2.2";
    private boolean[] reqFlagsState = new boolean[7];
    private boolean[] origFlagsState = new boolean[7];
    private Oid[] mechTypes;
    private MechTypeList list;
    private GSSCredential negCreds;
    private GSSManagerImpl manager;
    private GSSContextSpi context;
    private Oid supportedMech;
    private boolean msToken = false;
    private GSSContext ctx;

    public SPNEGOContext(GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        if (gSSCredentialSpi == null) {
            throw new GSSException(13);
        }
        if (gSSCredentialSpi.getAcceptLifetime() <= 0) {
            throw new GSSException(8);
        }
        if (gSSCredentialSpi.isInitiatorCredential()) {
            throw new GSSException(13, 0, "Not an acceptor credential");
        }
        this.cred = gSSCredentialSpi;
        this.initiator = false;
        this.desiredLifetime = gSSCredentialSpi.getAcceptLifetime();
        this.starttime = System.currentTimeMillis() / 1000L;
    }

    public SPNEGOContext(GSSCredentialSpi gSSCredentialSpi, GSSContext gSSContext) throws GSSException {
        this(gSSCredentialSpi);
        this.ctx = gSSContext;
    }

    public SPNEGOContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) throws GSSException {
        if (gSSNameSpi == null) {
            throw new GSSException(3, 0, "GSS peer name can not be null");
        }
        if (gSSCredentialSpi != null) {
            this.cred = gSSCredentialSpi;
            if (gSSCredentialSpi.getInitLifetime() <= 0) {
                throw new GSSException(8);
            }
            if (!this.cred.isInitiatorCredential()) {
                throw new GSSException(13, 0, "Not an initiator credential");
            }
        } else {
            throw new GSSException(13);
        }
        this.target = gSSNameSpi;
        this.desiredLifetime = n;
        this.starttime = System.currentTimeMillis() / 1000L;
        this.initiator = true;
    }

    public SPNEGOContext(byte[] byArray) throws GSSException {
        throw new GSSException(16, 0, "Not implemented");
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(16);
        }
        this.reqFlagsState[4] = bl;
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(16);
        }
        this.reqFlagsState[5] = bl;
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(16);
        }
        this.reqFlagsState[6] = bl;
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(16);
        }
        this.reqFlagsState[2] = bl;
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(16);
        }
        this.reqFlagsState[0] = bl;
    }

    public void requestConf(boolean bl) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(16);
        }
        this.reqFlagsState[1] = bl;
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(16);
        }
        this.reqFlagsState[3] = bl;
    }

    public void requestLifetime(int n) throws GSSException {
        if (!this.initiator || !this.beforeCallSecContext) {
            throw new GSSException(15);
        }
        this.desiredLifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (!this.established) {
            throw new GSSException(16, 0, "Not implemented");
        }
        this.context.setChannelBinding(channelBinding);
    }

    public void setNegMechs(Oid[] oidArray, GSSCredential gSSCredential) throws GSSException {
        this.mechTypes = (Oid[])oidArray.clone();
        this.negCreds = gSSCredential;
    }

    public boolean getCredDelegState() {
        if (!this.established) {
            return this.reqFlagsState[2];
        }
        return this.context.getCredDelegState();
    }

    public boolean getMutualAuthState() {
        if (!this.established) {
            return this.reqFlagsState[4];
        }
        return this.context.getMutualAuthState();
    }

    public boolean getReplayDetState() {
        if (!this.established) {
            return this.reqFlagsState[5];
        }
        return this.context.getReplayDetState();
    }

    public boolean getSequenceDetState() {
        if (!this.established) {
            return this.reqFlagsState[6];
        }
        return this.context.getSequenceDetState();
    }

    public boolean getAnonymityState() {
        if (!this.established) {
            return this.reqFlagsState[0];
        }
        return this.context.getAnonymityState();
    }

    public boolean isTransferable() throws GSSException {
        if (!this.established) {
            return false;
        }
        return this.context.isTransferable();
    }

    public boolean isProtReady() {
        if (!this.established) {
            return false;
        }
        return this.context.isProtReady();
    }

    public boolean getConfState() {
        if (!this.established) {
            return this.reqFlagsState[1];
        }
        return this.context.getConfState();
    }

    public boolean getIntegState() {
        if (!this.established) {
            return this.reqFlagsState[3];
        }
        return this.context.getIntegState();
    }

    public int getLifetime() {
        if (!this.established) {
            return this.desiredLifetime;
        }
        return Math.min(this.context.getLifetime(), (int)(this.starttime + (long)this.desiredLifetime - System.currentTimeMillis() / 1000L));
    }

    public boolean isEstablished() {
        return this.established;
    }

    public GSSNameSpi getSrcName() throws GSSException {
        if (this.established) {
            return this.context.getSrcName();
        }
        if (!this.initiator) {
            throw new GSSException(11);
        }
        return this.cred.getName();
    }

    public GSSNameSpi getTargName() throws GSSException {
        if (this.established) {
            return this.context.getTargName();
        }
        if (this.initiator) {
            return this.target;
        }
        return this.cred.getName();
    }

    public Oid getMech() throws GSSException {
        if (this.established) {
            return this.supportedMech;
        }
        return GSSManagerImpl.MECH_TYPE_SPNEGO;
    }

    public GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.established && !this.initiator) {
            return this.context.getDelegCred();
        }
        throw new GSSException(16);
    }

    public byte[] initSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray;
        this.beforeCallSecContext = false;
        if (inputStream == null) {
            if (this.initiator && !this.disposed) {
                try {
                    return this.createInitToken();
                }
                catch (IOException iOException) {
                    throw new GSSException(12, 0, iOException.getMessage());
                }
                catch (GSSException gSSException) {
                    throw gSSException;
                }
            }
            throw new GSSException(12);
        }
        try {
            byArray = this.getTotalBytes(inputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(11, 0, "Error reading input stream");
        }
        if (byArray.length < n) {
            throw new GSSException(11, 0, "Length of input stream read does not match size of the inner context token");
        }
        try {
            byte[] byArray2 = this.processTargToken(byArray);
            return byArray2;
        }
        catch (IOException iOException) {
            throw new GSSException(11, 0, "Error reading input stream");
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
    }

    public byte[] acceptSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray;
        this.beforeCallSecContext = false;
        if (this.initiator || this.disposed) {
            throw new GSSException(12);
        }
        try {
            byArray = this.getTotalBytes(inputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(11, 0, "Error reading input stream");
        }
        if (byArray.length < n) {
            throw new GSSException(11, 0, "Length of input stream read does not match size of the inner context token");
        }
        try {
            DerValue derValue = new DerValue(byArray);
            if ((derValue.getTag() & 0x1F) == 0) {
                InitNegToken initNegToken = new InitNegToken(derValue.getData());
                byte[] byArray2 = this.processInitToken(initNegToken);
                return byArray2;
            }
            throw new GSSException(11, 0, "Invalid token tag");
        }
        catch (IOException iOException) {
            throw new GSSException(11, 0, "Error reading input stream");
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (this.established) {
            return this.context.getWrapSizeLimit(n, bl, n2);
        }
        throw new GSSException(16);
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (!this.established) {
            throw new GSSException(16);
        }
        this.context.wrap(inputStream, outputStream, messageProp);
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.established) {
            return this.context.wrap(byArray, n, n2, messageProp);
        }
        throw new GSSException(16);
    }

    public int wrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        if (this.established) {
            debug.out(4, "SPNEGO: message wrap");
            byte[] byArray3 = this.context.wrap(byArray, n, n2, messageProp);
            if (byArray3 == null || byArray2 == null) {
                debug.out(4, "SPNEGO: wrap result is null");
                return 0;
            }
            if (byArray2.length - n3 < byArray3.length) {
                throw new GSSException(11, 0, "Result (len=" + byArray3 + ") will not fit " + "into provided buffer");
            }
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
            return byArray3.length;
        }
        throw new GSSException(16, 0, "Not implemented");
    }

    public void wrap(byte[] byArray, int n, int n2, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.established) {
            byte[] byArray2 = this.context.wrap(byArray, n, n2, messageProp);
            if (byArray2 == null || outputStream == null) {
                return;
            }
            try {
                outputStream.write(byArray2);
                outputStream.flush();
            }
            catch (IOException iOException) {
                throw new GSSException(11, 0, "Error in wrap: " + iOException.toString());
            }
        } else {
            throw new GSSException(16);
        }
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (!this.established) {
            throw new GSSException(16);
        }
        this.context.unwrap(inputStream, outputStream, messageProp);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.established) {
            return this.context.unwrap(byArray, n, n2, messageProp);
        }
        throw new GSSException(16);
    }

    public int unwrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        if (this.established) {
            byte[] byArray3 = this.context.unwrap(byArray, n, n2, messageProp);
            if (byArray3 == null || byArray2 == null) {
                return 0;
            }
            if (byArray2.length - n3 < byArray3.length) {
                throw new GSSException(11, 0, "Result (len=" + byArray3 + ") will not fit " + "into provided buffer");
            }
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
            return byArray3.length;
        }
        throw new GSSException(16);
    }

    public int unwrap(InputStream inputStream, byte[] byArray, int n, MessageProp messageProp) throws GSSException {
        if (this.established) {
            byte[] byArray2 = null;
            try {
                byArray2 = this.getTotalBytes(inputStream);
            }
            catch (IOException iOException) {
                throw new GSSException(11, 0, "Error parsing input stream");
            }
            return this.unwrap(byArray2, 0, byArray2.length, byArray, n, messageProp);
        }
        throw new GSSException(16);
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (!this.established) {
            throw new GSSException(16);
        }
        this.context.getMIC(inputStream, outputStream, messageProp);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.established) {
            return this.context.getMIC(byArray, n, n2, messageProp);
        }
        throw new GSSException(16);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (!this.established) {
            throw new GSSException(16);
        }
        this.context.verifyMIC(inputStream, inputStream2, messageProp);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (!this.established) {
            throw new GSSException(16);
        }
        this.context.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
    }

    public byte[] export() throws GSSException {
        if (this.established) {
            return this.context.export();
        }
        throw new GSSException(16, 0, "Unsupported function");
    }

    public void dispose() throws GSSException {
        this.disposed = true;
        this.cred = null;
        this.target = null;
        this.established = false;
        if (this.context != null) {
            this.context.dispose();
            this.context = null;
        }
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    private byte[] getTotalBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void createContext(Oid oid) throws GSSException {
        if (this.manager == null) {
            try {
                this.manager = (GSSManagerImpl)GSSManager.getInstance();
            }
            catch (ClassCastException classCastException) {
                throw new GSSException(11, 0, "IBM GSSManager not found");
            }
            catch (Exception exception) {
                throw new GSSException(11, 0, "IBM GSSManager not found");
            }
        }
        if (this.context != null) {
            this.context.dispose();
            this.context = null;
        }
        GSSCredentialImpl gSSCredentialImpl = null;
        try {
            gSSCredentialImpl = (GSSCredentialImpl)this.negCreds;
        }
        catch (ClassCastException classCastException) {
            throw new GSSException(11, 0, "IBM GSSCredential not found");
        }
        GSSCredentialSpi gSSCredentialSpi = null;
        GSSNameImpl gSSNameImpl = null;
        if (this.initiator) {
            try {
                gSSNameImpl = this.manager.createName(this.target);
                if (gSSNameImpl.getMechName(oid) == null) {
                    gSSNameImpl.canonicalize(oid);
                }
            }
            catch (GSSException gSSException) {
                throw new GSSException(11, 1, "Can not create target name for specified mechanism");
            }
            try {
                gSSCredentialSpi = gSSCredentialImpl.getCred(oid, 1);
                if (gSSCredentialSpi != null) {
                    this.context = this.manager.createMechContext(gSSNameImpl.getMechName(oid), gSSCredentialSpi, this.getLifetime(), oid);
                    return;
                }
            }
            catch (GSSException gSSException) {
                gSSCredentialSpi = null;
            }
            if (gSSCredentialSpi == null) {
                try {
                    gSSCredentialSpi = gSSCredentialImpl.getCred(oid, 0);
                    if (gSSCredentialSpi != null) {
                        this.context = this.manager.createMechContext(gSSNameImpl.getMechName(oid), gSSCredentialSpi, this.getLifetime(), oid);
                        return;
                    }
                }
                catch (GSSException gSSException) {
                    gSSCredentialSpi = null;
                }
            }
        } else {
            try {
                gSSCredentialSpi = gSSCredentialImpl.getCred(oid, 2);
                if (gSSCredentialSpi != null) {
                    this.context = this.ctx != null ? this.manager.createMechContext(gSSCredentialSpi, oid, this.ctx) : this.manager.createMechContext(gSSCredentialSpi, oid);
                    return;
                }
            }
            catch (GSSException gSSException) {
                gSSCredentialSpi = null;
            }
            if (gSSCredentialSpi == null) {
                try {
                    gSSCredentialSpi = gSSCredentialImpl.getCred(oid, 0);
                    if (gSSCredentialSpi != null) {
                        this.context = this.ctx != null ? this.manager.createMechContext(gSSCredentialSpi, oid, this.ctx) : this.manager.createMechContext(gSSCredentialSpi, oid);
                        return;
                    }
                }
                catch (GSSException gSSException) {
                    gSSCredentialSpi = null;
                }
            }
        }
        if (gSSCredentialSpi == null) {
            gSSCredentialSpi = this.createCredSpi(this.manager, oid);
        }
        if (gSSCredentialSpi != null) {
            this.context = this.initiator ? this.manager.createMechContext(gSSNameImpl.getMechName(oid), gSSCredentialSpi, this.getLifetime(), oid) : (this.ctx != null ? this.manager.createMechContext(gSSCredentialSpi, oid, this.ctx) : this.manager.createMechContext(gSSCredentialSpi, oid));
        } else {
            throw new GSSException(11, 0, "Unable to create context");
        }
    }

    private GSSCredentialSpi createCredSpi(GSSManagerImpl gSSManagerImpl, Oid oid) throws GSSException {
        GSSCredentialSpi gSSCredentialSpi = null;
        GSSNameSpi gSSNameSpi = null;
        try {
            try {
                gSSNameSpi = ((GSSNameImpl)this.negCreds.getName(oid)).getMechName(oid);
                gSSCredentialSpi = this.createCredSpi(gSSManagerImpl, gSSNameSpi, oid);
                return gSSCredentialSpi;
            }
            catch (GSSException gSSException) {
                gSSNameSpi = null;
                if (gSSNameSpi == null) {
                    Oid[] oidArray = this.negCreds.getMechs();
                    for (int i = 0; i < oidArray.length; ++i) {
                        try {
                            gSSNameSpi = ((GSSNameImpl)this.negCreds.getName(oidArray[i]).canonicalize(oid)).getMechName(oid);
                            gSSCredentialSpi = this.createCredSpi(gSSManagerImpl, gSSNameSpi, oid);
                            return gSSCredentialSpi;
                        }
                        catch (GSSException gSSException2) {
                            gSSNameSpi = null;
                            continue;
                        }
                    }
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new GSSException(11, 0, "IBM GSSName not found");
        }
        throw new GSSException(11, 0, "Unable to create mechanism credential element");
    }

    private GSSCredentialSpi createCredSpi(GSSManagerImpl gSSManagerImpl, GSSNameSpi gSSNameSpi, Oid oid) throws GSSException {
        int n = this.getLifetime();
        int n2 = this.getLifetime();
        if (this.initiator) {
            return gSSManagerImpl.createMechCredential(gSSNameSpi, n, n2, 1, oid);
        }
        return gSSManagerImpl.createMechCredential(gSSNameSpi, n, n2, 2, oid);
    }

    private void createMechContext(GSSManagerImpl gSSManagerImpl, Oid oid, GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        if (this.initiator) {
            GSSNameImpl gSSNameImpl = null;
            try {
                gSSNameImpl = gSSManagerImpl.createName(this.target);
                if (gSSNameImpl.getMechName(oid) == null) {
                    gSSNameImpl.canonicalize(oid);
                }
            }
            catch (GSSException gSSException) {
                throw new GSSException(11, 1, "Can not create target name for specified mechanism");
            }
            try {
                this.context = gSSManagerImpl.createMechContext(gSSNameImpl.getMechName(oid), gSSCredentialSpi, this.getLifetime(), oid);
            }
            catch (GSSException gSSException) {
                throw new GSSException(11, 0, "Failed to create context");
            }
        }
        try {
            this.context = gSSManagerImpl.createMechContext(gSSCredentialSpi, oid);
        }
        catch (GSSException gSSException) {
            throw new GSSException(11, 0, "Failed to create context");
        }
    }

    private byte[] createInitToken() throws GSSException, IOException {
        Object object;
        byte[] byArray = null;
        byte[] byArray2 = null;
        boolean bl = false;
        DerValue derValue = null;
        int n = -1;
        this.origFlagsState = (boolean[])this.reqFlagsState.clone();
        boolean bl2 = false;
        do {
            bl = false;
            if (bl2) {
                this.reqFlagsState = (boolean[])this.origFlagsState.clone();
            }
            if ((n = this.getPreferredMech(n + 1)) == -1) {
                throw new GSSException(11, 0, "Failed to set up context");
            }
            if (n > 0) {
                object = this.mechTypes[n];
                this.mechTypes[n] = this.mechTypes[0];
                this.mechTypes[0] = object;
            }
            bl2 = this.checkFlags(this.reqFlagsState);
            try {
                byArray2 = this.context.initSecContext(null, 0);
                if (byArray2 != null) {
                    byArray2 = new TokenHeader(this.mechTypes[0], byArray2).asn1Encode();
                }
            }
            catch (GSSException gSSException) {
                bl = true;
            }
            object = new ContextFlags(this.reqFlagsState);
            MechTypeList mechTypeList = new MechTypeList(this.mechTypes);
            if (this.context.isEstablished() && this.getIntegState()) {
                byArray = this.getMIC();
            }
            try {
                InitNegToken initNegToken = new InitNegToken(mechTypeList, (ContextFlags)object, byArray2, byArray);
                derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), initNegToken.encode());
            }
            catch (IOException iOException) {
                bl = true;
            }
        } while (bl);
        if (debug.on(4)) {
            object = new StringBuffer();
            ((StringBuffer)object).append("Negotiation mech list: ");
            for (int i = 0; i < this.mechTypes.length; ++i) {
                ((StringBuffer)object).append("\n\t\t" + this.mechTypes[i].toString());
            }
            debug.out(4, ((StringBuffer)object).toString());
        }
        return derValue.toByteArray();
    }

    private int getPreferredMech(int n) {
        int n2 = -1;
        for (int i = n; i < this.mechTypes.length; ++i) {
            try {
                this.createContext(this.mechTypes[i]);
                n2 = i;
                break;
            }
            catch (GSSException gSSException) {
                if (!debug.on(4)) continue;
                gSSException.printStackTrace();
                continue;
            }
        }
        return n2;
    }

    private byte[] processInitToken(InitNegToken initNegToken) throws IOException, GSSException {
        byte[] byArray = initNegToken.getMechToken();
        byte[] byArray2 = initNegToken.getMechListMIC();
        ContextFlags contextFlags = initNegToken.getReqFlags();
        MechTypeList mechTypeList = initNegToken.getMechTypes();
        if (contextFlags != null) {
            for (int i = 0; i < this.reqFlagsState.length; ++i) {
                this.reqFlagsState[i] = contextFlags.get(i);
            }
        }
        if (mechTypeList != null) {
            int n;
            this.list = mechTypeList;
            Oid[] oidArray = mechTypeList.getMechs();
            if (debug.on(4)) {
                debug.out(4, "SPNEGO: Acceptor side's mech list");
                for (n = 0; n < this.mechTypes.length; ++n) {
                    debug.out(4, this.mechTypes[n].toString());
                }
                debug.out(4, "SPNEGO: received mech list");
                for (n = 0; n < oidArray.length; ++n) {
                    debug.out(4, oidArray[n].toString());
                }
            }
            n = -1;
            while (n < oidArray.length) {
                Object object;
                int n2 = n + 1;
                n = -1;
                List<Oid> list = Arrays.asList(this.mechTypes);
                if (oidArray[0].toString().equals(this.msKrbOid)) {
                    if (debug.on(4)) {
                        debug.out(4, "SPNEGO: Get krb v5 legacy oid");
                    }
                    n = 0;
                } else {
                    for (int i = n2; i < oidArray.length; ++i) {
                        if (!list.contains(oidArray[i]) || oidArray[i].equals(GSSManagerImpl.MECH_TYPE_SPNEGO)) continue;
                        n = i;
                        break;
                    }
                }
                if (n == 0) {
                    int n3;
                    byte[] byArray3 = null;
                    object = null;
                    try {
                        block51: {
                            if (oidArray[0].toString().equals(this.msKrbOid)) {
                                debug.out(4, "SPNEGO: Map to standard krb oid");
                                this.msToken = true;
                                this.createContext(new Oid(this.mitKrbOid));
                            } else {
                                this.createContext(oidArray[0]);
                            }
                            if (byArray == null) {
                                try {
                                    byArray3 = this.context.acceptSecContext(null, 0);
                                    if (byArray3 == null) break block51;
                                    if (this.msToken) {
                                        byArray3 = new TokenHeader(new Oid(this.mitKrbOid), byArray3).asn1Encode();
                                        break block51;
                                    }
                                    byArray3 = new TokenHeader(oidArray[0], byArray3).asn1Encode();
                                }
                                catch (GSSException gSSException) {
                                    if (debug.on(4)) {
                                        gSSException.printStackTrace();
                                    }
                                    byArray3 = null;
                                }
                            } else {
                                byte[] byArray4 = new TokenHeader(byArray, true).getMechToken();
                                debug.out(4, "SPNEGO: convert the gss token to the mech specific token");
                                byArray3 = this.context.acceptSecContext((InputStream)new ByteArrayInputStream(byArray4), byArray4.length);
                                debug.out(4, "SPNEGO: wrap the response data to a gss token");
                                if (byArray3 != null) {
                                    byArray3 = this.msToken ? new TokenHeader(new Oid(this.mitKrbOid), byArray3).asn1Encode() : new TokenHeader(oidArray[0], byArray3).asn1Encode();
                                } else {
                                    debug.out(4, "SPNEGO: no response token");
                                }
                            }
                        }
                        this.supportedMech = oidArray[0];
                    }
                    catch (GSSException gSSException) {
                        if (debug.on(4)) {
                            gSSException.printStackTrace();
                        }
                        if (gSSException.getMajor() != 10) continue;
                        n = -1;
                    }
                    if (this.context.isEstablished()) {
                        block52: {
                            if (this.context.getIntegState()) {
                                debug.out(4, "SPNEGO: integState flag is on.");
                                byte[] byArray5 = mechTypeList.encode();
                                if (byArray2 != null) {
                                    try {
                                        this.context.verifyMIC(byArray2, 0, byArray2.length, byArray5, 0, byArray5.length, new MessageProp(true));
                                        break block52;
                                    }
                                    catch (GSSException gSSException) {
                                        if (!debug.on(4)) continue;
                                        gSSException.printStackTrace();
                                        continue;
                                    }
                                }
                                try {
                                    object = this.context.getMIC(byArray5, 0, byArray5.length, null);
                                }
                                catch (Exception exception) {
                                    if (!debug.on(4)) continue;
                                    exception.printStackTrace();
                                    continue;
                                }
                            }
                        }
                        this.established = true;
                    }
                    if (this.established) {
                        debug.out(4, "SPNEGO: target accept completd");
                        n3 = 0;
                    } else {
                        debug.out(4, "SPNEGO: target accept incomplete");
                        n3 = 1;
                    }
                    try {
                        byte[] byArray6 = new TargNegToken(new Integer(n3), oidArray[0], byArray3, (byte[])object).encode();
                        DerValue derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), byArray6);
                        debug.out(4, "SPNEGO: target select preferred mechanism");
                        return derValue.toByteArray();
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (n > 0) {
                    try {
                        this.createContext(oidArray[n]);
                        byte[] byArray7 = null;
                        try {
                            byArray7 = this.context.acceptSecContext(null, 0);
                            if (byArray7 != null && this.msToken) {
                                byArray7 = new TokenHeader(new Oid(this.mitKrbOid), byArray7).asn1Encode();
                            }
                        }
                        catch (GSSException gSSException) {
                            byArray7 = null;
                        }
                        object = new TargNegToken(new Integer(1), oidArray[n], byArray7, null).encode();
                        DerValue derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), (byte[])object);
                        this.supportedMech = oidArray[n];
                        debug.out(4, "SPNEGO: acceptor chooses mechanism " + oidArray[n]);
                        return derValue.toByteArray();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (n != -1) continue;
                byte[] byArray8 = new TargNegToken(new Integer(2), null, null, null).encode();
                object = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), byArray8);
                this.supportedMech = null;
                if (this.context != null) {
                    this.context.dispose();
                    this.context = null;
                }
                this.established = false;
                debug.out(4, "SPNEGO: target rejects all mechanism");
                return object.toByteArray();
            }
        } else {
            Object object;
            if (this.supportedMech == null) {
                throw new GSSException(11, 0, "Initial token does not include required data");
            }
            byte[] byArray9 = null;
            byte[] byArray10 = null;
            if (this.msToken) {
                object = new TokenHeader(byArray, true).getMechToken();
                byte[] byArray11 = this.context.acceptSecContext((InputStream)new ByteArrayInputStream((byte[])object), ((byte[])object).length);
                byArray9 = new TokenHeader(new Oid(this.mitKrbOid), byArray11).asn1Encode();
            } else {
                byArray9 = this.context.acceptSecContext((InputStream)new ByteArrayInputStream(byArray), byArray.length);
            }
            if (this.context.isEstablished()) {
                if (this.context.getIntegState()) {
                    if (byArray2 != null) {
                        object = this.list.encode();
                        this.context.verifyMIC(byArray2, 0, byArray2.length, object, 0, ((byte[])object).length, new MessageProp(true));
                        this.established = true;
                        return null;
                    }
                    object = this.list.encode();
                    byArray10 = this.context.getMIC(object, 0, ((byte[])object).length, null);
                }
                this.established = true;
            }
            if (byArray9 == null && byArray10 == null) {
                return null;
            }
            object = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), new TargNegToken(null, null, byArray9, byArray10).encode());
            return object.toByteArray();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] processTargToken(byte[] byArray) throws IOException, GSSException {
        DerValue derValue = new DerValue(byArray);
        if ((derValue.getTag() & 0x1F) != 1) {
            throw new IOException("Invalid tag. Failed to parse data");
        }
        DerInputStream derInputStream = derValue.getData();
        TargNegToken targNegToken = new TargNegToken(derInputStream);
        byte[] byArray2 = targNegToken.getResponse();
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        Integer n = null;
        n = targNegToken.getResult();
        if (n != null) {
            switch (n) {
                case 1: {
                    ContextFlags contextFlags = null;
                    this.checkSupportedMech(targNegToken.getSelectedMech());
                    if (!this.supportedMech.equals(this.mechTypes[0])) {
                        this.createContext(this.supportedMech);
                        this.reqFlagsState = (boolean[])this.origFlagsState.clone();
                        if (this.checkFlags(this.origFlagsState)) {
                            contextFlags = new ContextFlags(this.reqFlagsState);
                        }
                        byArray3 = this.context.initSecContext(null, 0);
                    } else {
                        byArray3 = this.context.initSecContext((InputStream)new ByteArrayInputStream(byArray2), byArray2.length);
                    }
                    if (this.context.isEstablished() && this.getIntegState()) {
                        byArray4 = this.getMIC();
                    }
                    DerValue derValue2 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), new InitNegToken(null, contextFlags, byArray3, byArray4).encode());
                    return derValue2.toByteArray();
                }
                case 0: {
                    this.checkSupportedMech(targNegToken.getSelectedMech());
                    if (!this.supportedMech.equals(this.mechTypes[0])) {
                        throw new GSSException(11, 0, "Invalid result from target");
                    }
                    if (byArray2 != null) {
                        byte[] byArray5 = new TokenHeader(byArray2, true).getMechToken();
                        this.context.initSecContext((InputStream)new ByteArrayInputStream(byArray5), byArray5.length);
                        if (!this.context.isEstablished()) throw new GSSException(11, 0, "Unable to set up the context");
                        if (this.getIntegState()) {
                            debug.out(4, "SPNEGO: verifying MIC from target");
                            this.verifyMIC(targNegToken.getMIC());
                        }
                        debug.out(4, "SPNEGO: target accept completed, initiator context established");
                        this.established = true;
                        return null;
                    } else {
                        this.established = true;
                    }
                    return null;
                }
                case 2: {
                    throw new GSSException(11, 0, "Target rejects all the proposed mechanisms");
                }
            }
            throw new GSSException(5, 0, "Invalid response from target");
        }
        if (byArray2 != null) {
            byArray3 = this.context.initSecContext((InputStream)new ByteArrayInputStream(byArray2), byArray2.length);
            if (byArray3 != null) {
                if (this.context.isEstablished() && this.getIntegState()) {
                    byArray4 = this.getMIC();
                }
                DerValue derValue3 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), new InitNegToken(null, null, byArray3, byArray4).encode());
                return derValue3.toByteArray();
            }
            if (!this.context.isEstablished()) throw new GSSException(11, 0, "Unable to set up the context");
            if (this.getIntegState()) {
                byArray4 = targNegToken.getMIC();
                if (byArray4 == null) throw new GSSException(11, 0, "Data integrity can not be determined");
                this.verifyMIC(byArray4);
            }
            this.established = true;
            return null;
        }
        this.verifyMIC(targNegToken.getMIC());
        this.established = true;
        return null;
    }

    private void verifyMIC(byte[] byArray) throws GSSException {
        if (byArray == null) {
            throw new GSSException(11, 0, "Result of getMIC is null");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = new MechTypeList(this.mechTypes).encode();
        }
        catch (IOException iOException) {
            throw new GSSException(11, 0, iOException.toString());
        }
        this.context.verifyMIC(byArray, 0, byArray.length, byArray2, 0, byArray2.length, new MessageProp(true));
    }

    private byte[] getMIC() throws GSSException {
        byte[] byArray = null;
        try {
            byArray = new MechTypeList(this.mechTypes).encode();
        }
        catch (IOException iOException) {
            throw new GSSException(11, 0, iOException.toString());
        }
        return this.context.getMIC(byArray, 0, byArray.length, null);
    }

    private boolean checkFlags(boolean[] blArray) {
        boolean bl;
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    bl = false;
                                    try {
                                        this.context.requestAnonymity(blArray[0]);
                                    }
                                    catch (GSSException gSSException) {
                                        if (!blArray[0]) break block14;
                                        blArray[0] = false;
                                        bl = true;
                                    }
                                }
                                try {
                                    this.context.requestConf(blArray[1]);
                                }
                                catch (GSSException gSSException) {
                                    if (!blArray[1]) break block15;
                                    blArray[1] = false;
                                    bl = true;
                                }
                            }
                            try {
                                this.context.requestCredDeleg(blArray[2]);
                            }
                            catch (GSSException gSSException) {
                                if (!blArray[2]) break block16;
                                blArray[2] = false;
                                bl = true;
                            }
                        }
                        try {
                            this.context.requestInteg(blArray[3]);
                        }
                        catch (GSSException gSSException) {
                            if (!blArray[3]) break block17;
                            blArray[3] = false;
                            bl = true;
                        }
                    }
                    try {
                        this.context.requestMutualAuth(blArray[4]);
                    }
                    catch (GSSException gSSException) {
                        if (!blArray[4]) break block18;
                        blArray[4] = false;
                        bl = true;
                    }
                }
                try {
                    this.context.requestReplayDet(blArray[5]);
                }
                catch (GSSException gSSException) {
                    if (!blArray[5]) break block19;
                    blArray[5] = false;
                    bl = true;
                }
            }
            try {
                this.context.requestSequenceDet(blArray[6]);
            }
            catch (GSSException gSSException) {
                if (!blArray[6]) break block20;
                blArray[6] = false;
                bl = true;
            }
        }
        return bl;
    }

    private void checkSupportedMech(Oid oid) throws GSSException {
        this.supportedMech = oid;
        if (this.supportedMech == null) {
            throw new GSSException(11, 0, "Returned token did not specify supported mechanism");
        }
        if (!new ArrayList<Oid>(Arrays.asList(this.mechTypes)).contains(this.supportedMech)) {
            throw new GSSException(2, 0, "Invalid selected mechanism from target");
        }
    }
}

