/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;
import java.util.StringTokenizer;
import org.apache.harmony.luni.util.Util;

public final class PropertyPermission
extends BasicPermission {
    private static final long serialVersionUID = 885438825399942851L;
    private transient boolean read;
    private transient boolean write;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};

    public PropertyPermission(String string, String string2) {
        super(string);
        this.decodeActions(string2);
    }

    private void decodeActions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(Util.toASCIILowerCase(string), " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("read")) {
                this.read = true;
                continue;
            }
            if (string2.equals("write")) {
                this.write = true;
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (!this.read && !this.write) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            PropertyPermission propertyPermission = (PropertyPermission)object;
            return this.read == propertyPermission.read && this.write == propertyPermission.write;
        }
        return false;
    }

    @Override
    public String getActions() {
        return this.read ? (this.write ? "read,write" : "read") : "write";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (super.implies(permission)) {
            PropertyPermission propertyPermission = (PropertyPermission)permission;
            return !(!this.read && propertyPermission.read || !this.write && propertyPermission.write);
        }
        return false;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("actions", this.getActions());
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("actions", "");
        this.decodeActions(string);
    }
}

