/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    transient int size = 0;
    transient Link<E> voidLink = new Link<Object>(null, null, null);

    public LinkedList() {
        this.voidLink.previous = this.voidLink;
        this.voidLink.next = this.voidLink;
    }

    public LinkedList(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public void add(int n, E e) {
        if (0 <= n && n <= this.size) {
            int n2;
            Link<Object> link = this.voidLink;
            if (n < this.size / 2) {
                for (n2 = 0; n2 <= n; ++n2) {
                    link = link.next;
                }
            } else {
                for (n2 = this.size; n2 > n; --n2) {
                    link = link.previous;
                }
            }
            Link link2 = link.previous;
            Link<E> link3 = new Link<E>(e, link2, link);
            link2.next = link3;
            link.previous = link3;
            ++this.size;
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean add(E e) {
        return this.addLastImpl(e);
    }

    private boolean addLastImpl(E e) {
        Link link = this.voidLink.previous;
        Link<E> link2 = new Link<E>(e, link, this.voidLink);
        this.voidLink.previous = link2;
        link.next = link2;
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        int n2;
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        Link<Object> link = this.voidLink;
        if (n < this.size / 2) {
            for (n2 = 0; n2 < n; ++n2) {
                link = link.next;
            }
        } else {
            for (n2 = this.size; n2 >= n; --n2) {
                link = link.previous;
            }
        }
        Link link2 = link.next;
        for (E e : collection) {
            Link<E> link3 = new Link<E>(e, link, null);
            link.next = link3;
            link = link3;
        }
        link.next = link2;
        link2.previous = link;
        this.size += n3;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        Link<Object> link = this.voidLink.previous;
        for (E e : collection) {
            Link<E> link2 = new Link<E>(e, link, null);
            link.next = link2;
            link = link2;
        }
        link.next = this.voidLink;
        this.voidLink.previous = link;
        this.size += n;
        ++this.modCount;
        return true;
    }

    @Override
    public void addFirst(E e) {
        this.addFirstImpl(e);
    }

    private boolean addFirstImpl(E e) {
        Link link = this.voidLink.next;
        Link<E> link2 = new Link<E>(e, this.voidLink, link);
        this.voidLink.next = link2;
        link.previous = link2;
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public void addLast(E e) {
        this.addLastImpl(e);
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            this.size = 0;
            this.voidLink.next = this.voidLink;
            this.voidLink.previous = this.voidLink;
            ++this.modCount;
        }
    }

    public Object clone() {
        try {
            LinkedList linkedList = (LinkedList)super.clone();
            linkedList.size = 0;
            linkedList.voidLink = new Link<Object>(null, null, null);
            linkedList.voidLink.previous = linkedList.voidLink;
            linkedList.voidLink.next = linkedList.voidLink;
            linkedList.addAll(this);
            return linkedList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        Link link = this.voidLink.next;
        if (object != null) {
            while (link != this.voidLink) {
                if (object.equals(link.data)) {
                    return true;
                }
                link = link.next;
            }
        } else {
            while (link != this.voidLink) {
                if (link.data == null) {
                    return true;
                }
                link = link.next;
            }
        }
        return false;
    }

    @Override
    public E get(int n) {
        if (0 <= n && n < this.size) {
            Link<Object> link = this.voidLink;
            if (n < this.size / 2) {
                for (int i = 0; i <= n; ++i) {
                    link = link.next;
                }
            } else {
                for (int i = this.size; i > n; --i) {
                    link = link.previous;
                }
            }
            return (E)link.data;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E getFirst() {
        return this.getFirstImpl();
    }

    private E getFirstImpl() {
        Link link = this.voidLink.next;
        if (link != this.voidLink) {
            return (E)link.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E getLast() {
        Link link = this.voidLink.previous;
        if (link != this.voidLink) {
            return (E)link.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        Link link = this.voidLink.next;
        if (object != null) {
            while (link != this.voidLink) {
                if (object.equals(link.data)) {
                    return n;
                }
                link = link.next;
                ++n;
            }
        } else {
            while (link != this.voidLink) {
                if (link.data == null) {
                    return n;
                }
                link = link.next;
                ++n;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size;
        Link link = this.voidLink.previous;
        if (object != null) {
            while (link != this.voidLink) {
                --n;
                if (object.equals(link.data)) {
                    return n;
                }
                link = link.previous;
            }
        } else {
            while (link != this.voidLink) {
                --n;
                if (link.data == null) {
                    return n;
                }
                link = link.previous;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new LinkIterator(this, n);
    }

    @Override
    public E remove(int n) {
        if (0 <= n && n < this.size) {
            Link link;
            int n2;
            Link<Object> link2 = this.voidLink;
            if (n < this.size / 2) {
                for (n2 = 0; n2 <= n; ++n2) {
                    link2 = link2.next;
                }
            } else {
                for (n2 = this.size; n2 > n; --n2) {
                    link2 = link2.previous;
                }
            }
            Link link3 = link2.previous;
            link3.next = link = link2.next;
            link.previous = link3;
            --this.size;
            ++this.modCount;
            return (E)link2.data;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrenceImpl(object);
    }

    @Override
    public E removeFirst() {
        return this.removeFirstImpl();
    }

    private E removeFirstImpl() {
        Link link = this.voidLink.next;
        if (link != this.voidLink) {
            Link link2;
            this.voidLink.next = link2 = link.next;
            link2.previous = this.voidLink;
            --this.size;
            ++this.modCount;
            return (E)link.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E removeLast() {
        return this.removeLastImpl();
    }

    private E removeLastImpl() {
        Link link = this.voidLink.previous;
        if (link != this.voidLink) {
            Link link2;
            this.voidLink.previous = link2 = link.previous;
            link2.next = this.voidLink;
            --this.size;
            ++this.modCount;
            return (E)link.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ReverseLinkIterator(this);
    }

    @Override
    public boolean offerFirst(E e) {
        return this.addFirstImpl(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public E peekFirst() {
        return this.peekFirstImpl();
    }

    @Override
    public E peekLast() {
        Link link = this.voidLink.previous;
        return link == this.voidLink ? null : (E)link.data;
    }

    @Override
    public E pollFirst() {
        return this.size == 0 ? null : (E)this.removeFirstImpl();
    }

    @Override
    public E pollLast() {
        return this.size == 0 ? null : (E)this.removeLastImpl();
    }

    @Override
    public E pop() {
        return this.removeFirstImpl();
    }

    @Override
    public void push(E e) {
        this.addFirstImpl(e);
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        return this.removeFirstOccurrenceImpl(object);
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        ReverseLinkIterator reverseLinkIterator = new ReverseLinkIterator(this);
        return this.removeOneOccurrence(object, reverseLinkIterator);
    }

    private boolean removeFirstOccurrenceImpl(Object object) {
        LinkIterator linkIterator = new LinkIterator(this, 0);
        return this.removeOneOccurrence(object, linkIterator);
    }

    private boolean removeOneOccurrence(Object object, Iterator<E> iterator) {
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (!(object == null ? e == null : object.equals(e))) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public E set(int n, E e) {
        if (0 <= n && n < this.size) {
            int n2;
            Link<Object> link = this.voidLink;
            if (n < this.size / 2) {
                for (n2 = 0; n2 <= n; ++n2) {
                    link = link.next;
                }
            } else {
                for (n2 = this.size; n2 > n; --n2) {
                    link = link.previous;
                }
            }
            Object ET = link.data;
            link.data = e;
            return (E)ET;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean offer(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public E poll() {
        return this.size == 0 ? null : (E)this.removeFirstImpl();
    }

    @Override
    public E remove() {
        return this.removeFirstImpl();
    }

    @Override
    public E peek() {
        return this.peekFirstImpl();
    }

    private E peekFirstImpl() {
        Link link = this.voidLink.next;
        return link == this.voidLink ? null : (E)link.data;
    }

    @Override
    public E element() {
        return this.getFirstImpl();
    }

    @Override
    public Object[] toArray() {
        int n = 0;
        Object[] objectArray = new Object[this.size];
        Link link = this.voidLink.next;
        while (link != this.voidLink) {
            objectArray[n++] = link.data;
            link = link.next;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        Link link;
        int n = 0;
        if (this.size > objectArray.length) {
            link = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(link, this.size);
        }
        link = this.voidLink.next;
        while (link != this.voidLink) {
            objectArray[n++] = link.data;
            link = link.next;
        }
        if (n < objectArray.length) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.size = objectInputStream.readInt();
        Link<Object> link = this.voidLink = new Link<Object>(null, null, null);
        int n = this.size;
        while (--n >= 0) {
            Link<Object> link2 = new Link<Object>(objectInputStream.readObject(), link, null);
            link.next = link2;
            link = link2;
        }
        link.next = this.voidLink;
        this.voidLink.previous = link;
    }

    private class ReverseLinkIterator<ET>
    implements Iterator<ET> {
        private int expectedModCount;
        private final LinkedList<ET> list;
        private Link<ET> link;
        private boolean canRemove;

        ReverseLinkIterator(LinkedList<ET> linkedList2) {
            this.list = linkedList2;
            this.expectedModCount = this.list.modCount;
            this.link = this.list.voidLink;
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            return this.link.previous != this.list.voidLink;
        }

        @Override
        public ET next() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.hasNext()) {
                    this.link = this.link.previous;
                    this.canRemove = true;
                    return this.link.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.canRemove) {
                    Link link;
                    Link link2 = this.link.previous;
                    link2.next = link = this.link.next;
                    link.previous = link2;
                    this.link = link;
                    --this.list.size;
                    ++this.list.modCount;
                    ++this.expectedModCount;
                    this.canRemove = false;
                    return;
                }
                throw new IllegalStateException();
            }
            throw new ConcurrentModificationException();
        }
    }

    private static final class LinkIterator<ET>
    implements ListIterator<ET> {
        int pos;
        int expectedModCount;
        final LinkedList<ET> list;
        Link<ET> link;
        Link<ET> lastLink;

        LinkIterator(LinkedList<ET> linkedList, int n) {
            this.list = linkedList;
            this.expectedModCount = this.list.modCount;
            if (0 <= n && n <= this.list.size) {
                this.link = this.list.voidLink;
                if (n < this.list.size / 2) {
                    this.pos = -1;
                    while (this.pos + 1 < n) {
                        this.link = this.link.next;
                        ++this.pos;
                    }
                } else {
                    this.pos = this.list.size;
                    while (this.pos >= n) {
                        this.link = this.link.previous;
                        --this.pos;
                    }
                }
            } else {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void add(ET ET) {
            if (this.expectedModCount == this.list.modCount) {
                Link link = this.link.next;
                Link<ET> link2 = new Link<ET>(ET, this.link, link);
                this.link.next = link2;
                link.previous = link2;
                this.link = link2;
                this.lastLink = null;
                ++this.pos;
                ++this.expectedModCount;
                ++this.list.size;
                ++this.list.modCount;
            } else {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.link.next != this.list.voidLink;
        }

        @Override
        public boolean hasPrevious() {
            return this.link != this.list.voidLink;
        }

        @Override
        public ET next() {
            if (this.expectedModCount == this.list.modCount) {
                Link link = this.link.next;
                if (link != this.list.voidLink) {
                    this.link = link;
                    this.lastLink = this.link;
                    ++this.pos;
                    return this.link.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public ET previous() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.link != this.list.voidLink) {
                    this.lastLink = this.link;
                    this.link = this.link.previous;
                    --this.pos;
                    return this.lastLink.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int previousIndex() {
            return this.pos;
        }

        @Override
        public void remove() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.lastLink != null) {
                    Link link;
                    Link link2 = this.lastLink.next;
                    link2.previous = link = this.lastLink.previous;
                    link.next = link2;
                    if (this.lastLink == this.link) {
                        --this.pos;
                    }
                    this.link = link;
                    this.lastLink = null;
                    ++this.expectedModCount;
                    --this.list.size;
                    ++this.list.modCount;
                    return;
                }
                throw new IllegalStateException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public void set(ET ET) {
            if (this.expectedModCount == this.list.modCount) {
                if (this.lastLink == null) {
                    throw new IllegalStateException();
                }
            } else {
                throw new ConcurrentModificationException();
            }
            this.lastLink.data = ET;
        }
    }

    private static final class Link<ET> {
        ET data;
        Link<ET> previous;
        Link<ET> next;

        Link(ET ET, Link<ET> link, Link<ET> link2) {
            this.data = ET;
            this.previous = link;
            this.next = link2;
        }
    }
}

