/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LinkedHashMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private final boolean accessOrder;
    private transient LinkedHashMapEntry<K, V> head;
    private transient LinkedHashMapEntry<K, V> tail;

    public LinkedHashMap() {
        this.accessOrder = false;
        this.head = null;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
        this.head = null;
    }

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
        this.head = null;
        this.tail = null;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> map) {
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
        this.putAll(map);
    }

    @Override
    public boolean containsValue(Object object) {
        LinkedHashMapEntry<K, V> linkedHashMapEntry = this.head;
        if (null == object) {
            while (null != linkedHashMapEntry) {
                if (null == linkedHashMapEntry.value) {
                    return true;
                }
                linkedHashMapEntry = linkedHashMapEntry.chainForward;
            }
        } else {
            while (null != linkedHashMapEntry) {
                if (object.equals(linkedHashMapEntry.value)) {
                    return true;
                }
                linkedHashMapEntry = linkedHashMapEntry.chainForward;
            }
        }
        return false;
    }

    @Override
    HashMap.Entry<K, V>[] newElementArray(int n) {
        return new LinkedHashMapEntry[n];
    }

    @Override
    public V get(Object object) {
        LinkedHashMapEntry linkedHashMapEntry;
        if (object == null) {
            linkedHashMapEntry = (LinkedHashMapEntry)this.findNullKeyEntry();
        } else {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
            linkedHashMapEntry = (LinkedHashMapEntry)this.findNonNullKeyEntry(object, n2, n);
        }
        if (linkedHashMapEntry == null) {
            return null;
        }
        if (this.accessOrder && this.tail != linkedHashMapEntry) {
            LinkedHashMapEntry linkedHashMapEntry2 = linkedHashMapEntry.chainBackward;
            LinkedHashMapEntry linkedHashMapEntry3 = linkedHashMapEntry.chainForward;
            linkedHashMapEntry3.chainBackward = linkedHashMapEntry2;
            if (linkedHashMapEntry2 != null) {
                linkedHashMapEntry2.chainForward = linkedHashMapEntry3;
            } else {
                this.head = linkedHashMapEntry3;
            }
            linkedHashMapEntry.chainForward = null;
            linkedHashMapEntry.chainBackward = this.tail;
            this.tail.chainForward = linkedHashMapEntry;
            this.tail = linkedHashMapEntry;
        }
        return (V)linkedHashMapEntry.value;
    }

    @Override
    HashMap.Entry<K, V> createEntry(K k, int n, V v) {
        LinkedHashMapEntry<K, V> linkedHashMapEntry = new LinkedHashMapEntry<K, V>(k, v);
        linkedHashMapEntry.next = this.elementData[n];
        this.elementData[n] = linkedHashMapEntry;
        this.linkEntry(linkedHashMapEntry);
        return linkedHashMapEntry;
    }

    @Override
    HashMap.Entry<K, V> createHashedEntry(K k, int n, int n2) {
        LinkedHashMapEntry linkedHashMapEntry = new LinkedHashMapEntry(k, n2);
        linkedHashMapEntry.next = this.elementData[n];
        this.elementData[n] = linkedHashMapEntry;
        this.linkEntry(linkedHashMapEntry);
        return linkedHashMapEntry;
    }

    @Override
    public V put(K k, V v) {
        V v2 = this.putImpl(k, v);
        if (this.removeEldestEntry(this.head)) {
            this.remove(this.head.key);
        }
        return v2;
    }

    @Override
    V putImpl(K k, V v) {
        LinkedHashMapEntry linkedHashMapEntry;
        if (this.elementCount == 0) {
            this.tail = null;
            this.head = null;
        }
        if (k == null) {
            linkedHashMapEntry = (LinkedHashMapEntry)this.findNullKeyEntry();
            if (linkedHashMapEntry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
                linkedHashMapEntry = (LinkedHashMapEntry)this.createHashedEntry(null, 0, 0);
            } else {
                this.linkEntry(linkedHashMapEntry);
            }
        } else {
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
            linkedHashMapEntry = (LinkedHashMapEntry)this.findNonNullKeyEntry(k, n2, n);
            if (linkedHashMapEntry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
                }
                linkedHashMapEntry = (LinkedHashMapEntry)this.createHashedEntry(k, n2, n);
            } else {
                this.linkEntry(linkedHashMapEntry);
            }
        }
        Object object = linkedHashMapEntry.value;
        linkedHashMapEntry.value = v;
        return (V)object;
    }

    void linkEntry(LinkedHashMapEntry<K, V> linkedHashMapEntry) {
        if (this.tail == linkedHashMapEntry) {
            return;
        }
        if (this.head == null) {
            this.tail = linkedHashMapEntry;
            this.head = this.tail;
            return;
        }
        LinkedHashMapEntry linkedHashMapEntry2 = linkedHashMapEntry.chainBackward;
        LinkedHashMapEntry linkedHashMapEntry3 = linkedHashMapEntry.chainForward;
        if (linkedHashMapEntry2 == null) {
            if (linkedHashMapEntry3 != null) {
                if (this.accessOrder) {
                    this.head = linkedHashMapEntry3;
                    linkedHashMapEntry3.chainBackward = null;
                    linkedHashMapEntry.chainBackward = this.tail;
                    linkedHashMapEntry.chainForward = null;
                    this.tail.chainForward = linkedHashMapEntry;
                    this.tail = linkedHashMapEntry;
                }
            } else {
                linkedHashMapEntry.chainBackward = this.tail;
                linkedHashMapEntry.chainForward = null;
                this.tail.chainForward = linkedHashMapEntry;
                this.tail = linkedHashMapEntry;
            }
            return;
        }
        if (linkedHashMapEntry3 == null) {
            return;
        }
        if (this.accessOrder) {
            linkedHashMapEntry2.chainForward = linkedHashMapEntry3;
            linkedHashMapEntry3.chainBackward = linkedHashMapEntry2;
            linkedHashMapEntry.chainForward = null;
            linkedHashMapEntry.chainBackward = this.tail;
            this.tail.chainForward = linkedHashMapEntry;
            this.tail = linkedHashMapEntry;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new LinkedHashMapEntrySet(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return LinkedHashMap.this.size();
                }

                @Override
                public void clear() {
                    LinkedHashMap.this.clear();
                }

                @Override
                public boolean remove(Object object) {
                    if (LinkedHashMap.this.containsKey(object)) {
                        LinkedHashMap.this.remove(object);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator(LinkedHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return LinkedHashMap.this.size();
                }

                @Override
                public void clear() {
                    LinkedHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator(LinkedHashMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public V remove(Object object) {
        LinkedHashMapEntry linkedHashMapEntry = (LinkedHashMapEntry)this.removeEntry(object);
        if (linkedHashMapEntry == null) {
            return null;
        }
        LinkedHashMapEntry linkedHashMapEntry2 = linkedHashMapEntry.chainBackward;
        LinkedHashMapEntry linkedHashMapEntry3 = linkedHashMapEntry.chainForward;
        if (linkedHashMapEntry2 != null) {
            linkedHashMapEntry2.chainForward = linkedHashMapEntry3;
        } else {
            this.head = linkedHashMapEntry3;
        }
        if (linkedHashMapEntry3 != null) {
            linkedHashMapEntry3.chainBackward = linkedHashMapEntry2;
        } else {
            this.tail = linkedHashMapEntry2;
        }
        return (V)linkedHashMapEntry.value;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    static final class LinkedHashMapEntry<K, V>
    extends HashMap.Entry<K, V> {
        LinkedHashMapEntry<K, V> chainForward = null;
        LinkedHashMapEntry<K, V> chainBackward = null;

        LinkedHashMapEntry(K k, V v) {
            super(k, v);
        }

        LinkedHashMapEntry(K k, int n) {
            super(k, n);
        }

        @Override
        public Object clone() {
            LinkedHashMapEntry linkedHashMapEntry = (LinkedHashMapEntry)super.clone();
            linkedHashMapEntry.chainBackward = this.chainBackward;
            linkedHashMapEntry.chainForward = this.chainForward;
            LinkedHashMapEntry linkedHashMapEntry2 = (LinkedHashMapEntry)linkedHashMapEntry.next;
            if (linkedHashMapEntry2 != null) {
                linkedHashMapEntry.next = (LinkedHashMapEntry)linkedHashMapEntry2.clone();
            }
            return linkedHashMapEntry;
        }
    }

    static final class LinkedHashMapEntrySet<KT, VT>
    extends HashMap.HashMapEntrySet<KT, VT> {
        public LinkedHashMapEntrySet(LinkedHashMap<KT, VT> linkedHashMap) {
            super(linkedHashMap);
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new EntryIterator((LinkedHashMap)this.hashMap());
        }
    }

    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        ValueIterator(LinkedHashMap<K, V> linkedHashMap) {
            super(linkedHashMap);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        KeyIterator(LinkedHashMap<K, V> linkedHashMap) {
            super(linkedHashMap);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(LinkedHashMap<K, V> linkedHashMap) {
            super(linkedHashMap);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private static class AbstractMapIterator<K, V> {
        int expectedModCount;
        LinkedHashMapEntry<K, V> futureEntry;
        LinkedHashMapEntry<K, V> currentEntry;
        final LinkedHashMap<K, V> associatedMap;

        AbstractMapIterator(LinkedHashMap<K, V> linkedHashMap) {
            this.expectedModCount = linkedHashMap.modCount;
            this.futureEntry = ((LinkedHashMap)linkedHashMap).head;
            this.associatedMap = linkedHashMap;
        }

        public boolean hasNext() {
            return this.futureEntry != null;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentEntry = this.futureEntry;
            this.futureEntry = this.futureEntry.chainForward;
        }

        public void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            this.associatedMap.removeEntry(this.currentEntry.getKey());
            LinkedHashMapEntry<K, V> linkedHashMapEntry = this.currentEntry;
            LinkedHashMapEntry linkedHashMapEntry2 = linkedHashMapEntry.chainBackward;
            LinkedHashMapEntry linkedHashMapEntry3 = linkedHashMapEntry.chainForward;
            LinkedHashMap<K, V> linkedHashMap = this.associatedMap;
            if (linkedHashMapEntry2 != null) {
                linkedHashMapEntry2.chainForward = linkedHashMapEntry3;
                if (linkedHashMapEntry3 != null) {
                    linkedHashMapEntry3.chainBackward = linkedHashMapEntry2;
                } else {
                    ((LinkedHashMap)linkedHashMap).tail = linkedHashMapEntry2;
                }
            } else {
                ((LinkedHashMap)linkedHashMap).head = linkedHashMapEntry3;
                if (linkedHashMapEntry3 != null) {
                    linkedHashMapEntry3.chainBackward = null;
                } else {
                    ((LinkedHashMap)linkedHashMap).tail = null;
                }
            }
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }
}

